/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table.row;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.observation.ComponentType;
import org.applied_geodesy.adjustment.network.observation.Direction;
import org.applied_geodesy.adjustment.network.observation.FaceType;
import org.applied_geodesy.adjustment.network.observation.GNSSBaseline;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.observation.ZenithAngle;
import org.applied_geodesy.jag3d.ui.table.row.Row;

public class AveragedObservationRow
extends Row {
    private ObjectProperty<String> startPointName = new SimpleObjectProperty((Object)this, "startPointName");
    private ObjectProperty<String> endPointName = new SimpleObjectProperty((Object)this, "endPointName");
    private ObjectProperty<ObservationType> observationType = new SimpleObjectProperty((Object)this, "observationType");
    private ObjectProperty<ComponentType> componentType = new SimpleObjectProperty((Object)this, "componentType");
    private ObjectProperty<Double> value = new SimpleObjectProperty((Object)this, "value");
    private ObjectProperty<Double> grossError = new SimpleObjectProperty((Object)this, "grossError");

    public AveragedObservationRow() {
    }

    public AveragedObservationRow(Observation observation) {
        this.setStartPointName(observation.getStartPoint().getName());
        this.setEndPointName(observation.getEndPoint().getName());
        ComponentType compType = null;
        ObservationType obsType = observation.getObservationType();
        double value = observation.getValueApriori();
        if (obsType == ObservationType.DIRECTION && ((Direction)observation).getFace() == FaceType.TWO) {
            value = MathExtension.MOD(value + Math.PI, Math.PI * 2);
        } else if (obsType == ObservationType.ZENITH_ANGLE && ((ZenithAngle)observation).getFace() == FaceType.TWO) {
            value = MathExtension.MOD(Math.PI * 2 - value, Math.PI * 2);
        } else if (obsType == ObservationType.GNSS1D || obsType == ObservationType.GNSS2D || obsType == ObservationType.GNSS3D) {
            compType = ((GNSSBaseline)observation).getComponentType();
        }
        this.setComponentType(compType);
        this.setObservationType(obsType);
        this.setValue(value);
        this.setGrossError(observation.getGrossError());
    }

    public final ObjectProperty<String> startPointNameProperty() {
        return this.startPointName;
    }

    public final String getStartPointName() {
        return (String)this.startPointNameProperty().get();
    }

    public final void setStartPointName(String startPointName) {
        this.startPointNameProperty().set((Object)startPointName);
    }

    public final ObjectProperty<String> endPointNameProperty() {
        return this.endPointName;
    }

    public final String getEndPointName() {
        return (String)this.endPointNameProperty().get();
    }

    public final void setEndPointName(String endPointName) {
        this.endPointNameProperty().set((Object)endPointName);
    }

    public final ObjectProperty<ObservationType> observationTypeProperty() {
        return this.observationType;
    }

    public final ObservationType getObservationType() {
        return (ObservationType)((Object)this.observationTypeProperty().get());
    }

    public final void setObservationType(ObservationType observationType) {
        this.observationTypeProperty().set((Object)observationType);
    }

    public final ObjectProperty<Double> valueProperty() {
        return this.value;
    }

    public final Double getValue() {
        return (Double)this.valueProperty().get();
    }

    public final void setValue(Double value) {
        this.valueProperty().set((Object)value);
    }

    public final ObjectProperty<Double> grossErrorProperty() {
        return this.grossError;
    }

    public final Double getGrossError() {
        return (Double)this.grossErrorProperty().get();
    }

    public final void setGrossError(Double grossError) {
        this.grossErrorProperty().set((Object)grossError);
    }

    public final ObjectProperty<ComponentType> componentTypeProperty() {
        return this.componentType;
    }

    public final ComponentType getComponentType() {
        return (ComponentType)((Object)this.componentTypeProperty().get());
    }

    public final void setComponentType(ComponentType componentType) {
        this.componentTypeProperty().set((Object)componentType);
    }
}

