/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table.column;

import java.io.BufferedInputStream;
import java.util.Properties;
import org.applied_geodesy.adjustment.network.DefaultUncertainty;
import org.applied_geodesy.jag3d.ui.table.column.ColumnContentType;

public class DefaultColumnProperty {
    private static final double NARROW = 75.0;
    private static final double NORMAL = 100.0;
    private static final double LARGE = 125.0;
    private static final double WIDE = 150.0;
    private static final Properties PROPERTIES = new Properties();

    static {
        BufferedInputStream bis = null;
        String path = "properties/tablecolumns.default";
        try {
            try {
                if (DefaultUncertainty.class.getClassLoader().getResourceAsStream("properties/tablecolumns.default") != null) {
                    bis = new BufferedInputStream(DefaultUncertainty.class.getClassLoader().getResourceAsStream("properties/tablecolumns.default"));
                    PROPERTIES.load(bis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DefaultColumnProperty() {
    }

    public static double getPrefWidth(ColumnContentType columnContentType) {
        double value = -1.0;
        switch (columnContentType) {
            case ENABLE: 
            case CODE: 
            case INSTRUMENT_HEIGHT: 
            case REFLECTOR_HEIGHT: 
            case REDUNDANCY: 
            case REDUNDANCY_X: 
            case REDUNDANCY_Y: 
            case REDUNDANCY_Z: 
            case NUMBER_OF_OBSERVATIONS: 
            case OMEGA: 
            case P_VALUE_APRIORI: 
            case P_VALUE_APOSTERIORI: 
            case TEST_STATISTIC_APRIORI: 
            case TEST_STATISTIC_APOSTERIORI: 
            case VARIANCE: {
                value = -1.0;
                try {
                    value = Double.parseDouble(PROPERTIES.getProperty(columnContentType.name()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return value > 0.0 ? Math.max(50.0, value) : 75.0;
            }
            case SIGNIFICANT: 
            case APPROXIMATED_DISTANCE_APRIORI: 
            case UNCERTAINTY_APRIORI: 
            case UNCERTAINTY_X_APRIORI: 
            case UNCERTAINTY_Y_APRIORI: 
            case UNCERTAINTY_Z_APRIORI: 
            case UNCERTAINTY_APOSTERIORI: 
            case UNCERTAINTY_X_APOSTERIORI: 
            case UNCERTAINTY_Y_APOSTERIORI: 
            case UNCERTAINTY_Z_APOSTERIORI: 
            case RESIDUAL: 
            case RESIDUAL_X: 
            case RESIDUAL_Y: 
            case RESIDUAL_Z: 
            case GROSS_ERROR: 
            case GROSS_ERROR_X: 
            case GROSS_ERROR_Y: 
            case GROSS_ERROR_Z: 
            case MINIMAL_DETECTABLE_BIAS: 
            case MINIMAL_DETECTABLE_BIAS_X: 
            case MINIMAL_DETECTABLE_BIAS_Y: 
            case MINIMAL_DETECTABLE_BIAS_Z: 
            case MAXIMUM_TOLERABLE_BIAS: 
            case MAXIMUM_TOLERABLE_BIAS_X: 
            case MAXIMUM_TOLERABLE_BIAS_Y: 
            case MAXIMUM_TOLERABLE_BIAS_Z: 
            case INFLUENCE_ON_POINT_POSITION: 
            case INFLUENCE_ON_POINT_POSITION_X: 
            case INFLUENCE_ON_POINT_POSITION_Y: 
            case INFLUENCE_ON_POINT_POSITION_Z: 
            case INFLUENCE_ON_NETWORK_DISTORTION: 
            case FIRST_PRINCIPLE_COMPONENT_X: 
            case FIRST_PRINCIPLE_COMPONENT_Y: 
            case FIRST_PRINCIPLE_COMPONENT_Z: 
            case CONFIDENCE_A: 
            case CONFIDENCE_B: 
            case CONFIDENCE_C: 
            case CONFIDENCE_ALPHA: 
            case CONFIDENCE_BETA: 
            case CONFIDENCE_GAMMA: {
                value = -1.0;
                try {
                    value = Double.parseDouble(PROPERTIES.getProperty(columnContentType.name()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return value > 0.0 ? Math.max(50.0, value) : 100.0;
            }
            case POINT_NAME: 
            case START_POINT_NAME: 
            case END_POINT_NAME: 
            case PARAMETER_NAME: 
            case VARIANCE_COMPONENT_TYPE: 
            case VARIANCE_COMPONENT_NAME: {
                value = -1.0;
                try {
                    value = Double.parseDouble(PROPERTIES.getProperty(columnContentType.name()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return value > 0.0 ? Math.max(50.0, value) : 150.0;
            }
            case VALUE_X_APRIORI: 
            case VALUE_Y_APRIORI: 
            case VALUE_Z_APRIORI: 
            case VALUE_X_APOSTERIORI: 
            case VALUE_Y_APOSTERIORI: 
            case VALUE_Z_APOSTERIORI: 
            case VALUE_APRIORI: 
            case VALUE_APOSTERIORI: {
                value = -1.0;
                try {
                    value = Double.parseDouble(PROPERTIES.getProperty(columnContentType.name()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return value > 0.0 ? Math.max(50.0, value) : 125.0;
            }
            case DEFAULT: {
                return 125.0;
            }
        }
        return 125.0;
    }
}

