/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table.column;

import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import org.applied_geodesy.jag3d.ui.table.column.ColumnContentType;
import org.applied_geodesy.jag3d.ui.table.column.ColumnProperty;

public class ContentColumn<S, T>
extends TableColumn<S, T> {
    private ColumnProperty columnProperty;

    public ContentColumn(ColumnProperty columnProperty) {
        this.columnProperty = columnProperty;
        this.setMinWidth(50.0);
        this.setPrefWidth(columnProperty.getPrefWidth());
        if (columnProperty.getColumnContentType() != ColumnContentType.DEFAULT) {
            this.prefWidthProperty().bindBidirectional((Property)columnProperty.prefWidthProperty());
            this.widthProperty().addListener((ChangeListener)new WidthChangListener());
            this.sortTypeProperty().bindBidirectional(columnProperty.sortTypeProperty());
        }
    }

    public ColumnProperty getColumnProperty() {
        return this.columnProperty;
    }

    private class WidthChangListener
    implements ChangeListener<Number> {
        private WidthChangListener() {
        }

        public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
            if (newValue != null && ContentColumn.this.columnProperty.getColumnContentType() != ColumnContentType.DEFAULT) {
                ContentColumn.this.columnProperty.setPrefWidth(newValue.doubleValue());
            }
        }
    }
}

