/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table.column;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.TableColumn;
import org.applied_geodesy.jag3d.ui.table.column.ColumnContentType;
import org.applied_geodesy.jag3d.ui.table.column.DefaultColumnProperty;

public class ColumnProperty {
    public static final double PREFERRED_WIDTH = 125.0;
    public static final double MIN_WIDTH = 50.0;
    private DoubleProperty prefWidth = new SimpleDoubleProperty((Object)this, "prefWidth", 125.0);
    private IntegerProperty sortOrder = new SimpleIntegerProperty((Object)this, "sortOrder", -1);
    private IntegerProperty columnOrder = new SimpleIntegerProperty((Object)this, "columnOrder", -1);
    private IntegerProperty defaultColumnOrder = new SimpleIntegerProperty((Object)this, "defaultColumnOrder", -1);
    private ObjectProperty<TableColumn.SortType> sortType = new SimpleObjectProperty((Object)this, "sortType", (Object)TableColumn.SortType.ASCENDING);
    private final ColumnContentType columnContentType;

    ColumnProperty(ColumnContentType columnContentType) {
        this.columnContentType = columnContentType;
        double prefWidth = DefaultColumnProperty.getPrefWidth(this.columnContentType);
        this.setPrefWidth(prefWidth);
    }

    public ColumnContentType getColumnContentType() {
        return this.columnContentType;
    }

    public DoubleProperty prefWidthProperty() {
        return this.prefWidth;
    }

    public TableColumn.SortType getSortType() {
        return (TableColumn.SortType)this.sortType.get();
    }

    public void setSortType(TableColumn.SortType sortType) {
        this.sortType.set((Object)sortType);
    }

    public ObjectProperty<TableColumn.SortType> sortTypeProperty() {
        return this.sortType;
    }

    public int getSortOrder() {
        return this.sortOrder.get();
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder.set(sortOrder);
    }

    public IntegerProperty sortOrderProperty() {
        return this.sortOrder;
    }

    public int getDefaultColumnOrder() {
        return this.defaultColumnOrder.get();
    }

    public void setDefaultColumnOrder(int defaultColumnOrder) {
        this.defaultColumnOrder.set(defaultColumnOrder);
    }

    public int getColumnOrder() {
        return this.columnOrder.get();
    }

    public void setColumnOrder(int columnOrder) {
        this.columnOrder.set(columnOrder);
        if (this.getDefaultColumnOrder() < 0) {
            this.setDefaultColumnOrder(columnOrder);
        }
    }

    public IntegerProperty columnOrderProperty() {
        return this.columnOrder;
    }

    public Double getPrefWidth() {
        return this.prefWidth.get();
    }

    public void setPrefWidth(double prefWidth) {
        this.prefWidth.set(Math.max(prefWidth, 50.0));
    }

    public String toString() {
        return "ColumnProperty [columnContentType=" + String.valueOf((Object)this.columnContentType) + ", prefWidth=" + String.valueOf(this.getPrefWidth()) + "]";
    }
}

