/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table.column;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.Pair;
import org.applied_geodesy.jag3d.ui.table.column.ColumnContentType;
import org.applied_geodesy.jag3d.ui.table.column.ColumnProperty;
import org.applied_geodesy.jag3d.ui.table.column.TableContentType;

public class ColumnPropertiesManager
implements Iterable<Map.Entry<Pair<TableContentType, ColumnContentType>, ColumnProperty>> {
    private static ColumnPropertiesManager columnPropertiesManager = new ColumnPropertiesManager();
    private Map<Pair<TableContentType, ColumnContentType>, ColumnProperty> properties = new HashMap<Pair<TableContentType, ColumnContentType>, ColumnProperty>();
    private Map<TableContentType, ObservableList<ColumnContentType>> tableSortOrder = new HashMap<TableContentType, ObservableList<ColumnContentType>>();
    private Map<TableContentType, ObservableList<ColumnContentType>> tableColumnsOrder = new HashMap<TableContentType, ObservableList<ColumnContentType>>();

    private ColumnPropertiesManager() {
    }

    public static ColumnPropertiesManager getInstance() {
        return columnPropertiesManager;
    }

    public ColumnProperty getProperty(TableContentType tableType, ColumnContentType columnType) {
        Pair key = new Pair((Object)tableType, (Object)columnType);
        if (!this.properties.containsKey(key)) {
            ColumnProperty property = new ColumnProperty(columnType);
            this.properties.put((Pair<TableContentType, ColumnContentType>)key, property);
        }
        return this.properties.get(key);
    }

    @Override
    public Iterator<Map.Entry<Pair<TableContentType, ColumnContentType>, ColumnProperty>> iterator() {
        return this.properties.entrySet().iterator();
    }

    public void clearOrder() {
        for (ObservableList<ColumnContentType> columnTypes : this.tableColumnsOrder.values()) {
            columnTypes.clear();
        }
        for (ObservableList<ColumnContentType> columnTypes : this.tableSortOrder.values()) {
            columnTypes.clear();
        }
    }

    public ObservableList<ColumnContentType> getSortOrder(TableContentType tableType) {
        if (!this.tableSortOrder.containsKey((Object)tableType)) {
            ObservableList columnTypes = FXCollections.observableArrayList();
            this.tableSortOrder.put(tableType, (ObservableList<ColumnContentType>)columnTypes);
        }
        return this.tableSortOrder.get((Object)tableType);
    }

    public ObservableList<ColumnContentType> getColumnsOrder(TableContentType tableType) {
        if (!this.tableColumnsOrder.containsKey((Object)tableType)) {
            ObservableList columnTypes = FXCollections.observableArrayList();
            this.tableColumnsOrder.put(tableType, (ObservableList<ColumnContentType>)columnTypes);
        }
        return this.tableColumnsOrder.get((Object)tableType);
    }
}

