/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.network.VerticalDeflectionType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.dnd.VerticalDeflectionRowDnD;
import org.applied_geodesy.jag3d.ui.table.UIEditableTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UITableBuilder;
import org.applied_geodesy.jag3d.ui.table.column.ColumnContentType;
import org.applied_geodesy.jag3d.ui.table.column.TableContentType;
import org.applied_geodesy.jag3d.ui.table.row.Row;
import org.applied_geodesy.jag3d.ui.table.row.VerticalDeflectionRow;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlight;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightRangeType;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;
import org.applied_geodesy.jag3d.ui.tree.EditableMenuCheckBoxTreeCell;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.jag3d.ui.tree.VerticalDeflectionTreeItemValue;
import org.applied_geodesy.ui.table.AbsoluteValueComparator;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.NaturalOrderTableColumnComparator;
import org.applied_geodesy.util.CellValueType;

public class UIVerticalDeflectionTableBuilder
extends UIEditableTableBuilder<VerticalDeflectionRow> {
    private VerticalDeflectionTreeItemValue verticalDeflectionItemValue;
    private VerticalDeflectionType type;
    private Map<VerticalDeflectionType, TableView<VerticalDeflectionRow>> tables = new HashMap<VerticalDeflectionType, TableView<VerticalDeflectionRow>>();
    private static UIVerticalDeflectionTableBuilder tableBuilder = new UIVerticalDeflectionTableBuilder();

    private UIVerticalDeflectionTableBuilder() {
    }

    public static UIVerticalDeflectionTableBuilder getInstance() {
        return tableBuilder;
    }

    public TableView<VerticalDeflectionRow> getTable(VerticalDeflectionTreeItemValue verticalDeflectionItemValue) {
        this.verticalDeflectionItemValue = verticalDeflectionItemValue;
        this.type = TreeItemType.getVerticalDeflectionTypeByTreeItemType(verticalDeflectionItemValue.getItemType());
        switch (this.type) {
            case REFERENCE_VERTICAL_DEFLECTION: 
            case STOCHASTIC_VERTICAL_DEFLECTION: 
            case UNKNOWN_VERTICAL_DEFLECTION: {
                this.init();
                return this.table;
            }
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, unsuported observation type " + String.valueOf((Object)this.type));
    }

    private TableContentType getTableContentType() {
        switch (this.type) {
            case REFERENCE_VERTICAL_DEFLECTION: {
                return TableContentType.REFERENCE_DEFLECTION;
            }
            case STOCHASTIC_VERTICAL_DEFLECTION: {
                return TableContentType.STOCHASTIC_DEFLECTION;
            }
        }
        return TableContentType.UNKNOWN_DEFLECTION;
    }

    private void init() {
        int columnIndex;
        if (this.tables.containsKey((Object)this.type)) {
            this.table = this.tables.get((Object)this.type);
            return;
        }
        TableColumn<VerticalDeflectionRow, Boolean> booleanColumn = null;
        TableColumn<VerticalDeflectionRow, String> stringColumn = null;
        TableColumn<VerticalDeflectionRow, Double> doubleColumn = null;
        TableContentType tableContentType = this.getTableContentType();
        TableView table = this.createTable();
        final int columnIndexEnable = columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.enable.label", "Enable");
        String tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.enable.tooltip", "State of the vertical deflection");
        CellValueType cellValueType = CellValueType.BOOLEAN;
        ColumnContentType columnContentType = ColumnContentType.ENABLE;
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::enableProperty, UIVerticalDeflectionTableBuilder.getBooleanCallback(), ColumnType.VISIBLE, columnIndex, true, true);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<VerticalDeflectionRow, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<VerticalDeflectionRow, Boolean> param) {
                UITableBuilder.TableCellChangeListener enableChangeListener = new UITableBuilder.TableCellChangeListener((UITableBuilder)UIVerticalDeflectionTableBuilder.this, columnIndexEnable, (Row)((VerticalDeflectionRow)param.getValue()));
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((VerticalDeflectionRow)param.getValue()).isEnable().booleanValue());
                booleanProp.addListener((ChangeListener)enableChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.station.name.label", "Point-Id");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.station.name.tooltip", "Id of the point");
        cellValueType = CellValueType.STRING;
        columnContentType = ColumnContentType.POINT_NAME;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::nameProperty, UIVerticalDeflectionTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true, true);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.y0.label", "\u03b6y0");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.y0.tooltip", "A-priori y-component of point deflection");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.VALUE_Y_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::yAprioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_DEFLECTION, columnIndex, true, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.x0.label", "\u03b6x0");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.x0.tooltip", "A-priori x-component of point deflection");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.VALUE_X_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::xAprioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_DEFLECTION, columnIndex, true, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.sigma.y0.label", "\u03c3y0");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.sigma.y0.tooltip", "A-priori uncertainty of y-component");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.UNCERTAINTY_Y_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::sigmaYaprioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION ? ColumnType.APRIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, true, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.sigma.x0.label", "\u03c3x0");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.sigma.x0.tooltip", "A-priori uncertainty of x-component");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.UNCERTAINTY_X_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::sigmaXaprioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION ? ColumnType.APRIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, true, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.y.label", "\u03b6y");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.y.tooltip", "Y-component of deflection of the vertical");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.VALUE_Y_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::yAposterioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_DEFLECTION, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.x.label", "\u03b6x");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.x.tooltip", "X-component of deflection of the vertical");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.VALUE_X_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::xAposterioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_DEFLECTION, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.sigma.y.label", "\u03c3y");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.sigma.y.tooltip", "A-posteriori uncertainty of y-component of deflection of the vertical");
        cellValueType = CellValueType.ANGLE_UNCERTAINTY;
        columnContentType = ColumnContentType.UNCERTAINTY_Y_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::sigmaYaposterioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.sigma.x.label", "\u03c3x");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.sigma.x.tooltip", "A-posteriori uncertainty of x-component of deflection of the vertical");
        cellValueType = CellValueType.ANGLE_UNCERTAINTY;
        columnContentType = ColumnContentType.UNCERTAINTY_X_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::sigmaXaposterioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.semiaxis.major.label", "a");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.semiaxis.major.tooltip", "Major semi axis");
        cellValueType = CellValueType.ANGLE_UNCERTAINTY;
        columnContentType = ColumnContentType.CONFIDENCE_A;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::confidenceAProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.semiaxis.minor.label", "c");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.semiaxis.minor.tooltip", "Minor semi axis");
        cellValueType = CellValueType.ANGLE_UNCERTAINTY;
        columnContentType = ColumnContentType.CONFIDENCE_C;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::confidenceCProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.redundancy.y.label", "ry");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.redundancy.y.tooltip", "Redundancy of y-component of deflection of the vertical");
        cellValueType = CellValueType.PERCENTAGE;
        columnContentType = ColumnContentType.REDUNDANCY_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::redundancyYProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.redundancy.x.label", "rx");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.redundancy.x.tooltip", "Redundancy of x-component of deflection of the vertical");
        cellValueType = CellValueType.PERCENTAGE;
        columnContentType = ColumnContentType.REDUNDANCY_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::redundancyXProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = this.type == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION ? i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.residual.y.label", "\u03b5y") : i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.deviation.y.label", "\u0394y");
        tooltipText = this.type == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION ? i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.residual.y.tooltip", "Residual of y-component of deflection of the vertical, i.e. computed minus observed") : i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.deviation.y.tooltip", "Deviation of y-component w.r.t. y0");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.RESIDUAL_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::residualYProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = this.type == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION ? i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.residual.x.label", "\u03b5y") : i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.deviation.x.label", "\u0394x");
        tooltipText = this.type == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION ? i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.residual.x.tooltip", "Residual of x-component of deflection of the vertical, i.e. computed minus observed") : i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.deviation.x.tooltip", "Deviation of x-component w.r.t. x0");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.RESIDUAL_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::residualXProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.grosserror.y.label", "\u2207y");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.grosserror.y.tooltip", "Gross-error of deflection of the vertical in y");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.GROSS_ERROR_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::grossErrorYProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.grosserror.x.label", "\u2207x");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.grosserror.x.tooltip", "Gross-error of deflection of the vertical in x");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.GROSS_ERROR_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::grossErrorXProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.maximumtolerablebias.y.label", "\u2207x(1)");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.maximumtolerablebias.y.tooltip", "Maximum tolerable bias of deflection of the vertical in y");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.MAXIMUM_TOLERABLE_BIAS_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::maximumTolerableBiasYProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.maximumtolerablebias.x.label", "\u2207y(1)");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.maximumtolerablebias.x.tooltip", "Maximum tolerable bias of deflection of the vertical in x");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.MAXIMUM_TOLERABLE_BIAS_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::maximumTolerableBiasXProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.minimaldetectablebias.y.label", "\u2207x(\u03bb)");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.minimaldetectablebias.y.tooltip", "Minimal detectable bias of deflection of the vertical in y");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.MINIMAL_DETECTABLE_BIAS_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::minimalDetectableBiasYProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.minimaldetectablebias.x.label", "\u2207y(\u03bb)");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.minimaldetectablebias.x.tooltip", "Minimal detectable bias of deflection of the vertical in x");
        cellValueType = CellValueType.ANGLE_RESIDUAL;
        columnContentType = ColumnContentType.MINIMAL_DETECTABLE_BIAS_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::minimalDetectableBiasXProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.omega.label", "\u03a9");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.omega.tooltip", "Weighted squares of residual");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.OMEGA;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::omegaProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.pvalue.apriori.label", "log(Pprio)");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.pvalue.apriori.tooltip", "A-priori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.P_VALUE_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::pValueAprioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.pvalue.aposteriori.label", "log(Ppost)");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.pvalue.aposteriori.tooltip", "A-posteriori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.P_VALUE_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::pValueAposterioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.teststatistic.apriori.label", "Tprio");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.teststatistic.apriori.tooltip", "A-priori test statistic");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.TEST_STATISTIC_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::testStatisticAprioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.teststatistic.aposteriori.label", "Tpost");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.teststatistic.aposteriori.tooltip", "A-posteriori test statistic");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.TEST_STATISTIC_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::testStatisticAposterioriProperty, UIVerticalDeflectionTableBuilder.getDoubleCallback(cellValueType), this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        final int columnIndexOutlierDeflection = columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.testdecision.label", "Significant");
        tooltipText = i18n.getString("UIVerticalDeflectionTableBuilder.tableheader.testdecision.tooltip", "Checked, if null-hypothesis is rejected");
        cellValueType = CellValueType.BOOLEAN;
        columnContentType = ColumnContentType.SIGNIFICANT;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(tableContentType, columnContentType, header, VerticalDeflectionRow::significantProperty, UIVerticalDeflectionTableBuilder.getBooleanCallback(), this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION ? ColumnType.APOSTERIORI_DEFLECTION : ColumnType.HIDDEN, columnIndex, false, true);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<VerticalDeflectionRow, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<VerticalDeflectionRow, Boolean> param) {
                UITableBuilder.TableCellChangeListener significantChangeListener = new UITableBuilder.TableCellChangeListener((UITableBuilder)UIVerticalDeflectionTableBuilder.this, columnIndexOutlierDeflection, (Row)((VerticalDeflectionRow)param.getValue()));
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((VerticalDeflectionRow)param.getValue()).isSignificant());
                booleanProp.addListener((ChangeListener)significantChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        this.addContextMenu(table, this.createContextMenu(UIEditableTableBuilder.ContextMenuType.DEFAULT));
        this.addDynamicRowAdder(table);
        this.addColumnOrderSequenceListeners(tableContentType, table);
        this.tables.put(this.type, table);
        this.table = table;
    }

    @Override
    public VerticalDeflectionRow getEmptyRow() {
        return new VerticalDeflectionRow();
    }

    @Override
    void setValue(final VerticalDeflectionRow rowData, int columnIndex, Object oldValue, Object newValue) {
        boolean valid = !(oldValue != null && !oldValue.toString().trim().isEmpty() || newValue != null && !newValue.toString().trim().isEmpty());
        switch (columnIndex) {
            case 0: {
                rowData.setEnable(newValue != null && newValue instanceof Boolean && (Boolean)newValue != false);
                valid = true;
                break;
            }
            case 1: {
                if (newValue != null && !newValue.toString().trim().isEmpty()) {
                    rowData.setName(newValue.toString().trim());
                    valid = true;
                    break;
                }
                rowData.setName(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            case 2: {
                if (newValue != null && newValue instanceof Double) {
                    rowData.setYApriori((Double)newValue);
                    valid = true;
                    break;
                }
                rowData.setYApriori(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 3: {
                if (newValue != null && newValue instanceof Double) {
                    rowData.setXApriori((Double)newValue);
                    valid = true;
                    break;
                }
                rowData.setXApriori(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 4: {
                rowData.setSigmaYapriori(newValue == null ? null : (newValue instanceof Double && (Double)newValue > 0.0 ? (Double)newValue : null));
                valid = true;
                break;
            }
            case 5: {
                rowData.setSigmaXapriori(newValue == null ? null : (newValue instanceof Double && (Double)newValue > 0.0 ? (Double)newValue : null));
                valid = true;
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Editable column exceed " + columnIndex);
                valid = false;
            }
        }
        if (valid && this.isComplete(rowData)) {
            if (rowData.getGroupId() < 0) {
                rowData.setGroupId(this.verticalDeflectionItemValue.getGroupId());
            }
            try {
                SQLManager.getInstance().saveItem(rowData);
            }
            catch (Exception e) {
                switch (columnIndex) {
                    case 1: {
                        rowData.setName(oldValue == null ? null : oldValue.toString().trim());
                        break;
                    }
                }
                valid = false;
                this.raiseErrorMessageSaveValue(e);
                e.printStackTrace();
            }
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UIVerticalDeflectionTableBuilder.this.table.refresh();
                UIVerticalDeflectionTableBuilder.this.table.requestFocus();
                UIVerticalDeflectionTableBuilder.this.table.getSelectionModel().clearSelection();
                UIVerticalDeflectionTableBuilder.this.table.getSelectionModel().select((Object)rowData);
                UIVerticalDeflectionTableBuilder.this.table.sort();
            }
        });
    }

    private boolean isComplete(VerticalDeflectionRow row) {
        return row.getName() != null && !row.getName().isBlank() && row.getXApriori() != null && row.getYApriori() != null;
    }

    @Override
    void enableDragSupport() {
        this.table.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ArrayList selectedRows = new ArrayList(UIVerticalDeflectionTableBuilder.this.table.getSelectionModel().getSelectedItems());
                if (selectedRows != null && !selectedRows.isEmpty()) {
                    ArrayList<VerticalDeflectionRowDnD> rowsDnD = new ArrayList<VerticalDeflectionRowDnD>(selectedRows.size());
                    for (VerticalDeflectionRow selectedRow : selectedRows) {
                        VerticalDeflectionRowDnD rowDnD = null;
                        if (!UIVerticalDeflectionTableBuilder.this.isComplete(selectedRow) || (rowDnD = VerticalDeflectionRowDnD.fromVerticalDeflectionRow(selectedRow)) == null) continue;
                        rowsDnD.add(rowDnD);
                    }
                    if (!rowsDnD.isEmpty()) {
                        Dragboard db = UIVerticalDeflectionTableBuilder.this.table.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                        ClipboardContent content = new ClipboardContent();
                        content.put((Object)EditableMenuCheckBoxTreeCell.TREE_ITEM_TYPE_DATA_FORMAT, (Object)UIVerticalDeflectionTableBuilder.this.verticalDeflectionItemValue.getItemType());
                        content.put((Object)EditableMenuCheckBoxTreeCell.GROUP_ID_DATA_FORMAT, (Object)UIVerticalDeflectionTableBuilder.this.verticalDeflectionItemValue.getGroupId());
                        content.put((Object)EditableMenuCheckBoxTreeCell.DIMENSION_DATA_FORMAT, (Object)UIVerticalDeflectionTableBuilder.this.verticalDeflectionItemValue.getDimension());
                        content.put((Object)EditableMenuCheckBoxTreeCell.VERTICAL_DEFLECTION_ROWS_DATA_FORMAT, rowsDnD);
                        db.setContent((Map)content);
                    }
                }
                event.consume();
            }
        });
    }

    @Override
    void duplicateRows() {
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        ArrayList<VerticalDeflectionRow> clonedRows = new ArrayList<VerticalDeflectionRow>(selectedRows.size());
        for (VerticalDeflectionRow row : selectedRows) {
            VerticalDeflectionRow clonedRow = VerticalDeflectionRow.cloneRowApriori(row);
            if (this.isComplete(clonedRow)) {
                try {
                    clonedRow.setName(SQLManager.getInstance().getNextValidVerticalDeflectionName(row.getName()));
                    SQLManager.getInstance().saveItem(clonedRow);
                }
                catch (Exception e) {
                    this.raiseErrorMessage(UIEditableTableBuilder.ContextMenuItemType.DUPLICATE, e);
                    e.printStackTrace();
                    break;
                }
            }
            clonedRows.add(clonedRow);
        }
        if (clonedRows != null && !clonedRows.isEmpty()) {
            ObservableList tableModel = this.getTableModel(this.table);
            tableModel.addAll(clonedRows);
            this.table.getSelectionModel().clearSelection();
            for (VerticalDeflectionRow clonedRow : clonedRows) {
                this.table.getSelectionModel().select((Object)clonedRow);
            }
            this.table.scrollTo((Object)((VerticalDeflectionRow)clonedRows.get(0)));
        }
    }

    @Override
    void removeRows() {
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        ArrayList<VerticalDeflectionRow> removedRows = new ArrayList<VerticalDeflectionRow>(selectedRows.size());
        for (VerticalDeflectionRow row : selectedRows) {
            if (this.isComplete(row)) {
                try {
                    SQLManager.getInstance().remove(row);
                }
                catch (Exception e) {
                    this.raiseErrorMessage(UIEditableTableBuilder.ContextMenuItemType.REMOVE, e);
                    e.printStackTrace();
                    break;
                }
            }
            removedRows.add(row);
        }
        if (removedRows != null && !removedRows.isEmpty()) {
            ObservableList tableModel = this.getTableModel(this.table);
            this.table.getSelectionModel().clearSelection();
            tableModel.removeAll(removedRows);
            if (tableModel.isEmpty()) {
                tableModel.setAll((Object[])new VerticalDeflectionRow[]{this.getEmptyRow()});
            }
        }
    }

    @Override
    void moveRows(UIEditableTableBuilder.ContextMenuItemType type) {
        if (type != UIEditableTableBuilder.ContextMenuItemType.MOVETO) {
            return;
        }
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(this.verticalDeflectionItemValue.getItemType());
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, false);
        try {
            SQLManager.getInstance().saveGroup((VerticalDeflectionTreeItemValue)newTreeItem.getValue());
        }
        catch (Exception e) {
            this.raiseErrorMessage(type, e);
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            return;
        }
        try {
            int groupId = ((VerticalDeflectionTreeItemValue)newTreeItem.getValue()).getGroupId();
            for (VerticalDeflectionRow row : selectedRows) {
                row.setGroupId(groupId);
                SQLManager.getInstance().saveItem(row);
            }
        }
        catch (Exception e) {
            this.raiseErrorMessage(type, e);
            e.printStackTrace();
            return;
        }
        MultipleSelectionModel selectionModel = UITreeBuilder.getInstance().getTree().getSelectionModel();
        selectionModel.clearSelection();
        selectionModel.select(newTreeItem);
    }

    public void export(File file, boolean aprioriValues) throws IOException {
        ObservableList rows = this.table.getItems();
        String exportFormatString = "%15s \t";
        String exportFormatDouble = "%20s \t";
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            for (VerticalDeflectionRow row : rows) {
                Double sigmaX;
                String name;
                if (!row.isEnable().booleanValue() || (name = row.getName()) == null || name.trim().isEmpty()) continue;
                Double y = aprioriValues ? row.getYApriori() : row.getYAposteriori();
                Double x = aprioriValues ? row.getXApriori() : row.getXAposteriori();
                Double sigmaY = aprioriValues ? row.getSigmaYapriori() : row.getSigmaYaposteriori();
                Double d = sigmaX = aprioriValues ? row.getSigmaXapriori() : row.getSigmaXaposteriori();
                if (!aprioriValues && (sigmaY == null || sigmaX == null)) continue;
                if (aprioriValues) {
                    if (sigmaY != null && sigmaY <= 0.0) {
                        sigmaY = null;
                    }
                    if (sigmaX != null && sigmaX <= 0.0) {
                        sigmaX = null;
                    }
                }
                String yValue = String.format(Locale.ENGLISH, exportFormatDouble, options.toAngleFormat(y, false));
                String xValue = String.format(Locale.ENGLISH, exportFormatDouble, options.toAngleFormat(x, false));
                String sigmaYvalue = sigmaY != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toAngleFormat(sigmaY, false)) : "";
                String sigmaXvalue = sigmaX != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toAngleFormat(sigmaX, false)) : "";
                writer.println(String.format(exportFormatString, name) + yValue + xValue + sigmaYvalue + sigmaXvalue);
            }
        }
    }

    @Override
    void highlightTableRow(TableRow<VerticalDeflectionRow> row) {
        if (row == null) {
            return;
        }
        TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
        TableRowHighlightType tableRowHighlightType = tableRowHighlight.getSelectedTableRowHighlightType();
        double leftBoundary = tableRowHighlight.getLeftBoundary(tableRowHighlightType);
        double rightBoundary = tableRowHighlight.getRightBoundary(tableRowHighlightType);
        VerticalDeflectionRow item = (VerticalDeflectionRow)row.getItem();
        if (!row.isSelected() && item != null) {
            switch (tableRowHighlightType) {
                case TEST_STATISTIC: {
                    if (this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION) {
                        this.setTableRowHighlight(row, item.isSignificant() ? TableRowHighlightRangeType.INADEQUATE : TableRowHighlightRangeType.EXCELLENT);
                        break;
                    }
                    this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                    break;
                }
                case GROSS_ERROR: {
                    if (this.type != VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION) {
                        Double grossErrorX = item.getGrossErrorX();
                        Double grossErrorY = item.getGrossErrorY();
                        Double mtbX = item.getMaximumTolerableBiasX();
                        Double mtbY = item.getMaximumTolerableBiasY();
                        Double mdbX = item.getMinimalDetectableBiasX();
                        Double mdbY = item.getMinimalDetectableBiasY();
                        double dMTB = Double.NaN;
                        double dMDB = Double.NaN;
                        if (grossErrorX != null && grossErrorY != null && mtbX != null && mtbY != null && mdbX != null && mdbY != null) {
                            dMTB = Math.max(Math.abs(grossErrorX) - Math.abs(mtbX), Math.abs(grossErrorY) - Math.abs(mtbY));
                            dMDB = Math.min(Math.abs(mdbX) - Math.abs(grossErrorX), Math.abs(mdbY) - Math.abs(grossErrorY));
                            if (dMTB > 0.0 && dMDB >= 0.0) {
                                this.setTableRowHighlight(row, TableRowHighlightRangeType.SATISFACTORY);
                                break;
                            }
                            if (dMDB < 0.0) {
                                this.setTableRowHighlight(row, TableRowHighlightRangeType.INADEQUATE);
                                break;
                            }
                            this.setTableRowHighlight(row, TableRowHighlightRangeType.EXCELLENT);
                            break;
                        }
                        this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                        break;
                    }
                    this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                    break;
                }
                case REDUNDANCY: {
                    if (this.type == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION) {
                        Double redundancyX = item.getRedundancyX();
                        Double redundancyY = item.getRedundancyY();
                        Double redundancy = null;
                        if (redundancyY != null && redundancyX != null) {
                            redundancy = Math.min(redundancyY, redundancyX);
                        }
                        if (redundancy == null) {
                            this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                            break;
                        }
                        this.setTableRowHighlight(row, redundancy < leftBoundary ? TableRowHighlightRangeType.INADEQUATE : (redundancy <= rightBoundary ? TableRowHighlightRangeType.SATISFACTORY : TableRowHighlightRangeType.EXCELLENT));
                        break;
                    }
                    this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                    break;
                }
                case INFLUENCE_ON_POSITION: {
                    this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                    break;
                }
                case P_PRIO_VALUE: {
                    Double pValue = item.getPValueApriori();
                    if (pValue == null) {
                        this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                        break;
                    }
                    this.setTableRowHighlight(row, pValue < Math.log(leftBoundary) ? TableRowHighlightRangeType.INADEQUATE : (pValue <= Math.log(rightBoundary) ? TableRowHighlightRangeType.SATISFACTORY : TableRowHighlightRangeType.EXCELLENT));
                    break;
                }
                case NONE: {
                    this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                }
            }
        } else {
            this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
        }
    }
}

