/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.applied_geodesy.jag3d.ui.table.UITableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.TestStatisticRow;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.util.CellValueType;

public class UITestStatisticTableBuilder
extends UITableBuilder<TestStatisticRow> {
    private static UITestStatisticTableBuilder tableBuilder = new UITestStatisticTableBuilder();
    private boolean isInitialize = false;

    private UITestStatisticTableBuilder() {
    }

    public static UITestStatisticTableBuilder getInstance() {
        tableBuilder.init();
        return tableBuilder;
    }

    private void init() {
        if (this.isInitialize) {
            return;
        }
        TableView table = this.createTable();
        TableColumn<TestStatisticRow, Double> doubleColumn = null;
        CellValueType cellValueTypeStatistic = CellValueType.STATISTIC;
        CellValueType cellValueTypePercent = CellValueType.PERCENTAGE;
        int columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UITestStatisticTableBuilder.tableheader.degrees_of_freedom_numerator.label", "d1");
        String tooltipText = i18n.getString("UITestStatisticTableBuilder.tableheader.degrees_of_freedom_numerator.tooltip", "Numerator degrees of freedom");
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueTypeStatistic, labelText, tooltipText);
        doubleColumn = this.getColumn(header, TestStatisticRow::numeratorDegreesOfFreedomProperty, UITestStatisticTableBuilder.getDoubleCallback(cellValueTypeStatistic), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITestStatisticTableBuilder.tableheader.degrees_of_freedom_denominator.label", "d2");
        tooltipText = i18n.getString("UITestStatisticTableBuilder.tableheader.degrees_of_freedom_denominator.tooltip", "Denominator degrees of freedom");
        header = new ColumnTooltipHeader(cellValueTypeStatistic, labelText, tooltipText);
        doubleColumn = this.getColumn(header, TestStatisticRow::denominatorDegreesOfFreedomProperty, UITestStatisticTableBuilder.getDoubleCallback(cellValueTypeStatistic), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITestStatisticTableBuilder.tableheader.probability_value.label", "\u03b1");
        tooltipText = i18n.getString("UITestStatisticTableBuilder.tableheader.probability_value.tooltip", "Probability value (type I-error)");
        header = new ColumnTooltipHeader(cellValueTypePercent, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueTypePercent).getUnit());
        doubleColumn = this.getColumn(header, TestStatisticRow::probabilityValueProperty, UITestStatisticTableBuilder.getDoubleCallback(cellValueTypePercent), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITestStatisticTableBuilder.tableheader.power_of_test.label", "1 - \u03b2");
        tooltipText = i18n.getString("UITestStatisticTableBuilder.tableheader.power_of_test.tooltip", "Power of test (type II-error)");
        header = new ColumnTooltipHeader(cellValueTypePercent, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueTypePercent).getUnit());
        doubleColumn = this.getColumn(header, TestStatisticRow::powerOfTestProperty, UITestStatisticTableBuilder.getDoubleCallback(cellValueTypePercent), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITestStatisticTableBuilder.tableheader.noncentrality_parameter.label", "\u03bb(\u03b1, \u03b2)");
        tooltipText = i18n.getString("UITestStatisticTableBuilder.tableheader.noncentrality_parameter.tooltip", "Noncentrality Parameter");
        header = new ColumnTooltipHeader(cellValueTypeStatistic, labelText, tooltipText);
        doubleColumn = this.getColumn(header, TestStatisticRow::noncentralityParameterProperty, UITestStatisticTableBuilder.getDoubleCallback(cellValueTypeStatistic), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITestStatisticTableBuilder.tableheader.p_value.label", "log(p)");
        tooltipText = i18n.getString("UITestStatisticTableBuilder.tableheader.p_value.tooltip", "p-value (logarithmic representation)");
        header = new ColumnTooltipHeader(cellValueTypeStatistic, labelText, tooltipText);
        doubleColumn = this.getColumn(header, TestStatisticRow::pValueProperty, UITestStatisticTableBuilder.getDoubleCallback(cellValueTypeStatistic), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITestStatisticTableBuilder.tableheader.quantile.label", "q");
        tooltipText = i18n.getString("UITestStatisticTableBuilder.tableheader.quantile.tooltip", "Quantile of F-distribution");
        header = new ColumnTooltipHeader(cellValueTypeStatistic, labelText, tooltipText);
        doubleColumn = this.getColumn(header, TestStatisticRow::quantileProperty, UITestStatisticTableBuilder.getDoubleCallback(cellValueTypeStatistic), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table = table;
        this.isInitialize = true;
    }

    @Override
    void setValue(TestStatisticRow row, int columnIndex, Object oldValue, Object newValue) {
    }

    @Override
    public TestStatisticRow getEmptyRow() {
        return new TestStatisticRow();
    }
}

