/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.dnd.TerrestrialObservationRowDnD;
import org.applied_geodesy.jag3d.ui.table.UIEditableTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UITableBuilder;
import org.applied_geodesy.jag3d.ui.table.column.ColumnContentType;
import org.applied_geodesy.jag3d.ui.table.column.TableContentType;
import org.applied_geodesy.jag3d.ui.table.row.ObservationRow;
import org.applied_geodesy.jag3d.ui.table.row.Row;
import org.applied_geodesy.jag3d.ui.table.row.TerrestrialObservationRow;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlight;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightRangeType;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;
import org.applied_geodesy.jag3d.ui.tree.EditableMenuCheckBoxTreeCell;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.table.AbsoluteValueComparator;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.NaturalOrderTableColumnComparator;
import org.applied_geodesy.util.CellValueType;

public class UITerrestrialObservationTableBuilder
extends UIEditableTableBuilder<TerrestrialObservationRow> {
    private ObservationTreeItemValue observationItemValue;
    private ObservationType type;
    private Map<ObservationType, TableView<TerrestrialObservationRow>> tables = new HashMap<ObservationType, TableView<TerrestrialObservationRow>>();
    private static UITerrestrialObservationTableBuilder tableBuilder = new UITerrestrialObservationTableBuilder();

    private UITerrestrialObservationTableBuilder() {
    }

    public static UITerrestrialObservationTableBuilder getInstance() {
        return tableBuilder;
    }

    public TableView<TerrestrialObservationRow> getTable(ObservationTreeItemValue observationItemValue) {
        this.observationItemValue = observationItemValue;
        this.type = TreeItemType.getObservationTypeByTreeItemType(observationItemValue.getItemType());
        switch (this.type) {
            case LEVELING: 
            case DIRECTION: 
            case HORIZONTAL_DISTANCE: 
            case SLOPE_DISTANCE: 
            case ZENITH_ANGLE: {
                this.init();
                return this.table;
            }
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, unsuported observation type " + String.valueOf((Object)this.type));
    }

    private TableContentType getTableContentType() {
        switch (this.type) {
            case LEVELING: {
                return TableContentType.LEVELING;
            }
            case DIRECTION: {
                return TableContentType.DIRECTION;
            }
            case HORIZONTAL_DISTANCE: {
                return TableContentType.HORIZONTAL_DISTANCE;
            }
            case SLOPE_DISTANCE: {
                return TableContentType.SLOPE_DISTANCE;
            }
            case ZENITH_ANGLE: {
                return TableContentType.ZENITH_ANGLE;
            }
        }
        return TableContentType.UNSPECIFIC;
    }

    private void init() {
        int columnIndex;
        if (this.tables.containsKey((Object)this.type)) {
            this.table = this.tables.get((Object)this.type);
            return;
        }
        TableColumn<TerrestrialObservationRow, Boolean> booleanColumn = null;
        TableColumn<TerrestrialObservationRow, String> stringColumn = null;
        TableColumn<TerrestrialObservationRow, Double> doubleColumn = null;
        TableContentType tableContentType = this.getTableContentType();
        TableView table = this.createTable();
        final int columnIndexEnable = columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.enable.label", "Enable");
        String tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.enable.tooltip", "State of the observation");
        CellValueType cellValueType = CellValueType.BOOLEAN;
        ColumnContentType columnContentType = ColumnContentType.ENABLE;
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::enableProperty, UITerrestrialObservationTableBuilder.getBooleanCallback(), ColumnType.VISIBLE, columnIndex, true, true);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TerrestrialObservationRow, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<TerrestrialObservationRow, Boolean> param) {
                UITableBuilder.TableCellChangeListener enableChangeListener = new UITableBuilder.TableCellChangeListener((UITableBuilder)UITerrestrialObservationTableBuilder.this, columnIndexEnable, (Row)((TerrestrialObservationRow)param.getValue()));
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((TerrestrialObservationRow)param.getValue()).isEnable());
                booleanProp.addListener((ChangeListener)enableChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.station.name.label", "Station-Id");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.station.name.tooltip", "Id of station");
        cellValueType = CellValueType.STRING;
        columnContentType = ColumnContentType.START_POINT_NAME;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::startPointNameProperty, UITerrestrialObservationTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true, true);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.target.name.label", "Target-Id");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.target.name.tooltip", "Id of target point");
        cellValueType = CellValueType.STRING;
        columnContentType = ColumnContentType.END_POINT_NAME;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::endPointNameProperty, UITerrestrialObservationTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true, true);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.station.height.label", "ih");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.station.height.tooltip", "Instrument height");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.INSTRUMENT_HEIGHT;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::instrumentHeightProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.target.height.label", "th");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.target.height.tooltip", "Target height");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.REFLECTOR_HEIGHT;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::reflectorHeightProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
        table.getColumns().add(doubleColumn);
        switch (this.type) {
            case LEVELING: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value0.leveling.label", "\u03b4h0");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value0.leveling.tooltip", "A-priori height difference");
                cellValueType = CellValueType.LENGTH;
                columnContentType = ColumnContentType.VALUE_APRIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::valueAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty0.leveling.label", "\u03c3h0");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty0.leveling.tooltip", "A-priori uncertainty of height difference");
                cellValueType = CellValueType.LENGTH_UNCERTAINTY;
                columnContentType = ColumnContentType.UNCERTAINTY_APRIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::sigmaAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            case DIRECTION: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value0.direction.label", "t0");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value0.direction.tooltip", "A-priori direction");
                cellValueType = CellValueType.ANGLE;
                columnContentType = ColumnContentType.VALUE_APRIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::valueAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty0.direction.label", "\u03c3t0");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty0.direction.tooltip", "A-priori uncertainty of direction");
                cellValueType = CellValueType.ANGLE_UNCERTAINTY;
                columnContentType = ColumnContentType.UNCERTAINTY_APRIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::sigmaAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            case HORIZONTAL_DISTANCE: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value0.horizontal_distance.label", "sh0");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value0.horizontal_distance.tooltip", "A-priori horizontal distance");
                cellValueType = CellValueType.LENGTH;
                columnContentType = ColumnContentType.VALUE_APRIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::valueAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty0.horizontal_distance.label", "\u03c3sh0");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty0.horizontal_distance.tooltip", "A-priori uncertainty of horizontal distance");
                cellValueType = CellValueType.LENGTH_UNCERTAINTY;
                columnContentType = ColumnContentType.UNCERTAINTY_APRIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::sigmaAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            case SLOPE_DISTANCE: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value0.slope_distance.label", "s0");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value0.slope_distance.tooltip", "A-priori slope distance");
                cellValueType = CellValueType.LENGTH;
                columnContentType = ColumnContentType.VALUE_APRIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::valueAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty0.slope_distance.label", "\u03c3s0");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty0.slope_distance.tooltip", "A-priori uncertainty of slope distance");
                cellValueType = CellValueType.LENGTH_UNCERTAINTY;
                columnContentType = ColumnContentType.UNCERTAINTY_APRIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::sigmaAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            case ZENITH_ANGLE: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value0.zenith_angle.label", "v0");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value0.zenith_angle.tooltip", "A-priori zenith angle");
                cellValueType = CellValueType.ANGLE;
                columnContentType = ColumnContentType.VALUE_APRIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::valueAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty0.zenith_angle.label", "\u03c3v0");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty0.zenith_angle.tooltip", "A-priori uncertainty of zenith angle");
                cellValueType = CellValueType.ANGLE_UNCERTAINTY;
                columnContentType = ColumnContentType.UNCERTAINTY_APRIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::sigmaAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Unsupported observation type " + String.valueOf((Object)this.type));
            }
        }
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.distance.label", "d0");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.distance.tooltip", "Length approximation for distance dependent uncertainty calculation");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.APPROXIMATED_DISTANCE_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::distanceAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, true, true);
        table.getColumns().add(doubleColumn);
        switch (this.type) {
            case LEVELING: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value.leveling.label", "\u03b4h");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value.leveling.tooltip", "A-posteriori height difference");
                cellValueType = CellValueType.LENGTH;
                columnContentType = ColumnContentType.VALUE_APOSTERIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::valueAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty.leveling.label", "\u03c3h");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty.leveling.tooltip", "A-posteriori uncertainty of height difference");
                cellValueType = CellValueType.LENGTH_UNCERTAINTY;
                columnContentType = ColumnContentType.UNCERTAINTY_APOSTERIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::sigmaAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            case DIRECTION: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value.direction.label", "t");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value.direction.tooltip", "A-posteriori direction");
                cellValueType = CellValueType.ANGLE;
                columnContentType = ColumnContentType.VALUE_APOSTERIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::valueAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty.direction.label", "\u03c3t");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty.direction.tooltip", "A-posteriori uncertainty of direction");
                cellValueType = CellValueType.ANGLE_UNCERTAINTY;
                columnContentType = ColumnContentType.UNCERTAINTY_APOSTERIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::sigmaAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            case HORIZONTAL_DISTANCE: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value.horizontal_distance.label", "sh");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value.horizontal_distance.tooltip", "A-posteriori horizontal distance");
                cellValueType = CellValueType.LENGTH;
                columnContentType = ColumnContentType.VALUE_APOSTERIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::valueAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty.horizontal_distance.label", "\u03c3sh");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty.horizontal_distance.tooltip", "A-posteriori uncertainty of horizontal distance");
                cellValueType = CellValueType.LENGTH_UNCERTAINTY;
                columnContentType = ColumnContentType.UNCERTAINTY_APOSTERIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::sigmaAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            case SLOPE_DISTANCE: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value.slope_distance.label", "s");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value.slope_distance.tooltip", "A-posteriori slope distance");
                cellValueType = CellValueType.LENGTH;
                columnContentType = ColumnContentType.VALUE_APOSTERIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::valueAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty.slope_distance.label", "\u03c3s");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty.slope_distance.tooltip", "A-posteriori uncertainty of slope distance");
                cellValueType = CellValueType.LENGTH_UNCERTAINTY;
                columnContentType = ColumnContentType.UNCERTAINTY_APOSTERIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::sigmaAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            case ZENITH_ANGLE: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value.zenith_angle.label", "v");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.value.zenith_angle.tooltip", "A-posteriori zenith angle");
                cellValueType = CellValueType.ANGLE;
                columnContentType = ColumnContentType.VALUE_APOSTERIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::valueAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty.zenith_angle.label", "\u03c3v");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.uncertainty.zenith_angle.tooltip", "A-posteriori uncertainty of zenith angle");
                cellValueType = CellValueType.ANGLE_UNCERTAINTY;
                columnContentType = ColumnContentType.UNCERTAINTY_APOSTERIORI;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::sigmaAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Unsupported observation type " + String.valueOf((Object)this.type));
            }
        }
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.redundancy.label", "r");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.redundancy.tooltip", "Redundancy");
        cellValueType = CellValueType.PERCENTAGE;
        columnContentType = ColumnContentType.REDUNDANCY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::redundancyProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        switch (this.type) {
            case LEVELING: 
            case HORIZONTAL_DISTANCE: 
            case SLOPE_DISTANCE: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.residual.label", "\u03b5");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.residual.tooltip", "Residual, i.e. computed minus observed");
                cellValueType = CellValueType.LENGTH_RESIDUAL;
                columnContentType = ColumnContentType.RESIDUAL;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::residualProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.grosserror.label", "\u2207");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.grosserror.tooltip", "Estimated gross error");
                cellValueType = CellValueType.LENGTH_RESIDUAL;
                columnContentType = ColumnContentType.GROSS_ERROR;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::grossErrorProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.maximumtolerablebias.label", "\u2207(1)");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.maximumtolerablebias.tooltip", "Maximum tolerable bias");
                cellValueType = CellValueType.LENGTH_RESIDUAL;
                columnContentType = ColumnContentType.MAXIMUM_TOLERABLE_BIAS;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::maximumTolerableBiasProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.minimaldetectablebias.label", "\u2207(\u03bb)");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.minimaldetectablebias.tooltip", "Minimal detectable bias");
                cellValueType = CellValueType.LENGTH_RESIDUAL;
                columnContentType = ColumnContentType.MINIMAL_DETECTABLE_BIAS;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::minimalDetectableBiasProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            case DIRECTION: 
            case ZENITH_ANGLE: {
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.residual.label", "\u03b5");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.residual.tooltip", "Residual, i.e. computed minus observed");
                cellValueType = CellValueType.ANGLE_RESIDUAL;
                columnContentType = ColumnContentType.RESIDUAL;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::residualProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.grosserror.label", "\u2207");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.grosserror.tooltip", "Estimated gross error");
                cellValueType = CellValueType.ANGLE_RESIDUAL;
                columnContentType = ColumnContentType.GROSS_ERROR;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::grossErrorProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.maximumtolerablebias.label", "\u2207(1)");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.maximumtolerablebias.tooltip", "Maximum tolerable bias");
                cellValueType = CellValueType.ANGLE_RESIDUAL;
                columnContentType = ColumnContentType.MAXIMUM_TOLERABLE_BIAS;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::maximumTolerableBiasProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                columnIndex = table.getColumns().size();
                labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.minimaldetectablebias.label", "\u2207(\u03bb)");
                tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.minimaldetectablebias.tooltip", "Minimal detectable bias");
                cellValueType = CellValueType.ANGLE_RESIDUAL;
                columnContentType = ColumnContentType.MINIMAL_DETECTABLE_BIAS;
                header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
                doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::minimalDetectableBiasProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
                doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
                table.getColumns().add(doubleColumn);
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Unsupported observation type " + String.valueOf((Object)this.type));
            }
        }
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.influenceonposition.label", "EP");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.influenceonposition.tooltip", "Influence on point position due to an undetected gross-error");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.INFLUENCE_ON_POINT_POSITION;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, TerrestrialObservationRow::influenceOnPointPositionProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.influenceonnetworkdistortion.label", "EF\u00b7SPmax");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.influenceonnetworkdistortion.tooltip", "Maximal influence on network distortion");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.INFLUENCE_ON_NETWORK_DISTORTION;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::influenceOnNetworkDistortionProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.omega.label", "\u03a9");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.omega.tooltip", "Weighted squares of residual");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.OMEGA;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::omegaProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.pvalue.apriori.label", "log(Pprio)");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.pvalue.apriori.tooltip", "A-priori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.P_VALUE_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::pValueAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.pvalue.aposteriori.label", "log(Ppost)");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.pvalue.aposteriori.tooltip", "A-posteriori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.P_VALUE_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::pValueAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.teststatistic.apriori.label", "Tprio");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.teststatistic.apriori.tooltip", "A-priori test statistic");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.TEST_STATISTIC_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::testStatisticAprioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.teststatistic.aposteriori.label", "Tpost");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.teststatistic.aposteriori.tooltip", "A-posteriori test statistic");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.TEST_STATISTIC_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::testStatisticAposterioriProperty, UITerrestrialObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        final int columnIndexOutlier = columnIndex = table.getColumns().size();
        labelText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.testdecision.label", "Significant");
        tooltipText = i18n.getString("UITerrestrialObservationTableBuilder.tableheader.testdecision.tooltip", "Checked, if null-hypothesis is rejected");
        cellValueType = CellValueType.BOOLEAN;
        columnContentType = ColumnContentType.SIGNIFICANT;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::significantProperty, UITerrestrialObservationTableBuilder.getBooleanCallback(), ColumnType.APOSTERIORI_TERRESTRIAL_OBSERVATION, columnIndex, false, true);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TerrestrialObservationRow, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<TerrestrialObservationRow, Boolean> param) {
                UITableBuilder.TableCellChangeListener significantChangeListener = new UITableBuilder.TableCellChangeListener((UITableBuilder)UITerrestrialObservationTableBuilder.this, columnIndexOutlier, (Row)((TerrestrialObservationRow)param.getValue()));
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((TerrestrialObservationRow)param.getValue()).isSignificant());
                booleanProp.addListener((ChangeListener)significantChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        this.addContextMenu(table, this.createContextMenu(UIEditableTableBuilder.ContextMenuType.OBSERVATION));
        this.addDynamicRowAdder(table);
        this.addColumnOrderSequenceListeners(tableContentType, table);
        this.tables.put(this.type, table);
        this.table = table;
    }

    @Override
    void setValue(final TerrestrialObservationRow rowData, int columnIndex, Object oldValue, Object newValue) {
        boolean valid = !(oldValue != null && !oldValue.toString().trim().isEmpty() || newValue != null && !newValue.toString().trim().isEmpty());
        switch (columnIndex) {
            case 0: {
                rowData.setEnable(newValue != null && newValue instanceof Boolean && (Boolean)newValue != false);
                valid = true;
                break;
            }
            case 1: {
                if (!(newValue == null || newValue.toString().trim().isEmpty() || rowData.getEndPointName() != null && rowData.getEndPointName().equals(newValue.toString().trim()))) {
                    rowData.setStartPointName(newValue.toString().trim());
                    valid = true;
                    break;
                }
                rowData.setStartPointName(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            case 2: {
                if (!(newValue == null || newValue.toString().trim().isEmpty() || rowData.getStartPointName() != null && rowData.getStartPointName().equals(newValue.toString().trim()))) {
                    rowData.setEndPointName(newValue.toString().trim());
                    valid = true;
                    break;
                }
                rowData.setEndPointName(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            case 3: {
                if (newValue != null && newValue instanceof Double) {
                    rowData.setInstrumentHeight((Double)newValue);
                    valid = true;
                    break;
                }
                rowData.setInstrumentHeight(0.0);
                break;
            }
            case 4: {
                if (newValue != null && newValue instanceof Double) {
                    rowData.setReflectorHeight((Double)newValue);
                    valid = true;
                    break;
                }
                rowData.setReflectorHeight(0.0);
                break;
            }
            case 5: {
                if (newValue != null && newValue instanceof Double) {
                    rowData.setValueApriori((Double)newValue);
                    valid = true;
                    break;
                }
                rowData.setValueApriori(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 6: {
                rowData.setSigmaApriori(newValue == null ? null : (newValue instanceof Double && (Double)newValue > 0.0 ? (Double)newValue : null));
                valid = true;
                break;
            }
            case 7: {
                rowData.setDistanceApriori(newValue == null ? null : (newValue instanceof Double && (Double)newValue > 0.0 ? (Double)newValue : null));
                valid = true;
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Editable column exceed " + columnIndex);
                valid = false;
            }
        }
        if (valid && this.isComplete(rowData)) {
            if (rowData.getGroupId() < 0) {
                rowData.setGroupId(this.observationItemValue.getGroupId());
            }
            try {
                SQLManager.getInstance().saveItem(rowData);
            }
            catch (Exception e) {
                switch (columnIndex) {
                    case 1: {
                        rowData.setStartPointName(oldValue == null ? null : oldValue.toString().trim());
                        break;
                    }
                    case 2: {
                        rowData.setEndPointName(oldValue == null ? null : oldValue.toString().trim());
                        break;
                    }
                }
                valid = false;
                this.raiseErrorMessageSaveValue(e);
                e.printStackTrace();
            }
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UITerrestrialObservationTableBuilder.this.table.refresh();
                UITerrestrialObservationTableBuilder.this.table.requestFocus();
                UITerrestrialObservationTableBuilder.this.table.getSelectionModel().clearSelection();
                UITerrestrialObservationTableBuilder.this.table.getSelectionModel().select((Object)rowData);
                UITerrestrialObservationTableBuilder.this.table.sort();
            }
        });
    }

    private boolean isComplete(TerrestrialObservationRow row) {
        return row.getStartPointName() != null && !row.getStartPointName().isBlank() && row.getEndPointName() != null && !row.getEndPointName().isBlank() && !row.getStartPointName().equals(row.getEndPointName()) && row.getInstrumentHeight() != null && row.getReflectorHeight() != null && row.getValueApriori() != null;
    }

    @Override
    public TerrestrialObservationRow getEmptyRow() {
        TerrestrialObservationRow emptyRow = new TerrestrialObservationRow();
        if (this.type == ObservationType.DIRECTION && !this.table.getItems().isEmpty()) {
            ObservableList items = this.table.getItems();
            String startPointName = null;
            for (TerrestrialObservationRow observationRow : items) {
                if (!this.isComplete(observationRow) || startPointName != null) continue;
                startPointName = observationRow.getStartPointName();
                break;
            }
            if (startPointName != null) {
                emptyRow.setStartPointName(startPointName);
            }
        }
        return emptyRow;
    }

    @Override
    void enableDragSupport() {
        this.table.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ArrayList selectedRows = new ArrayList(UITerrestrialObservationTableBuilder.this.table.getSelectionModel().getSelectedItems());
                if (selectedRows != null && !selectedRows.isEmpty()) {
                    ArrayList<TerrestrialObservationRowDnD> rowsDnD = new ArrayList<TerrestrialObservationRowDnD>(selectedRows.size());
                    for (TerrestrialObservationRow selectedRow : selectedRows) {
                        TerrestrialObservationRowDnD rowDnD = null;
                        if (!UITerrestrialObservationTableBuilder.this.isComplete(selectedRow) || (rowDnD = TerrestrialObservationRowDnD.fromTerrestrialObservationRow(selectedRow)) == null) continue;
                        rowsDnD.add(rowDnD);
                    }
                    if (!rowsDnD.isEmpty()) {
                        Dragboard db = UITerrestrialObservationTableBuilder.this.table.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                        ClipboardContent content = new ClipboardContent();
                        content.put((Object)EditableMenuCheckBoxTreeCell.TREE_ITEM_TYPE_DATA_FORMAT, (Object)UITerrestrialObservationTableBuilder.this.observationItemValue.getItemType());
                        content.put((Object)EditableMenuCheckBoxTreeCell.GROUP_ID_DATA_FORMAT, (Object)UITerrestrialObservationTableBuilder.this.observationItemValue.getGroupId());
                        content.put((Object)EditableMenuCheckBoxTreeCell.DIMENSION_DATA_FORMAT, (Object)UITerrestrialObservationTableBuilder.this.observationItemValue.getDimension());
                        content.put((Object)EditableMenuCheckBoxTreeCell.TERRESTRIAL_OBSERVATION_ROWS_DATA_FORMAT, rowsDnD);
                        db.setContent((Map)content);
                    }
                }
                event.consume();
            }
        });
    }

    @Override
    void duplicateRows() {
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        ArrayList<TerrestrialObservationRow> clonedRows = new ArrayList<TerrestrialObservationRow>(selectedRows.size());
        for (TerrestrialObservationRow row : selectedRows) {
            TerrestrialObservationRow clonedRow = TerrestrialObservationRow.cloneRowApriori(row);
            if (this.isComplete(clonedRow)) {
                try {
                    SQLManager.getInstance().saveItem(clonedRow);
                }
                catch (Exception e) {
                    this.raiseErrorMessage(UIEditableTableBuilder.ContextMenuItemType.DUPLICATE, e);
                    e.printStackTrace();
                    break;
                }
            }
            clonedRows.add(clonedRow);
        }
        if (clonedRows != null && !clonedRows.isEmpty()) {
            ObservableList tableModel = this.getTableModel(this.table);
            tableModel.addAll(clonedRows);
            this.table.getSelectionModel().clearSelection();
            for (TerrestrialObservationRow clonedRow : clonedRows) {
                this.table.getSelectionModel().select((Object)clonedRow);
            }
            this.table.scrollTo((Object)((TerrestrialObservationRow)clonedRows.get(0)));
        }
    }

    @Override
    void removeRows() {
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        ArrayList<TerrestrialObservationRow> removedRows = new ArrayList<TerrestrialObservationRow>(selectedRows.size());
        for (TerrestrialObservationRow row : selectedRows) {
            if (this.isComplete(row)) {
                try {
                    SQLManager.getInstance().remove(row);
                }
                catch (Exception e) {
                    this.raiseErrorMessage(UIEditableTableBuilder.ContextMenuItemType.REMOVE, e);
                    e.printStackTrace();
                    break;
                }
            }
            removedRows.add(row);
        }
        if (removedRows != null && !removedRows.isEmpty()) {
            this.table.getSelectionModel().clearSelection();
            ObservableList tableModel = this.getTableModel(this.table);
            tableModel.removeAll(removedRows);
            if (tableModel.isEmpty()) {
                tableModel.setAll((Object[])new TerrestrialObservationRow[]{this.getEmptyRow()});
            }
        }
    }

    @Override
    void moveRows(UIEditableTableBuilder.ContextMenuItemType type) {
        if (type != UIEditableTableBuilder.ContextMenuItemType.MOVETO) {
            return;
        }
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(this.observationItemValue.getItemType());
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, false);
        try {
            SQLManager.getInstance().saveGroup((ObservationTreeItemValue)newTreeItem.getValue());
        }
        catch (Exception e) {
            this.raiseErrorMessage(type, e);
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            return;
        }
        try {
            int groupId = ((ObservationTreeItemValue)newTreeItem.getValue()).getGroupId();
            for (TerrestrialObservationRow row : selectedRows) {
                row.setGroupId(groupId);
                SQLManager.getInstance().saveItem(row);
            }
        }
        catch (Exception e) {
            this.raiseErrorMessage(type, e);
            e.printStackTrace();
            return;
        }
        MultipleSelectionModel selectionModel = UITreeBuilder.getInstance().getTree().getSelectionModel();
        selectionModel.clearSelection();
        selectionModel.select(newTreeItem);
    }

    public void export(File file, boolean aprioriValues) throws IOException {
        ObservableList rows = this.table.getItems();
        String exportFormatString = "%15s \t";
        String exportFormatDouble = "%20s \t";
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            for (TerrestrialObservationRow row : rows) {
                String observationValue;
                String reflectorHeight;
                if (!row.isEnable()) continue;
                String startPointName = row.getStartPointName();
                String endPointName = row.getEndPointName();
                if (startPointName == null || startPointName.trim().isEmpty() || endPointName == null || endPointName.trim().isEmpty()) continue;
                Double value = aprioriValues ? row.getValueApriori() : row.getValueAposteriori();
                Double distance = aprioriValues ? row.getDistanceApriori() : null;
                Double sigma = aprioriValues ? row.getSigmaApriori() : row.getSigmaAposteriori();
                Double ih = row.getInstrumentHeight();
                Double th = row.getReflectorHeight();
                if (value == null || !aprioriValues && sigma == null) continue;
                String instrumentHeight = ih != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(ih, false)) : "";
                String string = reflectorHeight = th != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(th, false)) : "";
                if (aprioriValues) {
                    if (sigma != null && sigma <= 0.0) {
                        sigma = null;
                    }
                    if (sigma != null && sigma > 0.0) {
                        distance = null;
                    }
                    if (distance != null && distance <= 0.0) {
                        distance = null;
                    }
                }
                String sigmaValue = switch (this.type) {
                    case ObservationType.DIRECTION, ObservationType.ZENITH_ANGLE -> {
                        observationValue = value != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toAngleFormat(value, false)) : "";
                        yield sigma != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toAngleFormat(sigma, false)) : "";
                    }
                    default -> {
                        observationValue = value != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(value, false)) : "";
                        yield sigma != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(sigma, false)) : "";
                    }
                };
                String distanceValue = distance != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(distance, false)) : "";
                writer.println(String.format(exportFormatString, startPointName) + String.format(exportFormatString, endPointName) + instrumentHeight + reflectorHeight + observationValue + sigmaValue + distanceValue);
            }
        }
    }

    @Override
    void highlightTableRow(TableRow<TerrestrialObservationRow> row) {
        if (row == null) {
            return;
        }
        TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
        TableRowHighlightType tableRowHighlightType = tableRowHighlight.getSelectedTableRowHighlightType();
        double leftBoundary = tableRowHighlight.getLeftBoundary(tableRowHighlightType);
        double rightBoundary = tableRowHighlight.getRightBoundary(tableRowHighlightType);
        TerrestrialObservationRow item = (TerrestrialObservationRow)row.getItem();
        if (!row.isSelected() && item != null) {
            switch (tableRowHighlightType) {
                case TEST_STATISTIC: {
                    this.setTableRowHighlight(row, item.isSignificant() ? TableRowHighlightRangeType.INADEQUATE : TableRowHighlightRangeType.EXCELLENT);
                    break;
                }
                case GROSS_ERROR: {
                    Double grossError = item.getGrossError();
                    Double mtb = item.getMaximumTolerableBias();
                    Double mdb = item.getMinimalDetectableBias();
                    double dMTB = Double.NaN;
                    double dMDB = Double.NaN;
                    if (grossError != null && mtb != null && mdb != null) {
                        dMTB = Math.abs(grossError) - Math.abs(mtb);
                        dMDB = Math.abs(mdb) - Math.abs(grossError);
                        if (dMTB > 0.0 && dMDB >= 0.0) {
                            this.setTableRowHighlight(row, TableRowHighlightRangeType.SATISFACTORY);
                            break;
                        }
                        if (dMDB < 0.0) {
                            this.setTableRowHighlight(row, TableRowHighlightRangeType.INADEQUATE);
                            break;
                        }
                        this.setTableRowHighlight(row, TableRowHighlightRangeType.EXCELLENT);
                        break;
                    }
                    this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                    break;
                }
                case REDUNDANCY: {
                    Double redundancy = item.getRedundancy();
                    if (redundancy == null) {
                        this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                        break;
                    }
                    this.setTableRowHighlight(row, redundancy < leftBoundary ? TableRowHighlightRangeType.INADEQUATE : (redundancy <= rightBoundary ? TableRowHighlightRangeType.SATISFACTORY : TableRowHighlightRangeType.EXCELLENT));
                    break;
                }
                case INFLUENCE_ON_POSITION: {
                    Double influenceOnPosition = item.getInfluenceOnPointPosition();
                    if (influenceOnPosition == null) {
                        this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                        break;
                    }
                    this.setTableRowHighlight(row, Math.abs(influenceOnPosition) < leftBoundary ? TableRowHighlightRangeType.EXCELLENT : (Math.abs(influenceOnPosition) <= rightBoundary ? TableRowHighlightRangeType.SATISFACTORY : TableRowHighlightRangeType.INADEQUATE));
                    break;
                }
                case P_PRIO_VALUE: {
                    Double pValue = item.getPValueApriori();
                    if (pValue == null) {
                        this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                        break;
                    }
                    this.setTableRowHighlight(row, pValue < Math.log(leftBoundary) ? TableRowHighlightRangeType.INADEQUATE : (pValue <= Math.log(rightBoundary) ? TableRowHighlightRangeType.SATISFACTORY : TableRowHighlightRangeType.EXCELLENT));
                    break;
                }
                case NONE: {
                    this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                }
            }
        } else {
            this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
        }
    }
}

