/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.table.column.ColumnContentType;
import org.applied_geodesy.jag3d.ui.table.column.ColumnPropertiesManager;
import org.applied_geodesy.jag3d.ui.table.column.ColumnProperty;
import org.applied_geodesy.jag3d.ui.table.column.ContentColumn;
import org.applied_geodesy.jag3d.ui.table.column.TableContentType;
import org.applied_geodesy.jag3d.ui.table.row.Row;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlight;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightRangeType;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.EditableCell;
import org.applied_geodesy.ui.table.EditableDoubleCellConverter;
import org.applied_geodesy.ui.table.EditableIntegerCellConverter;
import org.applied_geodesy.ui.table.EditableStringCellConverter;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterOptions;

public abstract class UITableBuilder<T extends Row> {
    final NumberAndUnitFormatterChangedListener numberAndUnitFormatterChangedListener = new NumberAndUnitFormatterChangedListener();
    static FormatterOptions options = FormatterOptions.getInstance();
    static I18N i18n = I18N.getInstance();
    TableView<T> table = this.createTable();

    UITableBuilder() {
        options.addFormatterChangedListener(this.numberAndUnitFormatterChangedListener);
    }

    TableView<T> createTable() {
        this.table = new TableView();
        ObservableList tableModel = FXCollections.observableArrayList();
        SortedList sortedList = new SortedList(tableModel);
        sortedList.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)sortedList);
        this.table.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.table.setTableMenuButtonVisible(false);
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.table.setOnKeyPressed((EventHandler)new TableKeyEventHandler());
        tableModel.add(this.getEmptyRow());
        return this.table;
    }

    static <T> Callback<TableColumn<T, Integer>, TableCell<T, Integer>> getIntegerCallback() {
        return new Callback<TableColumn<T, Integer>, TableCell<T, Integer>>(){

            public TableCell<T, Integer> call(TableColumn<T, Integer> cell) {
                EditableCell tableCell = new EditableCell(new EditableIntegerCellConverter());
                tableCell.setAlignment(Pos.CENTER_RIGHT);
                return tableCell;
            }
        };
    }

    static <T> Callback<TableColumn<T, Double>, TableCell<T, Double>> getDoubleCallback(final CellValueType cellValueType) {
        return new Callback<TableColumn<T, Double>, TableCell<T, Double>>(){

            public TableCell<T, Double> call(TableColumn<T, Double> cell) {
                EditableCell tableCell = new EditableCell(new EditableDoubleCellConverter(cellValueType));
                tableCell.setAlignment(Pos.CENTER_RIGHT);
                return tableCell;
            }
        };
    }

    static <T> Callback<TableColumn<T, Double>, TableCell<T, Double>> getDoubleCallback(final CellValueType cellValueType, final boolean displayUnit) {
        return new Callback<TableColumn<T, Double>, TableCell<T, Double>>(){

            public TableCell<T, Double> call(TableColumn<T, Double> cell) {
                EditableCell tableCell = new EditableCell(new EditableDoubleCellConverter(cellValueType, displayUnit));
                tableCell.setAlignment(Pos.CENTER_RIGHT);
                return tableCell;
            }
        };
    }

    static <T> Callback<TableColumn<T, String>, TableCell<T, String>> getStringCallback() {
        return new Callback<TableColumn<T, String>, TableCell<T, String>>(){

            public TableCell<T, String> call(TableColumn<T, String> cell) {
                EditableCell tableCell = new EditableCell(new EditableStringCellConverter());
                tableCell.setAlignment(Pos.CENTER_LEFT);
                return tableCell;
            }
        };
    }

    static <T> Callback<TableColumn<T, Boolean>, TableCell<T, Boolean>> getBooleanCallback() {
        return new Callback<TableColumn<T, Boolean>, TableCell<T, Boolean>>(){

            public TableCell<T, Boolean> call(TableColumn<T, Boolean> cell) {
                CheckBoxTableCell tableCell = new CheckBoxTableCell();
                tableCell.setAlignment(Pos.CENTER);
                return tableCell;
            }
        };
    }

    void addContextMenu(TableView<T> table, final ContextMenu contextMenu) {
        table.setRowFactory(new Callback<TableView<T>, TableRow<T>>(){

            public TableRow<T> call(TableView<T> tableView) {
                TableRow row = new TableRow<T>(){

                    public void updateItem(T item, boolean empty) {
                        super.updateItem(item, empty);
                        UITableBuilder.this.highlightTableRow(this);
                    }
                };
                row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then(null).otherwise((Object)contextMenu));
                return row;
            }
        });
    }

    void addDynamicRowAdder(final TableView<T> table) {
        table.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getSource() == table) {
                    if (event.getTarget() instanceof TableCell && table.getItems() != null && ((TableCell)event.getTarget()).getIndex() >= table.getItems().size()) {
                        table.getSelectionModel().clearAndSelect(table.getItems().size() - 1);
                    } else if (event.getTarget() instanceof TableCell && table.getItems() != null && table.getItems().size() == table.getSelectionModel().getSelectedIndex() + 1) {
                        UITableBuilder.this.getTableModel(table).add(UITableBuilder.this.getEmptyRow());
                    }
                }
            }
        });
    }

    void addColumnOrderSequenceListeners(TableContentType tableContentType, TableView<T> table) {
        if (tableContentType != TableContentType.UNSPECIFIC) {
            ObservableList<ColumnContentType> sortOrder = ColumnPropertiesManager.getInstance().getSortOrder(tableContentType);
            ObservableList<ColumnContentType> columnsOrder = ColumnPropertiesManager.getInstance().getColumnsOrder(tableContentType);
            this.setSortOrderSequence(table, (List<? extends ColumnContentType>)sortOrder);
            this.setColumnsOrderSequence(table, (List<? extends ColumnContentType>)columnsOrder);
            table.getSortOrder().addListener((ListChangeListener)new SortOrderChangeListener());
            table.getColumns().addListener((ListChangeListener)new ColumnsOrderChangeListener());
            sortOrder.addListener((ListChangeListener)new SortOrderSequenceChangeListener(table));
            columnsOrder.addListener((ListChangeListener)new ColumnsOrderSequenceChangeListener(table));
        }
    }

    <S> TableColumn<T, S> getColumn(ColumnTooltipHeader header, Function<T, ObservableValue<S>> property, Callback<TableColumn<T, S>, TableCell<T, S>> callback, ColumnType type, int columnIndex, boolean editable) {
        return this.getColumn(TableContentType.UNSPECIFIC, ColumnContentType.DEFAULT, header, property, callback, type, columnIndex, editable, Boolean.FALSE);
    }

    <S> TableColumn<T, S> getColumn(TableContentType tableType, ColumnContentType columnType, ColumnTooltipHeader header, final Function<T, ObservableValue<S>> property, Callback<TableColumn<T, S>, TableCell<T, S>> callback, ColumnType type, int columnIndex, boolean editable, boolean reorderable) {
        ColumnPropertiesManager columnPropertiesManager = ColumnPropertiesManager.getInstance();
        ColumnProperty columnProperty = columnPropertiesManager.getProperty(tableType, columnType);
        columnProperty.setColumnOrder(columnIndex);
        columnProperty.setDefaultColumnOrder(columnIndex);
        ContentColumn column = new ContentColumn(columnProperty);
        TableCellEvent tableCellEvent = new TableCellEvent(columnIndex);
        Label columnLabel = header.getLabel();
        columnLabel.getStyleClass().add((Object)"column-header-label");
        columnLabel.setMaxWidth(Double.MAX_VALUE);
        columnLabel.setTooltip(header.getTooltip());
        column.setUserData((Object)type);
        column.setEditable(editable);
        column.setReorderable(reorderable);
        column.setGraphic((Node)columnLabel);
        column.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<T, S>, ObservableValue<S>>(){

            public ObservableValue<S> call(TableColumn.CellDataFeatures<T, S> param) {
                ObservableValue observableValue = (ObservableValue)property.apply((Row)param.getValue());
                return observableValue;
            }
        });
        column.setCellFactory(callback);
        column.setOnEditCommit(tableCellEvent);
        return column;
    }

    public void refreshTable() {
        if (this.table != null) {
            this.table.refresh();
        }
    }

    void highlightTableRow(TableRow<T> row) {
    }

    void setTableRowHighlight(TableRow<T> row, TableRowHighlightRangeType type) {
        Color color = TableRowHighlight.getInstance().getColor(type);
        Color darkerColor = color.darker();
        String rgbColor = String.format(Locale.ENGLISH, "rgb(%.0f, %.0f, %.0f, %.7f)", color.getRed() * 255.0, color.getGreen() * 255.0, color.getBlue() * 255.0, color.getOpacity());
        String rgbDarkerColor = String.format(Locale.ENGLISH, "rgb(%.0f, %.0f, %.0f, %.7f)", darkerColor.getRed() * 255.0, darkerColor.getGreen() * 255.0, darkerColor.getBlue() * 255.0, color.getOpacity());
        row.setStyle(color != null && color != Color.TRANSPARENT ? String.format("-fx-background-color: %s;", row.getIndex() % 2 == 0 ? rgbColor : rgbDarkerColor) : "");
    }

    public abstract T getEmptyRow();

    abstract void setValue(T var1, int var2, Object var3, Object var4);

    public TableView<T> getTable() {
        return this.table;
    }

    public ObservableList<T> getTableModel(TableView<T> tableView) {
        if (tableView.getItems() instanceof SortedList) {
            SortedList sortedList = (SortedList)tableView.getItems();
            return sortedList.getSource();
        }
        return tableView.getItems();
    }

    public static void copySelectionToClipboard(TableView<?> table) {
        StringBuilder clipboardString = new StringBuilder();
        for (TablePosition position : table.getSelectionModel().getSelectedCells()) {
            int rowIndex = position.getRow();
            if (rowIndex < 0 || rowIndex >= table.getItems().size()) continue;
            for (TableColumn column : table.getColumns()) {
                if (!column.isVisible()) continue;
                Object cell = column.getCellData(rowIndex);
                if (cell == null) {
                    cell = " ";
                }
                clipboardString.append(cell.toString()).append('\t');
            }
            clipboardString.append("\r\n");
        }
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    public static Object getValueAt(TableView<?> table, int columnIndex, int rowIndex) {
        return ((TableColumn)table.getColumns().get(columnIndex)).getCellObservableValue(rowIndex).getValue();
    }

    private void setSortOrderSequence(TableView<T> table, List<? extends ColumnContentType> columnTypes) {
        ArrayList<TableColumn> sortedColumns = new ArrayList<TableColumn>();
        ArrayList columns = new ArrayList(table.getColumns());
        if (columnTypes.isEmpty()) {
            for (TableColumn column : columns) {
                if (column == null || !(column instanceof ContentColumn)) continue;
                ((ContentColumn)column).getColumnProperty().setSortOrder(-1);
            }
        }
        int idx = 0;
        block1: for (ColumnContentType columnContentType : columnTypes) {
            ListIterator columnIterator = columns.listIterator();
            while (columnIterator.hasNext()) {
                ColumnContentType currentColumnType;
                TableColumn column = (TableColumn)columnIterator.next();
                if (!(column instanceof ContentColumn) || (currentColumnType = ((ContentColumn)column).getColumnProperty().getColumnContentType()) != columnContentType) continue;
                sortedColumns.add(column);
                ((ContentColumn)column).getColumnProperty().setSortOrder(idx++);
                columnIterator.remove();
                continue block1;
            }
        }
        table.getSortOrder().setAll(sortedColumns);
    }

    private void setColumnsOrderSequence(TableView<T> table, List<? extends ColumnContentType> columnTypes) {
        ArrayList<Object> orderedColumns = new ArrayList<Object>();
        ArrayList columns = new ArrayList(table.getColumns());
        if (columnTypes.isEmpty()) {
            for (TableColumn column : columns) {
                if (column == null || !(column instanceof ContentColumn)) continue;
                int defaultValue = ((ContentColumn)column).getColumnProperty().getDefaultColumnOrder();
                ((ContentColumn)column).getColumnProperty().setColumnOrder(defaultValue);
            }
            columns.sort(new Comparator<TableColumn<T, ?>>(){

                @Override
                public int compare(TableColumn<T, ?> column1, TableColumn<T, ?> column2) {
                    if (column1 == null || !(column1 instanceof ContentColumn)) {
                        return -1;
                    }
                    if (column2 == null || !(column2 instanceof ContentColumn)) {
                        return 1;
                    }
                    int defaultValue1 = ((ContentColumn)column1).getColumnProperty().getDefaultColumnOrder();
                    int defaultValue2 = ((ContentColumn)column2).getColumnProperty().getDefaultColumnOrder();
                    return defaultValue1 - defaultValue2;
                }
            });
        }
        int idx = 0;
        block1: for (ColumnContentType columnContentType : columnTypes) {
            ListIterator columnIterator = columns.listIterator();
            while (columnIterator.hasNext()) {
                ColumnContentType currentColumnType;
                TableColumn column = (TableColumn)columnIterator.next();
                if (!(column instanceof ContentColumn) || (currentColumnType = ((ContentColumn)column).getColumnProperty().getColumnContentType()) != columnContentType) continue;
                orderedColumns.add(column);
                ((ContentColumn)column).getColumnProperty().setColumnOrder(idx++);
                columnIterator.remove();
                continue block1;
            }
        }
        orderedColumns.addAll(columns);
        table.getColumns().setAll(orderedColumns);
    }

    private class ColumnsOrderChangeListener
    implements ListChangeListener<TableColumn<T, ?>> {
        private ColumnsOrderChangeListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends TableColumn<T, ?>> change) {
            int idx = 0;
            for (TableColumn addedColumnItem : change.getList()) {
                if (!(addedColumnItem instanceof ContentColumn)) continue;
                ((ContentColumn)addedColumnItem).getColumnProperty().setColumnOrder(idx++);
            }
        }
    }

    private class ColumnsOrderSequenceChangeListener
    implements ListChangeListener<ColumnContentType> {
        private final TableView<T> tableView;

        public ColumnsOrderSequenceChangeListener(TableView<T> tableView) {
            this.tableView = tableView;
        }

        public void onChanged(ListChangeListener.Change<? extends ColumnContentType> change) {
            UITableBuilder.this.setColumnsOrderSequence(this.tableView, (List<ColumnContentType>)change.getList());
        }
    }

    class NumberAndUnitFormatterChangedListener
    implements FormatterChangedListener {
        NumberAndUnitFormatterChangedListener() {
        }

        @Override
        public void formatterChanged(FormatterEvent evt) {
            if (UITableBuilder.this.table != null) {
                UITableBuilder.this.table.refresh();
            }
        }
    }

    private class SortOrderChangeListener
    implements ListChangeListener<TableColumn<T, ?>> {
        private SortOrderChangeListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends TableColumn<T, ?>> change) {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (TableColumn removedColumnItem : change.getRemoved()) {
                    if (!(removedColumnItem instanceof ContentColumn)) continue;
                    ((ContentColumn)removedColumnItem).getColumnProperty().setSortOrder(-1);
                }
            }
            int idx = 0;
            for (TableColumn addedColumnItem : change.getList()) {
                if (!(addedColumnItem instanceof ContentColumn)) continue;
                ((ContentColumn)addedColumnItem).getColumnProperty().setSortOrder(idx++);
            }
        }
    }

    private class SortOrderSequenceChangeListener
    implements ListChangeListener<ColumnContentType> {
        private final TableView<T> tableView;

        public SortOrderSequenceChangeListener(TableView<T> tableView) {
            this.tableView = tableView;
        }

        public void onChanged(ListChangeListener.Change<? extends ColumnContentType> change) {
            UITableBuilder.this.setSortOrderSequence(this.tableView, (List<ColumnContentType>)change.getList());
        }
    }

    static class TableCellChangeListener<S>
    implements ChangeListener<S> {
        private final int columnIndex;
        private final T rowData;
        final /* synthetic */ UITableBuilder this$0;

        TableCellChangeListener(int columnIndex, T rowData) {
            this.this$0 = var1_1;
            this.columnIndex = columnIndex;
            this.rowData = rowData;
        }

        public void changed(ObservableValue<? extends S> observable, S oldValue, S newValue) {
            if (this.rowData != null) {
                ArrayList selectedItems = new ArrayList(this.this$0.table.getSelectionModel().getSelectedItems());
                if (selectedItems == null || selectedItems.isEmpty() || !selectedItems.contains(this.rowData)) {
                    selectedItems = new ArrayList(1);
                    selectedItems.add(this.rowData);
                }
                for (Row item : selectedItems) {
                    this.this$0.setValue(item, this.columnIndex, oldValue, newValue);
                }
                if (selectedItems.size() > 1) {
                    this.this$0.table.refresh();
                }
                this.this$0.table.getSelectionModel().clearSelection();
                this.this$0.table.getSelectionModel().select(this.rowData);
            }
        }
    }

    class TableCellEvent<S>
    implements EventHandler<TableColumn.CellEditEvent<T, S>> {
        private final int columnIndex;

        TableCellEvent(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public void handle(TableColumn.CellEditEvent<T, S> event) {
            if (event.getTableColumn().isEditable()) {
                UITableBuilder.this.setValue((Row)event.getRowValue(), this.columnIndex, event.getOldValue(), event.getNewValue());
            }
        }
    }

    class TableKeyEventHandler
    implements EventHandler<KeyEvent> {
        KeyCodeCombination copyKeyCodeCompination = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY});

        TableKeyEventHandler() {
        }

        public void handle(KeyEvent keyEvent) {
            if (this.copyKeyCodeCompination.match(keyEvent) && keyEvent.getSource() instanceof TableView) {
                UITableBuilder.copySelectionToClipboard((TableView)keyEvent.getSource());
                keyEvent.consume();
            }
        }
    }
}

