/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.network.VarianceComponentType;
import org.applied_geodesy.jag3d.ui.table.UITableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIVarianceComponentTableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.ResidualSignDistributionRow;
import org.applied_geodesy.jag3d.ui.table.row.Row;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.NaturalOrderTableColumnComparator;
import org.applied_geodesy.util.CellValueType;

public class UIResidualSignDistributionTableBuilder
extends UITableBuilder<ResidualSignDistributionRow> {
    private static UIResidualSignDistributionTableBuilder tableBuilder = new UIResidualSignDistributionTableBuilder();
    private boolean isInitialize = false;

    private UIResidualSignDistributionTableBuilder() {
    }

    public static UIResidualSignDistributionTableBuilder getInstance() {
        tableBuilder.init();
        return tableBuilder;
    }

    private void init() {
        if (this.isInitialize) {
            return;
        }
        TableColumn<ResidualSignDistributionRow, VarianceComponentType> varianceComponentTypeColumn = null;
        TableColumn<ResidualSignDistributionRow, Boolean> booleanColumn = null;
        TableColumn<ResidualSignDistributionRow, Integer> integerColumn = null;
        TableColumn<ResidualSignDistributionRow, Double> doubleColumn = null;
        CellValueType cellValueTypeInteger = CellValueType.INTEGER;
        TableView table = this.createTable();
        int columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.type.label", "Component");
        String tooltipText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.type.tooltip", "Type of estimated variance component");
        CellValueType cellValueType = CellValueType.STRING;
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        varianceComponentTypeColumn = this.getColumn(header, ResidualSignDistributionRow::varianceComponentTypeProperty, UIResidualSignDistributionTableBuilder.getVarianceComponentTypeCallback(), ColumnType.VISIBLE, columnIndex, false);
        varianceComponentTypeColumn.setMinWidth(150.0);
        varianceComponentTypeColumn.setComparator(new NaturalOrderTableColumnComparator<VarianceComponentType>(varianceComponentTypeColumn));
        table.getColumns().add(varianceComponentTypeColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.number_of_observations.label", "n");
        tooltipText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.number_of_observations.tooltip", "Number of observations");
        header = new ColumnTooltipHeader(cellValueTypeInteger, labelText, tooltipText);
        integerColumn = this.getColumn(header, ResidualSignDistributionRow::numberOfObservationsProperty, UIResidualSignDistributionTableBuilder.getIntegerCallback(), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(integerColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.redundancy.label", "r");
        tooltipText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.redundancy.tooltip", "Redundancy");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, ResidualSignDistributionRow::redundancyProperty, UIResidualSignDistributionTableBuilder.getDoubleCallback(cellValueType), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.number_of_effective_observations.label", "n(r > 0)");
        tooltipText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.number_of_effective_observations.tooltip", "Number of effective observations");
        header = new ColumnTooltipHeader(cellValueTypeInteger, labelText, tooltipText);
        integerColumn = this.getColumn(header, ResidualSignDistributionRow::numberOfEffectiveObservationsProperty, UIResidualSignDistributionTableBuilder.getIntegerCallback(), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(integerColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.number_of_negative_residuals.label", "n(\u03b5 < 0)");
        tooltipText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.number_of_negative_residuals.tooltip", "Number of negative residuals");
        header = new ColumnTooltipHeader(cellValueTypeInteger, labelText, tooltipText);
        integerColumn = this.getColumn(header, ResidualSignDistributionRow::numberOfNegativeResidualsProperty, UIResidualSignDistributionTableBuilder.getIntegerCallback(), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(integerColumn);
        final int columnIndexOutlier = columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.significant.label", "Significant");
        tooltipText = i18n.getString("UIResidualSignDistributionTableBuilder.tableheader.significant.tooltip", "Checked, if number of negative signs is significant w.r.t. positive signs");
        cellValueType = CellValueType.BOOLEAN;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(header, ResidualSignDistributionRow::significantProperty, UIResidualSignDistributionTableBuilder.getBooleanCallback(), ColumnType.VISIBLE, columnIndex, false);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ResidualSignDistributionRow, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<ResidualSignDistributionRow, Boolean> param) {
                UITableBuilder.TableCellChangeListener significantChangeListener = new UITableBuilder.TableCellChangeListener((UITableBuilder)UIResidualSignDistributionTableBuilder.this, columnIndexOutlier, (Row)((ResidualSignDistributionRow)param.getValue()));
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((ResidualSignDistributionRow)param.getValue()).isSignificant());
                booleanProp.addListener((ChangeListener)significantChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table = table;
        this.isInitialize = true;
    }

    private static Callback<TableColumn<ResidualSignDistributionRow, VarianceComponentType>, TableCell<ResidualSignDistributionRow, VarianceComponentType>> getVarianceComponentTypeCallback() {
        return new Callback<TableColumn<ResidualSignDistributionRow, VarianceComponentType>, TableCell<ResidualSignDistributionRow, VarianceComponentType>>(){

            public TableCell<ResidualSignDistributionRow, VarianceComponentType> call(TableColumn<ResidualSignDistributionRow, VarianceComponentType> cell) {
                TextFieldTableCell tableCell = new TextFieldTableCell((StringConverter)new StringConverter<VarianceComponentType>(){

                    public String toString(VarianceComponentType type) {
                        if (type == null) {
                            return null;
                        }
                        return UIVarianceComponentTableBuilder.getVarianceComponentTypeLabel(type);
                    }

                    public VarianceComponentType fromString(String string) {
                        return VarianceComponentType.valueOf(string);
                    }
                });
                tableCell.setAlignment(Pos.CENTER_LEFT);
                return tableCell;
            }
        };
    }

    @Override
    void setValue(ResidualSignDistributionRow row, int columnIndex, Object oldValue, Object newValue) {
    }

    @Override
    public ResidualSignDistributionRow getEmptyRow() {
        return new ResidualSignDistributionRow();
    }
}

