/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.applied_geodesy.jag3d.ui.table.UITableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.PrincipalComponentRow;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.util.CellValueType;

public class UIPrincipalComponentTableBuilder
extends UITableBuilder<PrincipalComponentRow> {
    private static UIPrincipalComponentTableBuilder tableBuilder = new UIPrincipalComponentTableBuilder();
    private boolean isInitialize = false;

    private UIPrincipalComponentTableBuilder() {
    }

    public static UIPrincipalComponentTableBuilder getInstance() {
        tableBuilder.init();
        return tableBuilder;
    }

    private void init() {
        if (this.isInitialize) {
            return;
        }
        TableView table = this.createTable();
        TableColumn<PrincipalComponentRow, Integer> integerColumn = null;
        TableColumn<PrincipalComponentRow, Double> doubleColumn = null;
        CellValueType cellValueType = CellValueType.INTEGER;
        int columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIPrincipalComponentTableBuilder.tableheader.index.label", "k");
        String tooltipText = i18n.getString("UIPrincipalComponentTableBuilder.tableheader.index.tooltip", "k-te index of eigenvalue");
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        integerColumn = this.getColumn(header, PrincipalComponentRow::indexProperty, UIPrincipalComponentTableBuilder.getIntegerCallback(), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(integerColumn);
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPrincipalComponentTableBuilder.tableheader.square_root_eigenvalue.label", "\u221a\u03bb(k)");
        tooltipText = i18n.getString("UIPrincipalComponentTableBuilder.tableheader.square_root_eigenvalue.tooltip", "Square-root eigenvalue of covariance matrix");
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PrincipalComponentRow::valueProperty, UIPrincipalComponentTableBuilder.getDoubleCallback(cellValueType), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        cellValueType = CellValueType.PERCENTAGE;
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPrincipalComponentTableBuilder.tableheader.ratio.label", "\u03bb(k)/trace(Cxx)");
        tooltipText = i18n.getString("UIPrincipalComponentTableBuilder.tableheader.ratio.tooltip", "Ratio of eigenvalue \u03bb(k) w.r.t. trace of variance-covariance-matrix");
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PrincipalComponentRow::ratioProperty, UIPrincipalComponentTableBuilder.getDoubleCallback(cellValueType), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table = table;
        this.isInitialize = true;
    }

    @Override
    void setValue(PrincipalComponentRow row, int columnIndex, Object oldValue, Object newValue) {
    }

    @Override
    public PrincipalComponentRow getEmptyRow() {
        return new PrincipalComponentRow();
    }
}

