/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.dnd.GNSSObservationRowDnD;
import org.applied_geodesy.jag3d.ui.table.UIEditableTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UITableBuilder;
import org.applied_geodesy.jag3d.ui.table.column.ColumnContentType;
import org.applied_geodesy.jag3d.ui.table.column.TableContentType;
import org.applied_geodesy.jag3d.ui.table.row.GNSSObservationRow;
import org.applied_geodesy.jag3d.ui.table.row.ObservationRow;
import org.applied_geodesy.jag3d.ui.table.row.Row;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlight;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightRangeType;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;
import org.applied_geodesy.jag3d.ui.tree.EditableMenuCheckBoxTreeCell;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.table.AbsoluteValueComparator;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.NaturalOrderTableColumnComparator;
import org.applied_geodesy.util.CellValueType;

public class UIGNSSObservationTableBuilder
extends UIEditableTableBuilder<GNSSObservationRow> {
    private ObservationTreeItemValue observationItemValue;
    private ObservationType type;
    private Map<ObservationType, TableView<GNSSObservationRow>> tables = new HashMap<ObservationType, TableView<GNSSObservationRow>>();
    private static UIGNSSObservationTableBuilder tableBuilder = new UIGNSSObservationTableBuilder();

    private UIGNSSObservationTableBuilder() {
    }

    public static UIGNSSObservationTableBuilder getInstance() {
        return tableBuilder;
    }

    public TableView<GNSSObservationRow> getTable(ObservationTreeItemValue observationItemValue) {
        this.observationItemValue = observationItemValue;
        this.type = TreeItemType.getObservationTypeByTreeItemType(observationItemValue.getItemType());
        switch (this.type) {
            case GNSS1D: 
            case GNSS2D: 
            case GNSS3D: {
                this.init();
                return this.table;
            }
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, unsuported observation type " + String.valueOf((Object)this.type));
    }

    private TableContentType getTableContentType() {
        switch (this.type) {
            case GNSS1D: {
                return TableContentType.GNSS_1D;
            }
            case GNSS2D: {
                return TableContentType.GNSS_2D;
            }
        }
        return TableContentType.GNSS_3D;
    }

    private void init() {
        int columnIndex;
        if (this.tables.containsKey((Object)this.type)) {
            this.table = this.tables.get((Object)this.type);
            return;
        }
        TableColumn<GNSSObservationRow, Boolean> booleanColumn = null;
        TableColumn<GNSSObservationRow, String> stringColumn = null;
        TableColumn<GNSSObservationRow, Double> doubleColumn = null;
        TableContentType tableContentType = this.getTableContentType();
        TableView table = this.createTable();
        final int columnIndexEnable = columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.enable.label", "Enable");
        String tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.enable.tooltip", "State of the baseline");
        CellValueType cellValueType = CellValueType.BOOLEAN;
        ColumnContentType columnContentType = ColumnContentType.ENABLE;
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::enableProperty, UIGNSSObservationTableBuilder.getBooleanCallback(), ColumnType.VISIBLE, columnIndex, true, true);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<GNSSObservationRow, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<GNSSObservationRow, Boolean> param) {
                UITableBuilder.TableCellChangeListener enableChangeListener = new UITableBuilder.TableCellChangeListener((UITableBuilder)UIGNSSObservationTableBuilder.this, columnIndexEnable, (Row)((GNSSObservationRow)param.getValue()));
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((GNSSObservationRow)param.getValue()).isEnable());
                booleanProp.addListener((ChangeListener)enableChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.station.name.label", "Station-Id");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.station.name.tooltip", "Id of station");
        cellValueType = CellValueType.STRING;
        columnContentType = ColumnContentType.START_POINT_NAME;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::startPointNameProperty, UIGNSSObservationTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true, true);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.target.name.label", "Target-Id");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.target.name.tooltip", "Id of target point");
        cellValueType = CellValueType.STRING;
        columnContentType = ColumnContentType.END_POINT_NAME;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::endPointNameProperty, UIGNSSObservationTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true, true);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.y0.label", "y0");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.y0.tooltip", "A-priori y-component of the baseline");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.VALUE_Y_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::yAprioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APRIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, true, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.x0.label", "x0");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.x0.tooltip", "A-priori x-component of the baseline");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.VALUE_X_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::xAprioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APRIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, true, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.z0.label", "z0");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.z0.tooltip", "A-priori z-component of the baseline");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.VALUE_Z_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::zAprioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS2D ? ColumnType.APRIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, true, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.y0.label", "\u03c3y0");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.y0.tooltip", "A-priori uncertainty of y-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.UNCERTAINTY_Y_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::sigmaYaprioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APRIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, true, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.x0.label", "\u03c3x0");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.x0.tooltip", "A-priori uncertainty of x-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.UNCERTAINTY_X_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::sigmaXaprioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APRIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, true, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.z0.label", "\u03c3z0");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.z0.tooltip", "A-priori uncertainty of z-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.UNCERTAINTY_Z_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::sigmaZaprioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS2D ? ColumnType.APRIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, true, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.y.label", "y");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.y.tooltip", "A-posteriori y-component of the baseline");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.VALUE_Y_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::yAposterioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.x.label", "x");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.x.tooltip", "A-posteriori x-component of the baseline");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.VALUE_X_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::xAposterioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.z.label", "z");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.z.tooltip", "A-posteriori z-component of the baseline");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.VALUE_Z_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::zAposterioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS2D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.y.label", "\u03c3y");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.y.tooltip", "A-posteriori uncertainty of y-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.UNCERTAINTY_Y_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::sigmaYaposterioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.x.label", "\u03c3x");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.x.tooltip", "A-posteriori uncertainty of x-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.UNCERTAINTY_X_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::sigmaXaposterioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.z.label", "\u03c3z");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.sigma.z.tooltip", "A-posteriori uncertainty of z-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.UNCERTAINTY_Z_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::sigmaZaposterioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS2D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.redundancy.y.label", "ry");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.redundancy.y.tooltip", "Redundancy of y-component");
        cellValueType = CellValueType.PERCENTAGE;
        columnContentType = ColumnContentType.REDUNDANCY_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::redundancyYProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.redundancy.x.label", "rx");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.redundancy.x.tooltip", "Redundancy of x-component");
        cellValueType = CellValueType.PERCENTAGE;
        columnContentType = ColumnContentType.REDUNDANCY_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::redundancyXProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.redundancy.z.label", "rz");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.redundancy.z.tooltip", "Redundancy of z-component");
        cellValueType = CellValueType.PERCENTAGE;
        columnContentType = ColumnContentType.REDUNDANCY_Z;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::redundancyZProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS2D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.residual.y.label", "\u03b5y");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.residual.y.tooltip", "Residual of y-component of GNSS baseline, i.e. computed minus observed");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.RESIDUAL_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::residualYProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.residual.x.label", "\u03b5x");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.residual.x.tooltip", "Residual of x-component of GNSS baseline, i.e. computed minus observed");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.RESIDUAL_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::residualXProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.residual.z.label", "\u03b5z");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.residual.z.tooltip", "Residual of z-component of GNSS baseline, i.e. computed minus observed");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.RESIDUAL_Z;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::residualZProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS2D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.grosserror.y.label", "\u2207y");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.grosserror.y.tooltip", "Gross-error in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.GROSS_ERROR_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::grossErrorYProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.grosserror.x.label", "\u2207x");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.grosserror.x.tooltip", "Gross-error in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.GROSS_ERROR_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::grossErrorXProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.grosserror.z.label", "\u2207z");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.grosserror.z.tooltip", "Gross-error in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.GROSS_ERROR_Z;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::grossErrorZProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS2D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.maximumtolerablebias.y.label", "\u2207y(1)");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.maximumtolerablebias.y.tooltip", "Maximum tolerable bias in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.MAXIMUM_TOLERABLE_BIAS_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::maximumTolerableBiasYProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.maximumtolerablebias.x.label", "\u2207x(1)");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.maximumtolerablebias.x.tooltip", "Maximum tolerable bias in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.MAXIMUM_TOLERABLE_BIAS_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::maximumTolerableBiasXProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.maximumtolerablebias.z.label", "\u2207z(1)");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.maximumtolerablebias.z.tooltip", "Maximum tolerable bias in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.MAXIMUM_TOLERABLE_BIAS_Z;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::maximumTolerableBiasZProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS2D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.minimaldetectablebias.y.label", "\u2207y(\u03bb)");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.minimaldetectablebias.y.tooltip", "Minimal detectable bias in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.MINIMAL_DETECTABLE_BIAS_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::minimalDetectableBiasYProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.minimaldetectablebias.x.label", "\u2207x(\u03bb)");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.minimaldetectablebias.x.tooltip", "Minimal detectable bias in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.MINIMAL_DETECTABLE_BIAS_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::minimalDetectableBiasXProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.minimaldetectablebias.z.label", "\u2207z(\u03bb)");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.minimaldetectablebias.z.tooltip", "Minimal detectable bias in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.MINIMAL_DETECTABLE_BIAS_Z;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::minimalDetectableBiasZProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS2D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.influenceonposition.y.label", "EPy");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.influenceonposition.y.tooltip", "Influence on point position due to an undetected gross-error in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.INFLUENCE_ON_POINT_POSITION_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::influenceOnPointPositionYProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.influenceonposition.x.label", "EPx");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.influenceonposition.x.tooltip", "Influence on point position due to an undetected gross-error in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.INFLUENCE_ON_POINT_POSITION_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::influenceOnPointPositionXProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS1D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.influenceonposition.z.label", "EPz");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.influenceonposition.z.tooltip", "Influence on point position due to an undetected gross-error in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.INFLUENCE_ON_POINT_POSITION_Z;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, GNSSObservationRow::influenceOnPointPositionZProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), this.type != ObservationType.GNSS2D ? ColumnType.APOSTERIORI_GNSS_OBSERVATION : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.influenceonnetworkdistortion.label", "EF\u00b7SPmax");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.influenceonnetworkdistortion.tooltip", "Maximal influence on network distortion");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.INFLUENCE_ON_NETWORK_DISTORTION;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::influenceOnNetworkDistortionProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_GNSS_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.omega.label", "\u03a9");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.omega.tooltip", "Weighted squares of residual");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.OMEGA;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::omegaProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_GNSS_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.pvalue.apriori.label", "log(Pprio)");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.pvalue.apriori.tooltip", "A-priori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.P_VALUE_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::pValueAprioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_GNSS_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.pvalue.aposteriori.label", "log(Ppost)");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.pvalue.aposteriori.tooltip", "A-posteriori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.P_VALUE_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::pValueAposterioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_GNSS_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.teststatistic.apriori.label", "Tprio");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.teststatistic.apriori.tooltip", "A-priori test statistic");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.TEST_STATISTIC_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::testStatisticAprioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_GNSS_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.teststatistic.aposteriori.label", "Tpost");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.teststatistic.aposteriori.tooltip", "A-posteriori test statistic");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.TEST_STATISTIC_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::testStatisticAposterioriProperty, UIGNSSObservationTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_GNSS_OBSERVATION, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        final int columnIndexOutlier = columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.testdecision.label", "Significant");
        tooltipText = i18n.getString("UIGNSSObservationTableBuilder.tableheader.testdecision.tooltip", "Checked, if null-hypothesis is rejected");
        cellValueType = CellValueType.BOOLEAN;
        columnContentType = ColumnContentType.SIGNIFICANT;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(tableContentType, columnContentType, header, ObservationRow::significantProperty, UIGNSSObservationTableBuilder.getBooleanCallback(), ColumnType.APOSTERIORI_GNSS_OBSERVATION, columnIndex, false, true);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<GNSSObservationRow, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<GNSSObservationRow, Boolean> param) {
                UITableBuilder.TableCellChangeListener significantChangeListener = new UITableBuilder.TableCellChangeListener((UITableBuilder)UIGNSSObservationTableBuilder.this, columnIndexOutlier, (Row)((GNSSObservationRow)param.getValue()));
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((GNSSObservationRow)param.getValue()).isSignificant());
                booleanProp.addListener((ChangeListener)significantChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        this.addContextMenu(table, this.createContextMenu(UIEditableTableBuilder.ContextMenuType.DEFAULT));
        this.addDynamicRowAdder(table);
        this.addColumnOrderSequenceListeners(tableContentType, table);
        this.tables.put(this.type, table);
        this.table = table;
    }

    @Override
    void setValue(final GNSSObservationRow rowData, int columnIndex, Object oldValue, Object newValue) {
        boolean valid = !(oldValue != null && !oldValue.toString().trim().isEmpty() || newValue != null && !newValue.toString().trim().isEmpty());
        switch (columnIndex) {
            case 0: {
                rowData.setEnable(newValue != null && newValue instanceof Boolean && (Boolean)newValue != false);
                valid = true;
                break;
            }
            case 1: {
                if (!(newValue == null || newValue.toString().trim().isEmpty() || rowData.getEndPointName() != null && rowData.getEndPointName().equals(newValue.toString().trim()))) {
                    rowData.setStartPointName(newValue.toString().trim());
                    valid = true;
                    break;
                }
                rowData.setStartPointName(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            case 2: {
                if (!(newValue == null || newValue.toString().trim().isEmpty() || rowData.getStartPointName() != null && rowData.getStartPointName().equals(newValue.toString().trim()))) {
                    rowData.setEndPointName(newValue.toString().trim());
                    valid = true;
                    break;
                }
                rowData.setEndPointName(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            case 3: {
                if (newValue != null && newValue instanceof Double) {
                    rowData.setYApriori((Double)newValue);
                    valid = true;
                    break;
                }
                rowData.setYApriori(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 4: {
                if (newValue != null && newValue instanceof Double) {
                    rowData.setXApriori((Double)newValue);
                    valid = true;
                    break;
                }
                rowData.setXApriori(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 5: {
                if (newValue != null && newValue instanceof Double) {
                    rowData.setZApriori((Double)newValue);
                    valid = true;
                    break;
                }
                rowData.setZApriori(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 6: {
                rowData.setSigmaYapriori(newValue == null ? null : (newValue instanceof Double && (Double)newValue > 0.0 ? (Double)newValue : null));
                valid = true;
                break;
            }
            case 7: {
                rowData.setSigmaXapriori(newValue == null ? null : (newValue instanceof Double && (Double)newValue > 0.0 ? (Double)newValue : null));
                valid = true;
                break;
            }
            case 8: {
                rowData.setSigmaZapriori(newValue == null ? null : (newValue instanceof Double && (Double)newValue > 0.0 ? (Double)newValue : null));
                valid = true;
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Editable column exceed " + columnIndex);
                valid = false;
            }
        }
        if (valid && this.isComplete(rowData)) {
            if (rowData.getGroupId() < 0) {
                rowData.setGroupId(this.observationItemValue.getGroupId());
            }
            try {
                SQLManager.getInstance().saveItem(rowData);
            }
            catch (Exception e) {
                switch (columnIndex) {
                    case 1: {
                        rowData.setStartPointName(oldValue == null ? null : oldValue.toString().trim());
                        break;
                    }
                    case 2: {
                        rowData.setEndPointName(oldValue == null ? null : oldValue.toString().trim());
                        break;
                    }
                }
                valid = false;
                this.raiseErrorMessageSaveValue(e);
                e.printStackTrace();
            }
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UIGNSSObservationTableBuilder.this.table.refresh();
                UIGNSSObservationTableBuilder.this.table.requestFocus();
                UIGNSSObservationTableBuilder.this.table.getSelectionModel().clearSelection();
                UIGNSSObservationTableBuilder.this.table.getSelectionModel().select((Object)rowData);
                UIGNSSObservationTableBuilder.this.table.sort();
            }
        });
    }

    @Override
    public GNSSObservationRow getEmptyRow() {
        return new GNSSObservationRow();
    }

    private boolean isComplete(GNSSObservationRow row) {
        return row.getStartPointName() != null && !row.getStartPointName().trim().isEmpty() && row.getEndPointName() != null && !row.getEndPointName().trim().isEmpty() && !row.getStartPointName().equals(row.getEndPointName()) && row.getXApriori() != null && row.getYApriori() != null && row.getZApriori() != null;
    }

    @Override
    void enableDragSupport() {
        this.table.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ArrayList selectedRows = new ArrayList(UIGNSSObservationTableBuilder.this.table.getSelectionModel().getSelectedItems());
                if (selectedRows != null && !selectedRows.isEmpty()) {
                    ArrayList<GNSSObservationRowDnD> rowsDnD = new ArrayList<GNSSObservationRowDnD>(selectedRows.size());
                    for (GNSSObservationRow selectedRow : selectedRows) {
                        GNSSObservationRowDnD rowDnD = null;
                        if (!UIGNSSObservationTableBuilder.this.isComplete(selectedRow) || (rowDnD = GNSSObservationRowDnD.fromGNSSObservationRow(selectedRow)) == null) continue;
                        rowsDnD.add(rowDnD);
                    }
                    if (!rowsDnD.isEmpty()) {
                        Dragboard db = UIGNSSObservationTableBuilder.this.table.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                        ClipboardContent content = new ClipboardContent();
                        content.put((Object)EditableMenuCheckBoxTreeCell.TREE_ITEM_TYPE_DATA_FORMAT, (Object)UIGNSSObservationTableBuilder.this.observationItemValue.getItemType());
                        content.put((Object)EditableMenuCheckBoxTreeCell.GROUP_ID_DATA_FORMAT, (Object)UIGNSSObservationTableBuilder.this.observationItemValue.getGroupId());
                        content.put((Object)EditableMenuCheckBoxTreeCell.DIMENSION_DATA_FORMAT, (Object)UIGNSSObservationTableBuilder.this.observationItemValue.getDimension());
                        content.put((Object)EditableMenuCheckBoxTreeCell.GNSS_OBSERVATION_ROWS_DATA_FORMAT, rowsDnD);
                        db.setContent((Map)content);
                    }
                }
                event.consume();
            }
        });
    }

    @Override
    void duplicateRows() {
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        ArrayList<GNSSObservationRow> clonedRows = new ArrayList<GNSSObservationRow>(selectedRows.size());
        for (GNSSObservationRow row : selectedRows) {
            GNSSObservationRow clonedRow = GNSSObservationRow.cloneRowApriori(row);
            if (this.isComplete(clonedRow)) {
                try {
                    SQLManager.getInstance().saveItem(clonedRow);
                }
                catch (Exception e) {
                    this.raiseErrorMessage(UIEditableTableBuilder.ContextMenuItemType.DUPLICATE, e);
                    e.printStackTrace();
                    break;
                }
            }
            clonedRows.add(clonedRow);
        }
        if (clonedRows != null && !clonedRows.isEmpty()) {
            ObservableList tableModel = this.getTableModel(this.table);
            tableModel.addAll(clonedRows);
            this.table.getSelectionModel().clearSelection();
            for (GNSSObservationRow clonedRow : clonedRows) {
                this.table.getSelectionModel().select((Object)clonedRow);
            }
            this.table.scrollTo((Object)((GNSSObservationRow)clonedRows.get(0)));
        }
    }

    @Override
    void removeRows() {
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        ArrayList<GNSSObservationRow> removedRows = new ArrayList<GNSSObservationRow>(selectedRows.size());
        for (GNSSObservationRow row : selectedRows) {
            if (this.isComplete(row)) {
                try {
                    SQLManager.getInstance().remove(row);
                }
                catch (Exception e) {
                    this.raiseErrorMessage(UIEditableTableBuilder.ContextMenuItemType.REMOVE, e);
                    e.printStackTrace();
                    break;
                }
            }
            removedRows.add(row);
        }
        if (removedRows != null && !removedRows.isEmpty()) {
            this.table.getSelectionModel().clearSelection();
            ObservableList tableModel = this.getTableModel(this.table);
            tableModel.removeAll(removedRows);
            if (tableModel.isEmpty()) {
                tableModel.setAll((Object[])new GNSSObservationRow[]{this.getEmptyRow()});
            }
        }
    }

    @Override
    void moveRows(UIEditableTableBuilder.ContextMenuItemType type) {
        if (type != UIEditableTableBuilder.ContextMenuItemType.MOVETO) {
            return;
        }
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(this.observationItemValue.getItemType());
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, false);
        try {
            SQLManager.getInstance().saveGroup((ObservationTreeItemValue)newTreeItem.getValue());
        }
        catch (Exception e) {
            this.raiseErrorMessage(type, e);
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            return;
        }
        try {
            int groupId = ((ObservationTreeItemValue)newTreeItem.getValue()).getGroupId();
            for (GNSSObservationRow row : selectedRows) {
                row.setGroupId(groupId);
                SQLManager.getInstance().saveItem(row);
            }
        }
        catch (Exception e) {
            this.raiseErrorMessage(type, e);
            e.printStackTrace();
            return;
        }
        MultipleSelectionModel selectionModel = UITreeBuilder.getInstance().getTree().getSelectionModel();
        selectionModel.clearSelection();
        selectionModel.select(newTreeItem);
    }

    public void export(File file, boolean aprioriValues) throws IOException {
        ObservableList rows = this.table.getItems();
        String exportFormatString = "%15s \t";
        String exportFormatDouble = "%20s \t";
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            for (GNSSObservationRow row : rows) {
                Double sigmaZ;
                Double z;
                if (!row.isEnable()) continue;
                String startPointName = row.getStartPointName();
                String endPointName = row.getEndPointName();
                if (startPointName == null || startPointName.trim().isEmpty() || endPointName == null || endPointName.trim().isEmpty()) continue;
                Double y = aprioriValues ? row.getYApriori() : row.getYAposteriori();
                Double x = aprioriValues ? row.getXApriori() : row.getXAposteriori();
                Double d = z = aprioriValues ? row.getZApriori() : row.getZAposteriori();
                if (this.type != ObservationType.GNSS2D && z == null || this.type != ObservationType.GNSS1D && (y == null || x == null)) continue;
                Double sigmaY = aprioriValues ? row.getSigmaYapriori() : row.getSigmaYaposteriori();
                Double sigmaX = aprioriValues ? row.getSigmaXapriori() : row.getSigmaXaposteriori();
                Double d2 = sigmaZ = aprioriValues ? row.getSigmaZapriori() : row.getSigmaZaposteriori();
                if (!aprioriValues && (sigmaY == null || sigmaX == null || sigmaZ == null)) continue;
                if (aprioriValues) {
                    if (sigmaY != null && sigmaY <= 0.0) {
                        sigmaY = null;
                    }
                    if (sigmaX != null && sigmaX <= 0.0) {
                        sigmaX = null;
                    }
                    if (sigmaZ != null && sigmaZ <= 0.0) {
                        sigmaZ = null;
                    }
                }
                String yValue = this.type != ObservationType.GNSS1D && y != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(y, false)) : "";
                String xValue = this.type != ObservationType.GNSS1D && x != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(x, false)) : "";
                String zValue = this.type != ObservationType.GNSS2D && z != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(z, false)) : "";
                String sigmaYvalue = this.type != ObservationType.GNSS1D && sigmaY != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(sigmaY, false)) : "";
                String sigmaXvalue = this.type != ObservationType.GNSS1D && sigmaX != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(sigmaX, false)) : "";
                String sigmaZvalue = this.type != ObservationType.GNSS2D && sigmaZ != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(sigmaZ, false)) : "";
                writer.println(String.format(exportFormatString, startPointName) + String.format(exportFormatString, endPointName) + yValue + xValue + zValue + sigmaYvalue + sigmaXvalue + sigmaZvalue);
            }
        }
    }

    @Override
    void highlightTableRow(TableRow<GNSSObservationRow> row) {
        if (row == null) {
            return;
        }
        TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
        TableRowHighlightType tableRowHighlightType = tableRowHighlight.getSelectedTableRowHighlightType();
        double leftBoundary = tableRowHighlight.getLeftBoundary(tableRowHighlightType);
        double rightBoundary = tableRowHighlight.getRightBoundary(tableRowHighlightType);
        GNSSObservationRow item = (GNSSObservationRow)row.getItem();
        if (!row.isSelected() && item != null) {
            switch (tableRowHighlightType) {
                case TEST_STATISTIC: {
                    this.setTableRowHighlight(row, item.isSignificant() ? TableRowHighlightRangeType.INADEQUATE : TableRowHighlightRangeType.EXCELLENT);
                    break;
                }
                case GROSS_ERROR: {
                    Double grossErrorX = item.getGrossErrorX();
                    Double grossErrorY = item.getGrossErrorY();
                    Double grossErrorZ = item.getGrossErrorZ();
                    Double mtbX = item.getMaximumTolerableBiasX();
                    Double mtbY = item.getMaximumTolerableBiasY();
                    Double mtbZ = item.getMaximumTolerableBiasZ();
                    Double mdbX = item.getMinimalDetectableBiasX();
                    Double mdbY = item.getMinimalDetectableBiasY();
                    Double mdbZ = item.getMinimalDetectableBiasZ();
                    double dMTB = Double.NaN;
                    double dMDB = Double.NaN;
                    if (this.type == ObservationType.GNSS1D && grossErrorZ != null && mtbZ != null && mdbZ != null) {
                        dMTB = Math.abs(grossErrorZ) - Math.abs(mtbZ);
                        dMDB = Math.abs(mdbZ) - Math.abs(grossErrorZ);
                    } else if (this.type == ObservationType.GNSS2D && grossErrorX != null && grossErrorY != null && mtbX != null && mtbY != null && mdbX != null && mdbY != null) {
                        dMTB = Math.max(Math.abs(grossErrorX) - Math.abs(mtbX), Math.abs(grossErrorY) - Math.abs(mtbY));
                        dMDB = Math.min(Math.abs(mdbX) - Math.abs(grossErrorX), Math.abs(mdbY) - Math.abs(grossErrorY));
                    } else if (this.type == ObservationType.GNSS3D && grossErrorX != null && grossErrorY != null && grossErrorZ != null && mtbZ != null && mtbX != null && mtbY != null && mdbZ != null && mdbX != null && mdbY != null) {
                        dMTB = Math.max(Math.max(Math.abs(grossErrorX) - Math.abs(mtbX), Math.abs(grossErrorY) - Math.abs(mtbY)), Math.abs(grossErrorZ) - Math.abs(mtbZ));
                        dMDB = Math.min(Math.min(Math.abs(mdbX) - Math.abs(grossErrorX), Math.abs(mdbY) - Math.abs(grossErrorY)), Math.abs(mdbZ) - Math.abs(grossErrorZ));
                    }
                    if (!Double.isNaN(dMTB) && !Double.isNaN(dMDB)) {
                        if (dMTB <= 0.0) {
                            this.setTableRowHighlight(row, TableRowHighlightRangeType.EXCELLENT);
                            break;
                        }
                        if (dMTB > 0.0 && dMDB >= 0.0) {
                            this.setTableRowHighlight(row, TableRowHighlightRangeType.SATISFACTORY);
                            break;
                        }
                        if (dMDB < 0.0) {
                            this.setTableRowHighlight(row, TableRowHighlightRangeType.INADEQUATE);
                            break;
                        }
                        this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                        break;
                    }
                    this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                    break;
                }
                case REDUNDANCY: {
                    Double redundancyX = item.getRedundancyX();
                    Double redundancyY = item.getRedundancyY();
                    Double redundancyZ = item.getRedundancyZ();
                    Double redundancy = null;
                    if (this.type == ObservationType.GNSS1D && redundancyZ != null) {
                        redundancy = redundancyZ;
                    } else if (this.type == ObservationType.GNSS2D && redundancyY != null && redundancyX != null) {
                        redundancy = Math.min(redundancyY, redundancyX);
                    } else if (this.type == ObservationType.GNSS3D && redundancyY != null && redundancyX != null && redundancyZ != null) {
                        redundancy = Math.min(redundancyZ, Math.min(redundancyY, redundancyX));
                    }
                    if (redundancy == null) {
                        this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                        break;
                    }
                    this.setTableRowHighlight(row, redundancy < leftBoundary ? TableRowHighlightRangeType.INADEQUATE : (redundancy <= rightBoundary ? TableRowHighlightRangeType.SATISFACTORY : TableRowHighlightRangeType.EXCELLENT));
                    break;
                }
                case INFLUENCE_ON_POSITION: {
                    Double influenceOnPositionX = item.getInfluenceOnPointPositionX();
                    Double influenceOnPositionY = item.getInfluenceOnPointPositionY();
                    Double influenceOnPositionZ = item.getInfluenceOnPointPositionZ();
                    Double influenceOnPosition = null;
                    if (this.type == ObservationType.GNSS1D && influenceOnPositionZ != null) {
                        influenceOnPosition = influenceOnPositionZ;
                    } else if (this.type == ObservationType.GNSS2D && influenceOnPositionY != null && influenceOnPositionX != null) {
                        influenceOnPosition = Math.max(influenceOnPositionY, influenceOnPositionX);
                    } else if (this.type == ObservationType.GNSS3D && influenceOnPositionY != null && influenceOnPositionX != null && influenceOnPositionZ != null) {
                        influenceOnPosition = Math.max(influenceOnPositionZ, Math.max(influenceOnPositionY, influenceOnPositionX));
                    }
                    if (influenceOnPosition == null) {
                        this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                        break;
                    }
                    this.setTableRowHighlight(row, Math.abs(influenceOnPosition) < leftBoundary ? TableRowHighlightRangeType.EXCELLENT : (Math.abs(influenceOnPosition) <= rightBoundary ? TableRowHighlightRangeType.SATISFACTORY : TableRowHighlightRangeType.INADEQUATE));
                    break;
                }
                case P_PRIO_VALUE: {
                    Double pValue = item.getPValueApriori();
                    if (pValue == null) {
                        this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                        break;
                    }
                    this.setTableRowHighlight(row, pValue < Math.log(leftBoundary) ? TableRowHighlightRangeType.INADEQUATE : (pValue <= Math.log(rightBoundary) ? TableRowHighlightRangeType.SATISFACTORY : TableRowHighlightRangeType.EXCELLENT));
                    break;
                }
                case NONE: {
                    this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                }
            }
        } else {
            this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
        }
    }
}

