/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.applied_geodesy.jag3d.DefaultApplicationProperty;
import org.applied_geodesy.jag3d.ui.dialog.InstrumentAndReflectorHeightAdaptionDialog;
import org.applied_geodesy.jag3d.ui.dialog.SearchAndReplaceDialog;
import org.applied_geodesy.jag3d.ui.table.UITableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.GroupRow;
import org.applied_geodesy.jag3d.ui.tree.Groupable;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;

public abstract class UIEditableTableBuilder<T extends GroupRow>
extends UITableBuilder<T> {
    private ContextMenuEventHandler listener = new ContextMenuEventHandler();

    @Override
    TableView<T> createTable() {
        this.table = super.createTable();
        this.table.setEditable(true);
        this.enableDragSupport();
        this.addTableKeyEvents();
        return this.table;
    }

    ContextMenu createContextMenu(ContextMenuType contextMenuType) {
        MenuItem removeMenuItem = this.createMenuItem(i18n.getString("UIEditableTableBuilder.contextmenu.remove", "Remove selected items"), ContextMenuItemType.REMOVE, this.listener);
        MenuItem duplicateMenuItem = this.createMenuItem(i18n.getString("UIEditableTableBuilder.contextmenu.duplicate", "Duplicate selected items"), ContextMenuItemType.DUPLICATE, this.listener);
        MenuItem selectGroupsMenuItem = this.createMenuItem(i18n.getString("UIEditableTableBuilder.contextmenu.select", "Select item groups"), ContextMenuItemType.SELECT_GROUPS, this.listener);
        MenuItem searchAndReplaceMenuItem = this.createMenuItem(i18n.getString("UIEditableTableBuilder.contextmenu.search_and_replace", "Search and replace"), ContextMenuItemType.SEARCH_AND_REPLACE, this.listener);
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{removeMenuItem, duplicateMenuItem});
        if (contextMenuType != ContextMenuType.POINT) {
            MenuItem moveToMenuItem = this.createMenuItem(i18n.getString("UIEditableTableBuilder.contextmenu.moveto", "Move selected items"), ContextMenuItemType.MOVETO, this.listener);
            contextMenu.getItems().add((Object)moveToMenuItem);
        } else if (contextMenuType == ContextMenuType.POINT) {
            Menu moveToMenu = this.createMenu(i18n.getString("UIEditableTableBuilder.contextmenu.moveto", "Move selected items"));
            MenuItem moveToReferenceMenuItem = this.createMenuItem(i18n.getString("UIEditableTableBuilder.contextmenu.moveto.reference", "Reference point group"), ContextMenuItemType.MOVETO_REFERENCE, this.listener);
            MenuItem moveToStochasticMenuItem = this.createMenuItem(i18n.getString("UIEditableTableBuilder.contextmenu.moveto.stochastic", "Stochastic point group"), ContextMenuItemType.MOVETO_STOCHASTIC, this.listener);
            MenuItem moveToDatumMenuItem = this.createMenuItem(i18n.getString("UIEditableTableBuilder.contextmenu.moveto.datum", "Datum point group"), ContextMenuItemType.MOVETO_DATUM, this.listener);
            MenuItem moveToNewMenuItem = this.createMenuItem(i18n.getString("UIEditableTableBuilder.contextmenu.moveto.new", "New point group"), ContextMenuItemType.MOVETO_NEW, this.listener);
            moveToMenu.getItems().addAll((Object[])new MenuItem[]{moveToReferenceMenuItem, moveToStochasticMenuItem, moveToDatumMenuItem, moveToNewMenuItem});
            contextMenu.getItems().add((Object)moveToMenu);
        }
        contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), selectGroupsMenuItem, new SeparatorMenuItem(), searchAndReplaceMenuItem});
        if (contextMenuType == ContextMenuType.OBSERVATION) {
            MenuItem instrumentAndReflectorHeightItem = this.createMenuItem(i18n.getString("UIEditableTableBuilder.contextmenu.instrument_and_reflector_height", "Height adaption"), ContextMenuItemType.ADAPT_INSTRUMENT_AND_REFLECTOR_HEIGHT, this.listener);
            contextMenu.getItems().add((Object)instrumentAndReflectorHeightItem);
        }
        return contextMenu;
    }

    void raiseErrorMessage(final ContextMenuItemType type, final Exception e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                switch (type) {
                    case DUPLICATE: {
                        OptionDialog.showThrowableDialog(i18n.getString("UIEditableTableBuilder.message.error.duplicate.exception.title", "Unexpected SQL-Error"), i18n.getString("UIEditableTableBuilder.message.error.duplicate.exception.header", "Error, could not save copies of selected items."), i18n.getString("UIEditableTableBuilder.message.error.duplicate.exception.message", "An exception has occurred during database transaction."), e);
                        break;
                    }
                    case REMOVE: {
                        OptionDialog.showThrowableDialog(i18n.getString("UIEditableTableBuilder.message.error.remove.exception.title", "Unexpected SQL-Error"), i18n.getString("UIEditableTableBuilder.message.error.remove.exception.header", "Error, could not remove selected items."), i18n.getString("UIEditableTableBuilder.message.error.remove.exception.message", "An exception has occurred during database transaction."), e);
                        break;
                    }
                    case MOVETO: 
                    case MOVETO_NEW: 
                    case MOVETO_REFERENCE: 
                    case MOVETO_STOCHASTIC: 
                    case MOVETO_DATUM: {
                        OptionDialog.showThrowableDialog(i18n.getString("UIEditableTableBuilder.message.error.moveto.exception.title", "Unexpected SQL-Error"), i18n.getString("UIEditableTableBuilder.message.error.moveto.exception.header", "Error, could not move selected items to new table."), i18n.getString("UIEditableTableBuilder.message.error.moveto.exception.message", "An exception has occurred during database transaction."), e);
                        break;
                    }
                }
            }
        });
    }

    void raiseErrorMessageSaveValue(final Exception e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OptionDialog.showThrowableDialog(i18n.getString("UIEditableTableBuilder.message.error.save.exception.title", "Unexpected SQL-Error"), i18n.getString("UIEditableTableBuilder.message.error.save.exception.header", "Error, could not save value to database."), i18n.getString("UIEditableTableBuilder.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
            }
        });
    }

    private MenuItem createMenuItem(String label, ContextMenuItemType type, ContextMenuEventHandler listener) {
        MenuItem item = new MenuItem(label);
        item.setUserData((Object)type);
        item.setOnAction((EventHandler)listener);
        return item;
    }

    private Menu createMenu(String label) {
        Menu menu = new Menu(label);
        return menu;
    }

    abstract void enableDragSupport();

    abstract void removeRows();

    abstract void duplicateRows();

    abstract void moveRows(ContextMenuItemType var1);

    private void selectGroups() {
        try {
            ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
            HashSet<Integer> groupIds = new HashSet<Integer>();
            for (GroupRow selectedRow : selectedRows) {
                groupIds.add(selectedRow.getGroupId());
            }
            if (groupIds == null || groupIds.isEmpty()) {
                return;
            }
            ArrayList selectedTreeItems = new ArrayList(UITreeBuilder.getInstance().getTree().getSelectionModel().getSelectedItems());
            if (selectedTreeItems.size() > 1) {
                ArrayList selectedTreeItemIndices = new ArrayList(UITreeBuilder.getInstance().getTree().getSelectionModel().getSelectedIndices());
                final int[] indices = new int[groupIds.size()];
                int i = 0;
                int j = 0;
                while (i < selectedTreeItems.size()) {
                    TreeItem selectedTreeItem = (TreeItem)selectedTreeItems.get(i);
                    if (selectedTreeItem.getValue() instanceof Groupable && groupIds.contains(((Groupable)selectedTreeItem.getValue()).getGroupId())) {
                        indices[j++] = (Integer)selectedTreeItemIndices.get(i);
                        if (j == indices.length) break;
                    }
                    ++i;
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UITreeBuilder.getInstance().getTree().getSelectionModel().clearSelection();
                        UITreeBuilder.getInstance().getTree().getSelectionModel().selectIndices(indices[0], indices);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeTableRows() {
        boolean isDeleteConfirmed;
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        boolean bl = isDeleteConfirmed = !DefaultApplicationProperty.showConfirmDialogOnDelete();
        if (!isDeleteConfirmed) {
            Optional<ButtonType> result = OptionDialog.showConfirmationDialog(i18n.getString("UIEditableTableBuilder.message.confirmation.delete.title", "Delete items"), i18n.getString("UIEditableTableBuilder.message.confirmation.delete.header", "Delete items permanently?"), i18n.getString("UIEditableTableBuilder.message.confirmation.delete.message", "Are you sure you want to remove the selected items?"));
            boolean bl2 = isDeleteConfirmed = result.isPresent() && result.get() == ButtonType.OK;
        }
        if (isDeleteConfirmed) {
            this.removeRows();
        }
    }

    private void showDialog(ContextMenuItemType contextMenuItemType) {
        TreeView<TreeItemValue> treeView = UITreeBuilder.getInstance().getTree();
        TreeItem selectedItem = (TreeItem)treeView.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        ObservableList selectedItems = treeView.getSelectionModel().getSelectedItems();
        TreeItemValue[] selectedTreeItemValues = new TreeItemValue[selectedItems != null ? selectedItems.size() : 0];
        int i = 0;
        while (i < selectedItems.size()) {
            selectedTreeItemValues[i] = (TreeItemValue)((TreeItem)selectedItems.get(i)).getValue();
            ++i;
        }
        if (contextMenuItemType == ContextMenuItemType.SEARCH_AND_REPLACE) {
            SearchAndReplaceDialog.showAndWait((TreeItemValue)selectedItem.getValue(), selectedTreeItemValues);
        } else if (contextMenuItemType == ContextMenuItemType.ADAPT_INSTRUMENT_AND_REFLECTOR_HEIGHT) {
            InstrumentAndReflectorHeightAdaptionDialog.showAndWait((TreeItemValue)selectedItem.getValue(), selectedTreeItemValues);
        }
    }

    private void addTableKeyEvents() {
        this.table.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getSource() == UIEditableTableBuilder.this.table && keyEvent.getTarget() == UIEditableTableBuilder.this.table && keyEvent.getCode() == KeyCode.DELETE) {
                    UIEditableTableBuilder.this.removeTableRows();
                    keyEvent.consume();
                }
            }
        });
    }

    private class ContextMenuEventHandler
    implements EventHandler<ActionEvent> {
        private ContextMenuEventHandler() {
        }

        public void handle(ActionEvent event) {
            if (event.getSource() instanceof MenuItem && ((MenuItem)event.getSource()).getUserData() instanceof ContextMenuItemType) {
                ContextMenuItemType contextMenuType = (ContextMenuItemType)((Object)((MenuItem)event.getSource()).getUserData());
                switch (contextMenuType) {
                    case REMOVE: {
                        UIEditableTableBuilder.this.removeTableRows();
                        break;
                    }
                    case SELECT_GROUPS: {
                        UIEditableTableBuilder.this.selectGroups();
                    }
                    case MOVETO: 
                    case MOVETO_NEW: 
                    case MOVETO_REFERENCE: 
                    case MOVETO_STOCHASTIC: 
                    case MOVETO_DATUM: {
                        UIEditableTableBuilder.this.moveRows(contextMenuType);
                        break;
                    }
                    case DUPLICATE: {
                        UIEditableTableBuilder.this.duplicateRows();
                        break;
                    }
                    case ADAPT_INSTRUMENT_AND_REFLECTOR_HEIGHT: 
                    case SEARCH_AND_REPLACE: {
                        UIEditableTableBuilder.this.showDialog(contextMenuType);
                    }
                }
            }
        }
    }

    static enum ContextMenuItemType {
        REMOVE,
        DUPLICATE,
        MOVETO,
        SELECT_GROUPS,
        MOVETO_NEW,
        MOVETO_REFERENCE,
        MOVETO_STOCHASTIC,
        MOVETO_DATUM,
        ADAPT_INSTRUMENT_AND_REFLECTOR_HEIGHT,
        SEARCH_AND_REPLACE;

    }

    static enum ContextMenuType {
        POINT,
        OBSERVATION,
        DEFAULT;

    }
}

