/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.applied_geodesy.jag3d.ui.table.UITableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.ObservationRow;
import org.applied_geodesy.jag3d.ui.table.row.TerrestrialObservationRow;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.NaturalOrderTableColumnComparator;
import org.applied_geodesy.util.CellValueType;

public class UICongruentPointTableBuilder
extends UITableBuilder<TerrestrialObservationRow> {
    private static UICongruentPointTableBuilder tableBuilder = new UICongruentPointTableBuilder();
    private boolean isInitialize = false;

    private UICongruentPointTableBuilder() {
    }

    public static UICongruentPointTableBuilder getInstance() {
        tableBuilder.init();
        return tableBuilder;
    }

    private void init() {
        if (this.isInitialize) {
            return;
        }
        TableColumn<TerrestrialObservationRow, String> stringColumn = null;
        TableColumn<TerrestrialObservationRow, Double> doubleColumn = null;
        TableView table = this.createTable();
        int columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UICongruentPointTableBuilder.tableheader.point1.name.label", "Point A");
        String tooltipText = i18n.getString("UICongruentPointTableBuilder.tableheader.point1.name.tooltip", "Id of first point A");
        CellValueType cellValueType = CellValueType.STRING;
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(header, ObservationRow::startPointNameProperty, UICongruentPointTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, false);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruentPointTableBuilder.tableheader.point2.name.label", "Point B");
        tooltipText = i18n.getString("UICongruentPointTableBuilder.tableheader.point2.name.tooltip", "Id of second point B");
        cellValueType = CellValueType.STRING;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(header, ObservationRow::endPointNameProperty, UICongruentPointTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, false);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruentPointTableBuilder.tableheader.distance.label", "Distance");
        tooltipText = i18n.getString("UICongruentPointTableBuilder.tableheader.distance.tooltip", "Estimated distance between point A and B");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, TerrestrialObservationRow::distanceAprioriProperty, UICongruentPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_TERRESTRIAL_OBSERVATION, columnIndex, false);
        table.getColumns().add(doubleColumn);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table = table;
        this.isInitialize = true;
    }

    @Override
    public TerrestrialObservationRow getEmptyRow() {
        return new TerrestrialObservationRow();
    }

    @Override
    void setValue(TerrestrialObservationRow row, int columnIndex, Object oldValue, Object newValue) {
    }
}

