/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.dnd.CongruenceAnalysisRowDnD;
import org.applied_geodesy.jag3d.ui.table.UIEditableTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UITableBuilder;
import org.applied_geodesy.jag3d.ui.table.column.ColumnContentType;
import org.applied_geodesy.jag3d.ui.table.column.TableContentType;
import org.applied_geodesy.jag3d.ui.table.row.CongruenceAnalysisRow;
import org.applied_geodesy.jag3d.ui.table.row.Row;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlight;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightRangeType;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;
import org.applied_geodesy.jag3d.ui.tree.CongruenceAnalysisTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.EditableMenuCheckBoxTreeCell;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.table.AbsoluteValueComparator;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.NaturalOrderTableColumnComparator;
import org.applied_geodesy.util.CellValueType;

public class UICongruenceAnalysisTableBuilder
extends UIEditableTableBuilder<CongruenceAnalysisRow> {
    private CongruenceAnalysisTreeItemValue congruenceAnalysisItemValue;
    private int dimension;
    private Map<Integer, TableView<CongruenceAnalysisRow>> tables = new HashMap<Integer, TableView<CongruenceAnalysisRow>>();
    private static UICongruenceAnalysisTableBuilder tableBuilder = new UICongruenceAnalysisTableBuilder();

    private UICongruenceAnalysisTableBuilder() {
    }

    public static UICongruenceAnalysisTableBuilder getInstance() {
        return tableBuilder;
    }

    public TableView<CongruenceAnalysisRow> getTable(CongruenceAnalysisTreeItemValue congruenceAnalysisItemValue) {
        this.congruenceAnalysisItemValue = congruenceAnalysisItemValue;
        this.dimension = congruenceAnalysisItemValue.getDimension();
        this.init();
        return this.table;
    }

    private TableContentType getTableContentType() {
        switch (this.dimension) {
            case 1: {
                return TableContentType.CONGRUENCE_ANALYSIS_1D;
            }
            case 2: {
                return TableContentType.CONGRUENCE_ANALYSIS_2D;
            }
            case 3: {
                return TableContentType.CONGRUENCE_ANALYSIS_3D;
            }
        }
        return TableContentType.UNSPECIFIC;
    }

    private void init() {
        int columnIndex;
        if (this.tables.containsKey(this.dimension)) {
            this.table = this.tables.get(this.dimension);
            return;
        }
        TableColumn<CongruenceAnalysisRow, Boolean> booleanColumn = null;
        TableColumn<CongruenceAnalysisRow, String> stringColumn = null;
        TableColumn<CongruenceAnalysisRow, Double> doubleColumn = null;
        TableContentType tableContentType = this.getTableContentType();
        TableView table = this.createTable();
        final int columnIndexEnable = columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.enable.label", "Enable");
        String tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.enable.tooltip", "State of the point nexus");
        CellValueType cellValueType = CellValueType.BOOLEAN;
        ColumnContentType columnContentType = ColumnContentType.ENABLE;
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::enableProperty, UICongruenceAnalysisTableBuilder.getBooleanCallback(), ColumnType.VISIBLE, columnIndex, true, true);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<CongruenceAnalysisRow, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<CongruenceAnalysisRow, Boolean> param) {
                UITableBuilder.TableCellChangeListener enableChangeListener = new UITableBuilder.TableCellChangeListener((UITableBuilder)UICongruenceAnalysisTableBuilder.this, columnIndexEnable, (Row)((CongruenceAnalysisRow)param.getValue()));
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((CongruenceAnalysisRow)param.getValue()).isEnable());
                booleanProp.addListener((ChangeListener)enableChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.reference.epoch.name.label", "Point-Id (Reference epoch)");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.reference.epoch.name.tooltip", "Id of the point w.r.t. reference epoch");
        cellValueType = CellValueType.STRING;
        columnContentType = ColumnContentType.START_POINT_NAME;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::nameInReferenceEpochProperty, UICongruenceAnalysisTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true, true);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.control.epoch.name.label", "Point-Id (Control epoch)");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.control.epoch.name.tooltip", "Id of the point w.r.t. control epoch");
        cellValueType = CellValueType.STRING;
        columnContentType = ColumnContentType.END_POINT_NAME;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::nameInControlEpochProperty, UICongruenceAnalysisTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true, true);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.y.label", "y");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.y.tooltip", "A-posteriori y-component of displacement vector");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.VALUE_Y_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::yAposterioriProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 1 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.x.label", "x");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.x.tooltip", "A-posteriori x-component of displacement vector");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.VALUE_X_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::xAposterioriProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 1 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.z.label", "z");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.z.tooltip", "A-posteriori z-component of displacement vector");
        cellValueType = CellValueType.LENGTH;
        columnContentType = ColumnContentType.VALUE_Z_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::zAposterioriProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 2 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.sigma.y.label", "\u03c3y");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.sigma.y.tooltip", "A-posteriori uncertainty of y-component of displacement vector");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.UNCERTAINTY_Y_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::sigmaYaposterioriProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 1 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.sigma.x.label", "\u03c3x");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.sigma.x.tooltip", "A-posteriori uncertainty of x-component of displacement vector");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.UNCERTAINTY_X_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::sigmaXaposterioriProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 1 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.sigma.z.label", "\u03c3z");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.sigma.z.tooltip", "A-posteriori uncertainty of z-component of displacement vector");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.UNCERTAINTY_Z_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::sigmaZaposterioriProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 2 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxis.major.label", "a");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxis.major.tooltip", "Major semi axis");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.CONFIDENCE_A;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::confidenceAProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT_CONGRUENCE, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxis.middle.label", "b");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxis.middle.tooltip", "Middle semi axis");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.CONFIDENCE_B;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::confidenceBProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension == 3 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxis.minor.label", "c");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxis.minor.tooltip", "Minor semi axis");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        columnContentType = ColumnContentType.CONFIDENCE_C;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::confidenceCProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 1 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxisrotation.alpha.label", "\u03b1");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxisrotation.alpha.tooltip", "Rotation angle of confidence region");
        cellValueType = CellValueType.ANGLE;
        columnContentType = ColumnContentType.CONFIDENCE_ALPHA;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::confidenceAlphaProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension == 3 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxisrotation.beta.label", "\u03b2");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxisrotation.beta.tooltip", "Rotation angle of confidence region");
        cellValueType = CellValueType.ANGLE;
        columnContentType = ColumnContentType.CONFIDENCE_BETA;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::confidenceBetaProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension == 3 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxisrotation.gamma.label", "\u03b3");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.semiaxisrotation.gamma.tooltip", "Rotation angle of confidence region");
        cellValueType = CellValueType.ANGLE;
        columnContentType = ColumnContentType.CONFIDENCE_GAMMA;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::confidenceGammaProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 1 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.grosserror.y.label", "\u2207y");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.grosserror.y.tooltip", "Gross-error in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.RESIDUAL_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::grossErrorYProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 1 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.grosserror.x.label", "\u2207x");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.grosserror.x.tooltip", "Gross-error in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.RESIDUAL_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::grossErrorXProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 1 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.grosserror.z.label", "\u2207z");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.grosserror.z.tooltip", "Gross-error in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.RESIDUAL_Z;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::grossErrorZProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 2 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.minimaldetectablebias.y.label", "\u2207y(\u03bb)");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.minimaldetectablebias.y.tooltip", "Minimal detectable bias in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.MINIMAL_DETECTABLE_BIAS_Y;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::minimalDetectableBiasYProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 1 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.minimaldetectablebias.x.label", "\u2207x(\u03bb)");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.minimaldetectablebias.x.tooltip", "Minimal detectable bias in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.MINIMAL_DETECTABLE_BIAS_X;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::minimalDetectableBiasXProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 1 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.minimaldetectablebias.z.label", "\u2207z(\u03bb)");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.minimaldetectablebias.z.tooltip", "Minimal detectable bias in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        columnContentType = ColumnContentType.MINIMAL_DETECTABLE_BIAS_Z;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::minimalDetectableBiasZProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), this.dimension != 2 ? ColumnType.APOSTERIORI_POINT_CONGRUENCE : ColumnType.HIDDEN, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.pvalue.apriori.label", "log(Pprio)");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.pvalue.apriori.tooltip", "A-priori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.P_VALUE_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::pValueAprioriProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT_CONGRUENCE, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.pvalue.aposteriori.label", "log(Ppost)");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.pvalue.aposteriori.tooltip", "A-posteriori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.P_VALUE_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::pValueAposterioriProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT_CONGRUENCE, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.teststatistic.apriori.label", "Tprio");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.teststatistic.apriori.tooltip", "A-priori test statistic");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.TEST_STATISTIC_APRIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::testStatisticAprioriProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT_CONGRUENCE, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.teststatistic.aposteriori.label", "Tpost");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.teststatistic.aposteriori.tooltip", "A-posteriori test statistic");
        cellValueType = CellValueType.STATISTIC;
        columnContentType = ColumnContentType.TEST_STATISTIC_APOSTERIORI;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::testStatisticAposterioriProperty, UICongruenceAnalysisTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT_CONGRUENCE, columnIndex, false, true);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        final int columnIndexOutlier = columnIndex = table.getColumns().size();
        labelText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.testdecision.label", "Significant");
        tooltipText = i18n.getString("UICongruenceAnalysisTableBuilder.tableheader.testdecision.tooltip", "Checked, if null-hypothesis is rejected");
        cellValueType = CellValueType.BOOLEAN;
        columnContentType = ColumnContentType.SIGNIFICANT;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(tableContentType, columnContentType, header, CongruenceAnalysisRow::significantProperty, UICongruenceAnalysisTableBuilder.getBooleanCallback(), ColumnType.APOSTERIORI_POINT_CONGRUENCE, columnIndex, false, true);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<CongruenceAnalysisRow, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<CongruenceAnalysisRow, Boolean> param) {
                UITableBuilder.TableCellChangeListener significantChangeListener = new UITableBuilder.TableCellChangeListener((UITableBuilder)UICongruenceAnalysisTableBuilder.this, columnIndexOutlier, (Row)((CongruenceAnalysisRow)param.getValue()));
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((CongruenceAnalysisRow)param.getValue()).isSignificant());
                booleanProp.addListener((ChangeListener)significantChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        this.addContextMenu(table, this.createContextMenu(UIEditableTableBuilder.ContextMenuType.DEFAULT));
        this.addDynamicRowAdder(table);
        this.addColumnOrderSequenceListeners(tableContentType, table);
        this.tables.put(this.dimension, table);
        this.table = table;
    }

    @Override
    public CongruenceAnalysisRow getEmptyRow() {
        return new CongruenceAnalysisRow();
    }

    @Override
    void setValue(final CongruenceAnalysisRow rowData, int columnIndex, Object oldValue, Object newValue) {
        boolean valid = !(oldValue != null && !oldValue.toString().trim().isEmpty() || newValue != null && !newValue.toString().trim().isEmpty());
        switch (columnIndex) {
            case 0: {
                rowData.setEnable(newValue != null && newValue instanceof Boolean && (Boolean)newValue != false);
                valid = true;
                break;
            }
            case 1: {
                if (!(newValue == null || newValue.toString().trim().isEmpty() || rowData.getNameInControlEpoch() != null && rowData.getNameInControlEpoch().equals(newValue.toString().trim()))) {
                    rowData.setNameInReferenceEpoch(newValue.toString().trim());
                    valid = true;
                    break;
                }
                rowData.setNameInReferenceEpoch(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            case 2: {
                if (!(newValue == null || newValue.toString().trim().isEmpty() || rowData.getNameInReferenceEpoch() != null && rowData.getNameInReferenceEpoch().equals(newValue.toString().trim()))) {
                    rowData.setNameInControlEpoch(newValue.toString().trim());
                    valid = true;
                    break;
                }
                rowData.setNameInControlEpoch(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Editable column exceed " + columnIndex);
                valid = false;
            }
        }
        if (valid && this.isComplete(rowData)) {
            if (rowData.getGroupId() < 0) {
                rowData.setGroupId(this.congruenceAnalysisItemValue.getGroupId());
            }
            try {
                SQLManager.getInstance().saveItem(rowData);
            }
            catch (Exception e) {
                switch (columnIndex) {
                    case 1: {
                        rowData.setNameInReferenceEpoch(oldValue == null ? null : oldValue.toString().trim());
                        break;
                    }
                    case 2: {
                        rowData.setNameInControlEpoch(oldValue == null ? null : oldValue.toString().trim());
                        break;
                    }
                }
                valid = false;
                this.raiseErrorMessageSaveValue(e);
                e.printStackTrace();
            }
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UICongruenceAnalysisTableBuilder.this.table.refresh();
                UICongruenceAnalysisTableBuilder.this.table.requestFocus();
                UICongruenceAnalysisTableBuilder.this.table.getSelectionModel().clearSelection();
                UICongruenceAnalysisTableBuilder.this.table.getSelectionModel().select((Object)rowData);
                UICongruenceAnalysisTableBuilder.this.table.sort();
            }
        });
    }

    private boolean isComplete(CongruenceAnalysisRow row) {
        return row.getNameInReferenceEpoch() != null && !row.getNameInReferenceEpoch().trim().isEmpty() && row.getNameInControlEpoch() != null && !row.getNameInControlEpoch().trim().isEmpty() && !row.getNameInReferenceEpoch().equals(row.getNameInControlEpoch());
    }

    @Override
    void enableDragSupport() {
        this.table.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ArrayList selectedRows = new ArrayList(UICongruenceAnalysisTableBuilder.this.table.getSelectionModel().getSelectedItems());
                if (selectedRows != null && !selectedRows.isEmpty()) {
                    ArrayList<CongruenceAnalysisRowDnD> rowsDnD = new ArrayList<CongruenceAnalysisRowDnD>(selectedRows.size());
                    for (CongruenceAnalysisRow selectedRow : selectedRows) {
                        CongruenceAnalysisRowDnD rowDnD = null;
                        if (!UICongruenceAnalysisTableBuilder.this.isComplete(selectedRow) || (rowDnD = CongruenceAnalysisRowDnD.fromCongruenceAnalysisRow(selectedRow)) == null) continue;
                        rowsDnD.add(rowDnD);
                    }
                    if (!rowsDnD.isEmpty()) {
                        Dragboard db = UICongruenceAnalysisTableBuilder.this.table.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                        ClipboardContent content = new ClipboardContent();
                        content.put((Object)EditableMenuCheckBoxTreeCell.TREE_ITEM_TYPE_DATA_FORMAT, (Object)UICongruenceAnalysisTableBuilder.this.congruenceAnalysisItemValue.getItemType());
                        content.put((Object)EditableMenuCheckBoxTreeCell.GROUP_ID_DATA_FORMAT, (Object)UICongruenceAnalysisTableBuilder.this.congruenceAnalysisItemValue.getGroupId());
                        content.put((Object)EditableMenuCheckBoxTreeCell.DIMENSION_DATA_FORMAT, (Object)UICongruenceAnalysisTableBuilder.this.dimension);
                        content.put((Object)EditableMenuCheckBoxTreeCell.CONGRUENCE_ANALYSIS_ROWS_DATA_FORMAT, rowsDnD);
                        db.setContent((Map)content);
                    }
                }
                event.consume();
            }
        });
    }

    @Override
    void duplicateRows() {
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        ArrayList<CongruenceAnalysisRow> clonedRows = new ArrayList<CongruenceAnalysisRow>(selectedRows.size());
        for (CongruenceAnalysisRow row : selectedRows) {
            CongruenceAnalysisRow clonedRow = CongruenceAnalysisRow.cloneRowApriori(row);
            if (this.isComplete(clonedRow)) {
                try {
                    String[] names = SQLManager.getInstance().getNextValidPointNexusNames(this.congruenceAnalysisItemValue.getGroupId(), row.getNameInReferenceEpoch(), row.getNameInControlEpoch());
                    clonedRow.setNameInReferenceEpoch(names[0]);
                    clonedRow.setNameInControlEpoch(names[1]);
                    SQLManager.getInstance().saveItem(clonedRow);
                }
                catch (Exception e) {
                    this.raiseErrorMessage(UIEditableTableBuilder.ContextMenuItemType.DUPLICATE, e);
                    e.printStackTrace();
                    break;
                }
            }
            clonedRows.add(clonedRow);
        }
        if (clonedRows != null && !clonedRows.isEmpty()) {
            ObservableList tableModel = this.getTableModel(this.table);
            tableModel.addAll(clonedRows);
            this.table.getSelectionModel().clearSelection();
            for (CongruenceAnalysisRow clonedRow : clonedRows) {
                this.table.getSelectionModel().select((Object)clonedRow);
            }
            this.table.scrollTo((Object)((CongruenceAnalysisRow)clonedRows.get(0)));
        }
    }

    @Override
    void removeRows() {
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        ArrayList<CongruenceAnalysisRow> removedRows = new ArrayList<CongruenceAnalysisRow>(selectedRows.size());
        for (CongruenceAnalysisRow row : selectedRows) {
            if (this.isComplete(row)) {
                try {
                    SQLManager.getInstance().remove(row);
                }
                catch (Exception e) {
                    this.raiseErrorMessage(UIEditableTableBuilder.ContextMenuItemType.REMOVE, e);
                    e.printStackTrace();
                    break;
                }
            }
            removedRows.add(row);
        }
        if (removedRows != null && !removedRows.isEmpty()) {
            this.table.getSelectionModel().clearSelection();
            ObservableList tableModel = this.getTableModel(this.table);
            tableModel.removeAll(removedRows);
            if (tableModel.isEmpty()) {
                tableModel.setAll((Object[])new CongruenceAnalysisRow[]{this.getEmptyRow()});
            }
        }
    }

    @Override
    void moveRows(UIEditableTableBuilder.ContextMenuItemType type) {
        if (type != UIEditableTableBuilder.ContextMenuItemType.MOVETO) {
            return;
        }
        ArrayList selectedRows = new ArrayList(this.table.getSelectionModel().getSelectedItems());
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(this.congruenceAnalysisItemValue.getItemType());
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, false);
        try {
            SQLManager.getInstance().saveGroup((CongruenceAnalysisTreeItemValue)newTreeItem.getValue());
        }
        catch (Exception e) {
            this.raiseErrorMessage(type, e);
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            return;
        }
        try {
            int groupId = ((CongruenceAnalysisTreeItemValue)newTreeItem.getValue()).getGroupId();
            for (CongruenceAnalysisRow row : selectedRows) {
                row.setGroupId(groupId);
                SQLManager.getInstance().saveItem(row);
            }
        }
        catch (Exception e) {
            this.raiseErrorMessage(type, e);
            e.printStackTrace();
            return;
        }
        MultipleSelectionModel selectionModel = UITreeBuilder.getInstance().getTree().getSelectionModel();
        selectionModel.clearSelection();
        selectionModel.select(newTreeItem);
    }

    public void export(File file, boolean aprioriValues) throws IOException {
        ObservableList rows = this.table.getItems();
        String exportFormatString = "%15s \t";
        String exportFormatDouble = "%20s \t";
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            for (CongruenceAnalysisRow row : rows) {
                Double sigmaZ;
                Double z;
                if (!row.isEnable()) continue;
                String nameInReferenceEpoch = row.getNameInReferenceEpoch();
                String nameInControlEpoch = row.getNameInControlEpoch();
                if (nameInReferenceEpoch == null || nameInReferenceEpoch.trim().isEmpty() || nameInControlEpoch == null || nameInControlEpoch.trim().isEmpty()) continue;
                Double y = aprioriValues ? null : row.getYAposteriori();
                Double x = aprioriValues ? null : row.getXAposteriori();
                Double d = z = aprioriValues ? null : row.getZAposteriori();
                if (!aprioriValues && this.dimension != 2 && z == null || !aprioriValues && this.dimension != 1 && (y == null || x == null)) continue;
                Double sigmaY = aprioriValues ? null : row.getSigmaYaposteriori();
                Double sigmaX = aprioriValues ? null : row.getSigmaXaposteriori();
                Double d2 = sigmaZ = aprioriValues ? null : row.getSigmaZaposteriori();
                if (!aprioriValues && (sigmaY == null || sigmaX == null || sigmaZ == null)) continue;
                String yValue = this.dimension != 1 && y != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(y, false)) : "";
                String xValue = this.dimension != 1 && x != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(x, false)) : "";
                String zValue = this.dimension != 2 && z != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(z, false)) : "";
                String sigmaYvalue = this.dimension != 1 && sigmaY != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(sigmaY, false)) : "";
                String sigmaXvalue = this.dimension != 1 && sigmaX != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(sigmaX, false)) : "";
                String sigmaZvalue = this.dimension != 2 && sigmaZ != null ? String.format(Locale.ENGLISH, exportFormatDouble, options.toLengthFormat(sigmaZ, false)) : "";
                writer.println(String.format(exportFormatString, nameInReferenceEpoch) + String.format(exportFormatString, nameInControlEpoch) + yValue + xValue + zValue + sigmaYvalue + sigmaXvalue + sigmaZvalue);
            }
        }
    }

    @Override
    void highlightTableRow(TableRow<CongruenceAnalysisRow> row) {
        if (row == null) {
            return;
        }
        TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
        TableRowHighlightType tableRowHighlightType = tableRowHighlight.getSelectedTableRowHighlightType();
        double leftBoundary = tableRowHighlight.getLeftBoundary(tableRowHighlightType);
        double rightBoundary = tableRowHighlight.getRightBoundary(tableRowHighlightType);
        CongruenceAnalysisRow item = (CongruenceAnalysisRow)row.getItem();
        if (!row.isSelected() && item != null) {
            switch (tableRowHighlightType) {
                case TEST_STATISTIC: {
                    this.setTableRowHighlight(row, item.isSignificant() ? TableRowHighlightRangeType.INADEQUATE : TableRowHighlightRangeType.EXCELLENT);
                    break;
                }
                case P_PRIO_VALUE: {
                    Double pValue = item.getPValueApriori();
                    if (pValue == null) {
                        this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                        break;
                    }
                    this.setTableRowHighlight(row, pValue < Math.log(leftBoundary) ? TableRowHighlightRangeType.INADEQUATE : (pValue <= Math.log(rightBoundary) ? TableRowHighlightRangeType.SATISFACTORY : TableRowHighlightRangeType.EXCELLENT));
                    break;
                }
                default: {
                    this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
                    break;
                }
            }
        } else {
            this.setTableRowHighlight(row, TableRowHighlightRangeType.NONE);
        }
    }
}

