/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.ui.table.UITableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.AveragedObservationRow;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.NaturalOrderTableColumnComparator;
import org.applied_geodesy.util.CellValueType;

public class UIAverageObservationTableBuilder
extends UITableBuilder<AveragedObservationRow> {
    private static UIAverageObservationTableBuilder tableBuilder = new UIAverageObservationTableBuilder();
    private boolean isInitialize = false;

    private UIAverageObservationTableBuilder() {
    }

    public static UIAverageObservationTableBuilder getInstance() {
        tableBuilder.init();
        return tableBuilder;
    }

    private void init() {
        if (this.isInitialize) {
            return;
        }
        TableColumn<AveragedObservationRow, String> stringColumn = null;
        TableColumn<AveragedObservationRow, ObservationType> observationTypeColumn = null;
        TableColumn<AveragedObservationRow, Double> doubleColumn = null;
        TableView table = this.createTable();
        int columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIAverageObservationTableBuilder.tableheader.type.label", "Observation");
        String tooltipText = i18n.getString("UIAverageObservationTableBuilder.tableheader.type.tooltip", "Type of the observation");
        ColumnTooltipHeader header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        observationTypeColumn = this.getColumn(header, AveragedObservationRow::observationTypeProperty, UIAverageObservationTableBuilder.getObservationTypeCallback(), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(observationTypeColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIAverageObservationTableBuilder.tableheader.station.name.label", "Station-Id");
        tooltipText = i18n.getString("UIAverageObservationTableBuilder.tableheader.station.name.tooltip", "Id of station");
        header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        stringColumn = this.getColumn(header, AveragedObservationRow::startPointNameProperty, UIAverageObservationTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, false);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIAverageObservationTableBuilder.tableheader.target.name.label", "Target-Id");
        tooltipText = i18n.getString("UIAverageObservationTableBuilder.tableheader.target.name.tooltip", "Id of target point");
        header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        stringColumn = this.getColumn(header, AveragedObservationRow::endPointNameProperty, UIAverageObservationTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, false);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIAverageObservationTableBuilder.tableheader.value.label", "Value");
        tooltipText = i18n.getString("UIAverageObservationTableBuilder.tableheader.value.tooltip", "A-priori observation");
        header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        doubleColumn = this.getColumn(header, AveragedObservationRow::valueProperty, UIAverageObservationTableBuilder.getDoubleValueWithUnitCallback(DisplayFormatType.NORMAL), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIAverageObservationTableBuilder.tableheader.grosserror.label", "\u2207");
        tooltipText = i18n.getString("UIAverageObservationTableBuilder.tableheader.grosserror.tooltip", "Deviation w.r.t. median");
        header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        doubleColumn = this.getColumn(header, AveragedObservationRow::grossErrorProperty, UIAverageObservationTableBuilder.getDoubleValueWithUnitCallback(DisplayFormatType.RESIDUAL), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table = table;
        this.isInitialize = true;
    }

    private static Callback<TableColumn<AveragedObservationRow, ObservationType>, TableCell<AveragedObservationRow, ObservationType>> getObservationTypeCallback() {
        return new Callback<TableColumn<AveragedObservationRow, ObservationType>, TableCell<AveragedObservationRow, ObservationType>>(){

            public TableCell<AveragedObservationRow, ObservationType> call(final TableColumn<AveragedObservationRow, ObservationType> cell) {
                TableCell<AveragedObservationRow, ObservationType> tableCell = new TableCell<AveragedObservationRow, ObservationType>(){

                    protected void updateItem(ObservationType value, boolean empty) {
                        int currentIndex = this.indexProperty().getValue();
                        if (!empty && value != null && currentIndex >= 0 && currentIndex < cell.getTableView().getItems().size()) {
                            AveragedObservationRow row = (AveragedObservationRow)cell.getTableView().getItems().get(currentIndex);
                            if (row != null && row.getObservationType() != null) {
                                String component = null;
                                if (row.getComponentType() != null) {
                                    switch (row.getComponentType()) {
                                        case X: {
                                            component = i18n.getString("UIAverageObservationTableBuilder.gnss.x.label", "x");
                                            break;
                                        }
                                        case Y: {
                                            component = i18n.getString("UIAverageObservationTableBuilder.gnss.y.label", "y");
                                            break;
                                        }
                                        case Z: {
                                            component = i18n.getString("UIAverageObservationTableBuilder.gnss.z.label", "z");
                                        }
                                    }
                                }
                                switch (row.getObservationType()) {
                                    case LEVELING: {
                                        this.setText(i18n.getString("UIAverageObservationTableBuilder.leveling.label", "Leveling"));
                                        break;
                                    }
                                    case DIRECTION: {
                                        this.setText(i18n.getString("UIAverageObservationTableBuilder.direction.label", "Direction"));
                                        break;
                                    }
                                    case HORIZONTAL_DISTANCE: {
                                        this.setText(i18n.getString("UIAverageObservationTableBuilder.horizontal_distance.label", "Horizontal distance"));
                                        break;
                                    }
                                    case SLOPE_DISTANCE: {
                                        this.setText(i18n.getString("UIAverageObservationTableBuilder.slope_distance.label", "Slope distance"));
                                        break;
                                    }
                                    case ZENITH_ANGLE: {
                                        this.setText(i18n.getString("UIAverageObservationTableBuilder.zenith_angle.label", "Zenith angle"));
                                        break;
                                    }
                                    case GNSS1D: {
                                        this.setText(i18n.getString("UIAverageObservationTableBuilder.gnss.1d.label", "GNSS baseline 1D") + (String)(component != null ? " " + component : ""));
                                        break;
                                    }
                                    case GNSS2D: {
                                        this.setText(i18n.getString("UIAverageObservationTableBuilder.gnss.2d.label", "GNSS baseline 2D") + (String)(component != null ? " " + component : ""));
                                        break;
                                    }
                                    case GNSS3D: {
                                        this.setText(i18n.getString("UIAverageObservationTableBuilder.gnss.3d.label", "GNSS baseline 3D") + (String)(component != null ? " " + component : ""));
                                    }
                                }
                            } else {
                                this.setText(null);
                            }
                        } else {
                            this.setText(value == null ? null : value.toString());
                        }
                    }
                };
                tableCell.setAlignment(Pos.CENTER_LEFT);
                return tableCell;
            }
        };
    }

    private static Callback<TableColumn<AveragedObservationRow, Double>, TableCell<AveragedObservationRow, Double>> getDoubleValueWithUnitCallback(final DisplayFormatType displayFormatType) {
        return new Callback<TableColumn<AveragedObservationRow, Double>, TableCell<AveragedObservationRow, Double>>(){

            public TableCell<AveragedObservationRow, Double> call(final TableColumn<AveragedObservationRow, Double> cell) {
                TableCell<AveragedObservationRow, Double> tableCell = new TableCell<AveragedObservationRow, Double>(){

                    protected void updateItem(Double value, boolean empty) {
                        block9: {
                            block7: {
                                block8: {
                                    int currentIndex = this.indexProperty().getValue();
                                    if (empty || value == null || currentIndex < 0 || currentIndex >= cell.getTableView().getItems().size()) break block7;
                                    AveragedObservationRow row = (AveragedObservationRow)cell.getTableView().getItems().get(currentIndex);
                                    if (row == null || row.getObservationType() == null) break block8;
                                    switch (row.getObservationType()) {
                                        case DIRECTION: 
                                        case ZENITH_ANGLE: {
                                            if (displayFormatType == DisplayFormatType.NORMAL) {
                                                this.setText(options.toAngleFormat(value, true));
                                                break;
                                            }
                                            if (displayFormatType == DisplayFormatType.RESIDUAL) {
                                                this.setText(options.toAngleResidualFormat(value, true));
                                                break;
                                            }
                                            break block9;
                                        }
                                        default: {
                                            if (displayFormatType == DisplayFormatType.NORMAL) {
                                                this.setText(options.toLengthFormat(value, true));
                                                break;
                                            }
                                            if (displayFormatType == DisplayFormatType.RESIDUAL) {
                                                this.setText(options.toLengthResidualFormat(value, true));
                                                break;
                                            }
                                            break block9;
                                        }
                                    }
                                    break block9;
                                }
                                this.setText(null);
                                break block9;
                            }
                            this.setText(value == null ? null : value.toString());
                        }
                    }
                };
                tableCell.setAlignment(Pos.CENTER_RIGHT);
                return tableCell;
            }
        };
    }

    @Override
    public AveragedObservationRow getEmptyRow() {
        return new AveragedObservationRow();
    }

    @Override
    void setValue(AveragedObservationRow row, int columnIndex, Object oldValue, Object newValue) {
    }

    private static enum DisplayFormatType {
        NORMAL,
        RESIDUAL;

    }
}

