/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table;

import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import org.applied_geodesy.jag3d.ui.table.UIAdditionalParameterTableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.AdditionalParameterRow;
import org.applied_geodesy.ui.table.DisplayCellFormatType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterOptions;

class AdditionalParameterDoubleCell
extends TableCell<AdditionalParameterRow, Double>
implements FormatterChangedListener {
    private DisplayCellFormatType displayFormatType;
    private FormatterOptions options = FormatterOptions.getInstance();
    Double item;

    AdditionalParameterDoubleCell(DisplayCellFormatType displayFormatType) {
        this.displayFormatType = displayFormatType;
        this.setAlignment(Pos.CENTER_RIGHT);
        this.options.addFormatterChangedListener(this);
    }

    protected void updateItem(Double value, boolean empty) {
        int currentIndex = this.indexProperty().getValue();
        if (!empty && currentIndex >= 0 && currentIndex < this.getTableView().getItems().size()) {
            AdditionalParameterRow paramRow = (AdditionalParameterRow)this.getTableView().getItems().get(currentIndex);
            this.item = value;
            this.toFormattedString(paramRow, this.item);
        } else {
            this.setText(value == null ? null : value.toString());
        }
    }

    private void toFormattedString(AdditionalParameterRow paramRow, Double value) {
        block16: {
            block15: {
                if (value == null || paramRow == null || paramRow.getParameterType() == null) break block15;
                switch (paramRow.getParameterType()) {
                    case ZERO_POINT_OFFSET: 
                    case STRAIN_TRANSLATION_X: 
                    case STRAIN_TRANSLATION_Y: 
                    case STRAIN_TRANSLATION_Z: {
                        if (this.displayFormatType == DisplayCellFormatType.NORMAL) {
                            this.setText(this.options.toLengthFormat(value, true));
                            break;
                        }
                        if (this.displayFormatType == DisplayCellFormatType.UNCERTAINTY) {
                            this.setText(this.options.toLengthUncertaintyFormat(value, true));
                            break;
                        }
                        if (this.displayFormatType == DisplayCellFormatType.RESIDUAL) {
                            this.setText(this.options.toLengthResidualFormat(value, true));
                            break;
                        }
                        break block16;
                    }
                    case SCALE: 
                    case STRAIN_SCALE_X: 
                    case STRAIN_SCALE_Y: 
                    case STRAIN_SCALE_Z: {
                        if (this.displayFormatType == DisplayCellFormatType.NORMAL) {
                            this.setText(this.options.toScaleFormat(value, true));
                            break;
                        }
                        if (this.displayFormatType == DisplayCellFormatType.UNCERTAINTY) {
                            this.setText(this.options.toScaleUncertaintyFormat(value, true));
                            break;
                        }
                        if (this.displayFormatType == DisplayCellFormatType.RESIDUAL) {
                            this.setText(this.options.toScaleResidualFormat(value, true));
                            break;
                        }
                        break block16;
                    }
                    case ORIENTATION: 
                    case ROTATION_X: 
                    case ROTATION_Y: 
                    case ROTATION_Z: 
                    case STRAIN_ROTATION_X: 
                    case STRAIN_ROTATION_Y: 
                    case STRAIN_ROTATION_Z: 
                    case STRAIN_SHEAR_X: 
                    case STRAIN_SHEAR_Y: 
                    case STRAIN_SHEAR_Z: {
                        if (this.displayFormatType == DisplayCellFormatType.NORMAL) {
                            this.setText(this.options.toAngleFormat(value, true));
                            break;
                        }
                        if (this.displayFormatType == DisplayCellFormatType.UNCERTAINTY) {
                            this.setText(this.options.toAngleUncertaintyFormat(value, true));
                            break;
                        }
                        if (this.displayFormatType == DisplayCellFormatType.RESIDUAL) {
                            this.setText(this.options.toAngleResidualFormat(value, true));
                            break;
                        }
                        break block16;
                    }
                    case REFRACTION_INDEX: {
                        this.setText(this.options.toStatisticFormat(value));
                        break;
                    }
                    default: {
                        System.err.println(UIAdditionalParameterTableBuilder.class.getSimpleName() + " : Error, unknown parameter type " + String.valueOf((Object)paramRow.getParameterType()));
                        this.setText(null);
                        break;
                    }
                }
                break block16;
            }
            this.setText(null);
        }
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        int idx = this.getTableRow().getIndex();
        int itemSize = this.getTableView().getItems().size();
        if (idx >= 0 && idx < itemSize) {
            AdditionalParameterRow paramRow = (AdditionalParameterRow)this.getTableView().getItems().get(idx);
            this.toFormattedString(paramRow, this.item);
        }
    }
}

