/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.resultpane;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateChangeListener;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateEvent;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.resultpane.GlobalResultType;
import org.applied_geodesy.jag3d.ui.resultpane.GlobalResultTypeListCell;
import org.applied_geodesy.jag3d.ui.table.UIPrincipalComponentTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIResidualSignDistributionTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UITestStatisticTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIVarianceComponentTableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.PrincipalComponentRow;
import org.applied_geodesy.jag3d.ui.table.row.ResidualSignDistributionRow;
import org.applied_geodesy.jag3d.ui.table.row.Row;
import org.applied_geodesy.jag3d.ui.table.row.TestStatisticRow;
import org.applied_geodesy.jag3d.ui.table.row.VarianceComponentRow;
import org.applied_geodesy.ui.table.ColumnType;

public class UIGlobalResultPaneBuilder {
    private static UIGlobalResultPaneBuilder resultPaneBuilder = new UIGlobalResultPaneBuilder();
    private Node resultDataNode = null;

    private UIGlobalResultPaneBuilder() {
    }

    public static UIGlobalResultPaneBuilder getInstance() {
        resultPaneBuilder.init();
        return resultPaneBuilder;
    }

    public Node getNode() {
        return this.resultDataNode;
    }

    private void init() {
        if (this.resultDataNode != null) {
            return;
        }
        I18N i18n = I18N.getInstance();
        TableView testStatisticTable = UITestStatisticTableBuilder.getInstance().getTable();
        testStatisticTable.setUserData((Object)GlobalResultType.TEST_STATISTIC);
        testStatisticTable.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        TableView<VarianceComponentRow> varianceComponentTable = UIVarianceComponentTableBuilder.getInstance().getTable(UIVarianceComponentTableBuilder.VarianceComponentDisplayType.OVERALL_COMPONENTS);
        this.setTableColumnView(varianceComponentTable);
        varianceComponentTable.setUserData((Object)GlobalResultType.VARIANCE_COMPONENT);
        varianceComponentTable.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        TableView principalComponentTable = UIPrincipalComponentTableBuilder.getInstance().getTable();
        principalComponentTable.setUserData((Object)GlobalResultType.PRINCIPAL_COMPONENT);
        principalComponentTable.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        TableView residualSignDistributionTable = UIResidualSignDistributionTableBuilder.getInstance().getTable();
        residualSignDistributionTable.setUserData((Object)GlobalResultType.RESIDUAL_SIGN_DISTRIBUTION);
        residualSignDistributionTable.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        StackPane contenPane = new StackPane();
        contenPane.setPadding(new Insets(10.0, 30.0, 10.0, 30.0));
        contenPane.getChildren().addAll((Object[])new Node[]{testStatisticTable, varianceComponentTable, residualSignDistributionTable, principalComponentTable});
        varianceComponentTable.setVisible(false);
        principalComponentTable.setVisible(false);
        residualSignDistributionTable.setVisible(false);
        ComboBox paneSwitcherComboBox = new ComboBox();
        paneSwitcherComboBox.setCellFactory((Callback)new Callback<ListView<Node>, ListCell<Node>>(){

            public ListCell<Node> call(ListView<Node> param) {
                return new GlobalResultTypeListCell();
            }
        });
        paneSwitcherComboBox.setButtonCell((ListCell)new GlobalResultTypeListCell());
        paneSwitcherComboBox.getItems().addAll((Object[])new Node[]{testStatisticTable, varianceComponentTable, residualSignDistributionTable, principalComponentTable});
        paneSwitcherComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Node>(){

            public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
                if (oldValue != null) {
                    oldValue.setVisible(false);
                }
                if (newValue != null) {
                    newValue.setVisible(true);
                }
            }
        });
        paneSwitcherComboBox.getSelectionModel().select(varianceComponentTable);
        paneSwitcherComboBox.setTooltip(new Tooltip(i18n.getString("UIGlobalResultPaneBuilder.global_result_switcher.tooltip", "Global network adjustment results")));
        Region spacer = new Region();
        HBox hbox = new HBox(10.0);
        hbox.setPadding(new Insets(15.0, 30.0, 5.0, 0.0));
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        hbox.getChildren().addAll((Object[])new Node[]{spacer, paneSwitcherComboBox});
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)hbox);
        borderPane.setCenter((Node)contenPane);
        this.resultDataNode = borderPane;
        SQLManager.getInstance().addProjectDatabaseStateChangeListener(new DatabaseStateChangeListener());
    }

    private void setTableColumnView(TableView<? extends Row> tableView) {
        int columnCount = tableView.getColumns().size();
        int columnIndex = 0;
        while (columnIndex < columnCount) {
            TableColumn column = (TableColumn)tableView.getColumns().get(columnIndex);
            if (column.getUserData() instanceof ColumnType) {
                ColumnType columnType = (ColumnType)((Object)column.getUserData());
                switch (columnType) {
                    case VISIBLE: {
                        column.setVisible(true);
                        break;
                    }
                    default: {
                        column.setVisible(false);
                    }
                }
            }
            ++columnIndex;
        }
    }

    private class DatabaseStateChangeListener
    implements ProjectDatabaseStateChangeListener {
        private DatabaseStateChangeListener() {
        }

        @Override
        public void projectDatabaseStateChanged(ProjectDatabaseStateEvent evt) {
            if (evt.getEventType() == ProjectDatabaseStateType.CLOSED) {
                UITestStatisticTableBuilder.getInstance().getTableModel(UITestStatisticTableBuilder.getInstance().getTable()).setAll((Object[])new TestStatisticRow[]{UITestStatisticTableBuilder.getInstance().getEmptyRow()});
                UIPrincipalComponentTableBuilder.getInstance().getTableModel(UIPrincipalComponentTableBuilder.getInstance().getTable()).setAll((Object[])new PrincipalComponentRow[]{UIPrincipalComponentTableBuilder.getInstance().getEmptyRow()});
                UIResidualSignDistributionTableBuilder.getInstance().getTableModel(UIResidualSignDistributionTableBuilder.getInstance().getTable()).setAll((Object[])new ResidualSignDistributionRow[]{UIResidualSignDistributionTableBuilder.getInstance().getEmptyRow()});
                UIVarianceComponentTableBuilder.getInstance().getTableModel(UIVarianceComponentTableBuilder.getInstance().getTable(UIVarianceComponentTableBuilder.VarianceComponentDisplayType.OVERALL_COMPONENTS)).setAll((Object[])new VarianceComponentRow[]{UIVarianceComponentTableBuilder.getInstance().getEmptyRow()});
            }
        }
    }
}

