/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.resultpane;

import javafx.scene.Node;
import javafx.scene.control.ListCell;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.resultpane.GlobalResultType;

public class GlobalResultTypeListCell
extends ListCell<Node> {
    private I18N i18n = I18N.getInstance();

    protected void updateItem(Node item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.setGraphic(null);
        this.setText(null);
        if (item != null && !empty && item.getUserData() instanceof GlobalResultType) {
            this.setText(this.getText((GlobalResultType)((Object)item.getUserData())));
        }
    }

    private String getText(GlobalResultType type) {
        switch (type) {
            case TEST_STATISTIC: {
                return this.i18n.getString("GlobalResultTableListCell.test_statistic.label", "Test statistics");
            }
            case VARIANCE_COMPONENT: {
                return this.i18n.getString("GlobalResultTableListCell.variance_component.label", "Variance components estimation");
            }
            case PRINCIPAL_COMPONENT: {
                return this.i18n.getString("GlobalResultTableListCell.principal_component.label", "Principal component analysis");
            }
            case RESIDUAL_SIGN_DISTRIBUTION: {
                return this.i18n.getString("GlobalResultTableListCell.residual_sign_distribution.label", "Sign distribution analysis");
            }
        }
        return null;
    }
}

