/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.propertiespane;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.SequentialTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;
import org.applied_geodesy.adjustment.network.VerticalDeflectionGroupUncertaintyType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.jag3d.ui.tree.VerticalDeflectionTreeItemValue;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.ui.textfield.UncertaintyTextField;
import org.applied_geodesy.util.CellValueType;

public class UIVerticalDeflectionPropertiesPane {
    private I18N i18n = I18N.getInstance();
    private Node propertiesNode = null;
    private final TreeItemType type;
    private UncertaintyTextField uncertaintyDeflectionXField;
    private UncertaintyTextField uncertaintyDeflectionYField;
    private Label selectionInfoLabel = new Label();
    private Map<Object, ProgressIndicator> databaseTransactionProgressIndicators = new HashMap<Object, ProgressIndicator>(10);
    private Map<Object, Node> warningIconNodes = new HashMap<Object, Node>(10);
    private SequentialTransition sequentialTransition = new SequentialTransition();
    private boolean ignoreValueUpdate = false;
    private VerticalDeflectionTreeItemValue[] selectedVerticalDeflectionItemValues = null;

    UIVerticalDeflectionPropertiesPane(TreeItemType type) {
        switch (type) {
            case REFERENCE_VERTICAL_DEFLECTION_LEAF: 
            case STOCHASTIC_VERTICAL_DEFLECTION_LEAF: 
            case UNKNOWN_VERTICAL_DEFLECTION_LEAF: {
                this.type = type;
                this.init();
                break;
            }
            default: {
                throw new IllegalArgumentException(this.getClass().getSimpleName() + " Error, unsupported item type " + String.valueOf((Object)type));
            }
        }
    }

    public Node getNode() {
        return this.propertiesNode;
    }

    private void reset() {
        this.sequentialTransition.stop();
        this.setProgressIndicatorsVisible(false);
        this.setWarningIconsVisible(false);
        UITreeBuilder.getInstance().getTree().requestFocus();
        this.setUncertaintyDeflectionY(VerticalDeflectionTreeItemValue.getDefaultUncertainty(VerticalDeflectionGroupUncertaintyType.DEFLECTION_Y));
        this.setUncertaintyDeflectionX(VerticalDeflectionTreeItemValue.getDefaultUncertainty(VerticalDeflectionGroupUncertaintyType.DEFLECTION_Y));
    }

    public void setTreeItemValue(String name, VerticalDeflectionTreeItemValue ... selectedVerticalDeflectionItemValues) {
        if (this.selectedVerticalDeflectionItemValues != selectedVerticalDeflectionItemValues) {
            this.reset();
            this.selectedVerticalDeflectionItemValues = selectedVerticalDeflectionItemValues;
        }
        this.setGroupName(name, this.selectedVerticalDeflectionItemValues != null ? this.selectedVerticalDeflectionItemValues.length : 0);
    }

    private void setGroupName(String name, int cnt) {
        if (this.selectionInfoLabel != null) {
            String groupNameTmpl = this.i18n.getString("UIVerticalDeflectionPropertiesPane.status.selection.name.label", "Status:");
            String selectionCntTmpl = cnt > 1 ? String.format(Locale.ENGLISH, this.i18n.getString("UIVerticalDeflectionPropertiesPane.status.selection.counter.label", "and %d more selected group(s)\u2026"), cnt) : "";
            String label = String.format(Locale.ENGLISH, "%s %s %s", groupNameTmpl, name, selectionCntTmpl);
            if (!this.selectionInfoLabel.getText().equals(label)) {
                this.selectionInfoLabel.setText(label);
            }
        }
    }

    public boolean setUncertaintyDeflectionY(Double value) {
        if (this.uncertaintyDeflectionYField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.uncertaintyDeflectionYField.setValue(value != null && value > 0.0 ? value : null);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setUncertaintyDeflectionX(Double value) {
        if (this.uncertaintyDeflectionXField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.uncertaintyDeflectionXField.setValue(value != null && value > 0.0 ? value : null);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setUncertainty(VerticalDeflectionGroupUncertaintyType type, Double value, boolean displayWarningIcon) {
        if (this.warningIconNodes.containsKey((Object)type)) {
            this.warningIconNodes.get((Object)type).setVisible(displayWarningIcon);
            this.warningIconNodes.get((Object)type).setManaged(displayWarningIcon);
        }
        switch (type) {
            case DEFLECTION_X: {
                return this.setUncertaintyDeflectionX(value);
            }
            case DEFLECTION_Y: {
                return this.setUncertaintyDeflectionY(value);
            }
        }
        return false;
    }

    private Node createUncertaintiesPane() {
        if (this.type == TreeItemType.STOCHASTIC_VERTICAL_DEFLECTION_LEAF) {
            double fieldMinWidth = 200.0;
            double fieldMaxWidth = 350.0;
            double sigmaY = VerticalDeflectionTreeItemValue.getDefaultUncertainty(VerticalDeflectionGroupUncertaintyType.DEFLECTION_Y);
            double sigmaX = VerticalDeflectionTreeItemValue.getDefaultUncertainty(VerticalDeflectionGroupUncertaintyType.DEFLECTION_X);
            Node warningIconUncertaintyTypeYNode = this.createWarningIcon((Object)VerticalDeflectionGroupUncertaintyType.DEFLECTION_Y, this.i18n.getString("UIVerticalDeflectionPropertiesPane.uncertainty.y.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIVerticalDeflectionPropertiesPane.uncertainty.y.warning.tooltip", "Note: The selected groups have different values and \u03c3y differs by more than %.1f \u2030."), 0.1));
            Node warningIconUncertaintyTypeXNode = this.createWarningIcon((Object)VerticalDeflectionGroupUncertaintyType.DEFLECTION_X, this.i18n.getString("UIVerticalDeflectionPropertiesPane.uncertainty.x.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIVerticalDeflectionPropertiesPane.uncertainty.x.warning.tooltip", "Note: The selected groups have different values and \u03c3x differs by more than %.1f \u2030."), 0.1));
            ProgressIndicator uncertaintyDeflectionYProgressIndicator = this.createDatabaseTransactionProgressIndicator((Object)VerticalDeflectionGroupUncertaintyType.DEFLECTION_Y);
            ProgressIndicator uncertaintyDeflectionXProgressIndicator = this.createDatabaseTransactionProgressIndicator((Object)VerticalDeflectionGroupUncertaintyType.DEFLECTION_X);
            Label uncertaintyDeflectionYLabel = new Label(this.i18n.getString("UIVerticalDeflectionPropertiesPane.uncertainty.y.label", "\u03c3y"));
            Label uncertaintyDeflectionXLabel = new Label(this.i18n.getString("UIVerticalDeflectionPropertiesPane.uncertainty.x.label", "\u03c3x"));
            uncertaintyDeflectionYLabel.setMinWidth(Double.NEGATIVE_INFINITY);
            uncertaintyDeflectionXLabel.setMinWidth(Double.NEGATIVE_INFINITY);
            this.uncertaintyDeflectionYField = new UncertaintyTextField(sigmaY, CellValueType.ANGLE_UNCERTAINTY, true, DoubleTextField.ValueSupport.EXCLUDING_INCLUDING_INTERVAL);
            this.uncertaintyDeflectionYField.setTooltip(new Tooltip(this.i18n.getString("UIVerticalDeflectionPropertiesPane.uncertainty.y.tooltip", "Uncertainty of y-component of deflection of the vertical")));
            this.uncertaintyDeflectionYField.setUserData((Object)VerticalDeflectionGroupUncertaintyType.DEFLECTION_Y);
            this.uncertaintyDeflectionYField.numberProperty().addListener((ChangeListener)new NumberChangeListener(this.uncertaintyDeflectionYField));
            this.uncertaintyDeflectionYField.setOnAction(new CommitTextFieldActionListener());
            this.uncertaintyDeflectionYField.setMinWidth(fieldMinWidth);
            this.uncertaintyDeflectionYField.setMaxWidth(fieldMaxWidth);
            this.uncertaintyDeflectionXField = new UncertaintyTextField(sigmaX, CellValueType.ANGLE_UNCERTAINTY, true, DoubleTextField.ValueSupport.EXCLUDING_INCLUDING_INTERVAL);
            this.uncertaintyDeflectionXField.setTooltip(new Tooltip(this.i18n.getString("UIVerticalDeflectionPropertiesPane.uncertainty.x.tooltip", "Uncertainty of x-component of deflection of the vertical")));
            this.uncertaintyDeflectionXField.setUserData((Object)VerticalDeflectionGroupUncertaintyType.DEFLECTION_X);
            this.uncertaintyDeflectionXField.numberProperty().addListener((ChangeListener)new NumberChangeListener(this.uncertaintyDeflectionXField));
            this.uncertaintyDeflectionXField.setOnAction(new CommitTextFieldActionListener());
            this.uncertaintyDeflectionXField.setMinWidth(fieldMinWidth);
            this.uncertaintyDeflectionXField.setMaxWidth(fieldMaxWidth);
            uncertaintyDeflectionYLabel.setLabelFor((Node)this.uncertaintyDeflectionYField);
            uncertaintyDeflectionXLabel.setLabelFor((Node)this.uncertaintyDeflectionXField);
            GridPane gridPane = this.createGridPane();
            gridPane.add((Node)uncertaintyDeflectionYLabel, 0, 0);
            gridPane.add((Node)this.uncertaintyDeflectionYField, 1, 0);
            gridPane.add((Node)new HBox(new Node[]{warningIconUncertaintyTypeYNode, uncertaintyDeflectionYProgressIndicator}), 2, 0);
            gridPane.add((Node)uncertaintyDeflectionXLabel, 0, 1);
            gridPane.add((Node)this.uncertaintyDeflectionXField, 1, 1);
            gridPane.add((Node)new HBox(new Node[]{warningIconUncertaintyTypeXNode, uncertaintyDeflectionXProgressIndicator}), 2, 1);
            TitledPane uncertaintiesTitledPane = this.createTitledPane(this.i18n.getString("UIVerticalDeflectionPropertiesPane.uncertainty.title", "Uncertainties of deflection of the vertical"));
            uncertaintiesTitledPane.setContent((Node)gridPane);
            return uncertaintiesTitledPane;
        }
        return null;
    }

    private ProgressIndicator createDatabaseTransactionProgressIndicator(Object userData) {
        ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
        progressIndicator.setVisible(false);
        progressIndicator.setMinSize(17.0, 17.0);
        progressIndicator.setMaxSize(17.0, 17.0);
        progressIndicator.setUserData(userData);
        this.databaseTransactionProgressIndicators.put(userData, progressIndicator);
        return progressIndicator;
    }

    private Node createWarningIcon(Object userData, String text, String tooltip) {
        Label label = new Label();
        Label txtNode = new Label(text);
        txtNode.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        txtNode.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        txtNode.setTextFill((Paint)Color.DARKORANGE);
        txtNode.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        label.setGraphic((Node)txtNode);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setTooltip(new Tooltip(tooltip));
        label.setUserData(userData);
        label.setVisible(false);
        label.setManaged(false);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.warningIconNodes.put(userData, (Node)label);
        return label;
    }

    private GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        gridPane.setPadding(new Insets(20.0, 10.0, 20.0, 10.0));
        return gridPane;
    }

    private TitledPane createTitledPane(String title) {
        TitledPane parametersTitledPane = new TitledPane();
        parametersTitledPane.setMaxWidth(Double.MAX_VALUE);
        parametersTitledPane.setCollapsible(false);
        parametersTitledPane.setAnimated(false);
        parametersTitledPane.setText(title);
        parametersTitledPane.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        return parametersTitledPane;
    }

    private void init() {
        VBox content = new VBox();
        Node uncertainties = this.createUncertaintiesPane();
        if (uncertainties != null) {
            content.getChildren().add((Object)uncertainties);
        }
        this.reset();
        ScrollPane scroller = new ScrollPane((Node)content);
        scroller.setPadding(new Insets(20.0, 50.0, 20.0, 50.0));
        scroller.setFitToHeight(true);
        scroller.setFitToWidth(true);
        Region spacer = new Region();
        spacer.setPrefHeight(0.0);
        VBox.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.selectionInfoLabel.setPadding(new Insets(1.0, 5.0, 2.0, 10.0));
        this.selectionInfoLabel.setFont(new Font(10.5));
        this.propertiesNode = new VBox(new Node[]{scroller, spacer, this.selectionInfoLabel});
        FadeTransition fadeIn = new FadeTransition(Duration.millis((double)150.0));
        FadeTransition fadeOut = new FadeTransition(Duration.millis((double)150.0));
        fadeIn.setFromValue(0.0);
        fadeIn.setToValue(1.0);
        fadeIn.setCycleCount(1);
        fadeIn.setAutoReverse(false);
        fadeOut.setFromValue(1.0);
        fadeOut.setToValue(0.0);
        fadeOut.setCycleCount(1);
        fadeOut.setAutoReverse(false);
        this.sequentialTransition.getChildren().addAll((Object[])new Animation[]{fadeIn, fadeOut});
        this.sequentialTransition.setAutoReverse(false);
        this.sequentialTransition.onFinishedProperty().addListener((ChangeListener)new SequentialTransitionFinishedListener());
    }

    private void setProgressIndicatorsVisible(boolean visible) {
        if (this.databaseTransactionProgressIndicators != null) {
            for (ProgressIndicator progressIndicator : this.databaseTransactionProgressIndicators.values()) {
                progressIndicator.setVisible(visible);
            }
        }
    }

    private void setWarningIconsVisible(boolean visible) {
        if (this.warningIconNodes != null) {
            for (Node warningIconNode : this.warningIconNodes.values()) {
                warningIconNode.setVisible(visible);
                warningIconNode.setManaged(visible);
            }
        }
    }

    private void save(VerticalDeflectionGroupUncertaintyType uncertaintyType) {
        try {
            Double value = null;
            switch (uncertaintyType) {
                case DEFLECTION_X: {
                    value = this.uncertaintyDeflectionXField.getNumber();
                    break;
                }
                case DEFLECTION_Y: {
                    value = this.uncertaintyDeflectionYField.getNumber();
                    break;
                }
                default: {
                    System.err.println(this.getClass().getSimpleName() + " : Error, unsupported uncertainty type " + String.valueOf((Object)uncertaintyType));
                }
            }
            if (value != null && value > 0.0 && this.selectedVerticalDeflectionItemValues != null && this.selectedVerticalDeflectionItemValues.length > 0) {
                this.setProgressIndicatorsVisible(false);
                if (this.warningIconNodes.containsKey((Object)uncertaintyType)) {
                    Node warningIconNodes = this.warningIconNodes.get((Object)uncertaintyType);
                    warningIconNodes.setVisible(false);
                    warningIconNodes.setManaged(false);
                }
                if (this.databaseTransactionProgressIndicators.containsKey((Object)uncertaintyType)) {
                    ProgressIndicator node = this.databaseTransactionProgressIndicators.get((Object)uncertaintyType);
                    node.setVisible(true);
                    this.sequentialTransition.stop();
                    this.sequentialTransition.setNode((Node)node);
                    this.sequentialTransition.playFromStart();
                }
                SQLManager.getInstance().saveUncertainty(uncertaintyType, (double)value, this.selectedVerticalDeflectionItemValues);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setProgressIndicatorsVisible(false);
            this.sequentialTransition.stop();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(UIVerticalDeflectionPropertiesPane.this.i18n.getString("UIVerticalDeflectionPropertiesPane.message.error.save.uncertainty.exception.title", "Unexpected SQL-Error"), UIVerticalDeflectionPropertiesPane.this.i18n.getString("UIVerticalDeflectionPropertiesPane.message.error.save.uncertainty.exception.header", "Error, could not save group uncertainties to database."), UIVerticalDeflectionPropertiesPane.this.i18n.getString("UIVerticalDeflectionPropertiesPane.message.error.save.uncertainty.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private class CommitTextFieldActionListener
    implements EventHandler<ActionEvent> {
        private CommitTextFieldActionListener() {
        }

        public void handle(ActionEvent event) {
            if (!UIVerticalDeflectionPropertiesPane.this.ignoreValueUpdate && event.getSource() != null && event.getSource() instanceof DoubleTextField && ((DoubleTextField)event.getSource()).getUserData() != null && ((DoubleTextField)event.getSource()).getUserData() instanceof VerticalDeflectionGroupUncertaintyType) {
                DoubleTextField field = (DoubleTextField)event.getSource();
                VerticalDeflectionGroupUncertaintyType uncertaintyType = (VerticalDeflectionGroupUncertaintyType)((Object)field.getUserData());
                UIVerticalDeflectionPropertiesPane.this.save(uncertaintyType);
            }
        }
    }

    private class NumberChangeListener
    implements ChangeListener<Double> {
        private final DoubleTextField field;

        private NumberChangeListener(DoubleTextField field) {
            this.field = field;
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (!UIVerticalDeflectionPropertiesPane.this.ignoreValueUpdate && this.field.getUserData() != null && this.field.getUserData() instanceof VerticalDeflectionGroupUncertaintyType) {
                VerticalDeflectionGroupUncertaintyType uncertaintyType = (VerticalDeflectionGroupUncertaintyType)((Object)this.field.getUserData());
                UIVerticalDeflectionPropertiesPane.this.save(uncertaintyType);
            }
        }
    }

    private class SequentialTransitionFinishedListener
    implements ChangeListener<EventHandler<ActionEvent>> {
        private SequentialTransitionFinishedListener() {
        }

        public void changed(ObservableValue<? extends EventHandler<ActionEvent>> observable, EventHandler<ActionEvent> oldValue, EventHandler<ActionEvent> newValue) {
            UIVerticalDeflectionPropertiesPane.this.setProgressIndicatorsVisible(false);
            if (UIVerticalDeflectionPropertiesPane.this.sequentialTransition != null) {
                UIVerticalDeflectionPropertiesPane.this.sequentialTransition.setNode(null);
            }
        }
    }
}

