/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.propertiespane;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.SequentialTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.network.Epoch;
import org.applied_geodesy.adjustment.network.ObservationGroupUncertaintyType;
import org.applied_geodesy.adjustment.network.ParameterType;
import org.applied_geodesy.adjustment.network.observation.DeltaZ;
import org.applied_geodesy.adjustment.network.observation.Direction;
import org.applied_geodesy.adjustment.network.observation.GNSSBaselineDeltaX2D;
import org.applied_geodesy.adjustment.network.observation.GNSSBaselineDeltaX3D;
import org.applied_geodesy.adjustment.network.observation.GNSSBaselineDeltaZ1D;
import org.applied_geodesy.adjustment.network.observation.HorizontalDistance;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.observation.SlopeDistance;
import org.applied_geodesy.adjustment.network.observation.ZenithAngle;
import org.applied_geodesy.adjustment.network.observation.group.DeltaZGroup;
import org.applied_geodesy.adjustment.network.observation.group.DirectionGroup;
import org.applied_geodesy.adjustment.network.observation.group.GNSSBaseline1DGroup;
import org.applied_geodesy.adjustment.network.observation.group.GNSSBaseline2DGroup;
import org.applied_geodesy.adjustment.network.observation.group.GNSSBaseline3DGroup;
import org.applied_geodesy.adjustment.network.observation.group.HorizontalDistanceGroup;
import org.applied_geodesy.adjustment.network.observation.group.ObservationGroup;
import org.applied_geodesy.adjustment.network.observation.group.SlopeDistanceGroup;
import org.applied_geodesy.adjustment.network.observation.group.ZenithAngleGroup;
import org.applied_geodesy.adjustment.network.point.Point3D;
import org.applied_geodesy.jag3d.sql.ParameterModificationType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.ui.textfield.UncertaintyTextField;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterOptions;

public class UIObservationPropertiesPane {
    private I18N i18n = I18N.getInstance();
    private Node propertiesNode = null;
    private final TreeItemType type;
    private DoubleTextField zeroPointOffsetField;
    private CheckBox zeroPointOffsetCheckBox;
    private DoubleTextField scaleField;
    private CheckBox scaleCheckBox;
    private DoubleTextField rotationXField;
    private CheckBox rotationXCheckBox;
    private DoubleTextField rotationYField;
    private CheckBox rotationYCheckBox;
    private DoubleTextField rotationZField;
    private CheckBox rotationZCheckBox;
    private DoubleTextField orientationOffsetField;
    private CheckBox orientationOffsetCheckBox;
    private DoubleTextField refractionIndexField;
    private CheckBox refractionIndexCheckBox;
    private UncertaintyTextField zeroPointOffsetUncertaintyField;
    private UncertaintyTextField squareRootDistanceDependentUncertaintyField;
    private UncertaintyTextField distanceDependentUncertaintyField;
    private Label selectionInfoLabel = new Label();
    private RadioButton referenceEpochRadioButton;
    private RadioButton controlEpochRadioButton;
    private Map<Object, ProgressIndicator> databaseTransactionProgressIndicators = new HashMap<Object, ProgressIndicator>(10);
    private Map<Object, Node> warningIconNodes = new HashMap<Object, Node>(10);
    private SequentialTransition sequentialTransition = new SequentialTransition();
    private boolean ignoreValueUpdate = false;
    private ObservationTreeItemValue[] selectedObservationItemValues = null;
    private LineChart<Number, Number> lineChart;
    private final double minDistanceForUncertaintyChart = 5.0;
    private final double maxDistanceForUncertaintyChart = 150.0;
    private FormatterOptions options = FormatterOptions.getInstance();

    UIObservationPropertiesPane(TreeItemType type) {
        switch (type) {
            case LEVELING_LEAF: 
            case DIRECTION_LEAF: 
            case HORIZONTAL_DISTANCE_LEAF: 
            case SLOPE_DISTANCE_LEAF: 
            case ZENITH_ANGLE_LEAF: 
            case GNSS_1D_LEAF: 
            case GNSS_2D_LEAF: 
            case GNSS_3D_LEAF: {
                this.type = type;
                this.init();
                break;
            }
            default: {
                throw new IllegalArgumentException(this.getClass().getSimpleName() + " Error, unsupported item type " + String.valueOf((Object)type));
            }
        }
    }

    public void setTreeItemValue(String name, ObservationTreeItemValue ... selectedObservationItemValues) {
        if (this.selectedObservationItemValues != selectedObservationItemValues) {
            this.reset();
            this.selectedObservationItemValues = selectedObservationItemValues;
        }
        this.setGroupName(name, this.selectedObservationItemValues != null ? this.selectedObservationItemValues.length : 0);
    }

    public Node getNode() {
        return this.propertiesNode;
    }

    private void setGroupName(String name, int cnt) {
        if (this.selectionInfoLabel != null) {
            String groupNameTmpl = this.i18n.getString("UIObservationPropertiesPane.status.selection.name.label", "Status:");
            String selectionCntTmpl = cnt > 1 ? String.format(Locale.ENGLISH, this.i18n.getString("UIObservationPropertiesPane.status.selection.counter.label", "and %d more selected group(s)\u2026"), cnt - 1) : "";
            String label = String.format(Locale.ENGLISH, "%s %s %s", groupNameTmpl, name, selectionCntTmpl);
            if (!this.selectionInfoLabel.getText().equals(label)) {
                this.selectionInfoLabel.setText(label);
            }
        }
    }

    private void reset() {
        this.sequentialTransition.stop();
        this.setProgressIndicatorsVisible(false);
        this.setWarningIconsVisible(false);
        UITreeBuilder.getInstance().getTree().requestFocus();
        double offset = 0.0;
        double scale = 1.0;
        double orientation = 0.0;
        double refraction = 0.0;
        double rotationY = 0.0;
        double rotationX = 0.0;
        double rotationZ = 0.0;
        this.setZeroPointOffsetUncertainty(ObservationTreeItemValue.getDefaultUncertainty(this.type, ObservationGroupUncertaintyType.ZERO_POINT_OFFSET));
        this.setSquareRootDistanceDependentUncertainty(ObservationTreeItemValue.getDefaultUncertainty(this.type, ObservationGroupUncertaintyType.SQUARE_ROOT_DISTANCE_DEPENDENT));
        this.setDistanceDependentUncertainty(ObservationTreeItemValue.getDefaultUncertainty(this.type, ObservationGroupUncertaintyType.DISTANCE_DEPENDENT));
        this.setReferenceEpoch(true);
        this.setZeroPointOffset(offset, false);
        this.setScale(scale, false);
        this.setOrientation(orientation, true);
        this.setRotationX(rotationX, false);
        this.setRotationY(rotationY, false);
        this.setRotationZ(rotationZ, false);
        this.setRefractionIndex(refraction, false);
    }

    public boolean setZeroPointOffsetUncertainty(Double value) {
        if (this.zeroPointOffsetUncertaintyField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.zeroPointOffsetUncertaintyField.setValue(value != null && value > 0.0 ? value : null);
        this.updateUncertaintyChart(this.lineChart);
        this.updateTickLabels(this.lineChart);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setSquareRootDistanceDependentUncertainty(Double value) {
        if (this.squareRootDistanceDependentUncertaintyField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.squareRootDistanceDependentUncertaintyField.setValue(value != null && value >= 0.0 ? value : null);
        this.updateUncertaintyChart(this.lineChart);
        this.updateTickLabels(this.lineChart);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setDistanceDependentUncertainty(Double value) {
        if (this.distanceDependentUncertaintyField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.distanceDependentUncertaintyField.setValue(value != null && value >= 0.0 ? value : null);
        this.updateUncertaintyChart(this.lineChart);
        this.updateTickLabels(this.lineChart);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setReferenceEpoch(Boolean referenceEpoch) {
        if (this.referenceEpochRadioButton == null || this.controlEpochRadioButton == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.referenceEpochRadioButton.setSelected(referenceEpoch != null && referenceEpoch == Boolean.TRUE);
        this.controlEpochRadioButton.setSelected(referenceEpoch == null || referenceEpoch == Boolean.FALSE);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setUncertainty(ObservationGroupUncertaintyType type, Double value, boolean displayWarningIcon) {
        if (this.warningIconNodes.containsKey((Object)type)) {
            this.warningIconNodes.get((Object)type).setVisible(displayWarningIcon);
            this.warningIconNodes.get((Object)type).setManaged(displayWarningIcon);
        }
        switch (type) {
            case ZERO_POINT_OFFSET: {
                return this.setZeroPointOffsetUncertainty(value);
            }
            case DISTANCE_DEPENDENT: {
                return this.setDistanceDependentUncertainty(value);
            }
            case SQUARE_ROOT_DISTANCE_DEPENDENT: {
                return this.setSquareRootDistanceDependentUncertainty(value);
            }
        }
        return false;
    }

    public boolean setAdditionalParameter(ParameterType paramType, Double value, Boolean enable, boolean displayWarningIcon) {
        if (this.warningIconNodes.containsKey((Object)paramType)) {
            this.warningIconNodes.get((Object)paramType).setVisible(displayWarningIcon);
            this.warningIconNodes.get((Object)paramType).setManaged(displayWarningIcon);
        }
        switch (paramType) {
            case ZERO_POINT_OFFSET: {
                return this.setZeroPointOffset(value, enable);
            }
            case SCALE: {
                return this.setScale(value, enable);
            }
            case ORIENTATION: {
                return this.setOrientation(value, enable);
            }
            case ROTATION_X: {
                return this.setRotationX(value, enable);
            }
            case ROTATION_Y: {
                return this.setRotationY(value, enable);
            }
            case ROTATION_Z: {
                return this.setRotationZ(value, enable);
            }
            case REFRACTION_INDEX: {
                return this.setRefractionIndex(value, enable);
            }
        }
        return false;
    }

    public boolean setZeroPointOffset(Double value, Boolean enable) {
        if (this.zeroPointOffsetCheckBox == null || this.zeroPointOffsetField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.zeroPointOffsetCheckBox.setSelected(enable != null && enable == Boolean.TRUE);
        this.zeroPointOffsetField.setValue(value);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setScale(Double value, Boolean enable) {
        if (this.scaleCheckBox == null || this.scaleField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.scaleCheckBox.setSelected(enable != null && enable == Boolean.TRUE);
        this.scaleField.setValue(value);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setRotationX(Double value, Boolean enable) {
        if (this.rotationXCheckBox == null || this.rotationXField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.rotationXCheckBox.setSelected(enable != null && enable == Boolean.TRUE);
        this.rotationXField.setValue(value);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setRotationY(Double value, Boolean enable) {
        if (this.rotationYCheckBox == null || this.rotationYField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.rotationYCheckBox.setSelected(enable != null && enable == Boolean.TRUE);
        this.rotationYField.setValue(value);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setRotationZ(Double value, Boolean enable) {
        if (this.rotationZCheckBox == null || this.rotationZField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.rotationZCheckBox.setSelected(enable != null && enable == Boolean.TRUE);
        this.rotationZField.setValue(value);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setOrientation(Double value, Boolean enable) {
        if (this.orientationOffsetCheckBox == null || this.orientationOffsetField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.orientationOffsetCheckBox.setSelected(enable != null && enable == Boolean.TRUE);
        this.orientationOffsetField.setValue(value);
        this.ignoreValueUpdate = false;
        return true;
    }

    public boolean setRefractionIndex(Double value, Boolean enable) {
        if (this.refractionIndexCheckBox == null || this.refractionIndexField == null) {
            return false;
        }
        this.ignoreValueUpdate = true;
        this.refractionIndexCheckBox.setSelected(enable != null && enable == Boolean.TRUE);
        this.refractionIndexField.setValue(value);
        this.ignoreValueUpdate = false;
        return true;
    }

    private Node createAdditionalParametersPane() {
        ParameterType[] paramTypes;
        GridPane gridPane = this.createGridPane();
        double offset = 0.0;
        double scale = 1.0;
        double orientation = 0.0;
        double refraction = 0.0;
        double rotationY = 0.0;
        double rotationX = 0.0;
        double rotationZ = 0.0;
        int row = 0;
        ParameterType[] parameterTypeArray = paramTypes = ObservationTreeItemValue.getParameterTypes(this.type);
        int n = paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterType paramType = parameterTypeArray[n2];
            CheckBox box = null;
            DoubleTextField field = null;
            ProgressIndicator progressIndicator = null;
            Node warningIcon = null;
            switch (paramType) {
                case ORIENTATION: {
                    box = this.orientationOffsetCheckBox = this.createCheckBox(this.i18n.getString("UIObservationPropertiesPane.additionalparameter.orientation.label", "Orientation o"), this.i18n.getString("UIObservationPropertiesPane.additionalparameter.orientation.label.tooltip", "Checked, if orientation is an unknown parameter to be estimated"), false, paramType);
                    field = this.orientationOffsetField = this.createDoubleTextField(orientation, CellValueType.ANGLE_RESIDUAL, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.orientation.tooltip", "Set orientation offset"), paramType);
                    progressIndicator = this.createDatabaseTransactionProgressIndicator((Object)paramType);
                    warningIcon = this.createWarningIcon((Object)paramType, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.orientation.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.orientation.warning.tooltip", "Note: The selected groups have different values and the orientation differs by more than %.1f \u2030."), 0.1));
                    break;
                }
                case REFRACTION_INDEX: {
                    box = this.refractionIndexCheckBox = this.createCheckBox(this.i18n.getString("UIObservationPropertiesPane.additionalparameter.refraction.label", "Refraction index k"), this.i18n.getString("UIObservationPropertiesPane.additionalparameter.refraction.label.tooltip", "Checked, if refraction index is an unknown parameter to be estimated"), true, paramType);
                    field = this.refractionIndexField = this.createDoubleTextField(refraction, CellValueType.STATISTIC, false, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.refraction.tooltip", "Set refraction index offset"), paramType);
                    progressIndicator = this.createDatabaseTransactionProgressIndicator((Object)paramType);
                    warningIcon = this.createWarningIcon((Object)paramType, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.refraction.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.refraction.warning.tooltip", "Note: The selected groups have different values and the refraction index differs by more than %.1f \u2030."), 0.1));
                    break;
                }
                case ROTATION_Y: {
                    box = this.rotationYCheckBox = this.createCheckBox(this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.y.label", "Rotation angle ry"), this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.y.label.tooltip", "Checked, if rotation angle around y-axis is an unknown parameter to be estimated"), true, paramType);
                    field = this.rotationYField = this.createDoubleTextField(rotationY, CellValueType.ANGLE_RESIDUAL, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.y.tooltip", "Set rotation angle around y-axis"), paramType);
                    progressIndicator = this.createDatabaseTransactionProgressIndicator((Object)paramType);
                    warningIcon = this.createWarningIcon((Object)paramType, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.y.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.y.warning.tooltip", "Note: The selected groups have different values and the rotation angle around y-axis differs by more than %.1f \u2030."), 0.1));
                    break;
                }
                case ROTATION_X: {
                    box = this.rotationXCheckBox = this.createCheckBox(this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.x.label", "Rotation angle rx"), this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.x.label.tooltip", "Checked, if rotation angle around x-axis is an unknown parameter to be estimated"), true, paramType);
                    field = this.rotationXField = this.createDoubleTextField(rotationX, CellValueType.ANGLE_RESIDUAL, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.x.tooltip", "Set rotation angle around x-axis"), paramType);
                    progressIndicator = this.createDatabaseTransactionProgressIndicator((Object)paramType);
                    warningIcon = this.createWarningIcon((Object)paramType, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.x.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.x.warning.tooltip", "Note: The selected groups have different values and the rotation angle around x-axis differs by more than %.1f \u2030."), 0.1));
                    break;
                }
                case ROTATION_Z: {
                    box = this.rotationZCheckBox = this.createCheckBox(this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.z.label", "Rotation angle rz"), this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.z.label.tooltip", "Checked, if rotation angle around z-axis is an unknown parameter to be estimated"), true, paramType);
                    field = this.rotationZField = this.createDoubleTextField(rotationZ, CellValueType.ANGLE_RESIDUAL, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.z.tooltip", "Set rotation angle around z-axis"), paramType);
                    progressIndicator = this.createDatabaseTransactionProgressIndicator((Object)paramType);
                    warningIcon = this.createWarningIcon((Object)paramType, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.z.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.rotation.z.warning.tooltip", "Note: The selected groups have different values and the rotation angle around z-axis differs by more than %.1f \u2030."), 0.1));
                    break;
                }
                case SCALE: {
                    box = this.scaleCheckBox = this.createCheckBox(this.i18n.getString("UIObservationPropertiesPane.additionalparameter.scale.label", "Scale s"), this.i18n.getString("UIObservationPropertiesPane.additionalparameter.scale.label.tooltip", "Checked, if scale is an unknown parameter to be estimated"), true, paramType);
                    field = this.scaleField = this.createDoubleTextField(scale, CellValueType.SCALE, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.scale.tooltip", "Set scale"), paramType);
                    progressIndicator = this.createDatabaseTransactionProgressIndicator((Object)paramType);
                    warningIcon = this.createWarningIcon((Object)paramType, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.scale.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.scale.warning.tooltip", "Note: The selected groups have different values and the scale differs by more than %.1f \u2030."), 0.1));
                    break;
                }
                case ZERO_POINT_OFFSET: {
                    box = this.zeroPointOffsetCheckBox = this.createCheckBox(this.i18n.getString("UIObservationPropertiesPane.additionalparameter.zero_point_offset.label", "Offset a"), this.i18n.getString("UIObservationPropertiesPane.additionalparameter.zero_point_offset.label.tooltip", "Checked, if zero point offset is an unknown parameter to be estimated"), true, paramType);
                    field = this.zeroPointOffsetField = this.createDoubleTextField(offset, CellValueType.LENGTH_RESIDUAL, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.zero_point_offset.tooltip", "Set zero point offset"), paramType);
                    progressIndicator = this.createDatabaseTransactionProgressIndicator((Object)paramType);
                    warningIcon = this.createWarningIcon((Object)paramType, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.zero_point_offset.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIObservationPropertiesPane.additionalparameter.zero_point_offset.warning.tooltip", "Note: The selected groups have different values and the zero point offset differs by more than %.1f \u2030."), 0.1));
                    break;
                }
            }
            if (field != null && box != null && progressIndicator != null && warningIcon != null) {
                gridPane.add(box, 0, row);
                gridPane.add(field, 1, row);
                gridPane.add((Node)new HBox(new Node[]{warningIcon, progressIndicator}), 2, row++);
            }
            ++n2;
        }
        TitledPane additionalParametersTitledPane = this.createTitledPane(this.i18n.getString("UIObservationPropertiesPane.additionalparameter.title", "Additional parameters"));
        additionalParametersTitledPane.setContent((Node)gridPane);
        return additionalParametersTitledPane;
    }

    private Node createUncertaintiesPane() {
        CellValueType constantUncertaintyCellValueType = null;
        CellValueType squareRootDistanceDependentUncertaintyCellValueType = CellValueType.LENGTH_UNCERTAINTY;
        CellValueType distanceDependentUncertaintyCellValueType = null;
        double sigmaZeroPointOffset = ObservationTreeItemValue.getDefaultUncertainty(this.type, ObservationGroupUncertaintyType.ZERO_POINT_OFFSET);
        double sigmaSquareRootDistance = ObservationTreeItemValue.getDefaultUncertainty(this.type, ObservationGroupUncertaintyType.SQUARE_ROOT_DISTANCE_DEPENDENT);
        double sigmaDistanceDependent = ObservationTreeItemValue.getDefaultUncertainty(this.type, ObservationGroupUncertaintyType.DISTANCE_DEPENDENT);
        switch (this.type) {
            case LEVELING_LEAF: {
                constantUncertaintyCellValueType = CellValueType.LENGTH_UNCERTAINTY;
                distanceDependentUncertaintyCellValueType = CellValueType.SCALE_UNCERTAINTY;
                break;
            }
            case HORIZONTAL_DISTANCE_LEAF: 
            case SLOPE_DISTANCE_LEAF: {
                constantUncertaintyCellValueType = CellValueType.LENGTH_UNCERTAINTY;
                distanceDependentUncertaintyCellValueType = CellValueType.SCALE_UNCERTAINTY;
                break;
            }
            case DIRECTION_LEAF: 
            case ZENITH_ANGLE_LEAF: {
                constantUncertaintyCellValueType = CellValueType.ANGLE_UNCERTAINTY;
                distanceDependentUncertaintyCellValueType = CellValueType.LENGTH_UNCERTAINTY;
                break;
            }
            case GNSS_1D_LEAF: 
            case GNSS_2D_LEAF: 
            case GNSS_3D_LEAF: {
                constantUncertaintyCellValueType = CellValueType.LENGTH_UNCERTAINTY;
                distanceDependentUncertaintyCellValueType = CellValueType.SCALE_UNCERTAINTY;
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Error, unsupported node type " + String.valueOf((Object)this.type));
                return null;
            }
        }
        GridPane gridPane = this.createGridPane();
        Node warningIconUncertaintyTypeANode = this.createWarningIcon((Object)ObservationGroupUncertaintyType.ZERO_POINT_OFFSET, this.i18n.getString("UIObservationPropertiesPane.uncertainty.ua.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIObservationPropertiesPane.uncertainty.ua.warning.tooltip", "Note: The selected groups have different values and \u03c3a differs by more than %.1f \u2030."), 0.1));
        ProgressIndicator databaseTransactionUncertaintyTypeAProgressIndicator = this.createDatabaseTransactionProgressIndicator((Object)ObservationGroupUncertaintyType.ZERO_POINT_OFFSET);
        Label uncertaintyTypeALabel = new Label(this.i18n.getString("UIObservationPropertiesPane.uncertainty.ua.label", "\u03c3a"));
        uncertaintyTypeALabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.zeroPointOffsetUncertaintyField = this.createUncertaintyTextField(sigmaZeroPointOffset, constantUncertaintyCellValueType, true, DoubleTextField.ValueSupport.EXCLUDING_INCLUDING_INTERVAL, this.i18n.getString("UIObservationPropertiesPane.uncertainty.ua.tooltip", "Set constant part of combined uncertainty"), ObservationGroupUncertaintyType.ZERO_POINT_OFFSET);
        Node warningIconUncertaintyTypeBNode = this.createWarningIcon((Object)ObservationGroupUncertaintyType.SQUARE_ROOT_DISTANCE_DEPENDENT, this.i18n.getString("UIObservationPropertiesPane.uncertainty.ub.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIObservationPropertiesPane.uncertainty.ub.warning.tooltip", "Note: The selected groups have different values and \u03c3b differs by more than %.1f \u2030."), 0.1));
        ProgressIndicator databaseTransactionUncertaintyTypeBProgressIndicator = this.createDatabaseTransactionProgressIndicator((Object)ObservationGroupUncertaintyType.SQUARE_ROOT_DISTANCE_DEPENDENT);
        Label uncertaintyTypeBLabel = new Label(this.i18n.getString("UIObservationPropertiesPane.uncertainty.ub.label", "\u03c3b(\u221ad)"));
        uncertaintyTypeBLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.squareRootDistanceDependentUncertaintyField = this.createUncertaintyTextField(sigmaSquareRootDistance, squareRootDistanceDependentUncertaintyCellValueType, true, DoubleTextField.ValueSupport.INCLUDING_INCLUDING_INTERVAL, this.i18n.getString("UIObservationPropertiesPane.uncertainty.ub.tooltip", "Set square-root distance dependent part of combined uncertainty"), ObservationGroupUncertaintyType.SQUARE_ROOT_DISTANCE_DEPENDENT);
        Node warningIconUncertaintyTypeCNode = this.createWarningIcon((Object)ObservationGroupUncertaintyType.DISTANCE_DEPENDENT, this.i18n.getString("UIObservationPropertiesPane.uncertainty.uc.warning.label", "\u26a0"), String.format(Locale.ENGLISH, this.i18n.getString("UIObservationPropertiesPane.uncertainty.uc.warning.tooltip", "Note: The selected groups have different values and \u03c3c differs by more than %.1f \u2030."), 0.1));
        ProgressIndicator databaseTransactionUncertaintyTypeCProgressIndicator = this.createDatabaseTransactionProgressIndicator((Object)ObservationGroupUncertaintyType.DISTANCE_DEPENDENT);
        Label uncertaintyTypeCLabel = new Label(this.i18n.getString("UIObservationPropertiesPane.uncertainty.uc.label", "\u03c3c(d)"));
        uncertaintyTypeCLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.distanceDependentUncertaintyField = this.createUncertaintyTextField(sigmaDistanceDependent, distanceDependentUncertaintyCellValueType, true, DoubleTextField.ValueSupport.INCLUDING_INCLUDING_INTERVAL, this.i18n.getString("UIObservationPropertiesPane.uncertainty.uc.tooltip", "Set distance dependent part of combined uncertainty"), ObservationGroupUncertaintyType.DISTANCE_DEPENDENT);
        uncertaintyTypeALabel.setLabelFor((Node)this.zeroPointOffsetUncertaintyField);
        uncertaintyTypeBLabel.setLabelFor((Node)this.squareRootDistanceDependentUncertaintyField);
        uncertaintyTypeCLabel.setLabelFor((Node)this.distanceDependentUncertaintyField);
        gridPane.add((Node)uncertaintyTypeALabel, 0, 0);
        gridPane.add((Node)this.zeroPointOffsetUncertaintyField, 1, 0);
        gridPane.add((Node)new HBox(new Node[]{warningIconUncertaintyTypeANode, databaseTransactionUncertaintyTypeAProgressIndicator}), 2, 0);
        gridPane.add((Node)uncertaintyTypeBLabel, 0, 1);
        gridPane.add((Node)this.squareRootDistanceDependentUncertaintyField, 1, 1);
        gridPane.add((Node)new HBox(new Node[]{warningIconUncertaintyTypeBNode, databaseTransactionUncertaintyTypeBProgressIndicator}), 2, 1);
        gridPane.add((Node)uncertaintyTypeCLabel, 0, 2);
        gridPane.add((Node)this.distanceDependentUncertaintyField, 1, 2);
        gridPane.add((Node)new HBox(new Node[]{warningIconUncertaintyTypeCNode, databaseTransactionUncertaintyTypeCProgressIndicator}), 2, 2);
        TitledPane uncertaintiesTitledPane = this.createTitledPane(this.i18n.getString("UIObservationPropertiesPane.uncertainty.title", "Uncertainties"));
        uncertaintiesTitledPane.setContent((Node)gridPane);
        return uncertaintiesTitledPane;
    }

    private Node createCongruenceAnalysisPane() {
        GridPane gridPane = this.createGridPane();
        ProgressIndicator databaseTransactionReferenceEpochProgressIndicator = this.createDatabaseTransactionProgressIndicator((Object)Epoch.REFERENCE);
        ProgressIndicator databaseTransactionControlEpochProgressIndicator = this.createDatabaseTransactionProgressIndicator((Object)Epoch.CONTROL);
        ToggleGroup group = new ToggleGroup();
        this.referenceEpochRadioButton = this.createRadioButton(this.i18n.getString("UIObservationPropertiesPane.congruenceanalysis.referenceepoch.label", "Reference epoch"), this.i18n.getString("UIObservationPropertiesPane.congruenceanalysis.referenceepoch.tooltip", "Selected, if group is referred to reference epoch"), group, true, Epoch.REFERENCE);
        this.controlEpochRadioButton = this.createRadioButton(this.i18n.getString("UIObservationPropertiesPane.congruenceanalysis.controlepoch.label", "Control epoch"), this.i18n.getString("UIObservationPropertiesPane.congruenceanalysis.controlepoch.tooltip", "Selected, if group is referred to control epoch"), group, false, Epoch.CONTROL);
        gridPane.add((Node)this.referenceEpochRadioButton, 0, 0);
        gridPane.add((Node)databaseTransactionReferenceEpochProgressIndicator, 1, 0);
        gridPane.add((Node)this.controlEpochRadioButton, 0, 1);
        gridPane.add((Node)databaseTransactionControlEpochProgressIndicator, 1, 1);
        TitledPane congruenceAnalysisTitledPane = this.createTitledPane(this.i18n.getString("UIObservationPropertiesPane.congruenceanalysis.title", "Congruence analysis"));
        congruenceAnalysisTitledPane.setContent((Node)gridPane);
        return congruenceAnalysisTitledPane;
    }

    private Node createUncertaintyChartPane() {
        NumberAxis xAxis = new NumberAxis(0.0, 155.0, 10.0);
        NumberAxis yAxis = new NumberAxis();
        xAxis.setForceZeroInRange(true);
        xAxis.setMinorTickVisible(false);
        xAxis.setAnimated(false);
        yAxis.setMinorTickVisible(false);
        yAxis.setForceZeroInRange(false);
        yAxis.setAnimated(false);
        this.lineChart = new LineChart((Axis)xAxis, (Axis)yAxis);
        this.lineChart.setLegendVisible(false);
        this.lineChart.setAnimated(false);
        this.lineChart.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.lineChart.setCreateSymbols(false);
        this.lineChart.setMinHeight(175.0);
        this.updateUncertaintyChart(this.lineChart);
        this.updateTickLabels(this.lineChart);
        TitledPane uncertaintyChartTitledPane = this.createTitledPane(this.i18n.getString("UIObservationPropertiesPane.chart.title", "Combined Uncertainties"));
        uncertaintyChartTitledPane.setContent(this.lineChart);
        return uncertaintyChartTitledPane;
    }

    private void init() {
        VBox content = new VBox();
        content.getChildren().addAll((Object[])new Node[]{this.createUncertaintiesPane(), this.createAdditionalParametersPane(), this.createCongruenceAnalysisPane(), this.createUncertaintyChartPane()});
        this.reset();
        ScrollPane scroller = new ScrollPane((Node)content);
        scroller.setPadding(new Insets(20.0, 50.0, 20.0, 50.0));
        scroller.setFitToHeight(true);
        scroller.setFitToWidth(true);
        Region spacer = new Region();
        spacer.setPrefHeight(0.0);
        VBox.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.selectionInfoLabel.setPadding(new Insets(1.0, 5.0, 2.0, 10.0));
        this.selectionInfoLabel.setFont(new Font(10.5));
        this.propertiesNode = new VBox(new Node[]{scroller, spacer, this.selectionInfoLabel});
        FadeTransition fadeIn = new FadeTransition(Duration.millis((double)150.0));
        FadeTransition fadeOut = new FadeTransition(Duration.millis((double)150.0));
        fadeIn.setFromValue(0.0);
        fadeIn.setToValue(1.0);
        fadeIn.setCycleCount(1);
        fadeIn.setAutoReverse(false);
        fadeOut.setFromValue(1.0);
        fadeOut.setToValue(0.0);
        fadeOut.setCycleCount(1);
        fadeOut.setAutoReverse(false);
        this.sequentialTransition.getChildren().addAll((Object[])new Animation[]{fadeIn, fadeOut});
        this.sequentialTransition.setAutoReverse(false);
        this.sequentialTransition.onFinishedProperty().addListener((ChangeListener)new SequentialTransitionFinishedListener());
        this.options.addFormatterChangedListener(new TickFormatChangedListener());
    }

    private DoubleTextField createDoubleTextField(double value, CellValueType type, boolean displayUnit, DoubleTextField.ValueSupport valueSupport, String tooltipText, ParameterType userData) {
        DoubleTextField field = new DoubleTextField(value, type, displayUnit, valueSupport);
        field.setTooltip(new Tooltip(tooltipText));
        field.setMinWidth(200.0);
        field.setMaxWidth(350.0);
        field.setUserData((Object)userData);
        field.numberProperty().addListener((ChangeListener)new NumberChangeListener(field));
        field.setOnAction(new CommitTextFieldActionListener());
        return field;
    }

    private UncertaintyTextField createUncertaintyTextField(double value, CellValueType type, boolean displayUnit, DoubleTextField.ValueSupport valueSupport, String tooltipText, ObservationGroupUncertaintyType userData) {
        UncertaintyTextField field = new UncertaintyTextField(value, type, displayUnit, valueSupport);
        field.setTooltip(new Tooltip(tooltipText));
        field.setMinWidth(200.0);
        field.setMaxWidth(350.0);
        field.setUserData((Object)userData);
        field.numberProperty().addListener((ChangeListener)new NumberChangeListener(field));
        field.setOnAction(new CommitTextFieldActionListener());
        return field;
    }

    private CheckBox createCheckBox(String title, String tooltipText, boolean selected, ParameterType userData) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltipText));
        checkBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        checkBox.setSelected(selected);
        checkBox.setUserData((Object)userData);
        checkBox.selectedProperty().addListener((ChangeListener)new BooleanChangeListener((ButtonBase)checkBox));
        return checkBox;
    }

    private RadioButton createRadioButton(String title, String tooltipText, ToggleGroup group, boolean selected, Epoch userData) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        RadioButton radioButton = new RadioButton();
        radioButton.setGraphic((Node)label);
        radioButton.setTooltip(new Tooltip(tooltipText));
        radioButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        radioButton.setToggleGroup(group);
        radioButton.setSelected(selected);
        radioButton.setUserData((Object)userData);
        radioButton.selectedProperty().addListener((ChangeListener)new BooleanChangeListener((ButtonBase)radioButton));
        return radioButton;
    }

    private ProgressIndicator createDatabaseTransactionProgressIndicator(Object userData) {
        ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
        progressIndicator.setVisible(false);
        progressIndicator.setMinSize(17.0, 17.0);
        progressIndicator.setMaxSize(17.0, 17.0);
        progressIndicator.setUserData(userData);
        this.databaseTransactionProgressIndicators.put(userData, progressIndicator);
        return progressIndicator;
    }

    private Node createWarningIcon(Object userData, String text, String tooltip) {
        Label label = new Label();
        Label txtNode = new Label(text);
        txtNode.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        txtNode.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        txtNode.setTextFill((Paint)Color.DARKORANGE);
        txtNode.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        label.setGraphic((Node)txtNode);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setTooltip(new Tooltip(tooltip));
        label.setUserData(userData);
        label.setVisible(false);
        label.setManaged(false);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.warningIconNodes.put(userData, (Node)label);
        return label;
    }

    private GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        gridPane.setPadding(new Insets(20.0, 10.0, 20.0, 10.0));
        return gridPane;
    }

    private TitledPane createTitledPane(String title) {
        TitledPane parametersTitledPane = new TitledPane();
        parametersTitledPane.setMaxWidth(Double.MAX_VALUE);
        parametersTitledPane.setCollapsible(false);
        parametersTitledPane.setAnimated(false);
        parametersTitledPane.setText(title);
        parametersTitledPane.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        return parametersTitledPane;
    }

    private void setProgressIndicatorsVisible(boolean visible) {
        if (this.databaseTransactionProgressIndicators != null) {
            for (ProgressIndicator progressIndicator : this.databaseTransactionProgressIndicators.values()) {
                progressIndicator.setVisible(visible);
            }
        }
    }

    private void setWarningIconsVisible(boolean visible) {
        if (this.warningIconNodes != null) {
            for (Node warningIconNode : this.warningIconNodes.values()) {
                warningIconNode.setVisible(visible);
                warningIconNode.setManaged(visible);
            }
        }
    }

    private void save(ObservationGroupUncertaintyType uncertaintyType) {
        try {
            Double value = null;
            switch (uncertaintyType) {
                case ZERO_POINT_OFFSET: {
                    value = this.zeroPointOffsetUncertaintyField.getNumber();
                    break;
                }
                case DISTANCE_DEPENDENT: {
                    value = this.distanceDependentUncertaintyField.getNumber();
                    break;
                }
                case SQUARE_ROOT_DISTANCE_DEPENDENT: {
                    value = this.squareRootDistanceDependentUncertaintyField.getNumber();
                    break;
                }
                default: {
                    System.err.println(this.getClass().getSimpleName() + " : Error, unsupported uncertainty type " + String.valueOf((Object)uncertaintyType));
                }
            }
            if (value != null && value >= 0.0 && this.selectedObservationItemValues != null && this.selectedObservationItemValues.length > 0) {
                this.setProgressIndicatorsVisible(false);
                if (this.warningIconNodes.containsKey((Object)uncertaintyType)) {
                    Node warningIconNodes = this.warningIconNodes.get((Object)uncertaintyType);
                    warningIconNodes.setVisible(false);
                    warningIconNodes.setManaged(false);
                }
                if (this.databaseTransactionProgressIndicators.containsKey((Object)uncertaintyType)) {
                    ProgressIndicator progressIndicator = this.databaseTransactionProgressIndicators.get((Object)uncertaintyType);
                    progressIndicator.setVisible(true);
                    this.sequentialTransition.stop();
                    this.sequentialTransition.setNode((Node)progressIndicator);
                    this.sequentialTransition.playFromStart();
                }
                SQLManager.getInstance().saveUncertainty(uncertaintyType, (double)value, this.selectedObservationItemValues);
                this.updateUncertaintyChart(this.lineChart);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setProgressIndicatorsVisible(false);
            this.sequentialTransition.stop();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(UIObservationPropertiesPane.this.i18n.getString("UIObservationPropertiesPane.message.error.save.uncertainty.exception.title", "Unexpected SQL-Error"), UIObservationPropertiesPane.this.i18n.getString("UIObservationPropertiesPane.message.error.save.uncertainty.exception.header", "Error, could not save group uncertainties to database."), UIObservationPropertiesPane.this.i18n.getString("UIObservationPropertiesPane.message.error.save.uncertainty.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void save(ParameterType parameterType, ParameterModificationType modificationType) {
        try {
            boolean enable = false;
            Double value = null;
            switch (parameterType) {
                case ORIENTATION: {
                    enable = this.orientationOffsetCheckBox.isSelected();
                    value = this.orientationOffsetField.getNumber();
                    break;
                }
                case REFRACTION_INDEX: {
                    enable = this.refractionIndexCheckBox.isSelected();
                    value = this.refractionIndexField.getNumber();
                    break;
                }
                case ROTATION_X: {
                    enable = this.rotationXCheckBox.isSelected();
                    value = this.rotationXField.getNumber();
                    break;
                }
                case ROTATION_Y: {
                    enable = this.rotationYCheckBox.isSelected();
                    value = this.rotationYField.getNumber();
                    break;
                }
                case ROTATION_Z: {
                    enable = this.rotationZCheckBox.isSelected();
                    value = this.rotationZField.getNumber();
                    break;
                }
                case SCALE: {
                    enable = this.scaleCheckBox.isSelected();
                    value = this.scaleField.getNumber();
                    break;
                }
                case ZERO_POINT_OFFSET: {
                    enable = this.zeroPointOffsetCheckBox.isSelected();
                    value = this.zeroPointOffsetField.getNumber();
                    break;
                }
                default: {
                    System.err.println(this.getClass().getSimpleName() + " : Error, unsupported parameter type " + String.valueOf((Object)parameterType));
                }
            }
            if (value != null && this.selectedObservationItemValues != null && this.selectedObservationItemValues.length > 0) {
                this.setProgressIndicatorsVisible(false);
                if (this.warningIconNodes.containsKey((Object)parameterType)) {
                    Node warningIconNodes = this.warningIconNodes.get((Object)parameterType);
                    warningIconNodes.setVisible(false);
                    warningIconNodes.setManaged(false);
                }
                if (this.databaseTransactionProgressIndicators.containsKey((Object)parameterType)) {
                    ProgressIndicator node = this.databaseTransactionProgressIndicators.get((Object)parameterType);
                    node.setVisible(true);
                    this.sequentialTransition.stop();
                    this.sequentialTransition.setNode((Node)node);
                    this.sequentialTransition.playFromStart();
                }
                SQLManager.getInstance().saveAdditionalParameter(parameterType, enable, value, modificationType, this.selectedObservationItemValues);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setProgressIndicatorsVisible(false);
            this.sequentialTransition.stop();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(UIObservationPropertiesPane.this.i18n.getString("UIObservationPropertiesPane.message.error.save.parameter.exception.title", "Unexpected SQL-Error"), UIObservationPropertiesPane.this.i18n.getString("UIObservationPropertiesPane.message.error.save.parameter.exception.header", "Error, could not save properties of additional group parameters to database."), UIObservationPropertiesPane.this.i18n.getString("UIObservationPropertiesPane.message.error.save.parameter.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void save() {
        try {
            if (this.selectedObservationItemValues != null && this.selectedObservationItemValues.length > 0) {
                this.setProgressIndicatorsVisible(false);
                if (this.databaseTransactionProgressIndicators.containsKey(this.referenceEpochRadioButton.isSelected() ? this.referenceEpochRadioButton.getUserData() : this.controlEpochRadioButton.getUserData())) {
                    ProgressIndicator node = this.databaseTransactionProgressIndicators.get(this.referenceEpochRadioButton.isSelected() ? this.referenceEpochRadioButton.getUserData() : this.controlEpochRadioButton.getUserData());
                    node.setVisible(true);
                    this.sequentialTransition.stop();
                    this.sequentialTransition.setNode((Node)node);
                    this.sequentialTransition.playFromStart();
                }
                SQLManager.getInstance().saveEpoch(this.referenceEpochRadioButton.isSelected(), this.selectedObservationItemValues);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setProgressIndicatorsVisible(false);
            this.setReferenceEpoch(!this.referenceEpochRadioButton.isSelected());
            this.sequentialTransition.stop();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(UIObservationPropertiesPane.this.i18n.getString("UIObservationPropertiesPane.message.error.save.epoch.exception.title", "Unexpected SQL-Error"), UIObservationPropertiesPane.this.i18n.getString("UIObservationPropertiesPane.message.error.save.epoch.exception.header", "Error, could not save observation epoch properties to database."), UIObservationPropertiesPane.this.i18n.getString("UIObservationPropertiesPane.message.error.save.epoch.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void updateTickLabels(LineChart<Number, Number> lineChart) {
        CellValueType cellValueType;
        NumberAxis xAxis = (NumberAxis)lineChart.getXAxis();
        NumberAxis yAxis = (NumberAxis)lineChart.getYAxis();
        switch (this.type) {
            case DIRECTION_LEAF: 
            case ZENITH_ANGLE_LEAF: {
                cellValueType = CellValueType.ANGLE_UNCERTAINTY;
                yAxis.setLabel(String.format(Locale.ENGLISH, "%s %s", this.i18n.getString("UIObservationPropertiesPane.chart.axis.y.label", "\u03c30"), this.options.getFormatterOptions().get((Object)CellValueType.ANGLE_UNCERTAINTY).getUnit().toFormattedAbbreviation()).trim());
                break;
            }
            default: {
                cellValueType = CellValueType.LENGTH_UNCERTAINTY;
                yAxis.setLabel(String.format(Locale.ENGLISH, "%s %s", this.i18n.getString("UIObservationPropertiesPane.chart.axis.y.label", "\u03c30"), this.options.getFormatterOptions().get((Object)CellValueType.LENGTH_UNCERTAINTY).getUnit().toFormattedAbbreviation()).trim());
            }
        }
        yAxis.setTickLabelFormatter((StringConverter)new StringConverter<Number>(){

            public String toString(Number number) {
                return UIObservationPropertiesPane.this.options.toViewFormat(cellValueType, number.doubleValue(), false);
            }

            public Number fromString(String string) {
                return null;
            }
        });
        xAxis.setTickLabelFormatter((StringConverter)new StringConverter<Number>(){

            public String toString(Number number) {
                return number.doubleValue() > 150.0 ? "" : String.format(Locale.ENGLISH, "%.0f", number.doubleValue());
            }

            public Number fromString(String string) {
                return null;
            }
        });
        xAxis.setLabel(String.format(Locale.ENGLISH, "%s %s", this.i18n.getString("UIObservationPropertiesPane.chart.axis.x.label", "d0"), this.options.getFormatterOptions().get((Object)CellValueType.LENGTH).getUnit().toFormattedAbbreviation()).trim());
    }

    private void updateUncertaintyChart(LineChart<Number, Number> lineChart) {
        XYChart.Series uncertaintyChartSeries = new XYChart.Series();
        double uncertaintyA = this.zeroPointOffsetUncertaintyField.getNumber();
        double uncertaintyB = this.squareRootDistanceDependentUncertaintyField.getNumber();
        double uncertaintyC = this.distanceDependentUncertaintyField.getNumber();
        ObservationGroup group = null;
        switch (this.type) {
            case LEVELING_LEAF: {
                group = new DeltaZGroup(-1, uncertaintyA, uncertaintyB, uncertaintyC, Epoch.REFERENCE);
                break;
            }
            case DIRECTION_LEAF: {
                group = new DirectionGroup(-1, uncertaintyA, uncertaintyB, uncertaintyC, Epoch.REFERENCE);
                break;
            }
            case HORIZONTAL_DISTANCE_LEAF: {
                group = new HorizontalDistanceGroup(-1, uncertaintyA, uncertaintyB, uncertaintyC, Epoch.REFERENCE);
                break;
            }
            case SLOPE_DISTANCE_LEAF: {
                group = new SlopeDistanceGroup(-1, uncertaintyA, uncertaintyB, uncertaintyC, Epoch.REFERENCE);
                break;
            }
            case ZENITH_ANGLE_LEAF: {
                group = new ZenithAngleGroup(-1, uncertaintyA, uncertaintyB, uncertaintyC, Epoch.REFERENCE);
                break;
            }
            case GNSS_1D_LEAF: {
                group = new GNSSBaseline1DGroup(-1, uncertaintyA, uncertaintyB, uncertaintyC, Epoch.REFERENCE);
                break;
            }
            case GNSS_2D_LEAF: {
                group = new GNSSBaseline2DGroup(-1, uncertaintyA, uncertaintyB, uncertaintyC, Epoch.REFERENCE);
                break;
            }
            case GNSS_3D_LEAF: {
                group = new GNSSBaseline3DGroup(-1, uncertaintyA, uncertaintyB, uncertaintyC, Epoch.REFERENCE);
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " Error, unsupported obsewrvation group type " + String.valueOf((Object)this.type));
            }
        }
        if (group == null) {
            return;
        }
        double distanceInViewUnit = 5.0;
        while (distanceInViewUnit <= 150.0) {
            double distanceInModelUnit = this.options.convertLengthToModel(distanceInViewUnit);
            Observation observation = this.createObservation(this.type, distanceInModelUnit);
            if (observation == null) break;
            double uncertaintyInModelUnit = group.getStd(observation);
            double uncertaintyInViewUnit = 0.0;
            switch (this.type) {
                case DIRECTION_LEAF: 
                case ZENITH_ANGLE_LEAF: {
                    uncertaintyInViewUnit = this.options.convertAngleUncertaintyToView(uncertaintyInModelUnit);
                    break;
                }
                default: {
                    uncertaintyInViewUnit = this.options.convertLengthUncertaintyToView(uncertaintyInModelUnit);
                }
            }
            uncertaintyChartSeries.getData().add((Object)new XYChart.Data((Object)distanceInViewUnit, (Object)uncertaintyInViewUnit));
            distanceInViewUnit += 0.25;
        }
        this.lineChart.getData().clear();
        this.lineChart.getData().add((Object)uncertaintyChartSeries);
        Node line = uncertaintyChartSeries.getNode().lookup(".chart-series-line");
        line.setStyle("-fx-stroke: rgba(200, 0, 0, 1); -fx-stroke-width: 2.5px;");
    }

    private Observation createObservation(TreeItemType type, double distance) {
        Point3D startPoint = new Point3D("0", 0.0, 0.0, 0.0);
        Point3D endPoint = new Point3D("1", distance, 0.0, 0.0);
        Observation observation = null;
        switch (this.type) {
            case LEVELING_LEAF: {
                observation = new DeltaZ(-1, startPoint, endPoint, 0.0, 0.0, 0.0, -1.0, distance);
                break;
            }
            case DIRECTION_LEAF: {
                observation = new Direction(-1, startPoint, endPoint, 0.0, 0.0, 0.0, -1.0, distance);
                break;
            }
            case HORIZONTAL_DISTANCE_LEAF: {
                observation = new HorizontalDistance(-1, startPoint, endPoint, 0.0, 0.0, 0.0, -1.0, distance);
                break;
            }
            case SLOPE_DISTANCE_LEAF: {
                observation = new SlopeDistance(-1, startPoint, endPoint, 0.0, 0.0, 0.0, -1.0, distance);
                break;
            }
            case ZENITH_ANGLE_LEAF: {
                observation = new ZenithAngle(-1, startPoint, endPoint, 0.0, 0.0, 0.0, -1.0, distance);
                break;
            }
            case GNSS_1D_LEAF: {
                observation = new GNSSBaselineDeltaZ1D(-1, startPoint, endPoint, distance, -1.0);
                break;
            }
            case GNSS_2D_LEAF: {
                observation = new GNSSBaselineDeltaX2D(-1, startPoint, endPoint, distance, -1.0);
                break;
            }
            case GNSS_3D_LEAF: {
                observation = new GNSSBaselineDeltaX3D(-1, startPoint, endPoint, distance, -1.0);
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " Error, unsupported obsewrvation group type " + String.valueOf((Object)type));
            }
        }
        return observation;
    }

    private class BooleanChangeListener
    implements ChangeListener<Boolean> {
        private final ButtonBase button;

        private BooleanChangeListener(ButtonBase button) {
            this.button = button;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (!UIObservationPropertiesPane.this.ignoreValueUpdate && this.button.getUserData() != null) {
                if (this.button == UIObservationPropertiesPane.this.referenceEpochRadioButton) {
                    UIObservationPropertiesPane.this.save();
                } else if (this.button.getUserData() instanceof ParameterType) {
                    ParameterType paramType = (ParameterType)((Object)this.button.getUserData());
                    UIObservationPropertiesPane.this.save(paramType, ParameterModificationType.ENABLE);
                }
            }
        }
    }

    private class CommitTextFieldActionListener
    implements EventHandler<ActionEvent> {
        private CommitTextFieldActionListener() {
        }

        public void handle(ActionEvent event) {
            if (!UIObservationPropertiesPane.this.ignoreValueUpdate && event.getSource() != null && event.getSource() instanceof DoubleTextField && ((DoubleTextField)event.getSource()).getUserData() != null) {
                DoubleTextField field = (DoubleTextField)event.getSource();
                if (field.getUserData() instanceof ParameterType) {
                    ParameterType paramType = (ParameterType)((Object)field.getUserData());
                    UIObservationPropertiesPane.this.save(paramType, ParameterModificationType.VALUE);
                } else if (field.getUserData() instanceof ObservationGroupUncertaintyType) {
                    ObservationGroupUncertaintyType uncertaintyType = (ObservationGroupUncertaintyType)((Object)field.getUserData());
                    UIObservationPropertiesPane.this.save(uncertaintyType);
                }
            }
        }
    }

    private class NumberChangeListener
    implements ChangeListener<Double> {
        private final DoubleTextField field;

        private NumberChangeListener(DoubleTextField field) {
            this.field = field;
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (!UIObservationPropertiesPane.this.ignoreValueUpdate && this.field.getUserData() != null) {
                if (this.field.getUserData() instanceof ParameterType) {
                    ParameterType paramType = (ParameterType)((Object)this.field.getUserData());
                    UIObservationPropertiesPane.this.save(paramType, ParameterModificationType.VALUE);
                } else if (this.field.getUserData() instanceof ObservationGroupUncertaintyType) {
                    ObservationGroupUncertaintyType uncertaintyType = (ObservationGroupUncertaintyType)((Object)this.field.getUserData());
                    UIObservationPropertiesPane.this.save(uncertaintyType);
                }
            }
        }
    }

    private class SequentialTransitionFinishedListener
    implements ChangeListener<EventHandler<ActionEvent>> {
        private SequentialTransitionFinishedListener() {
        }

        public void changed(ObservableValue<? extends EventHandler<ActionEvent>> observable, EventHandler<ActionEvent> oldValue, EventHandler<ActionEvent> newValue) {
            UIObservationPropertiesPane.this.setProgressIndicatorsVisible(false);
            if (UIObservationPropertiesPane.this.sequentialTransition != null) {
                UIObservationPropertiesPane.this.sequentialTransition.setNode(null);
            }
        }
    }

    private class TickFormatChangedListener
    implements FormatterChangedListener {
        private TickFormatChangedListener() {
        }

        @Override
        public void formatterChanged(FormatterEvent evt) {
            UIObservationPropertiesPane.this.updateUncertaintyChart(UIObservationPropertiesPane.this.lineChart);
            UIObservationPropertiesPane.this.updateTickLabels(UIObservationPropertiesPane.this.lineChart);
        }
    }
}

