/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.metadata;

import java.time.LocalDate;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateChangeListener;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateEvent;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.metadata.MetaData;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.textfield.LimitedTextArea;
import org.applied_geodesy.ui.textfield.LimitedTextField;

public class UIMetaDataPaneBuilder {
    private I18N i18n = I18N.getInstance();
    private static UIMetaDataPaneBuilder metaDataPane = new UIMetaDataPaneBuilder();
    private Node metaDataNode = null;
    private DatePicker datePicker;
    private LimitedTextField nameLimitedTextField;
    private LimitedTextField operatorLimitedTextField;
    private LimitedTextField customerIdLimitedTextField;
    private LimitedTextField projectIdLimitedTextField;
    private LimitedTextArea descriptionTextArea;
    private final MetaData metaData = new MetaData();

    private UIMetaDataPaneBuilder() {
    }

    public static UIMetaDataPaneBuilder getInstance() {
        metaDataPane.init();
        return metaDataPane;
    }

    public Node getNode() {
        return this.metaDataNode;
    }

    private void init() {
        if (this.metaDataNode != null) {
            return;
        }
        SQLManager.getInstance().addProjectDatabaseStateChangeListener(new DatabaseStateChangeListener());
        GridPane gridPane = this.createGridPane();
        Label nameLabel = new Label(this.i18n.getString("UIMetaDataPane.name.label", "Project name:"));
        this.nameLimitedTextField = this.createLimitedTextField(this.i18n.getString("UIMetaDataPane.name.tooltip", "Name of current project"), this.i18n.getString("UIMetaDataPane.name.prompt", "Name of project"));
        nameLabel.setLabelFor((Node)this.nameLimitedTextField);
        nameLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label operatorLabel = new Label(this.i18n.getString("UIMetaDataPane.operator.label", "Person in charge:"));
        this.operatorLimitedTextField = this.createLimitedTextField(this.i18n.getString("UIMetaDataPane.operator.tooltip", "Name of person in charge"), this.i18n.getString("UIMetaDataPane.operator.prompt", "Operator"));
        operatorLabel.setLabelFor((Node)this.operatorLimitedTextField);
        operatorLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label dateLabel = new Label(this.i18n.getString("UIMetaDataPane.date.label", "Processing date:"));
        this.datePicker = this.createDatePicker(this.i18n.getString("UIMetaDataPane.date.tooltip", "Date of project processing"), this.i18n.getString("UIMetaDataPane.date.prompt", "Processing date"));
        dateLabel.setLabelFor((Node)this.datePicker);
        dateLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label customerIdLabel = new Label(this.i18n.getString("UIMetaDataPane.customer.label", "Customer Id:"));
        this.customerIdLimitedTextField = this.createLimitedTextField(this.i18n.getString("UIMetaDataPane.customer.tooltip", "Id of customer"), this.i18n.getString("UIMetaDataPane.customer.prompt", "Customer"));
        customerIdLabel.setLabelFor((Node)this.customerIdLimitedTextField);
        customerIdLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label projectIdLabel = new Label(this.i18n.getString("UIMetaDataPane.project.label", "Project Id:"));
        this.projectIdLimitedTextField = this.createLimitedTextField(this.i18n.getString("UIMetaDataPane.project.tooltip", "Id of project"), this.i18n.getString("UIMetaDataPane.project.prompt", "Project"));
        projectIdLabel.setLabelFor((Node)this.projectIdLimitedTextField);
        projectIdLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label descriptionLabel = new Label(this.i18n.getString("UIMetaDataPane.description.label", "Project description:"));
        this.descriptionTextArea = this.createLimitedTextArea(this.i18n.getString("UIMetaDataPane.description.tooltip", "Project description and comments"), this.i18n.getString("UIMetaDataPane.description.prompt", "Project description and comments"));
        descriptionLabel.setLabelFor((Node)this.descriptionTextArea);
        descriptionLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        GridPane.setHgrow((Node)nameLabel, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)dateLabel, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)operatorLabel, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)customerIdLabel, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)projectIdLabel, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)descriptionLabel, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)this.nameLimitedTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.datePicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.operatorLimitedTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.customerIdLimitedTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.projectIdLimitedTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.descriptionTextArea, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.descriptionTextArea, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)nameLabel, 0, ++row, 2, 1);
        gridPane.add((Node)this.nameLimitedTextField, 0, ++row, 2, 1);
        gridPane.add((Node)new Region(), 0, ++row, 2, 1);
        gridPane.add((Node)operatorLabel, 0, ++row);
        gridPane.add((Node)dateLabel, 1, row);
        gridPane.add((Node)this.operatorLimitedTextField, 0, ++row);
        gridPane.add((Node)this.datePicker, 1, row);
        gridPane.add((Node)new Region(), 0, ++row, 2, 1);
        gridPane.add((Node)customerIdLabel, 0, ++row);
        gridPane.add((Node)projectIdLabel, 1, row);
        gridPane.add((Node)this.customerIdLimitedTextField, 0, ++row);
        gridPane.add((Node)this.projectIdLimitedTextField, 1, row);
        gridPane.add((Node)new Region(), 0, ++row, 2, 1);
        gridPane.add((Node)descriptionLabel, 0, ++row, 2, 1);
        gridPane.add((Node)this.descriptionTextArea, 0, ++row, 2, 1);
        ScrollPane scroller = new ScrollPane((Node)gridPane);
        scroller.setPadding(new Insets(20.0, 30.0, 20.0, 30.0));
        scroller.setFitToHeight(true);
        scroller.setFitToWidth(true);
        this.nameLimitedTextField.textProperty().bindBidirectional((Property)this.metaData.nameProperty());
        this.datePicker.valueProperty().bindBidirectional(this.metaData.dateProperty());
        this.operatorLimitedTextField.textProperty().bindBidirectional((Property)this.metaData.operatorProperty());
        this.customerIdLimitedTextField.textProperty().bindBidirectional((Property)this.metaData.customerIdProperty());
        this.projectIdLimitedTextField.textProperty().bindBidirectional((Property)this.metaData.projectIdProperty());
        this.descriptionTextArea.textProperty().bindBidirectional((Property)this.metaData.descriptionProperty());
        this.metaDataNode = scroller;
        this.disableComponents(true);
        this.clearComponents();
    }

    private LimitedTextField createLimitedTextField(String tooltip, String promptText) {
        MetaDataChangeListener listener = new MetaDataChangeListener();
        LimitedTextField textField = new LimitedTextField(255);
        textField.setPromptText(promptText);
        textField.setTooltip(new Tooltip(tooltip));
        textField.setMaxWidth(Double.MAX_VALUE);
        textField.setMinWidth(150.0);
        textField.setOnAction(listener);
        textField.focusedProperty().addListener((ChangeListener)listener);
        return textField;
    }

    private DatePicker createDatePicker(String tooltip, String promptText) {
        MetaDataChangeListener listener = new MetaDataChangeListener();
        final DatePicker datePicker = new DatePicker();
        datePicker.setPromptText(promptText);
        datePicker.setTooltip(new Tooltip(tooltip));
        datePicker.setMaxWidth(Double.MAX_VALUE);
        datePicker.setMinWidth(150.0);
        datePicker.setOnAction((EventHandler)listener);
        datePicker.focusedProperty().addListener((ChangeListener)listener);
        datePicker.setEditable(true);
        datePicker.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                    datePicker.setValue((Object)LocalDate.now());
                }
            }
        });
        return datePicker;
    }

    private LimitedTextArea createLimitedTextArea(String tooltip, String promptText) {
        MetaDataChangeListener listener = new MetaDataChangeListener();
        LimitedTextArea textArea = new LimitedTextArea(10000);
        textArea.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        textArea.setPromptText(promptText);
        textArea.setTooltip(new Tooltip(tooltip));
        textArea.focusedProperty().addListener((ChangeListener)listener);
        return textArea;
    }

    private GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(20.0);
        gridPane.setVgap(10.0);
        gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        return gridPane;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    private void disableComponents(boolean disable) {
        this.nameLimitedTextField.setDisable(disable);
        this.datePicker.setDisable(disable);
        this.operatorLimitedTextField.setDisable(disable);
        this.customerIdLimitedTextField.setDisable(disable);
        this.projectIdLimitedTextField.setDisable(disable);
        this.descriptionTextArea.setDisable(disable);
    }

    private void clearComponents() {
        this.nameLimitedTextField.setText(null);
        this.operatorLimitedTextField.setText(null);
        this.customerIdLimitedTextField.setText(null);
        this.projectIdLimitedTextField.setText(null);
        this.descriptionTextArea.setText(null);
    }

    private boolean isFilled() {
        return this.nameLimitedTextField.getText() != null && this.operatorLimitedTextField.getText() != null && this.customerIdLimitedTextField.getText() != null && this.projectIdLimitedTextField.getText() != null && this.descriptionTextArea.getText() != null;
    }

    private void save() {
        try {
            if (this.isFilled()) {
                SQLManager.getInstance().save(this.metaData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(UIMetaDataPaneBuilder.this.i18n.getString("UIMetaDataPane.message.error.save.exception.title", "Unexpected SQL-Error"), UIMetaDataPaneBuilder.this.i18n.getString("UIMetaDataPane.message.error.save.exception.header", "Error, could not save project meta-data to database."), UIMetaDataPaneBuilder.this.i18n.getString("UIMetaDataPane.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private class DatabaseStateChangeListener
    implements ProjectDatabaseStateChangeListener {
        private DatabaseStateChangeListener() {
        }

        @Override
        public void projectDatabaseStateChanged(ProjectDatabaseStateEvent evt) {
            if (UIMetaDataPaneBuilder.this.metaDataNode != null) {
                boolean disable = evt.getEventType() != ProjectDatabaseStateType.OPENED;
                UIMetaDataPaneBuilder.this.disableComponents(disable);
                if (evt.getEventType() == ProjectDatabaseStateType.CLOSED) {
                    UIMetaDataPaneBuilder.this.clearComponents();
                }
            }
        }
    }

    private class MetaDataChangeListener
    implements ChangeListener<Boolean>,
    EventHandler<ActionEvent> {
        private MetaDataChangeListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (!newValue.booleanValue()) {
                UIMetaDataPaneBuilder.this.save();
            }
        }

        public void handle(ActionEvent event) {
            UIMetaDataPaneBuilder.this.save();
        }
    }
}

