/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.menu;

import com.derletztekick.geodesy.geotra.gui.GeoTra;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.PointType;
import org.applied_geodesy.adjustment.network.VerticalDeflectionType;
import org.applied_geodesy.coordtrans.ui.CoordTrans;
import org.applied_geodesy.jag3d.DefaultApplicationProperty;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateChangeListener;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateEvent;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.JAG3D;
import org.applied_geodesy.jag3d.ui.dialog.ColumnImportDialog;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.io.reader.BeoFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.CongruenceAnalysisFlatFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.DL100FileReader;
import org.applied_geodesy.jag3d.ui.io.reader.DimensionType;
import org.applied_geodesy.jag3d.ui.io.reader.FlatFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.GKAFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.GSIFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.M5FileReader;
import org.applied_geodesy.jag3d.ui.io.reader.ObservationFlatFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.PointFlatFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.VerticalDeflectionFlatFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.ZFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.xml.HeXMLFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.xml.JobXMLFileReader;
import org.applied_geodesy.jag3d.ui.io.sql.OADBReader;
import org.applied_geodesy.jag3d.ui.io.writer.report.FTLReport;
import org.applied_geodesy.jag3d.ui.menu.MenuEventHandler;
import org.applied_geodesy.jag3d.ui.menu.MenuItemType;
import org.applied_geodesy.jag3d.ui.menu.PathMenuItem;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.juniform.ui.JUniForm;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.io.DefaultFileChooser;
import org.applied_geodesy.util.io.SourceFileReader;
import org.applied_geodesy.util.io.properties.HTTPPropertiesLoader;
import org.applied_geodesy.util.io.properties.URLParameter;
import org.applied_geodesy.util.sql.DataBase;
import org.applied_geodesy.util.sql.HSQLDB;
import org.applied_geodesy.version.jag3d.DatabaseVersionMismatchException;
import org.applied_geodesy.version.jag3d.Version;

public class UIMenuBuilder {
    private File historyFile = new File(System.getProperty("user.home") + File.separator + ".jag3d_history");
    private Menu historyMenu;
    private HostServices hostServices;
    private static UIMenuBuilder menuBuilder = new UIMenuBuilder();
    private I18N i18n = I18N.getInstance();
    private MenuEventHandler menuEventHandler = new MenuEventHandler(this);
    private MenuBar menuBar;

    private UIMenuBuilder() {
    }

    public static UIMenuBuilder getInstance() {
        return menuBuilder;
    }

    public static void setHostServices(HostServices hostServices) {
        UIMenuBuilder.menuBuilder.hostServices = hostServices;
    }

    public MenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.init();
        }
        return this.menuBar;
    }

    private void init() {
        SQLManager.getInstance().addProjectDatabaseStateChangeListener(new DatabaseStateChangeListener());
        this.historyFile = DefaultApplicationProperty.getDefaultHistoryPath();
        this.menuBar = new MenuBar();
        Menu projectMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.project.label", "_Project"), true);
        this.createProjectMenu(projectMenu);
        Menu importMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.import.label", "_Import"), true);
        this.createImportMenu(importMenu);
        Menu propertyMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.property.label", "Propertie_s"), true);
        this.createPropertyMenu(propertyMenu);
        Menu preprocessingMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.preprocessing.label", "P_reprocessing"), true);
        this.createPreprocessingMenu(preprocessingMenu);
        Menu analysisMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.analysis.label", "_Analysis"), true);
        this.createAnalysisMenu(analysisMenu);
        Menu reportMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.report.label", "Repor_t"), true);
        this.createReportMenu(reportMenu);
        Menu moduleMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.module.label", "_Module"), true);
        this.createModuleMenu(moduleMenu);
        Menu helpMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.help.label", "_Help"), true);
        this.createHelpMenu(helpMenu);
        this.menuBar.getMenus().addAll((Object[])new Menu[]{projectMenu, importMenu, propertyMenu, preprocessingMenu, analysisMenu, reportMenu, moduleMenu, helpMenu});
    }

    private void createPreprocessingMenu(Menu parentMenu) {
        MenuItem approximationValuesItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.preprocessing.approximation.label", "Aproximation _values"), true, MenuItemType.APROXIMATE_VALUES, new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem averageItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.preprocessing.average.label", "Avera_ge observations"), true, MenuItemType.AVERAGE, new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{approximationValuesItem, averageItem});
    }

    private void createReportMenu(Menu parentMenu) {
        List<Path> templates = FTLReport.getTemplates();
        if (templates != null && !templates.isEmpty()) {
            for (Path templatePath : templates) {
                MenuItem templateFileItem = UIMenuBuilder.createMenuItem(templatePath.getFileName().toString(), false, MenuItemType.REPORT, templatePath, null, this.menuEventHandler, true);
                parentMenu.getItems().add((Object)templateFileItem);
            }
        }
    }

    private void createModuleMenu(Menu parentMenu) {
        MenuItem moduleGEOTRAItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.module.geotra.label", "Coordinate converter"), true, MenuItemType.MODULE_GEOTRA, null, this.menuEventHandler, false);
        MenuItem moduleCOORDTRANSItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.module.coordtrans.label", "Coordinate transformation"), true, MenuItemType.MODULE_COORDTRANS, null, this.menuEventHandler, false);
        MenuItem moduleJUniFormItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.module.juniform.label", "Curve and surface analysis"), true, MenuItemType.MODULE_JUNIFORM, null, this.menuEventHandler, false);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{moduleGEOTRAItem, moduleCOORDTRANSItem, moduleJUniFormItem});
    }

    private void createHelpMenu(Menu parentMenu) {
        MenuItem aboutItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.help.about.label", "_About JAG3D"), true, MenuItemType.ABOUT, new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        MenuItem updateItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.help.check_update.label", "Check for _updates\u2026"), true, MenuItemType.CHECK_UPDATES, new KeyCodeCombination(KeyCode.U, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{aboutItem, updateItem});
    }

    private void createAnalysisMenu(Menu parentMenu) {
        MenuItem congruentPointItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.analysis.congruentpoint.label", "Congr_uent points"), true, MenuItemType.CONGRUENT_POINT, new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem rowHighlightItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.analysis.highlight.label", "Ro_w highlighting"), true, MenuItemType.HIGHLIGHT_TABLE_ROWS, new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem analysisChartsItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.analysis.chart.label", "Analysis charts"), true, MenuItemType.ANALYSIS_CHARTS, new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{congruentPointItem, rowHighlightItem, analysisChartsItem});
    }

    private void createPropertyMenu(Menu parentMenu) {
        MenuItem formatterItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.property.formatter.label", "Formatter preferences"), true, MenuItemType.FORMATTER_PREFERENCES, new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), this.menuEventHandler, true);
        MenuItem importItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.property.import.label", "Import preferences"), true, MenuItemType.IMPORT_PREFERENCES, new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.ALT_DOWN}), this.menuEventHandler, true);
        MenuItem exportItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.property.export.label", "Export preferences"), true, MenuItemType.EXPORT_PREFERENCES, new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.ALT_DOWN}), this.menuEventHandler, true);
        MenuItem leastSquaresItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.property.leastsquares.label", "Least-squares"), true, MenuItemType.LEAST_SQUARES, new KeyCodeCombination(KeyCode.Q, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem teststatisticItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.property.teststatistic.label", "Test statistic"), true, MenuItemType.TEST_STATISTIC, new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem projectionItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.property.projection.label", "Projection & reductions"), true, MenuItemType.PROJECTION_AND_REDUCTION, new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem rankDefectItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.property.rankdefect.label", "Rank defect"), true, MenuItemType.RANK_DEFECT, new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{leastSquaresItem, teststatisticItem, rankDefectItem, projectionItem, new SeparatorMenuItem(), importItem, exportItem, new SeparatorMenuItem(), formatterItem});
    }

    private void createProjectMenu(Menu parentMenu) {
        MenuItem newItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.project.new.label", "Create _new project"), true, MenuItemType.NEW, new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        MenuItem openItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.project.open.label", "_Open existing project"), true, MenuItemType.OPEN, new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        MenuItem migrateItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.project.migrate.label", "Migrate exi_sting project"), true, MenuItemType.MIGRATE, new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.ALT_DOWN}), this.menuEventHandler, true);
        MenuItem copyItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.project.copy.label", "_Copy current project and open"), true, MenuItemType.COPY, new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.ALT_DOWN}), this.menuEventHandler, true);
        MenuItem sqlItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.project.sql.label", "Execute S_QL script"), true, MenuItemType.SQL_SCRIPT, new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.ALT_DOWN}), this.menuEventHandler, true);
        MenuItem closeItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.project.close.label", "C_lose current project"), true, MenuItemType.CLOSE, new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem exitItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.project.exit.label", "_Exit"), true, MenuItemType.EXIT, new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        Menu historyMenu = this.createHistoryMenu();
        parentMenu.getItems().addAll((Object[])new MenuItem[]{newItem, openItem, migrateItem, closeItem, copyItem, sqlItem, new SeparatorMenuItem(), historyMenu, new SeparatorMenuItem(), exitItem});
    }

    private void writeProjectHistory() {
        if (this.historyFile == null) {
            return;
        }
        ObservableList items = this.historyMenu.getItems();
        if (items.isEmpty()) {
            return;
        }
        try (PrintWriter pw = null;){
            try {
                pw = new PrintWriter(new BufferedWriter(new FileWriter(this.historyFile)));
                int i = 0;
                while (i < items.size()) {
                    if (items.get(i) instanceof PathMenuItem) {
                        PathMenuItem pathMenuItem = (PathMenuItem)((Object)items.get(i));
                        pw.printf(Locale.ENGLISH, "%s\r\n", pathMenuItem.getPath());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    private void addHistoryFile(Path path) {
        try {
            ArrayList<MenuItem> items = new ArrayList<MenuItem>((Collection<MenuItem>)this.historyMenu.getItems());
            Collections.reverse(items);
            int removeIndex = -1;
            int i = 0;
            while (i < items.size()) {
                if (items.get(i) instanceof PathMenuItem) {
                    PathMenuItem pathMenuItem = (PathMenuItem)((Object)items.get(i));
                    if (path.toAbsolutePath().normalize().equals(pathMenuItem.getPath().toAbsolutePath().normalize())) {
                        removeIndex = i;
                        break;
                    }
                }
                ++i;
            }
            if (removeIndex >= 0) {
                items.remove(removeIndex);
            }
            Object itemName = path.toAbsolutePath().normalize().toString();
            String parent = path.getParent().toString();
            if (parent.length() > 60) {
                itemName = parent.substring(0, 50) + "\u2026" + File.separator + path.getFileName().toString();
            }
            MenuItem newFileItem = UIMenuBuilder.createMenuItem((String)itemName, false, MenuItemType.RECENTLY_USED, path, null, this.menuEventHandler, false);
            items.add(newFileItem);
            while (items.size() >= 10) {
                items.remove(0);
            }
            Collections.reverse(items);
            this.historyMenu.getItems().setAll(items);
            this.historyMenu.setDisable(items.isEmpty());
            this.writeProjectHistory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Menu createHistoryMenu() {
        block12: {
            if (this.historyMenu == null) {
                this.historyMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.project.history.label", "_Recently used projects"), true);
                ObservableList newItems = this.historyMenu.getItems();
                newItems.clear();
                if (this.historyFile == null) {
                    this.historyMenu.setDisable(newItems.isEmpty());
                    return this.historyMenu;
                }
                String regex = "(?i)(.+?)(\\.)(backup$|data$|properties$|script$)";
                Scanner scanner = null;
                try {
                    try {
                        Path path = this.historyFile.toPath();
                        if (!Files.exists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) break block12;
                        scanner = new Scanner(this.historyFile);
                        while (scanner.hasNext()) {
                            String string = scanner.nextLine().trim();
                            Path projectPath = Path.of(string, new String[0]);
                            if (!string.isEmpty() && string.matches(regex) && Files.exists(projectPath, new LinkOption[0]) && Files.isRegularFile(projectPath, new LinkOption[0])) {
                                Object itemName = projectPath.toAbsolutePath().normalize().toString();
                                String parent = projectPath.getParent().toString();
                                if (parent.length() > 60) {
                                    itemName = parent.substring(0, 50) + "\u2026" + File.separator + projectPath.getFileName().toString();
                                }
                                MenuItem fileItem = UIMenuBuilder.createMenuItem((String)itemName, false, MenuItemType.RECENTLY_USED, projectPath, null, this.menuEventHandler, false);
                                newItems.add(fileItem);
                            }
                            if (newItems.size() != 10) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        newItems.clear();
                        if (scanner != null) {
                            scanner.close();
                        }
                        this.historyMenu.setDisable(newItems.isEmpty());
                    }
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                    this.historyMenu.setDisable(newItems.isEmpty());
                }
            }
        }
        return this.historyMenu;
    }

    private void createImportMenu(Menu parentMenu) {
        Menu importReferencePointFlatMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.reference.label", "Reference points"), true);
        MenuItem importReferencePoint1DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.reference.1d.label", "Reference points 1D"), true, MenuItemType.IMPORT_FLAT_REFERENCE_POINT_1D, null, this.menuEventHandler, true);
        MenuItem importReferencePoint2DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.reference.2d.label", "Reference points 2D"), true, MenuItemType.IMPORT_FLAT_REFERENCE_POINT_2D, null, this.menuEventHandler, true);
        MenuItem importReferencePoint3DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.reference.3d.label", "Reference points 3D"), true, MenuItemType.IMPORT_FLAT_REFERENCE_POINT_3D, null, this.menuEventHandler, true);
        Menu importStochasticPointFlatMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.stochastic.label", "Stochastic points"), true);
        MenuItem importStochasticPoint1DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.stochastic.1d.label", "Stochastic points 1D"), true, MenuItemType.IMPORT_FLAT_STOCHASTIC_POINT_1D, null, this.menuEventHandler, true);
        MenuItem importStochasticPoint2DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.stochastic.2d.label", "Stochastic points 2D"), true, MenuItemType.IMPORT_FLAT_STOCHASTIC_POINT_2D, null, this.menuEventHandler, true);
        MenuItem importStochasticPoint3DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.stochastic.3d.label", "Stochastic points 3D"), true, MenuItemType.IMPORT_FLAT_STOCHASTIC_POINT_3D, null, this.menuEventHandler, true);
        Menu importDatumPointFlatMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.datum.label", "Datum points"), true);
        MenuItem importDatumPoint1DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.datum.1d.label", "Datum points 1D"), true, MenuItemType.IMPORT_FLAT_DATUM_POINT_1D, null, this.menuEventHandler, true);
        MenuItem importDatumPoint2DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.datum.2d.label", "Datum points 2D"), true, MenuItemType.IMPORT_FLAT_DATUM_POINT_2D, null, this.menuEventHandler, true);
        MenuItem importDatumPoint3DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.datum.3d.label", "Datum points 3D"), true, MenuItemType.IMPORT_FLAT_DATUM_POINT_3D, null, this.menuEventHandler, true);
        Menu importNewPointFlatMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.new.label", "New points"), true);
        MenuItem importNewPoint1DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.new.1d.label", "New points 1D"), true, MenuItemType.IMPORT_FLAT_NEW_POINT_1D, null, this.menuEventHandler, true);
        MenuItem importNewPoint2DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.new.2d.label", "New points 2D"), true, MenuItemType.IMPORT_FLAT_NEW_POINT_2D, null, this.menuEventHandler, true);
        MenuItem importNewPoint3DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.point.new.3d.label", "New points 3D"), true, MenuItemType.IMPORT_FLAT_NEW_POINT_3D, null, this.menuEventHandler, true);
        Menu importVerticalDeflectionFlatMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.import.flat.deflection.label", "Vertical deflection"), true);
        MenuItem importReferenceDeflectionFlatMenu = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.deflection.reference.label", "Reference deflection"), true, MenuItemType.IMPORT_FLAT_REFERENCE_VERTICAL_DEFLECTION, null, this.menuEventHandler, true);
        MenuItem importStochasticDeflectionFlatMenu = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.deflection.stochastic.label", "Stochastic deflection"), true, MenuItemType.IMPORT_FLAT_STOCASTIC_VERTICAL_DEFLECTION, null, this.menuEventHandler, true);
        MenuItem importUnknownDeflectionFlatMenu = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.deflection.unknown.label", "Approximated deflection"), true, MenuItemType.IMPORT_FLAT_UNKNOWN_VERTICAL_DEFLECTION, null, this.menuEventHandler, true);
        Menu importTerrestrialFlatMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.import.flat.terrestrial.label", "Terrestrial observations"), true);
        MenuItem importLevelingFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.terrestrial.leveling.label", "Leveling data"), true, MenuItemType.IMPORT_FLAT_LEVELING, null, this.menuEventHandler, true);
        MenuItem importDirectionFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.terrestrial.direction.label", "Direction sets"), true, MenuItemType.IMPORT_FLAT_DIRECTION, null, this.menuEventHandler, true);
        MenuItem importHorizontalDistanceFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.terrestrial.horizontal_distance.label", "Horizontal distances"), true, MenuItemType.IMPORT_FLAT_HORIZONTAL_DISTANCE, null, this.menuEventHandler, true);
        MenuItem importSlopeDistanceFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.terrestrial.slope_distance.label", "Slope distances"), true, MenuItemType.IMPORT_FLAT_SLOPE_DISTANCE, null, this.menuEventHandler, true);
        MenuItem importZenithAngleFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.terrestrial.zenith_angle.label", "Zenith angles"), true, MenuItemType.IMPORT_FLAT_ZENITH_ANGLE, null, this.menuEventHandler, true);
        Menu importCongruenceAnalysisPairFlatMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.import.flat.congruence_analysis.label", "Congruence Analysis"), true);
        MenuItem importCongruenceAnalysisPair1DFlatMenu = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.congruence_analysis.1d.label", "Point nexus 1D"), true, MenuItemType.IMPORT_FLAT_CONGRUENCE_ANALYSIS_PAIR_1D, null, this.menuEventHandler, true);
        MenuItem importCongruenceAnalysisPair2DFlatMenu = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.congruence_analysis.2d.label", "Point nexus 2D"), true, MenuItemType.IMPORT_FLAT_CONGRUENCE_ANALYSIS_PAIR_2D, null, this.menuEventHandler, true);
        MenuItem importCongruenceAnalysisPair3DFlatMenu = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.congruence_analysis.3d.label", "Point nexus 3D"), true, MenuItemType.IMPORT_FLAT_CONGRUENCE_ANALYSIS_PAIR_3D, null, this.menuEventHandler, true);
        Menu importGNSSFlatMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.import.flat.gnss.label", "GNSS baselines"), true);
        MenuItem importGNSS1DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.gnss.1d.label", "GNSS baselines 1D"), true, MenuItemType.IMPORT_FLAT_GNSS1D, null, this.menuEventHandler, true);
        MenuItem importGNSS2DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.gnss.2d.label", "GNSS baselines 2D"), true, MenuItemType.IMPORT_FLAT_GNSS2D, null, this.menuEventHandler, true);
        MenuItem importGNSS3DFlatItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.flat.gnss.3d.label", "GNSS baselines 3D"), true, MenuItemType.IMPORT_FLAT_GNSS3D, null, this.menuEventHandler, true);
        Menu importHexagonFlatMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.import.hexagon.label", "Hexagon/Leica"), true);
        MenuItem gsi1DFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.hexagon.gsi.1d.label", "GSI 1D"), true, MenuItemType.IMPORT_GSI1D, null, this.menuEventHandler, true);
        MenuItem gsi2DFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.hexagon.gsi.2d.label", "GSI 2D"), true, MenuItemType.IMPORT_GSI2D, null, this.menuEventHandler, true);
        MenuItem gsi2DHFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.hexagon.gsi.2dh.label", "GSI 2D+H"), true, MenuItemType.IMPORT_GSI2DH, null, this.menuEventHandler, true);
        MenuItem gsi3DFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.hexagon.gsi.3d.label", "GSI 3D"), true, MenuItemType.IMPORT_GSI3D, null, this.menuEventHandler, true);
        MenuItem hexml2DFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.hexagon.landxml.2d.label", "LandXML 1.2 2D"), true, MenuItemType.IMPORT_LAND_XML2D, null, this.menuEventHandler, true);
        MenuItem hexml3DFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.hexagon.landxml.3d.label", "LandXML 1.2 3D"), true, MenuItemType.IMPORT_LAND_XML3D, null, this.menuEventHandler, true);
        Menu importTrimbleFlatMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.import.trimble.label", "Trimble/Zeiss"), true);
        MenuItem m5FileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.trimble.m5.label", "M5 (DiNi)"), true, MenuItemType.IMPORT_M5, null, this.menuEventHandler, true);
        MenuItem gkaFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.trimble.gka.label", "GKA"), true, MenuItemType.IMPORT_GKA, null, this.menuEventHandler, true);
        MenuItem jxml2DFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.trimble.jobxml.2d.label", "JobXML 2D"), true, MenuItemType.IMPORT_JOB_XML2D, null, this.menuEventHandler, true);
        MenuItem jxml2DHFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.trimble.jobxml.2dh.label", "JobXML 2D+H"), true, MenuItemType.IMPORT_JOB_XML2DH, null, this.menuEventHandler, true);
        MenuItem jxml3DFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.trimble.jobxml.3d.label", "JobXML 3D"), true, MenuItemType.IMPORT_JOB_XML3D, null, this.menuEventHandler, true);
        MenuItem dl100FileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.topcon.dl100.label", "DL-100 (Topcon)"), true, MenuItemType.IMPORT_DL100, null, this.menuEventHandler, true);
        MenuItem zFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.z.label", "Z-File (Caplan)"), true, MenuItemType.IMPORT_Z, null, this.menuEventHandler, true);
        MenuItem beoFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.beo.label", "Beo-File (Neptan)"), true, MenuItemType.IMPORT_BEO, null, this.menuEventHandler, true);
        MenuItem columnBasedFileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.import.column_based.label", "Column-based data"), true, MenuItemType.IMPORT_COLUMN_BASED_FILES, null, this.menuEventHandler, true);
        importHexagonFlatMenu.getItems().addAll((Object[])new MenuItem[]{gsi1DFileItem, gsi2DFileItem, gsi2DHFileItem, gsi3DFileItem, new SeparatorMenuItem(), hexml2DFileItem, hexml3DFileItem});
        importTrimbleFlatMenu.getItems().addAll((Object[])new MenuItem[]{m5FileItem, gkaFileItem, new SeparatorMenuItem(), jxml2DFileItem, jxml2DHFileItem, jxml3DFileItem});
        importTerrestrialFlatMenu.getItems().addAll((Object[])new MenuItem[]{importLevelingFlatItem, new SeparatorMenuItem(), importDirectionFlatItem, importHorizontalDistanceFlatItem, new SeparatorMenuItem(), importSlopeDistanceFlatItem, importZenithAngleFlatItem});
        importReferencePointFlatMenu.getItems().addAll((Object[])new MenuItem[]{importReferencePoint1DFlatItem, importReferencePoint2DFlatItem, importReferencePoint3DFlatItem});
        importStochasticPointFlatMenu.getItems().addAll((Object[])new MenuItem[]{importStochasticPoint1DFlatItem, importStochasticPoint2DFlatItem, importStochasticPoint3DFlatItem});
        importDatumPointFlatMenu.getItems().addAll((Object[])new MenuItem[]{importDatumPoint1DFlatItem, importDatumPoint2DFlatItem, importDatumPoint3DFlatItem});
        importNewPointFlatMenu.getItems().addAll((Object[])new MenuItem[]{importNewPoint1DFlatItem, importNewPoint2DFlatItem, importNewPoint3DFlatItem});
        importVerticalDeflectionFlatMenu.getItems().addAll((Object[])new MenuItem[]{importReferenceDeflectionFlatMenu, importStochasticDeflectionFlatMenu, importUnknownDeflectionFlatMenu});
        importCongruenceAnalysisPairFlatMenu.getItems().addAll((Object[])new MenuItem[]{importCongruenceAnalysisPair1DFlatMenu, importCongruenceAnalysisPair2DFlatMenu, importCongruenceAnalysisPair3DFlatMenu});
        importGNSSFlatMenu.getItems().addAll((Object[])new MenuItem[]{importGNSS1DFlatItem, importGNSS2DFlatItem, importGNSS3DFlatItem});
        parentMenu.getItems().addAll((Object[])new MenuItem[]{importReferencePointFlatMenu, importStochasticPointFlatMenu, importDatumPointFlatMenu, importNewPointFlatMenu, new SeparatorMenuItem(), importVerticalDeflectionFlatMenu, new SeparatorMenuItem(), importTerrestrialFlatMenu, importGNSSFlatMenu, new SeparatorMenuItem(), importCongruenceAnalysisPairFlatMenu, new SeparatorMenuItem(), importHexagonFlatMenu, importTrimbleFlatMenu, dl100FileItem, new SeparatorMenuItem(), beoFileItem, zFileItem, new SeparatorMenuItem(), columnBasedFileItem});
    }

    private static Menu createMenu(String label, boolean mnemonicParsing) {
        Menu menu = new Menu(label);
        menu.setMnemonicParsing(mnemonicParsing);
        return menu;
    }

    private static MenuItem createMenuItem(MenuItem menuItem, boolean mnemonicParsing, MenuItemType menuItemType, KeyCodeCombination keyCodeCombination, MenuEventHandler menuEventHandler, boolean disable) {
        menuItem.setMnemonicParsing(mnemonicParsing);
        if (keyCodeCombination != null) {
            menuItem.setAccelerator((KeyCombination)keyCodeCombination);
        }
        menuItem.setOnAction((EventHandler)menuEventHandler);
        menuItem.setDisable(disable);
        menuItem.setUserData((Object)menuItemType);
        return menuItem;
    }

    private static MenuItem createMenuItem(String label, boolean mnemonicParsing, MenuItemType menuItemType, KeyCodeCombination keyCodeCombination, MenuEventHandler menuEventHandler, boolean disable) {
        MenuItem menuItem = UIMenuBuilder.createMenuItem(new MenuItem(label), mnemonicParsing, menuItemType, keyCodeCombination, menuEventHandler, disable);
        return menuItem;
    }

    private static MenuItem createMenuItem(String label, boolean mnemonicParsing, MenuItemType menuItemType, Path path, KeyCodeCombination keyCodeCombination, MenuEventHandler menuEventHandler, boolean disable) {
        PathMenuItem menuItem = (PathMenuItem)UIMenuBuilder.createMenuItem(new PathMenuItem(label), mnemonicParsing, menuItemType, keyCodeCombination, menuEventHandler, disable);
        menuItem.setPath(path);
        return menuItem;
    }

    void newProject() {
        File selectedFile = DefaultFileChooser.showSaveDialog((Window)JAG3D.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.new.title", "Create new project"), "jag3d_project.script", new FileChooser.ExtensionFilter(this.i18n.getString("OADBReader.extension.script", "HyperSQL"), new String[]{"*.script"}));
        try {
            if (selectedFile != null) {
                Path path = selectedFile.toPath();
                String regex = "(?i)(.+?)(\\.)(backup$|data$|properties$|script$)";
                String project = path.toAbsolutePath().toString().replaceFirst(regex, "$1");
                if (project != null) {
                    SQLManager.createNewProject(new HSQLDB(project));
                    JAG3D.setTitle(path.getFileName() == null ? null : path.getFileName().toString().replaceFirst(regex, "$1"));
                    this.addHistoryFile(selectedFile.toPath());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.new.exception.title", "I/O Error"), this.i18n.getString("UIMenuBuilder.message.error.new.exception.header", "Error, could not create new project."), this.i18n.getString("UIMenuBuilder.message.error.new.exception.message", "An exception has occurred during project creation."), e);
            SQLManager.getInstance().closeDataBase();
        }
    }

    void copyProject() {
        try {
            String currentDataBaseName;
            if (!SQLManager.getInstance().hasDatabase()) {
                return;
            }
            String[] dataBaseFileExtensions = new String[]{"data", "properties", "script", "backup"};
            String string = currentDataBaseName = SQLManager.getInstance().getDataBase() != null && SQLManager.getInstance().getDataBase() instanceof HSQLDB ? ((HSQLDB)SQLManager.getInstance().getDataBase()).getDataBaseFileName() : null;
            if (currentDataBaseName == null) {
                return;
            }
            File selectedFile = DefaultFileChooser.showSaveDialog((Window)JAG3D.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.copy.title", "Create deep copy of current project"), null, OADBReader.getExtensionFilters());
            if (selectedFile == null) {
                return;
            }
            String regex = "(.+?)(\\.)(backup$|data$|properties$|script$)";
            String copyDataBaseName = selectedFile.getAbsolutePath().replaceAll(regex, "$1");
            if (currentDataBaseName.equals(copyDataBaseName)) {
                return;
            }
            SQLManager.getInstance().closeDataBase();
            int i = 0;
            while (i < dataBaseFileExtensions.length) {
                Path src = Paths.get(currentDataBaseName + "." + dataBaseFileExtensions[i], new String[0]);
                if (Files.exists(src, LinkOption.NOFOLLOW_LINKS)) {
                    Path trg = Paths.get(copyDataBaseName + "." + dataBaseFileExtensions[i], new String[0]);
                    Files.copy(src, trg, StandardCopyOption.REPLACE_EXISTING);
                }
                ++i;
            }
            if (Files.exists(selectedFile.toPath(), LinkOption.NOFOLLOW_LINKS) && Files.isRegularFile(selectedFile.toPath(), LinkOption.NOFOLLOW_LINKS)) {
                this.openProject(selectedFile.toPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.copy.exception.title", "I/O Error"), this.i18n.getString("UIMenuBuilder.message.error.copy.exception.header", "Error, could not create a deep copy of the current database."), this.i18n.getString("UIMenuBuilder.message.error.copy.exception.message", "An exception has occurred during project copying."), e);
        }
    }

    void openProject() {
        File selectedFile = DefaultFileChooser.showOpenDialog((Window)JAG3D.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.open.title", "Open existing project"), null, OADBReader.getExtensionFilters());
        if (selectedFile != null) {
            this.openProject(selectedFile.toPath());
        }
    }

    void openProject(Path path) {
        block6: {
            try {
                if (path == null) break block6;
                String regex = "(?i)(.+?)(\\.)(backup$|data$|properties$|script$)";
                String dataBaseName = Files.exists(path, LinkOption.NOFOLLOW_LINKS) ? path.toAbsolutePath().toString().replaceFirst(regex, "$1") : null;
                String[] dataBaseFileExtensions = new String[]{"data", "properties", "script"};
                int i = 0;
                while (i < dataBaseFileExtensions.length) {
                    Path p;
                    if (dataBaseName != null && !Files.exists(p = Paths.get(dataBaseName + "." + dataBaseFileExtensions[i], new String[0]), LinkOption.NOFOLLOW_LINKS)) {
                        dataBaseName = null;
                        throw new FileNotFoundException("Incomplete data base detected. Could not found " + p.toString() + ".");
                    }
                    ++i;
                }
                if (dataBaseName != null) {
                    SQLManager.openExistingProject(new HSQLDB(dataBaseName));
                    JAG3D.setTitle(path.getFileName() == null ? null : path.getFileName().toString().replaceFirst(regex, "$1"));
                    this.addHistoryFile(path);
                    this.historyMenu.getParentMenu().hide();
                    DefaultFileChooser.setLastSelectedDirectory(path.getFileName().toFile());
                    break block6;
                }
                throw new FileNotFoundException(path.toString());
            }
            catch (DatabaseVersionMismatchException e) {
                e.printStackTrace();
                OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.version.exception.title", "Version error"), this.i18n.getString("UIMenuBuilder.message.error.version.exception.header", "Error, database version of the stored project is greater\r\nthan accepted database version of the application."), this.i18n.getString("UIMenuBuilder.message.error.version.exception.message", "An exception has occurred during project opening."), e);
                SQLManager.getInstance().closeDataBase();
            }
            catch (Exception e) {
                e.printStackTrace();
                OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.open.exception.title", "I/O Error"), this.i18n.getString("UIMenuBuilder.message.error.open.exception.header", "Error, could not open selected project."), this.i18n.getString("UIMenuBuilder.message.error.open.exception.message", "An exception has occurred during project opening."), e);
                SQLManager.getInstance().closeDataBase();
            }
        }
    }

    public void migrateProject() {
        block7: {
            File selectedFile = DefaultFileChooser.showOpenDialog((Window)JAG3D.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.migrate.title", "Migrate existing JAG3D project"), null, OADBReader.getExtensionFilters());
            if (selectedFile == null) {
                return;
            }
            try {
                String project;
                Path path = selectedFile.toPath();
                String regex = "(?i)(.+?)(\\.)(backup$|data$|properties$|script$)";
                String string = project = Files.exists(path, LinkOption.NOFOLLOW_LINKS) ? path.toAbsolutePath().toString().replaceFirst(regex, "$1") : null;
                if (project != null) {
                    HSQLDB dataBase = new HSQLDB(project);
                    if (SQLManager.getInstance().getDataBase().getURI().equals(((DataBase)dataBase).getURI())) {
                        throw new IOException(this.getClass().getSimpleName() + " : Error, cannot re-import data to the same database!");
                    }
                    if (!OADBReader.isCurrentOADBVersion(dataBase)) {
                        throw new DatabaseVersionMismatchException(this.getClass().getSimpleName() + ": Error, database version of the stored project is unequal to the required version of the application!");
                    }
                    OADBReader fileReader = new OADBReader(dataBase);
                    TreeItem lastItem = (TreeItem)((SourceFileReader)fileReader).readAndImport();
                    if (lastItem != null) {
                        TreeView<TreeItemValue> treeView = UITreeBuilder.getInstance().getTree();
                        treeView.getSelectionModel().clearSelection();
                        treeView.getSelectionModel().select((Object)lastItem);
                        int index = treeView.getRow(lastItem);
                        treeView.scrollTo(index);
                    }
                    break block7;
                }
                throw new FileNotFoundException(selectedFile.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.migrate.exception.title", "I/O Error"), this.i18n.getString("UIMenuBuilder.message.error.migrate.exception.header", "Error, could not migrate selected project."), this.i18n.getString("UIMenuBuilder.message.error.migrate.exception.message", "An exception has occurred during project migrating."), e);
            }
        }
    }

    private void importFile(SourceFileReader<TreeItem<TreeItemValue>> fileReader, FileChooser.ExtensionFilter[] extensionFilters, String title) {
        List<File> selectedFiles = DefaultFileChooser.showOpenMultipleDialog((Window)JAG3D.getStage(), title, null, extensionFilters);
        if (selectedFiles == null || selectedFiles.isEmpty()) {
            return;
        }
        this.importFile(fileReader, selectedFiles);
    }

    private void importFile(SourceFileReader<TreeItem<TreeItemValue>> fileReader, List<File> selectedFiles) {
        if (selectedFiles == null || selectedFiles.isEmpty()) {
            return;
        }
        TreeItem<TreeItemValue> lastItem = null;
        for (File file : selectedFiles) {
            fileReader.setPath(file.toPath());
            try {
                lastItem = fileReader.readAndImport();
            }
            catch (Exception e) {
                e.printStackTrace();
                OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.import.exception.title", "I/O Error"), this.i18n.getString("UIMenuBuilder.message.error.import.exception.header", "Error, could not import selected file."), this.i18n.getString("UIMenuBuilder.message.error.import.exception.message", "An exception has occurred during file import."), e);
            }
        }
        if (lastItem != null) {
            TreeView<TreeItemValue> treeView = UITreeBuilder.getInstance().getTree();
            treeView.getSelectionModel().clearSelection();
            treeView.getSelectionModel().select(lastItem);
            int index = treeView.getRow(lastItem);
            treeView.scrollTo(index);
        }
    }

    void importFile(MenuItemType menuItemType) {
        switch (menuItemType) {
            case IMPORT_FLAT_REFERENCE_POINT_1D: {
                this.importFile(new PointFlatFileReader(PointType.REFERENCE_POINT, 1), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.reference.1d.title", "Import 1D reference point data from flat files"));
                break;
            }
            case IMPORT_FLAT_REFERENCE_POINT_2D: {
                this.importFile(new PointFlatFileReader(PointType.REFERENCE_POINT, 2), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.reference.2d.title", "Import 2D reference point data from flat files"));
                break;
            }
            case IMPORT_FLAT_REFERENCE_POINT_3D: {
                this.importFile(new PointFlatFileReader(PointType.REFERENCE_POINT, 3), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.reference.3d.title", "Import 3D reference point data from flat files"));
                break;
            }
            case IMPORT_FLAT_STOCHASTIC_POINT_1D: {
                this.importFile(new PointFlatFileReader(PointType.STOCHASTIC_POINT, 1), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.stochastic.1d.title", "Import 1D stochastic point data from flat files"));
                break;
            }
            case IMPORT_FLAT_STOCHASTIC_POINT_2D: {
                this.importFile(new PointFlatFileReader(PointType.STOCHASTIC_POINT, 2), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.stochastic.2d.title", "Import 2D stochastic point data from flat files"));
                break;
            }
            case IMPORT_FLAT_STOCHASTIC_POINT_3D: {
                this.importFile(new PointFlatFileReader(PointType.STOCHASTIC_POINT, 3), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.stochastic.3d.title", "Import 3D stochastic point data from flat files"));
                break;
            }
            case IMPORT_FLAT_DATUM_POINT_1D: {
                this.importFile(new PointFlatFileReader(PointType.DATUM_POINT, 1), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.datum.1d.title", "Import 1D datum point data from flat files"));
                break;
            }
            case IMPORT_FLAT_DATUM_POINT_2D: {
                this.importFile(new PointFlatFileReader(PointType.DATUM_POINT, 2), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.datum.2d.title", "Import 2D datum point data from flat files"));
                break;
            }
            case IMPORT_FLAT_DATUM_POINT_3D: {
                this.importFile(new PointFlatFileReader(PointType.DATUM_POINT, 3), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.datum.3d.title", "Import 3D datum point data from flat files"));
                break;
            }
            case IMPORT_FLAT_NEW_POINT_1D: {
                this.importFile(new PointFlatFileReader(PointType.NEW_POINT, 1), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.new.1d.title", "Import 1D new point data from flat files"));
                break;
            }
            case IMPORT_FLAT_NEW_POINT_2D: {
                this.importFile(new PointFlatFileReader(PointType.NEW_POINT, 2), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.new.2d.title", "Import 2D new point data from flat files"));
                break;
            }
            case IMPORT_FLAT_NEW_POINT_3D: {
                this.importFile(new PointFlatFileReader(PointType.NEW_POINT, 3), PointFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.point.new.3d.title", "Import 3D new point data from flat files"));
                break;
            }
            case IMPORT_FLAT_REFERENCE_VERTICAL_DEFLECTION: {
                this.importFile(new VerticalDeflectionFlatFileReader(VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION), VerticalDeflectionFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.deflection.reference.title", "Import reference vertical deflection data from flat files"));
                break;
            }
            case IMPORT_FLAT_STOCASTIC_VERTICAL_DEFLECTION: {
                this.importFile(new VerticalDeflectionFlatFileReader(VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION), VerticalDeflectionFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.deflection.stochastic.title", "Import stochastic vertical deflection data from flat files"));
                break;
            }
            case IMPORT_FLAT_UNKNOWN_VERTICAL_DEFLECTION: {
                this.importFile(new VerticalDeflectionFlatFileReader(VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION), VerticalDeflectionFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.deflection.unknown.title", "Import approximated vertical deflection data from flat files"));
                break;
            }
            case IMPORT_FLAT_LEVELING: {
                this.importFile(new ObservationFlatFileReader(ObservationType.LEVELING), ObservationFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.leveling.title", "Import leveling data from flat files"));
                break;
            }
            case IMPORT_FLAT_DIRECTION: {
                this.importFile(new ObservationFlatFileReader(ObservationType.DIRECTION), ObservationFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.direction.title", "Import direction sets from flat files"));
                break;
            }
            case IMPORT_FLAT_HORIZONTAL_DISTANCE: {
                this.importFile(new ObservationFlatFileReader(ObservationType.HORIZONTAL_DISTANCE), ObservationFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.horizontal_distances.title", "Import horizontal distances from flat files"));
                break;
            }
            case IMPORT_FLAT_SLOPE_DISTANCE: {
                this.importFile(new ObservationFlatFileReader(ObservationType.SLOPE_DISTANCE), ObservationFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.slope_distances.title", "Import slope distances from flat files"));
                break;
            }
            case IMPORT_FLAT_ZENITH_ANGLE: {
                this.importFile(new ObservationFlatFileReader(ObservationType.ZENITH_ANGLE), ObservationFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.zenith_angles.title", "Import zenith angles from flat files"));
                break;
            }
            case IMPORT_FLAT_GNSS1D: {
                this.importFile(new ObservationFlatFileReader(ObservationType.GNSS1D), ObservationFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.gnss.1d.title", "Import 1D gnss baselines from flat files"));
                break;
            }
            case IMPORT_FLAT_GNSS2D: {
                this.importFile(new ObservationFlatFileReader(ObservationType.GNSS2D), ObservationFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.gnss.2d.title", "Import 2D gnss baselines from flat files"));
                break;
            }
            case IMPORT_FLAT_GNSS3D: {
                this.importFile(new ObservationFlatFileReader(ObservationType.GNSS3D), ObservationFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.gnss.3d.title", "Import 3D gnss baselines from flat files"));
                break;
            }
            case IMPORT_FLAT_CONGRUENCE_ANALYSIS_PAIR_1D: {
                this.importFile(new CongruenceAnalysisFlatFileReader(1), CongruenceAnalysisFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.congruence_analysis.1d.title", "Import congruence analysis point nexus 1D from flat files"));
                break;
            }
            case IMPORT_FLAT_CONGRUENCE_ANALYSIS_PAIR_2D: {
                this.importFile(new CongruenceAnalysisFlatFileReader(2), CongruenceAnalysisFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.congruence_analysis.2d.title", "Import congruence analysis point nexus 2D from flat files"));
                break;
            }
            case IMPORT_FLAT_CONGRUENCE_ANALYSIS_PAIR_3D: {
                this.importFile(new CongruenceAnalysisFlatFileReader(3), CongruenceAnalysisFlatFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.flat.congruence_analysis.3d.title", "Import congruence analysis point nexus 3D from flat files"));
                break;
            }
            case IMPORT_BEO: {
                this.importFile(new BeoFileReader(), BeoFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.beo.title", "Import data from BEO files"));
                break;
            }
            case IMPORT_DL100: {
                this.importFile(new DL100FileReader(), DL100FileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.dl100.title", "Import data from DL-100 files"));
                break;
            }
            case IMPORT_GSI1D: {
                this.importFile(new GSIFileReader(DimensionType.HEIGHT), GSIFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.gsi.1d.title", "Import 1D data from GSI files"));
                break;
            }
            case IMPORT_GSI2D: {
                this.importFile(new GSIFileReader(DimensionType.PLAN), GSIFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.gsi.2d.title", "Import 2D data from GSI files"));
                break;
            }
            case IMPORT_GSI2DH: {
                this.importFile(new GSIFileReader(DimensionType.PLAN_AND_HEIGHT), GSIFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.gsi.2dh.title", "Import 2D+H data from GSI files"));
                break;
            }
            case IMPORT_GSI3D: {
                this.importFile(new GSIFileReader(DimensionType.SPATIAL), GSIFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.gsi.3d.title", "Import 3D data from GSI files"));
                break;
            }
            case IMPORT_JOB_XML2D: {
                this.importFile(new JobXMLFileReader(DimensionType.PLAN), JobXMLFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.jobxml.2d.title", "Import 2D data from JobXML files"));
                break;
            }
            case IMPORT_JOB_XML2DH: {
                this.importFile(new JobXMLFileReader(DimensionType.PLAN_AND_HEIGHT), JobXMLFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.jobxml.2dh.title", "Import 2D+H data from JobXML files"));
                break;
            }
            case IMPORT_JOB_XML3D: {
                this.importFile(new JobXMLFileReader(DimensionType.SPATIAL), JobXMLFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.jobxml.3d.title", "Import 3D data from JobXML files"));
                break;
            }
            case IMPORT_LAND_XML2D: {
                this.importFile(new HeXMLFileReader(DimensionType.PLAN), HeXMLFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.landxml.2d.title", "Import 2D data from LandXML/HeXML files"));
                break;
            }
            case IMPORT_LAND_XML3D: {
                this.importFile(new HeXMLFileReader(DimensionType.SPATIAL), HeXMLFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.landxml.3d.title", "Import 3D data from LandXML/HeXML files"));
                break;
            }
            case IMPORT_M5: {
                this.importFile(new M5FileReader(), M5FileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.m5.title", "Import data from M5 files"));
                break;
            }
            case IMPORT_GKA: {
                this.importFile(new GKAFileReader(), GKAFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.gka.title", "Import data from GKA files"));
                break;
            }
            case IMPORT_Z: {
                this.importFile(new ZFileReader(), ZFileReader.getExtensionFilters(), this.i18n.getString("UIMenuBuilder.filechooser.import.z.title", "Import data from Z files"));
                break;
            }
            case IMPORT_COLUMN_BASED_FILES: {
                List<File> selectedFiles = DefaultFileChooser.showOpenMultipleDialog((Window)JAG3D.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.import.column_based.title", "Import user-defined column-based flat files"), null, FlatFileReader.getExtensionFilters());
                if (selectedFiles == null || selectedFiles.isEmpty()) {
                    return;
                }
                Optional<SourceFileReader<TreeItem<TreeItemValue>>> optional = ColumnImportDialog.showAndWait(selectedFiles.get(0));
                if (!optional.isPresent() || optional.get() == null) break;
                SourceFileReader<TreeItem<TreeItemValue>> fileReader = optional.get();
                this.importFile(fileReader, selectedFiles);
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " Error, unknwon import-type: " + String.valueOf((Object)menuItemType));
            }
        }
    }

    void embedSQLSripts() {
        List<File> selectedFiles = DefaultFileChooser.showOpenMultipleDialog((Window)JAG3D.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.sql.title", "Execute SQL script"), null, new FileChooser.ExtensionFilter(I18N.getInstance().getString("UIMenuBuilder.extension.sql", "Structured Query Language"), new String[]{"*.sql", "*.SQL"}));
        if (selectedFiles == null || selectedFiles.isEmpty()) {
            return;
        }
        try {
            DataBase dataBase = SQLManager.getInstance().getDataBase();
            dataBase.executeFiles(selectedFiles);
            OptionDialog.showInformationDialog(this.i18n.getString("UIMenuBuilder.message.information.sql.title", "SQL Script executed"), this.i18n.getString("UIMenuBuilder.message.information.sql.header", "SQL script successfully executed."), this.i18n.getString("UIMenuBuilder.message.information.sql.message", "The selected SQL script was executed without errors."));
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.sql.exception.title", "SQL Error"), this.i18n.getString("UIMenuBuilder.message.error.sql.exception.header", "Error, could not embed SQL script."), this.i18n.getString("UIMenuBuilder.message.error.sql.exception.message", "An exception has occurred during SQL embedding."), e);
        }
        TreeView<TreeItemValue> treeView = UITreeBuilder.getInstance().getTree();
        treeView.getSelectionModel().clearSelection();
        treeView.getSelectionModel().select(0);
    }

    void createReport(Path template) {
        try {
            String currentDataBaseName;
            Pattern pattern = Pattern.compile(".*?\\.(\\.)?(\\w+)\\.ftlh$", 2);
            Matcher matcher = pattern.matcher(template.getFileName().toString().toLowerCase());
            String extension = "html";
            boolean openFileInSystemApplication = true;
            FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter(this.i18n.getString("UIMenuBuilder.extension.html", "Hypertext Markup Language"), new String[]{"*.html", "*.htm", "*.HTML", "*.HTM"});
            if (matcher.find() && matcher.groupCount() == 2) {
                openFileInSystemApplication = matcher.group(1) == null;
                extension = matcher.group(2);
                extensionFilter = new FileChooser.ExtensionFilter(String.format(Locale.ENGLISH, this.i18n.getString("UIMenuBuilder.extension.template", "%s-File"), extension), new String[]{"*." + extension});
            }
            Object fileNameSuggestion = null;
            String string = currentDataBaseName = SQLManager.getInstance().getDataBase() != null && SQLManager.getInstance().getDataBase() instanceof HSQLDB ? ((HSQLDB)SQLManager.getInstance().getDataBase()).getDataBaseFileName() : null;
            if (currentDataBaseName != null && !currentDataBaseName.isBlank()) {
                int lastIndex = currentDataBaseName.lastIndexOf(File.separatorChar);
                fileNameSuggestion = lastIndex < 0 || lastIndex + 1 >= currentDataBaseName.length() ? currentDataBaseName : currentDataBaseName.substring(lastIndex + 1);
            }
            fileNameSuggestion = fileNameSuggestion == null || ((String)fileNameSuggestion).isBlank() ? "report." + extension : (String)fileNameSuggestion + "." + extension;
            FTLReport ftl = SQLManager.getInstance().getFTLReport();
            File reportFile = DefaultFileChooser.showSaveDialog((Window)JAG3D.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.report.title", "Save adjustment report"), (String)fileNameSuggestion, extensionFilter);
            if (reportFile != null && ftl != null) {
                ftl.setTemplate(template.getFileName().toString());
                ftl.toFilePath(reportFile.toPath(), openFileInSystemApplication);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.report.exception.title", "I/O Error"), this.i18n.getString("UIMenuBuilder.message.error.report.exception.header", "Error, could not create adjustment report."), this.i18n.getString("UIMenuBuilder.message.error.report.exception.message", "An exception has occurred during report creation."), e);
        }
    }

    public void checkUpdates() {
        String address = "https://software.applied-geodesy.org/update.php";
        URLParameter param = new URLParameter("checkupdate", "jag3d");
        try {
            int propVersion;
            boolean validProperties = false;
            Properties properties = HTTPPropertiesLoader.getProperties("https://software.applied-geodesy.org/update.php", param);
            if (properties != null && properties.containsKey("VERSION") && (propVersion = Integer.parseInt(properties.getProperty("VERSION", "-1"))) > 0) {
                validProperties = true;
                if (propVersion > Version.get() && propVersion > org.applied_geodesy.version.juniform.Version.get() && propVersion > org.applied_geodesy.version.coordtrans.Version.get()) {
                    Optional<ButtonType> result = OptionDialog.showConfirmationDialog(this.i18n.getString("UIMenuBuilder.message.confirmation.outdated_version.title", "New version available"), String.format(Locale.ENGLISH, this.i18n.getString("UIMenuBuilder.message.confirmation.outdated_version.header", "A new version v%d of JAG3D is available.\r\nDo you want to download the latest release?"), propVersion), this.i18n.getString("UIMenuBuilder.message.confirmation.outdated_version.message", "The currently used application is outdated. A new version of JAG3D is available at <software.applied-geodesy.org>."));
                    if (result.get() == ButtonType.OK && this.hostServices != null) {
                        this.hostServices.showDocument(properties.getProperty("DOWNLOAD", "https://software.applied-geodesy.org"));
                    }
                } else {
                    OptionDialog.showInformationDialog(this.i18n.getString("UIMenuBuilder.message.information.latest_version.title", "JAG3D is up-to-date"), this.i18n.getString("UIMenuBuilder.message.information.latest_version.header", "You are using the latest version of JAG3D."), this.i18n.getString("UIMenuBuilder.message.information.latest_version.message", "No update found, JAG3D software package is up-to-date."));
                }
            }
            if (!validProperties) {
                throw new IOException("Error, could not connect to server to check for updates. Received properties are invalid. " + String.valueOf(properties));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.check_updates.exception.title", "I/O Error"), this.i18n.getString("UIMenuBuilder.message.error.check_updates.exception.header", "Error, could not connect to server to check for updates."), this.i18n.getString("UIMenuBuilder.message.error.check_updates.exception.message", "An exception has occurred during check for updates."), e);
        }
    }

    void showModule(final MenuItemType menuItemType) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Stage stage = null;
                    switch (menuItemType) {
                        case MODULE_JUNIFORM: {
                            stage = JUniForm.getStage();
                            if (stage == null) {
                                stage = new Stage();
                                stage.initOwner((Window)JAG3D.getStage());
                            }
                            JUniForm juniform = new JUniForm();
                            juniform.start(stage);
                            break;
                        }
                        case MODULE_COORDTRANS: {
                            stage = CoordTrans.getStage();
                            if (stage == null) {
                                stage = new Stage();
                                stage.initOwner((Window)JAG3D.getStage());
                            }
                            CoordTrans coordTrans = new CoordTrans();
                            coordTrans.start(stage);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    OptionDialog.showThrowableDialog(UIMenuBuilder.this.i18n.getString("UIMenuBuilder.message.error.module.exception.title", "Application error"), UIMenuBuilder.this.i18n.getString("UIMenuBuilder.message.error.module.exception.header", "Error, could not start application."), UIMenuBuilder.this.i18n.getString("UIMenuBuilder.message.error.module.exception.message", "An exception has occurred during application start."), e);
                }
            }
        });
    }

    void showSwingApplication(final MenuItemType menuItemType) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (menuItemType) {
                    case MODULE_GEOTRA: {
                        new GeoTra(true);
                        break;
                    }
                }
            }
        });
    }

    private class DatabaseStateChangeListener
    implements ProjectDatabaseStateChangeListener {
        final Set<MenuItemType> unDisableItemTypes = new HashSet<MenuItemType>(Arrays.asList(MenuItemType.NEW, MenuItemType.OPEN, MenuItemType.EXIT, MenuItemType.RECENTLY_USED, MenuItemType.ABOUT, MenuItemType.CHECK_UPDATES, MenuItemType.MODULE_GEOTRA, MenuItemType.MODULE_COORDTRANS, MenuItemType.MODULE_JUNIFORM));

        private DatabaseStateChangeListener() {
        }

        @Override
        public void projectDatabaseStateChanged(ProjectDatabaseStateEvent evt) {
            if (UIMenuBuilder.this.menuBar == null || UIMenuBuilder.this.menuBar.getChildrenUnmodifiable().isEmpty()) {
                return;
            }
            boolean disable = evt.getEventType() != ProjectDatabaseStateType.OPENED;
            ObservableList menus = UIMenuBuilder.this.menuBar.getMenus();
            for (Menu menu : menus) {
                this.disableMenu(menu, disable);
            }
        }

        private void disableMenu(Menu menu, boolean disable) {
            ObservableList items = menu.getItems();
            for (MenuItem item : items) {
                if (item instanceof Menu) {
                    this.disableMenu((Menu)item, disable);
                    continue;
                }
                if (this.unDisableItemTypes.contains(item.getUserData())) continue;
                item.setDisable(disable);
            }
        }
    }
}

