/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.menu;

import java.nio.file.Path;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.MenuItem;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.JAG3D;
import org.applied_geodesy.jag3d.ui.dialog.AboutDialog;
import org.applied_geodesy.jag3d.ui.dialog.AnalysisChartsDialog;
import org.applied_geodesy.jag3d.ui.dialog.ApproximationValuesDialog;
import org.applied_geodesy.jag3d.ui.dialog.AverageDialog;
import org.applied_geodesy.jag3d.ui.dialog.CongruentPointDialog;
import org.applied_geodesy.jag3d.ui.dialog.ExportOptionDialog;
import org.applied_geodesy.jag3d.ui.dialog.FormatterOptionDialog;
import org.applied_geodesy.jag3d.ui.dialog.ImportOptionDialog;
import org.applied_geodesy.jag3d.ui.dialog.LeastSquaresSettingDialog;
import org.applied_geodesy.jag3d.ui.dialog.ProjectionAndReductionDialog;
import org.applied_geodesy.jag3d.ui.dialog.RankDefectDialog;
import org.applied_geodesy.jag3d.ui.dialog.TableRowHighlightDialog;
import org.applied_geodesy.jag3d.ui.dialog.TestStatisticDialog;
import org.applied_geodesy.jag3d.ui.menu.MenuItemType;
import org.applied_geodesy.jag3d.ui.menu.PathMenuItem;
import org.applied_geodesy.jag3d.ui.menu.UIMenuBuilder;

public class MenuEventHandler
implements EventHandler<ActionEvent> {
    private UIMenuBuilder menuBuilder;

    MenuEventHandler(UIMenuBuilder menuBuilder) {
        this.menuBuilder = menuBuilder;
    }

    public void handle(ActionEvent event) {
        MenuItem menuItem;
        if (event.getSource() instanceof MenuItem && (menuItem = (MenuItem)event.getSource()).getUserData() instanceof MenuItemType) {
            MenuItemType menuItemType = (MenuItemType)((Object)menuItem.getUserData());
            Path path = menuItem instanceof PathMenuItem ? ((PathMenuItem)menuItem).getPath() : null;
            this.handleAction(menuItemType, path);
        }
    }

    private void handleAction(MenuItemType menuItemType, Path path) {
        switch (menuItemType) {
            case EXIT: {
                JAG3D.close();
                break;
            }
            case CLOSE: {
                SQLManager.closeProject();
                break;
            }
            case ABOUT: {
                AboutDialog.showAndWait();
                break;
            }
            case NEW: {
                this.menuBuilder.newProject();
                break;
            }
            case OPEN: {
                this.menuBuilder.openProject();
                break;
            }
            case MIGRATE: {
                this.menuBuilder.migrateProject();
                break;
            }
            case COPY: {
                this.menuBuilder.copyProject();
                break;
            }
            case SQL_SCRIPT: {
                this.menuBuilder.embedSQLSripts();
                break;
            }
            case FORMATTER_PREFERENCES: {
                FormatterOptionDialog.showAndWait();
                break;
            }
            case IMPORT_PREFERENCES: {
                ImportOptionDialog.showAndWait();
                break;
            }
            case EXPORT_PREFERENCES: {
                ExportOptionDialog.showAndWait();
                break;
            }
            case LEAST_SQUARES: {
                LeastSquaresSettingDialog.showAndWait();
                break;
            }
            case TEST_STATISTIC: {
                TestStatisticDialog.showAndWait();
                break;
            }
            case RANK_DEFECT: {
                RankDefectDialog.showAndWait();
                break;
            }
            case PROJECTION_AND_REDUCTION: {
                ProjectionAndReductionDialog.showAndWait();
                break;
            }
            case CONGRUENT_POINT: {
                CongruentPointDialog.showAndWait();
                break;
            }
            case APROXIMATE_VALUES: {
                ApproximationValuesDialog.showAndWait();
                break;
            }
            case AVERAGE: {
                AverageDialog.showAndWait();
                break;
            }
            case CHECK_UPDATES: {
                this.menuBuilder.checkUpdates();
                break;
            }
            case IMPORT_FLAT_LEVELING: 
            case IMPORT_FLAT_DIRECTION: 
            case IMPORT_FLAT_HORIZONTAL_DISTANCE: 
            case IMPORT_FLAT_SLOPE_DISTANCE: 
            case IMPORT_FLAT_ZENITH_ANGLE: 
            case IMPORT_FLAT_GNSS1D: 
            case IMPORT_FLAT_GNSS2D: 
            case IMPORT_FLAT_GNSS3D: 
            case IMPORT_FLAT_REFERENCE_POINT_1D: 
            case IMPORT_FLAT_REFERENCE_POINT_2D: 
            case IMPORT_FLAT_REFERENCE_POINT_3D: 
            case IMPORT_FLAT_STOCHASTIC_POINT_1D: 
            case IMPORT_FLAT_STOCHASTIC_POINT_2D: 
            case IMPORT_FLAT_STOCHASTIC_POINT_3D: 
            case IMPORT_FLAT_DATUM_POINT_1D: 
            case IMPORT_FLAT_DATUM_POINT_2D: 
            case IMPORT_FLAT_DATUM_POINT_3D: 
            case IMPORT_FLAT_NEW_POINT_1D: 
            case IMPORT_FLAT_NEW_POINT_2D: 
            case IMPORT_FLAT_NEW_POINT_3D: 
            case IMPORT_FLAT_REFERENCE_VERTICAL_DEFLECTION: 
            case IMPORT_FLAT_STOCASTIC_VERTICAL_DEFLECTION: 
            case IMPORT_FLAT_UNKNOWN_VERTICAL_DEFLECTION: 
            case IMPORT_FLAT_CONGRUENCE_ANALYSIS_PAIR_1D: 
            case IMPORT_FLAT_CONGRUENCE_ANALYSIS_PAIR_2D: 
            case IMPORT_FLAT_CONGRUENCE_ANALYSIS_PAIR_3D: 
            case IMPORT_BEO: 
            case IMPORT_Z: 
            case IMPORT_DL100: 
            case IMPORT_M5: 
            case IMPORT_GKA: 
            case IMPORT_GSI1D: 
            case IMPORT_GSI2D: 
            case IMPORT_GSI2DH: 
            case IMPORT_GSI3D: 
            case IMPORT_LAND_XML2D: 
            case IMPORT_LAND_XML3D: 
            case IMPORT_JOB_XML2D: 
            case IMPORT_JOB_XML2DH: 
            case IMPORT_JOB_XML3D: 
            case IMPORT_COLUMN_BASED_FILES: {
                this.menuBuilder.importFile(menuItemType);
                break;
            }
            case HIGHLIGHT_TABLE_ROWS: {
                TableRowHighlightDialog.showAndWait();
                break;
            }
            case ANALYSIS_CHARTS: {
                AnalysisChartsDialog.showAndWait();
                break;
            }
            case MODULE_GEOTRA: {
                this.menuBuilder.showSwingApplication(menuItemType);
                break;
            }
            case MODULE_COORDTRANS: 
            case MODULE_JUNIFORM: {
                this.menuBuilder.showModule(menuItemType);
                break;
            }
            case REPORT: {
                this.menuBuilder.createReport(path);
                break;
            }
            case RECENTLY_USED: {
                this.menuBuilder.openProject(path);
            }
        }
    }
}

