/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.io.writer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.applied_geodesy.adjustment.network.NetworkAdjustment;
import org.applied_geodesy.adjustment.network.ParameterType;
import org.applied_geodesy.adjustment.network.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.network.parameter.UnknownParameters;
import org.applied_geodesy.adjustment.network.point.Point;
import org.applied_geodesy.jag3d.ui.io.writer.NetworkAdjustmentResultWriter;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.Struct;

public class MatlabNetworkAdjustmentResultWriter
extends NetworkAdjustmentResultWriter {
    public MatlabNetworkAdjustmentResultWriter(String exportPathAndFileBaseName) {
        super(exportPathAndFileBaseName);
    }

    @Override
    public void export(NetworkAdjustment networkAdjustment) throws NullPointerException, IllegalArgumentException, IOException {
        if (networkAdjustment == null) {
            throw new NullPointerException("Error, network adjustment object cannot be null!");
        }
        String exportPathAndFileBaseName = this.getExportPathAndFileBaseName();
        if (exportPathAndFileBaseName == null) {
            throw new NullPointerException("Error, export path cannot be null!");
        }
        int numberOfUnknownParameters = networkAdjustment.getNumberOfUnknownParameters();
        int numberOfObservations = networkAdjustment.getNumberOfObservations();
        int degreeOfFreedom = networkAdjustment.degreeOfFreedom();
        double varianceOfUnitWeight = networkAdjustment.getVarianceFactorAposteriori();
        no.uib.cipr.matrix.Matrix cofactor = networkAdjustment.getCofactorMatrix();
        if (cofactor == null || cofactor.numRows() < numberOfUnknownParameters || varianceOfUnitWeight < 0.0) {
            throw new NullPointerException("Error, dipsersion matrix cannot be null!");
        }
        List<Point> points = this.extractPointsFromUnknownParameters(networkAdjustment);
        File binFile = new File(exportPathAndFileBaseName + ".mat");
        Struct coordinates = Mat5.newStruct((int)1, (int)points.size());
        int structIndex = 0;
        for (Point point : points) {
            if (networkAdjustment.isInterrupted()) break;
            String name = point.getName();
            int dim = point.getDimension();
            int colInJacobi = point.getColInJacobiMatrix();
            double x0 = 0.0;
            double z0 = 0.0;
            double y0 = 0.0;
            double x = 0.0;
            double z = 0.0;
            double y = 0.0;
            int columnX = -1;
            int columnY = -1;
            int columnZ = -1;
            if (dim != 1) {
                x0 = point.getX0();
                y0 = point.getY0();
                x = point.getX();
                y = point.getY();
                ++colInJacobi;
                columnX = colInJacobi++;
                columnY = colInJacobi;
            }
            if (dim != 2) {
                z0 = point.getZ0();
                z = point.getZ();
                columnZ = ++colInJacobi;
            }
            coordinates.set("name", structIndex, (Array)Mat5.newString((String)name));
            coordinates.set("dimension", structIndex, (Array)MatlabNetworkAdjustmentResultWriter.newInteger(dim));
            coordinates.set("x0", structIndex, (Array)MatlabNetworkAdjustmentResultWriter.newDouble(x0));
            coordinates.set("y0", structIndex, (Array)MatlabNetworkAdjustmentResultWriter.newDouble(y0));
            coordinates.set("z0", structIndex, (Array)MatlabNetworkAdjustmentResultWriter.newDouble(z0));
            coordinates.set("x", structIndex, (Array)MatlabNetworkAdjustmentResultWriter.newDouble(x));
            coordinates.set("y", structIndex, (Array)MatlabNetworkAdjustmentResultWriter.newDouble(y));
            coordinates.set("z", structIndex, (Array)MatlabNetworkAdjustmentResultWriter.newDouble(z));
            coordinates.set("covx", structIndex, (Array)MatlabNetworkAdjustmentResultWriter.newInteger(columnX));
            coordinates.set("covy", structIndex, (Array)MatlabNetworkAdjustmentResultWriter.newInteger(columnY));
            coordinates.set("covz", structIndex, (Array)MatlabNetworkAdjustmentResultWriter.newInteger(columnZ));
            ++structIndex;
        }
        Matrix dispersion = Mat5.newMatrix((int)numberOfUnknownParameters, (int)numberOfUnknownParameters, (MatlabType)MatlabType.Double);
        int rowIdx = 0;
        while (rowIdx < numberOfUnknownParameters) {
            if (networkAdjustment.isInterrupted()) break;
            double var = cofactor.get(rowIdx, rowIdx);
            dispersion.setDouble(rowIdx, rowIdx, var);
            int columnIdx = rowIdx + 1;
            while (columnIdx < numberOfUnknownParameters) {
                if (networkAdjustment.isInterrupted()) break;
                double covar = cofactor.get(rowIdx, columnIdx);
                dispersion.setDouble(rowIdx, columnIdx, covar);
                dispersion.setDouble(columnIdx, rowIdx, covar);
                ++columnIdx;
            }
            ++rowIdx;
        }
        Mat5File matFile = Mat5.newMatFile();
        matFile.addArray("variance_of_unit_weight_prio", (Array)MatlabNetworkAdjustmentResultWriter.newDouble(1.0));
        matFile.addArray("variance_of_unit_weight_post", (Array)MatlabNetworkAdjustmentResultWriter.newDouble(varianceOfUnitWeight));
        matFile.addArray("degree_of_freedom", (Array)MatlabNetworkAdjustmentResultWriter.newInteger(degreeOfFreedom));
        matFile.addArray("number_of_observations", (Array)MatlabNetworkAdjustmentResultWriter.newInteger(numberOfObservations));
        matFile.addArray("number_of_unknowns", (Array)MatlabNetworkAdjustmentResultWriter.newInteger(numberOfUnknownParameters));
        matFile.addArray("coordinates", (Array)coordinates);
        matFile.addArray("dispersion", (Array)dispersion);
        Mat5.writeToFile((MatFile)matFile, (File)binFile);
    }

    private List<Point> extractPointsFromUnknownParameters(NetworkAdjustment networkAdjustment) {
        UnknownParameters unknownParameters = networkAdjustment.getUnknownParameters();
        ArrayList<Point> points = new ArrayList<Point>(unknownParameters.size());
        for (UnknownParameter unknownParameter : unknownParameters) {
            if (networkAdjustment.isInterrupted()) break;
            if (unknownParameter.getParameterType() != ParameterType.POINT1D && unknownParameter.getParameterType() != ParameterType.POINT2D && unknownParameter.getParameterType() != ParameterType.POINT3D) continue;
            Point point = (Point)unknownParameter;
            points.add(point);
        }
        return points;
    }

    private static Matrix newInteger(int value) {
        Matrix matrix = Mat5.newMatrix((int)1, (int)1, (MatlabType)MatlabType.Int32);
        matrix.setInt(0, 0, value);
        return matrix;
    }

    private static Matrix newDouble(double value) {
        Matrix matrix = Mat5.newMatrix((int)1, (int)1, (MatlabType)MatlabType.Double);
        matrix.setDouble(0, 0, value);
        return matrix;
    }
}

