/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.io.writer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.network.NetworkAdjustment;
import org.applied_geodesy.adjustment.network.ParameterType;
import org.applied_geodesy.adjustment.network.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.network.parameter.UnknownParameters;
import org.applied_geodesy.adjustment.network.point.Point;
import org.applied_geodesy.jag3d.ui.io.writer.NetworkAdjustmentResultWriter;

public class DefaultNetworkAdjustmentResultWriter
extends NetworkAdjustmentResultWriter {
    public DefaultNetworkAdjustmentResultWriter(String exportPathAndFileBaseName) {
        super(exportPathAndFileBaseName);
    }

    @Override
    public void export(NetworkAdjustment networkAdjustment) throws NullPointerException, IllegalArgumentException, IOException {
        if (networkAdjustment == null) {
            throw new NullPointerException("Error, network adjustment cannot be null!");
        }
        String exportPathAndFileBaseName = this.getExportPathAndFileBaseName();
        if (exportPathAndFileBaseName == null) {
            throw new NullPointerException("Error, export path cannot be null!");
        }
        this.exportCovarianceInformation(networkAdjustment, new File(exportPathAndFileBaseName + ".info"));
        this.exportCovarianceMatrix(networkAdjustment, new File(exportPathAndFileBaseName + ".cxx"));
    }

    private void exportCovarianceInformation(NetworkAdjustment networkAdjustment, File file) throws IOException {
        if (networkAdjustment.getCofactorMatrix() == null) {
            return;
        }
        UnknownParameters unknownParameters = networkAdjustment.getUnknownParameters();
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            String format = "%25s\t%5s\t%35.15f\t%10d\t%10d%n";
            for (UnknownParameter unknownParameter : unknownParameters) {
                if (unknownParameter.getParameterType() != ParameterType.POINT1D && unknownParameter.getParameterType() != ParameterType.POINT2D && unknownParameter.getParameterType() != ParameterType.POINT3D) continue;
                if (networkAdjustment.isInterrupted()) {
                    break;
                }
                Point point = (Point)unknownParameter;
                int colInJacobi = point.getColInJacobiMatrix();
                int rowInJacobi = point.getRowInJacobiMatrix();
                int dim = point.getDimension();
                int numberOfObservations = point.numberOfObservations() + (rowInJacobi >= 0 ? dim : 0);
                if (colInJacobi < 0) continue;
                if (dim != 1) {
                    pw.printf(Locale.ENGLISH, format, point.getName(), Character.valueOf('X'), point.getX(), colInJacobi++, numberOfObservations);
                    pw.printf(Locale.ENGLISH, format, point.getName(), Character.valueOf('Y'), point.getY(), colInJacobi++, numberOfObservations);
                }
                if (dim == 2) continue;
                pw.printf(Locale.ENGLISH, format, point.getName(), Character.valueOf('Z'), point.getZ(), colInJacobi++, numberOfObservations);
            }
        }
    }

    private void exportCovarianceMatrix(NetworkAdjustment networkAdjustment, File file) throws IOException {
        Matrix cofactor = networkAdjustment.getCofactorMatrix();
        int numberOfUnknownParameters = networkAdjustment.getNumberOfUnknownParameters();
        double varianceOfUnitWeight = networkAdjustment.getVarianceFactorAposteriori();
        if (cofactor == null || cofactor.numRows() < numberOfUnknownParameters || varianceOfUnitWeight < 0.0) {
            return;
        }
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            int i = 0;
            while (i < numberOfUnknownParameters) {
                if (networkAdjustment.isInterrupted()) {
                    break;
                }
                int j = 0;
                while (j < numberOfUnknownParameters) {
                    if (networkAdjustment.isInterrupted()) break;
                    pw.printf(Locale.ENGLISH, "%+35.25f  ", varianceOfUnitWeight * cofactor.get(i, j));
                    ++j;
                }
                pw.println();
                ++i;
            }
        }
    }
}

