/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.io.reader.xml;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.scene.control.TreeItem;
import javafx.stage.FileChooser;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.io.reader.DimensionType;
import org.applied_geodesy.jag3d.ui.io.reader.ImportOption;
import org.applied_geodesy.jag3d.ui.io.reader.xml.AngularUnit;
import org.applied_geodesy.jag3d.ui.io.reader.xml.HeXMLNamespaceContext;
import org.applied_geodesy.jag3d.ui.io.reader.xml.LengthUnit;
import org.applied_geodesy.jag3d.ui.table.row.GNSSObservationRow;
import org.applied_geodesy.jag3d.ui.table.row.PointRow;
import org.applied_geodesy.jag3d.ui.table.row.TerrestrialObservationRow;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.PointTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.util.XMLUtilities;
import org.applied_geodesy.util.io.SourceFileReader;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HeXMLFileReader
extends SourceFileReader<TreeItem<TreeItemValue>>
implements ErrorHandler {
    private LengthUnit lengthUnit = LengthUnit.METER;
    private AngularUnit angularUnit = AngularUnit.RADIAN;
    private Map<String, InstrumentSetup> setups = new LinkedHashMap<String, InstrumentSetup>();
    private boolean isValidDocument = true;
    private final DimensionType dim;
    private List<GNSSObservationRow> gnss2D = null;
    private List<GNSSObservationRow> gnss3D = null;
    private List<TerrestrialObservationRow> horizontalDistances = null;
    private List<TerrestrialObservationRow> directions = null;
    private List<TerrestrialObservationRow> slopeDistances = null;
    private List<TerrestrialObservationRow> zenithAngles = null;
    private List<PointRow> points2d = null;
    private List<PointRow> points3d = null;
    private Set<String> pointNames = null;
    private Set<String> point3DName = null;
    private Set<String> reservedNames = null;
    private TreeItem<TreeItemValue> lastTreeItem = null;

    public HeXMLFileReader(DimensionType dim) {
        this.dim = dim == DimensionType.PLAN ? DimensionType.PLAN : DimensionType.SPATIAL;
        this.reset();
    }

    public HeXMLFileReader(Path p, DimensionType dim) {
        super(p);
        this.dim = dim == DimensionType.PLAN ? DimensionType.PLAN : DimensionType.SPATIAL;
        this.reset();
    }

    public HeXMLFileReader(String xmlFileName, DimensionType dim) {
        this(new File(xmlFileName), dim);
    }

    public HeXMLFileReader(File xmlFile, DimensionType dim) {
        this(xmlFile.toPath(), dim);
    }

    private double convertToRadian(double d) {
        switch (this.angularUnit) {
            case GRADIAN: {
                return d * 0.015707963267948967;
            }
            case DEGREE: {
                return d * (Math.PI / 180);
            }
            case DDMMSSss: {
                int dd = (int)d;
                d = 100.0 * (d - (double)dd);
                int mm = (int)d;
                double ss = 100.0 * (d - (double)mm);
                return ((double)dd + (double)mm / 60.0 + ss / 3600.0) * (Math.PI / 180);
            }
        }
        return d;
    }

    private double convertToMeter(double d) {
        switch (this.lengthUnit) {
            case MILLIMETER: {
                return 0.001 * d;
            }
            case CENTIMETER: {
                return 0.01 * d;
            }
            case KILOMETER: {
                return 1000.0 * d;
            }
            case FOOT: {
                return 0.30479999999999996 * d;
            }
            case INCH: {
                return 0.0254 * d;
            }
            case US_SURVEY_FOOT: {
                return 0.3048006096012192 * d;
            }
            case MILE: {
                return 1609.344 * d;
            }
        }
        return d;
    }

    public boolean isValidDocument() {
        return this.isValidDocument;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        e.getMessage();
        this.isValidDocument = false;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        e.getMessage();
        this.isValidDocument = false;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        e.getMessage();
    }

    @Override
    public void parse(String line) {
    }

    @Override
    public void reset() {
        if (this.setups == null) {
            this.setups = new LinkedHashMap<String, InstrumentSetup>();
        }
        if (this.points2d == null) {
            this.points2d = new ArrayList<PointRow>();
        }
        if (this.points3d == null) {
            this.points3d = new ArrayList<PointRow>();
        }
        if (this.horizontalDistances == null) {
            this.horizontalDistances = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.directions == null) {
            this.directions = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.slopeDistances == null) {
            this.slopeDistances = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.zenithAngles == null) {
            this.zenithAngles = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.gnss2D == null) {
            this.gnss2D = new ArrayList<GNSSObservationRow>();
        }
        if (this.gnss3D == null) {
            this.gnss3D = new ArrayList<GNSSObservationRow>();
        }
        if (this.reservedNames == null) {
            this.reservedNames = new HashSet<String>();
        }
        if (this.pointNames == null) {
            this.pointNames = new HashSet<String>();
        }
        if (this.point3DName == null) {
            this.point3DName = new HashSet<String>();
        }
        this.setups.clear();
        this.reservedNames.clear();
        this.pointNames.clear();
        this.point3DName.clear();
        this.points2d.clear();
        this.points3d.clear();
        this.horizontalDistances.clear();
        this.directions.clear();
        this.slopeDistances.clear();
        this.zenithAngles.clear();
        this.gnss2D.clear();
        this.gnss3D.clear();
    }

    @Override
    public TreeItem<TreeItemValue> readAndImport() throws IOException, SQLException {
        this.reset();
        this.lastTreeItem = null;
        this.reservedNames = SQLManager.getInstance().getFullPointNameSet();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            File xmlFile = this.getPath().toFile();
            Document document = builder.parse(xmlFile);
            HeXMLNamespaceContext namespaceContext = new HeXMLNamespaceContext(document);
            String xpathPattern = "//landxml:LandXML/landxml:Application/@name";
            String applicationName = (String)XMLUtilities.xpathSearch(document, xpathPattern, (NamespaceContext)namespaceContext, XPathConstants.STRING);
            xpathPattern = "//landxml:LandXML/landxml:Units/*[1]";
            Node units = (Node)XMLUtilities.xpathSearch(document, xpathPattern, (NamespaceContext)namespaceContext, XPathConstants.NODE);
            if (units != null) {
                String angularUnit;
                String lengthUnit;
                NamedNodeMap attr = units.getAttributes();
                String string = lengthUnit = attr.getNamedItem("linearUnit") == null ? "meter" : attr.getNamedItem("linearUnit").getNodeValue();
                this.lengthUnit = lengthUnit.equalsIgnoreCase("millimeter") ? LengthUnit.MILLIMETER : (lengthUnit.equalsIgnoreCase("centimeter") ? LengthUnit.CENTIMETER : (lengthUnit.equalsIgnoreCase("kilometer") ? LengthUnit.KILOMETER : (lengthUnit.equalsIgnoreCase("foot") ? LengthUnit.FOOT : (lengthUnit.equalsIgnoreCase("USSurveyFoot") ? LengthUnit.US_SURVEY_FOOT : (lengthUnit.equalsIgnoreCase("inch") ? LengthUnit.INCH : (lengthUnit.equalsIgnoreCase("mile") ? LengthUnit.MILE : LengthUnit.METER))))));
                String string2 = angularUnit = attr.getNamedItem("angularUnit") == null ? "radians" : attr.getNamedItem("angularUnit").getNodeValue();
                this.angularUnit = angularUnit.equalsIgnoreCase("grads") ? AngularUnit.GRADIAN : (angularUnit.equalsIgnoreCase("decimal degrees") ? AngularUnit.DEGREE : (angularUnit.equalsIgnoreCase("decimal dd.mm.ss") ? AngularUnit.DDMMSSss : AngularUnit.RADIAN));
            }
            xpathPattern = "//landxml:LandXML/landxml:CgPoints/landxml:CgPoint[@name] | //landxml:LandXML/landxml:Survey//landxml:Backsight/landxml:BacksightPoint[@name] | //landxml:LandXML/landxml:Survey//landxml:TargetPoint[@name] |//landxml:LandXML/landxml:Survey//landxml:InstrumentSetup[@stationName]/landxml:InstrumentPoint";
            NodeList nodeList = (NodeList)XMLUtilities.xpathSearch(document, xpathPattern, (NamespaceContext)namespaceContext, XPathConstants.NODESET);
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.hasChildNodes() && node.getFirstChild().getNodeType() == 3 && !node.getFirstChild().getNodeValue().trim().isEmpty()) {
                    NamedNodeMap attr = node.getAttributes();
                    String pointName = "";
                    String code = null;
                    String setupId = "";
                    double ih = 0.0;
                    PointRow point = null;
                    boolean isDeleted = false;
                    if (node.getNodeName().equalsIgnoreCase("CgPoint")) {
                        pointName = attr.getNamedItem("oID") == null ? attr.getNamedItem("name").getNodeValue() : attr.getNamedItem("oID").getNodeValue();
                        code = attr.getNamedItem("code") == null ? null : attr.getNamedItem("code").getNodeValue();
                    } else if (node.getNodeName().equalsIgnoreCase("InstrumentPoint")) {
                        NamedNodeMap parentNodeAttr = node.getParentNode().getAttributes();
                        pointName = parentNodeAttr.getNamedItem("stationName").getNodeValue();
                        Node status = parentNodeAttr.getNamedItem("status");
                        isDeleted = status != null && status.getNodeValue() != null && status.getNodeValue().equalsIgnoreCase("deleted");
                        setupId = parentNodeAttr.getNamedItem("id") == null ? "" : parentNodeAttr.getNamedItem("id").getNodeValue();
                        try {
                            ih = parentNodeAttr.getNamedItem("instrumentHeight") == null ? 0.0 : this.convertToMeter(Double.parseDouble(parentNodeAttr.getNamedItem("instrumentHeight").getNodeValue()));
                        }
                        catch (NumberFormatException e) {
                            ih = 0.0;
                        }
                    } else {
                        pointName = attr.getNamedItem("name").getNodeValue();
                    }
                    if (!(isDeleted || pointName.isEmpty() || this.pointNames.contains(pointName))) {
                        this.pointNames.add(pointName);
                        String[] pointContent = node.getFirstChild().getNodeValue().trim().split("\\s+");
                        double[] xyz = new double[pointContent.length];
                        try {
                            int p = 0;
                            while (p < pointContent.length) {
                                xyz[p] = this.convertToMeter(Double.parseDouble(pointContent[p]));
                                ++p;
                            }
                        }
                        catch (NumberFormatException e) {
                            xyz = null;
                        }
                        if (xyz != null && pointContent.length > 1) {
                            point = new PointRow();
                            point.setName(pointName);
                            point.setCode(code);
                            double x = 0.0;
                            double y = 0.0;
                            double z = 0.0;
                            if (xyz.length != 1) {
                                x = xyz[0];
                                y = xyz[1];
                                point.setXApriori(x);
                                point.setYApriori(y);
                            }
                            if (xyz.length != 2) {
                                z = xyz[xyz.length - 1];
                                point.setZApriori(z);
                            }
                            if (xyz.length == 2 || this.dim == DimensionType.PLAN) {
                                if (!this.reservedNames.contains(pointName)) {
                                    this.points2d.add(point);
                                }
                            } else {
                                if (!this.reservedNames.contains(pointName)) {
                                    this.points3d.add(point);
                                }
                                this.point3DName.add(pointName);
                            }
                        }
                    }
                    if (!setupId.isEmpty() && !pointName.isEmpty() && this.pointNames.contains(pointName)) {
                        this.setups.put(setupId, new InstrumentSetup(pointName, ih));
                    }
                }
                ++i;
            }
            xpathPattern = "//landxml:LandXML/landxml:Survey//landxml:RawObservation[@setupID=\"%s\"]";
            boolean applyAtmosphericCorrection = applicationName == null || !applicationName.equalsIgnoreCase("LandXML Export");
            for (String setupId : this.setups.keySet()) {
                InstrumentSetup setup = this.setups.get(setupId);
                nodeList = (NodeList)XMLUtilities.xpathSearch(document, String.format(Locale.ENGLISH, xpathPattern, setupId), (NamespaceContext)namespaceContext, XPathConstants.NODESET);
                int i2 = 0;
                while (i2 < nodeList.getLength()) {
                    Node node = nodeList.item(i2);
                    double th = 0.0;
                    Double dir = null;
                    Double zenith = null;
                    Double dist2d = null;
                    Double dist3d = null;
                    Boolean isDeleted = false;
                    NamedNodeMap attr = node.getAttributes();
                    try {
                        isDeleted = attr.getNamedItem("status") == null ? false : attr.getNamedItem("status").getNodeValue().equalsIgnoreCase("deleted");
                    }
                    catch (Exception e) {
                        isDeleted = false;
                    }
                    if (!isDeleted.booleanValue()) {
                        int targetPointDim;
                        String xpath;
                        String endPointName;
                        try {
                            th = attr.getNamedItem("targetHeight") == null ? 0.0 : this.convertToMeter(Double.parseDouble(attr.getNamedItem("targetHeight").getNodeValue()));
                        }
                        catch (NumberFormatException e) {
                            th = 0.0;
                        }
                        try {
                            dir = attr.getNamedItem("horizAngle") == null ? null : Double.valueOf(this.convertToRadian(Double.parseDouble(attr.getNamedItem("horizAngle").getNodeValue())));
                        }
                        catch (NumberFormatException e) {
                            dir = null;
                        }
                        try {
                            zenith = attr.getNamedItem("zenithAngle") == null ? null : Double.valueOf(this.convertToRadian(Double.parseDouble(attr.getNamedItem("zenithAngle").getNodeValue())));
                        }
                        catch (NumberFormatException e) {
                            zenith = null;
                        }
                        try {
                            dist2d = attr.getNamedItem("horizDistance") == null ? null : Double.valueOf(this.convertToMeter(Double.parseDouble(attr.getNamedItem("horizDistance").getNodeValue())));
                        }
                        catch (NumberFormatException e) {
                            dist2d = null;
                        }
                        try {
                            dist3d = attr.getNamedItem("slopeDistance") == null ? null : Double.valueOf(this.convertToMeter(Double.parseDouble(attr.getNamedItem("slopeDistance").getNodeValue())));
                        }
                        catch (NumberFormatException e) {
                            dist3d = null;
                        }
                        boolean isFaceI = true;
                        if (attr.getNamedItem("directFace") != null && !attr.getNamedItem("directFace").getNodeValue().equalsIgnoreCase("TRUE") || zenith != null && !Double.isNaN(zenith) && !Double.isInfinite(zenith) && zenith > Math.PI) {
                            isFaceI = false;
                        }
                        if (!isFaceI) {
                            if (dir != null) {
                                dir = MathExtension.MOD(dir + Math.PI, Math.PI * 2);
                            }
                            if (this.dim == DimensionType.SPATIAL && zenith != null && zenith > Math.PI) {
                                zenith = MathExtension.MOD(Math.PI * 2 - zenith, Math.PI * 2);
                            }
                        }
                        int n = this.point3DName.contains(endPointName = (String)XMLUtilities.xpathSearch(node, xpath = "./landxml:TargetPoint/@name", (NamespaceContext)namespaceContext, XPathConstants.STRING)) ? 3 : (this.pointNames.contains(endPointName) ? 2 : (targetPointDim = this.dim == DimensionType.PLAN ? 2 : 3));
                        int startPointDim = this.point3DName.contains(setup.getSetupPointName()) ? 3 : (this.pointNames.contains(setup.getSetupPointName()) ? 2 : (this.dim == DimensionType.PLAN ? 2 : 3));
                        int obsDim = Math.min(targetPointDim, startPointDim);
                        double distanceForUncertaintyModel = 0.0;
                        if (this.dim == DimensionType.SPATIAL && obsDim == 3) {
                            if (dist3d != null) {
                                xpath = "./landxml:Feature[@code=\"observationInfo\"]/landxml:Property[@label=\"TPSCorrectionRef\"]/@value";
                                String tpsCorr = (String)XMLUtilities.xpathSearch(node, xpath, (NamespaceContext)namespaceContext, XPathConstants.STRING);
                                xpath = "./landxml:TargetPoint/@pntRef";
                                tpsCorr = tpsCorr == null || tpsCorr.isEmpty() ? (String)XMLUtilities.xpathSearch(node, xpath, (NamespaceContext)namespaceContext, XPathConstants.STRING) : tpsCorr;
                                xpath = "1.0 + //landxml:LandXML/hexml:HexagonLandXML/hexml:Survey/hexml:TPSCorrection[@uniqueID = ./../hexml:InstrumentSetup[@uniqueID=\"%s\"]/hexml:RawObservation[@targetPntRef=\"%s\"]/@tpsCorrectionRef ]/@atmosphericPPM * 0.000001";
                                Double scale = (Double)XMLUtilities.xpathSearch(document, String.format(Locale.ENGLISH, xpath, setupId, tpsCorr), (NamespaceContext)namespaceContext, XPathConstants.NUMBER);
                                xpath = "//landxml:LandXML/hexml:HexagonLandXML/hexml:Survey/hexml:InstrumentSetup[@uniqueID=\"%s\"]/hexml:RawObservation[@targetPntRef=\"%s\"]/@reflectorConstant";
                                Double add = (Double)XMLUtilities.xpathSearch(document, String.format(Locale.ENGLISH, xpath, setupId, tpsCorr), (NamespaceContext)namespaceContext, XPathConstants.NUMBER);
                                xpath = "1.0 + //landxml:LandXML/landxml:Survey//landxml:Corrections/landxml:Feature[@code=\"TPSCorrection\"]/landxml:Property[@label=\"oID\"][@value = \"%s\"]/../landxml:Property[@label=\"atmosphericPPM\"]/@value * 0.000001";
                                scale = scale == null || Double.isNaN(scale) ? (Double)XMLUtilities.xpathSearch(node, String.format(Locale.ENGLISH, xpath, tpsCorr), (NamespaceContext)namespaceContext, XPathConstants.NUMBER) : scale;
                                xpath = "./landxml:Feature[@code=\"observationInfo\"]/landxml:Property[@label=\"reflectorConstant\"]/@value";
                                add = add == null || Double.isNaN(add) ? (Double)XMLUtilities.xpathSearch(node, xpath, (NamespaceContext)namespaceContext, XPathConstants.NUMBER) : add;
                                scale = !applyAtmosphericCorrection || scale == null || Double.isNaN(scale) ? 1.0 : scale;
                                add = !applyAtmosphericCorrection || add == null || Double.isNaN(add) ? 0.0 : add;
                                add = this.convertToMeter(add);
                                dist3d = (dist3d - add) * scale + add;
                                distanceForUncertaintyModel = dist3d;
                                TerrestrialObservationRow slopeDistances = new TerrestrialObservationRow();
                                slopeDistances.setInstrumentHeight(setup.getInstrumentHeight());
                                slopeDistances.setStartPointName(setup.getSetupPointName());
                                slopeDistances.setReflectorHeight(th);
                                slopeDistances.setEndPointName(endPointName);
                                slopeDistances.setValueApriori(dist3d);
                                slopeDistances.setDistanceApriori(distanceForUncertaintyModel);
                                if (dist3d > 0.0) {
                                    this.slopeDistances.add(slopeDistances);
                                }
                            }
                            if (zenith != null) {
                                TerrestrialObservationRow zenithAngles = new TerrestrialObservationRow();
                                zenithAngles.setInstrumentHeight(setup.getInstrumentHeight());
                                zenithAngles.setStartPointName(setup.getSetupPointName());
                                zenithAngles.setReflectorHeight(th);
                                zenithAngles.setEndPointName(endPointName);
                                zenithAngles.setValueApriori(zenith);
                                if (distanceForUncertaintyModel > 0.0) {
                                    zenithAngles.setDistanceApriori(distanceForUncertaintyModel);
                                    distanceForUncertaintyModel = Math.abs(zenith) > SQRT_EPS ? distanceForUncertaintyModel * Math.sin(zenith) : distanceForUncertaintyModel * Math.sin(SQRT_EPS);
                                }
                                this.zenithAngles.add(zenithAngles);
                            }
                        } else if (dist2d != null) {
                            distanceForUncertaintyModel = dist2d;
                            TerrestrialObservationRow horizontalDistances = new TerrestrialObservationRow();
                            horizontalDistances.setInstrumentHeight(setup.getInstrumentHeight());
                            horizontalDistances.setStartPointName(setup.getSetupPointName());
                            horizontalDistances.setReflectorHeight(th);
                            horizontalDistances.setEndPointName(endPointName);
                            horizontalDistances.setValueApriori(dist2d);
                            horizontalDistances.setDistanceApriori(distanceForUncertaintyModel);
                            if (dist2d > 0.0) {
                                this.horizontalDistances.add(horizontalDistances);
                            }
                        }
                        if (dir != null) {
                            distanceForUncertaintyModel = dist2d != null && dist2d > 0.0 ? dist2d : distanceForUncertaintyModel;
                            TerrestrialObservationRow directions = new TerrestrialObservationRow();
                            directions.setInstrumentHeight(setup.getInstrumentHeight());
                            directions.setStartPointName(setup.getSetupPointName());
                            directions.setReflectorHeight(th);
                            directions.setEndPointName(endPointName);
                            directions.setValueApriori(dir);
                            if (distanceForUncertaintyModel > 0.0) {
                                directions.setDistanceApriori(distanceForUncertaintyModel);
                            }
                            this.directions.add(directions);
                        }
                    }
                    ++i2;
                }
                this.saveObservationGroups(false);
            }
            xpathPattern = "//landxml:LandXML/landxml:Survey//landxml:GPSVector";
            nodeList = (NodeList)XMLUtilities.xpathSearch(document, xpathPattern, (NamespaceContext)namespaceContext, XPathConstants.NODESET);
            int i3 = 0;
            while (i3 < nodeList.getLength()) {
                String endPointName;
                Node node = nodeList.item(i3);
                NamedNodeMap attr = node.getAttributes();
                String startPointName = attr.getNamedItem("setupID_A") == null ? null : attr.getNamedItem("setupID_A").getNodeValue();
                String string = endPointName = attr.getNamedItem("setupID_B") == null ? null : attr.getNamedItem("setupID_B").getNodeValue();
                if (startPointName != null && endPointName != null) {
                    xpathPattern = "//landxml:LandXML/landxml:Survey//landxml:GPSSetup[@id=\"%s\"]//landxml:TargetPoint[1]";
                    Node startNode = (Node)XMLUtilities.xpathSearch(document, String.format(Locale.ENGLISH, xpathPattern, startPointName), (NamespaceContext)namespaceContext, XPathConstants.NODE);
                    Node targetNode = (Node)XMLUtilities.xpathSearch(document, String.format(Locale.ENGLISH, xpathPattern, endPointName), (NamespaceContext)namespaceContext, XPathConstants.NODE);
                    if (startNode != null && targetNode != null) {
                        startPointName = startNode.getAttributes().getNamedItem("name") == null ? null : startNode.getAttributes().getNamedItem("name").getNodeValue();
                        String string3 = endPointName = targetNode.getAttributes().getNamedItem("name") == null ? null : targetNode.getAttributes().getNamedItem("name").getNodeValue();
                        if (startPointName != null && endPointName != null) {
                            String[] startPointContent = startNode.getFirstChild().getNodeValue().trim().split("\\s+");
                            String[] targetPointContent = targetNode.getFirstChild().getNodeValue().trim().split("\\s+");
                            int vecdim = Math.min(Math.min(startPointContent.length, targetPointContent.length), this.dim == DimensionType.PLAN ? 2 : 3);
                            double[] sxyz = new double[vecdim];
                            double[] txyz = new double[vecdim];
                            try {
                                int p = 0;
                                while (p < vecdim) {
                                    sxyz[p] = this.convertToMeter(Double.parseDouble(startPointContent[p]));
                                    txyz[p] = this.convertToMeter(Double.parseDouble(targetPointContent[p]));
                                    ++p;
                                }
                            }
                            catch (NumberFormatException e) {
                                sxyz = null;
                                txyz = null;
                            }
                            if (sxyz != null && txyz != null) {
                                GNSSObservationRow gnss = new GNSSObservationRow();
                                gnss.setStartPointName(startPointName);
                                gnss.setEndPointName(endPointName);
                                if (vecdim != 1) {
                                    gnss.setXApriori(this.convertToMeter(txyz[0] - sxyz[0]));
                                    gnss.setYApriori(this.convertToMeter(txyz[1] - sxyz[1]));
                                }
                                if (vecdim != 2) {
                                    gnss.setZApriori(this.convertToMeter(txyz[vecdim - 1] - sxyz[vecdim - 1]));
                                }
                                if (vecdim == 2) {
                                    this.gnss2D.add(gnss);
                                } else {
                                    this.gnss3D.add(gnss);
                                }
                            }
                        }
                    }
                }
                ++i3;
            }
            String itemName = this.createItemName(null, null);
            if (!this.points2d.isEmpty()) {
                this.lastTreeItem = this.savePoints(itemName, TreeItemType.DATUM_POINT_2D_LEAF, this.points2d);
            }
            if (this.dim == DimensionType.SPATIAL && !this.points3d.isEmpty()) {
                this.lastTreeItem = this.savePoints(itemName, TreeItemType.DATUM_POINT_3D_LEAF, this.points3d);
            }
            this.saveObservationGroups(true);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.isValidDocument = false;
            throw new IOException(e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.isValidDocument = false;
            throw new SQLException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isValidDocument = false;
            throw new IOException(e);
        }
        this.reset();
        return this.lastTreeItem;
    }

    public static FileChooser.ExtensionFilter[] getExtensionFilters() {
        return new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18N.getInstance().getString("HeXMLReader.extension.hexml", "LandXML/HeXML"), new String[]{"*.hexml", "*.HEXML"}), new FileChooser.ExtensionFilter(I18N.getInstance().getString("HeXMLReader.extension.xml", "Extensible Markup Language"), new String[]{"*.xml", "*.XML"}), new FileChooser.ExtensionFilter(I18N.getInstance().getString("FlatFileReader.extension", "All files"), new String[]{"*.*"})};
    }

    private void saveObservationGroups(boolean forceSaving) throws SQLException {
        if (!this.directions.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.DIRECTION))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.DIRECTION_LEAF, this.directions);
        }
        if (!this.horizontalDistances.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.HORIZONTAL_DISTANCE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.HORIZONTAL_DISTANCE_LEAF, this.horizontalDistances);
        }
        if (this.dim == DimensionType.SPATIAL && !this.slopeDistances.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.SLOPE_DISTANCE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.SLOPE_DISTANCE_LEAF, this.slopeDistances);
        }
        if (this.dim == DimensionType.SPATIAL && !this.zenithAngles.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.ZENITH_ANGLE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.ZENITH_ANGLE_LEAF, this.zenithAngles);
        }
        if (!this.gnss2D.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.GNSS2D))) {
            this.lastTreeItem = this.saveGNSSGroup(TreeItemType.GNSS_2D_LEAF, this.gnss2D);
        }
        if (this.dim == DimensionType.SPATIAL && !this.gnss3D.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.GNSS3D))) {
            this.lastTreeItem = this.saveGNSSGroup(TreeItemType.GNSS_3D_LEAF, this.gnss3D);
        }
    }

    private TreeItem<TreeItemValue> saveObservationGroup(TreeItemType itemType, List<TerrestrialObservationRow> observations) throws SQLException {
        TreeItem<TreeItemValue> treeItem = null;
        if (!observations.isEmpty()) {
            boolean isGroupWithEqualStation = ImportOption.getInstance().isGroupSeparation(TreeItemType.getObservationTypeByTreeItemType(itemType));
            String itemName = this.createItemName(null, isGroupWithEqualStation && observations.get(0).getStartPointName() != null ? " (" + observations.get(0).getStartPointName() + ")" : null);
            treeItem = this.saveTerrestrialObservations(itemName, itemType, observations);
        }
        observations.clear();
        return treeItem;
    }

    private TreeItem<TreeItemValue> saveGNSSGroup(TreeItemType itemType, List<GNSSObservationRow> observations) throws SQLException {
        TreeItem<TreeItemValue> treeItem = null;
        if (!observations.isEmpty()) {
            boolean isGroupWithEqualStation = ImportOption.getInstance().isGroupSeparation(TreeItemType.getObservationTypeByTreeItemType(itemType));
            String itemName = this.createItemName(null, isGroupWithEqualStation && observations.get(0).getStartPointName() != null ? " (" + observations.get(0).getStartPointName() + ")" : null);
            treeItem = this.saveGNSSObservations(itemName, itemType, observations);
        }
        observations.clear();
        return treeItem;
    }

    private TreeItem<TreeItemValue> saveTerrestrialObservations(String itemName, TreeItemType treeItemType, List<TerrestrialObservationRow> observations) throws SQLException {
        if (observations == null || observations.isEmpty()) {
            return null;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(treeItemType);
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, -1, itemName, true, false);
        try {
            SQLManager.getInstance().saveGroup((ObservationTreeItemValue)newTreeItem.getValue());
        }
        catch (SQLException e) {
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            throw new SQLException(e);
        }
        try {
            int groupId = ((ObservationTreeItemValue)newTreeItem.getValue()).getGroupId();
            for (TerrestrialObservationRow row : observations) {
                row.setGroupId(groupId);
                SQLManager.getInstance().saveItem(row);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
        return newTreeItem;
    }

    private TreeItem<TreeItemValue> saveGNSSObservations(String itemName, TreeItemType treeItemType, List<GNSSObservationRow> gnssObservations) throws SQLException {
        if (gnssObservations == null || gnssObservations.isEmpty()) {
            return null;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(treeItemType);
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, -1, itemName, true, false);
        try {
            SQLManager.getInstance().saveGroup((ObservationTreeItemValue)newTreeItem.getValue());
        }
        catch (SQLException e) {
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            throw new SQLException(e);
        }
        try {
            int groupId = ((ObservationTreeItemValue)newTreeItem.getValue()).getGroupId();
            for (GNSSObservationRow row : gnssObservations) {
                row.setGroupId(groupId);
                SQLManager.getInstance().saveItem(row);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
        return newTreeItem;
    }

    private TreeItem<TreeItemValue> savePoints(String itemName, TreeItemType treeItemType, List<PointRow> points) throws SQLException {
        if (points == null || points.isEmpty()) {
            return null;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(treeItemType);
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, -1, itemName, true, false);
        try {
            SQLManager.getInstance().saveGroup((PointTreeItemValue)newTreeItem.getValue());
        }
        catch (SQLException e) {
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            throw new SQLException(e);
        }
        try {
            int groupId = ((PointTreeItemValue)newTreeItem.getValue()).getGroupId();
            for (PointRow row : points) {
                row.setGroupId(groupId);
                SQLManager.getInstance().saveItem(row);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
        return newTreeItem;
    }

    private class InstrumentSetup {
        private String instrPointName;
        private double ih;

        public InstrumentSetup(String instrPointName, double ih) {
            this.instrPointName = instrPointName;
            this.ih = ih;
        }

        public double getInstrumentHeight() {
            return this.ih;
        }

        public String getSetupPointName() {
            return this.instrPointName;
        }

        public String toString() {
            return "InstrumentSetup [instrPointName=" + this.instrPointName + ", ih=" + this.ih + "]";
        }
    }
}

