/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.io.reader;

class LevelingData {
    private Double r1 = null;
    private Double r2 = null;
    private Double dr1 = null;
    private Double dr2 = null;
    private Double v1 = null;
    private Double v2 = null;
    private Double dv1 = null;
    private Double dv2 = null;
    private String startPointName = null;
    private String endPointName = null;

    LevelingData() {
    }

    public void addBackSightReading(String name, double r, double d) {
        this.addBackSightReading(name, r, d, this.r1 == null);
    }

    public void addForeSightReading(String name, double v, double d) {
        this.addForeSightReading(name, v, d, this.v1 == null);
    }

    public void addForeSightReading(String name, double v, double d, boolean isFirstForeSightReading) {
        if (isFirstForeSightReading) {
            this.endPointName = name;
            this.v1 = v;
            this.dv1 = d;
        } else if (!isFirstForeSightReading && (name == null || name.isBlank() || this.endPointName.equals(name))) {
            this.v2 = v;
            this.dv2 = d;
        }
    }

    public void addBackSightReading(String name, double r, double d, boolean isFirstBackSightReading) {
        if (isFirstBackSightReading) {
            this.startPointName = name;
            this.r1 = r;
            this.dr1 = d;
        } else if (!isFirstBackSightReading && (name == null || name.isBlank() || this.startPointName.equals(name))) {
            this.r2 = r;
            this.dr2 = d;
        }
    }

    public double getDistance() {
        double dr = 0.0;
        double dv = 0.0;
        if (this.dr1 != null && this.dr2 != null && this.dr1 > 0.0 && this.dr2 > 0.0) {
            dr = 0.5 * (this.dr1 + this.dr2);
        } else if (this.dr1 != null && this.dr1 > 0.0) {
            dr = this.dr1;
        }
        if (this.dv1 != null && this.dv2 != null && this.dv1 > 0.0 && this.dv2 > 0.0) {
            dv = 0.5 * (this.dv1 + this.dv2);
        } else if (this.dv1 != null && this.dv1 > 0.0) {
            dv = this.dv1;
        }
        return dr + dv;
    }

    public double getDeltaH() {
        double r = 0.0;
        double v = 0.0;
        if (this.r1 != null && this.r2 != null) {
            r = 0.5 * (this.r1 + this.r2);
        } else if (this.r1 != null) {
            r = this.r1;
        }
        if (this.v1 != null && this.v2 != null) {
            v = 0.5 * (this.v1 + this.v2);
        } else if (this.v1 != null) {
            v = this.v1;
        }
        return r - v;
    }

    public String getStartPointName() {
        return this.startPointName;
    }

    public String getEndPointName() {
        return this.endPointName;
    }

    public String toString() {
        return "LevelingData [startPointName=" + this.startPointName + " - endPointName=" + this.endPointName + ", r1=" + String.valueOf(this.r1) + ", r2=" + String.valueOf(this.r2) + ", dr1=" + String.valueOf(this.dr1) + ", dr2=" + String.valueOf(this.dr2) + ", v1=" + String.valueOf(this.v1) + ", v2=" + String.valueOf(this.v2) + ", dv1=" + String.valueOf(this.dv1) + ", dv2=" + String.valueOf(this.dv2) + "]";
    }

    public boolean hasFirstBackSightReading() {
        return this.r1 != null;
    }

    public boolean hasSecondBackSightReading() {
        return this.r2 != null;
    }

    public boolean hasFirstForeSightReading() {
        return this.v1 != null;
    }

    public boolean hasSecondForeSightReading() {
        return this.v2 != null;
    }
}

