/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.io.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.scene.control.TreeItem;
import javafx.stage.FileChooser;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.io.reader.DimensionType;
import org.applied_geodesy.jag3d.ui.io.reader.ImportOption;
import org.applied_geodesy.jag3d.ui.io.reader.LevelingData;
import org.applied_geodesy.jag3d.ui.table.row.PointRow;
import org.applied_geodesy.jag3d.ui.table.row.TerrestrialObservationRow;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.PointTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.util.io.SourceFileReader;

public class GSIFileReader
extends SourceFileReader<TreeItem<TreeItemValue>> {
    private final DimensionType dim;
    private boolean isNewStation = false;
    private boolean isNewLevelingLine = false;
    private Set<String> reservedNames = null;
    private Map<String, PointRow> pointMap = new HashMap<String, PointRow>();
    private String startPointName = null;
    private String endPointName = null;
    private String lastStartPointName = null;
    private String lastLevelingLineName = null;
    private String lastPointNameForeSightReading = null;
    private LevelingData levelingData = null;
    private double ih = 0.0;
    private double th = 0.0;
    private Double rb1 = null;
    private Double vb1 = null;
    private Double distRb1 = null;
    private Double distVb1 = null;
    private Double rb2 = null;
    private Double vb2 = null;
    private Double distRb2 = null;
    private Double distVb2 = null;
    private Double zb = null;
    private Double distZb = null;
    private Double lastRb4Zb = null;
    private Double distLastRb4Zb;
    private long cnt = 0L;
    private List<PointRow> points1d = null;
    private List<PointRow> points2d = null;
    private List<PointRow> points3d = null;
    private List<TerrestrialObservationRow> leveling = null;
    private List<TerrestrialObservationRow> horizontalDistances = null;
    private List<TerrestrialObservationRow> directions = null;
    private List<TerrestrialObservationRow> slopeDistances = null;
    private List<TerrestrialObservationRow> zenithAngles = null;
    private TreeItem<TreeItemValue> lastTreeItem = null;

    public GSIFileReader(DimensionType dim) {
        this.dim = dim;
        this.reset();
    }

    public GSIFileReader(Path p, DimensionType dim) {
        super(p);
        this.dim = dim;
        this.reset();
    }

    public GSIFileReader(File f, DimensionType dim) {
        this(f.toPath(), dim);
    }

    public GSIFileReader(String s, DimensionType dim) {
        this(new File(s), dim);
    }

    @Override
    public void reset() {
        this.isNewStation = false;
        this.isNewLevelingLine = false;
        this.startPointName = null;
        this.endPointName = null;
        this.ih = 0.0;
        this.th = 0.0;
        this.rb1 = null;
        this.vb1 = null;
        this.rb2 = null;
        this.vb2 = null;
        this.zb = null;
        this.distRb1 = null;
        this.distVb1 = null;
        this.distRb2 = null;
        this.distVb2 = null;
        this.distZb = null;
        this.lastRb4Zb = null;
        this.distLastRb4Zb = null;
        this.levelingData = null;
        if (this.points1d == null) {
            this.points1d = new ArrayList<PointRow>();
        }
        if (this.points2d == null) {
            this.points2d = new ArrayList<PointRow>();
        }
        if (this.points3d == null) {
            this.points3d = new ArrayList<PointRow>();
        }
        if (this.leveling == null) {
            this.leveling = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.horizontalDistances == null) {
            this.horizontalDistances = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.directions == null) {
            this.directions = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.slopeDistances == null) {
            this.slopeDistances = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.zenithAngles == null) {
            this.zenithAngles = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.reservedNames == null) {
            this.reservedNames = new HashSet<String>();
        }
        this.reservedNames.clear();
        this.points1d.clear();
        this.points2d.clear();
        this.points3d.clear();
        this.leveling.clear();
        this.horizontalDistances.clear();
        this.directions.clear();
        this.slopeDistances.clear();
        this.zenithAngles.clear();
        this.cnt = 0L;
    }

    @Override
    public TreeItem<TreeItemValue> readAndImport() throws IOException, SQLException {
        this.reset();
        this.reservedNames = SQLManager.getInstance().getFullPointNameSet();
        this.lastTreeItem = null;
        this.ignoreLinesWhichStartWith("#");
        super.read();
        String itemName = this.createItemName(null, null);
        if (!(this.dim != DimensionType.HEIGHT && this.dim != DimensionType.PLAN_AND_HEIGHT || this.points1d.isEmpty())) {
            this.lastTreeItem = this.savePoints(itemName, TreeItemType.DATUM_POINT_1D_LEAF, this.points1d);
        }
        if (!(this.dim != DimensionType.PLAN && this.dim != DimensionType.PLAN_AND_HEIGHT || this.points2d.isEmpty())) {
            this.lastTreeItem = this.savePoints(itemName, TreeItemType.DATUM_POINT_2D_LEAF, this.points2d);
        }
        if (!(this.dim != DimensionType.SPATIAL && this.dim != DimensionType.PLAN_AND_HEIGHT || this.points3d.isEmpty())) {
            this.lastTreeItem = this.savePoints(itemName, TreeItemType.DATUM_POINT_3D_LEAF, this.points3d);
        }
        this.saveObservationGroups(true);
        this.reset();
        return this.lastTreeItem;
    }

    @Override
    public void parse(String line) throws SQLException {
        int gsiType;
        int n = gsiType = ((String)(line = ((String)line).trim() + " ")).startsWith("*") ? 16 : 8;
        if (gsiType == 16) {
            line = ((String)line).substring(1);
        }
        String pointName = null;
        String pointCode = "";
        Double ih = null;
        Double th = null;
        Double deltaH = null;
        Double dir = null;
        Double dist2d = null;
        Double dist3d = null;
        Double zenith = null;
        Double x = null;
        Double y = null;
        Double z = null;
        int startIdx = 0;
        int endIdx = 7 + gsiType;
        while (endIdx < ((String)line).length()) {
            String dataBlock = ((String)line).substring(startIdx, endIdx);
            startIdx = endIdx + 1;
            endIdx = startIdx + 7 + gsiType;
            int wordIndexLength = dataBlock.charAt(2) == '.' ? 2 : 3;
            try {
                int key = Integer.parseInt(dataBlock.substring(0, wordIndexLength));
                UnitType unit = UnitType.getEnumByValue(dataBlock.charAt(5) == '.' ? -1 : Character.getNumericValue(dataBlock.charAt(5)));
                int sign = dataBlock.charAt(6) == '-' ? -1 : 1;
                String data = dataBlock.substring(7, 7 + gsiType);
                if (key == 11 || key > 100 && key / 10 == 11) {
                    pointName = this.removeLeadingZeros(data).trim();
                    if (!pointName.isBlank()) continue;
                    pointName = "0";
                    continue;
                }
                if (key == 41 || key > 400 && key / 10 == 41) {
                    pointCode = this.removeLeadingZeros(data).trim();
                    this.isNewLevelingLine = pointCode.matches("^\\?\\.*\\d$") && this.dim == DimensionType.HEIGHT;
                    continue;
                }
                if (key == 271 && this.dim == DimensionType.HEIGHT) {
                    this.lastLevelingLineName = this.removeLeadingZeros(data).trim();
                    continue;
                }
                if (!this.isNumericValue(key) || !data.matches("\\d+")) continue;
                if (key == 84 || key == 85 || key == 86 || key == 331 || key == 335) {
                    this.isNewStation = true;
                }
                switch (key) {
                    case 21: {
                        dir = this.convertToTrueValue(unit, sign, data);
                        break;
                    }
                    case 22: {
                        zenith = this.convertToTrueValue(unit, sign, data);
                        break;
                    }
                    case 32: {
                        dist2d = this.convertToTrueValue(unit, sign, data);
                        dist2d = dist2d == 0.0 ? null : dist2d;
                        break;
                    }
                    case 31: {
                        dist3d = this.convertToTrueValue(unit, sign, data);
                        dist3d = dist3d == 0.0 ? null : dist3d;
                        break;
                    }
                    case 33: {
                        deltaH = this.convertToTrueValue(unit, sign, data);
                        break;
                    }
                    case 81: 
                    case 84: {
                        y = this.convertToTrueValue(unit, sign, data);
                        break;
                    }
                    case 82: 
                    case 85: {
                        x = this.convertToTrueValue(unit, sign, data);
                        break;
                    }
                    case 83: 
                    case 86: {
                        z = this.convertToTrueValue(unit, sign, data);
                        break;
                    }
                    case 87: {
                        th = this.convertToTrueValue(unit, sign, data);
                        break;
                    }
                    case 88: {
                        ih = this.convertToTrueValue(unit, sign, data);
                        break;
                    }
                    case 331: {
                        this.lastRb4Zb = this.rb1 = Double.valueOf(this.convertToTrueValue(unit, sign, data));
                        break;
                    }
                    case 335: {
                        this.rb2 = this.convertToTrueValue(unit, sign, data);
                        this.lastRb4Zb = this.lastRb4Zb == null ? this.rb2 : 0.5 * (this.lastRb4Zb + this.rb2);
                        break;
                    }
                    case 332: {
                        this.vb1 = this.convertToTrueValue(unit, sign, data);
                        break;
                    }
                    case 336: {
                        this.vb2 = this.convertToTrueValue(unit, sign, data);
                        break;
                    }
                    case 333: {
                        this.zb = this.convertToTrueValue(unit, sign, data);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.dim != DimensionType.HEIGHT) {
            boolean isFaceI;
            boolean bl = isFaceI = zenith == null || Double.isNaN(zenith) || Double.isInfinite(zenith) || !(zenith > Math.PI);
            if (!isFaceI) {
                if (dir != null) {
                    dir = MathExtension.MOD(dir + Math.PI, Math.PI * 2);
                }
                if (this.dim == DimensionType.SPATIAL && zenith != null && zenith > Math.PI) {
                    zenith = MathExtension.MOD(Math.PI * 2 - zenith, Math.PI * 2);
                }
            }
        }
        if (this.isNewStation && pointName != null && !pointName.isBlank()) {
            this.startPointName = pointName;
            this.endPointName = null;
            this.ih = ih == null ? 0.0 : ih;
            this.th = th == null ? 0.0 : th;
            this.distRb1 = null;
            this.distRb2 = null;
            this.distLastRb4Zb = null;
            this.saveObservationGroups(false);
            this.lastStartPointName = null;
        } else if (pointName != null && !pointName.isBlank()) {
            this.endPointName = pointName;
        } else if (this.isNewLevelingLine) {
            this.saveObservationGroups(this.dim == DimensionType.HEIGHT);
            this.lastLevelingLineName = null;
            this.lastPointNameForeSightReading = null;
        }
        if (this.startPointName != null) {
            this.ih = ih == null ? this.ih : ih;
            double d = this.th = th == null ? this.th : th;
            if (this.rb1 != null && dist2d != null && this.distRb1 == null) {
                this.distRb1 = dist2d;
                this.distLastRb4Zb = dist2d;
                dist2d = null;
            } else if (this.rb2 != null && dist2d != null && this.distRb2 == null) {
                this.distRb2 = dist2d;
                this.distLastRb4Zb = this.distLastRb4Zb == null ? dist2d : 0.5 * (this.distLastRb4Zb + dist2d);
                dist2d = null;
            } else if (this.vb1 != null && dist2d != null && this.distVb1 == null) {
                this.distVb1 = dist2d;
                dist2d = null;
            } else if (this.vb2 != null && dist2d != null && this.distVb2 == null) {
                this.distVb2 = dist2d;
                dist2d = null;
            } else if (this.zb != null && dist2d != null && this.distZb == null) {
                this.distZb = dist2d;
                dist2d = null;
            }
            if (this.startPointName != null && this.endPointName != null) {
                if (this.dim == DimensionType.HEIGHT) {
                    if (this.startPointName.equals("0") && (this.rb1 != null && this.vb1 != null || this.lastRb4Zb != null && this.zb != null) && this.lastPointNameForeSightReading != null && !this.lastPointNameForeSightReading.isBlank()) {
                        this.startPointName = this.lastPointNameForeSightReading;
                    }
                    if (this.endPointName.equals("0") && this.rb1 != null && this.vb1 != null) {
                        this.endPointName = this.lastPointNameForeSightReading = GSIFileReader.generatePointId(++this.cnt);
                    }
                    if (pointName != null && pointName.equals("0") && this.lastPointNameForeSightReading != null && !this.lastPointNameForeSightReading.isBlank()) {
                        pointName = this.lastPointNameForeSightReading;
                    }
                }
                if (this.lastStartPointName == null) {
                    this.lastStartPointName = this.startPointName;
                }
                if (this.lastRb4Zb != null && this.zb != null) {
                    this.addLevelingData(this.levelingData);
                    this.levelingData = null;
                    LevelingData sideLevelingData = new LevelingData();
                    sideLevelingData.addBackSightReading(this.startPointName, this.lastRb4Zb, this.distLastRb4Zb != null ? this.distLastRb4Zb : 0.0, true);
                    sideLevelingData.addForeSightReading(this.endPointName, this.zb, this.distZb != null ? this.distZb : 0.0, true);
                    this.addLevelingData(sideLevelingData);
                    sideLevelingData = null;
                    this.zb = null;
                    this.distZb = null;
                }
                if (this.rb1 != null && this.vb1 != null) {
                    this.addLevelingData(this.levelingData);
                    this.levelingData = null;
                    this.levelingData = new LevelingData();
                    this.levelingData.addBackSightReading(this.startPointName, this.rb1, this.distRb1 != null ? this.distRb1 : 0.0, true);
                    this.levelingData.addForeSightReading(this.endPointName, this.vb1, this.distVb1 != null ? this.distVb1 : 0.0, true);
                    this.vb1 = null;
                    this.rb1 = null;
                    this.distVb1 = null;
                    this.distRb1 = null;
                }
                if (this.levelingData != null && this.rb2 != null && this.vb2 != null) {
                    if (this.startPointName.equals("0")) {
                        this.startPointName = this.levelingData.getStartPointName();
                    }
                    if (this.endPointName.equals("0")) {
                        this.endPointName = this.levelingData.getEndPointName();
                    }
                    this.levelingData.addBackSightReading(this.startPointName, this.rb2, this.distRb2 != null ? this.distRb2 : 0.0, false);
                    this.levelingData.addForeSightReading(this.endPointName, this.vb2, this.distVb2 != null ? this.distVb2 : 0.0, false);
                    this.addLevelingData(this.levelingData);
                    this.levelingData = null;
                    this.vb2 = null;
                    this.rb2 = null;
                    this.distVb2 = null;
                    this.distRb2 = null;
                }
                if (deltaH != null) {
                    TerrestrialObservationRow obs = new TerrestrialObservationRow();
                    obs.setStartPointName(this.startPointName);
                    obs.setEndPointName(this.endPointName);
                    obs.setInstrumentHeight(0.0);
                    obs.setReflectorHeight(0.0);
                    if (dist2d != null && dist2d > 0.0) {
                        obs.setDistanceApriori(dist2d);
                    }
                    obs.setValueApriori(deltaH);
                    this.leveling.add(obs);
                }
                if (dir != null) {
                    TerrestrialObservationRow obs = new TerrestrialObservationRow();
                    obs.setStartPointName(this.startPointName);
                    obs.setEndPointName(this.endPointName);
                    obs.setInstrumentHeight(this.ih);
                    obs.setReflectorHeight(this.th);
                    obs.setValueApriori(dir);
                    if (dist2d != null && dist2d > 0.0) {
                        obs.setDistanceApriori(dist2d);
                    } else if (dist3d != null && dist3d > 0.0) {
                        obs.setDistanceApriori(zenith != null && Math.abs(zenith) > SQRT_EPS ? dist3d * Math.sin(zenith) : (zenith != null ? dist3d * Math.sin(SQRT_EPS) : dist3d));
                    }
                    this.directions.add(obs);
                }
                if (dist2d != null) {
                    TerrestrialObservationRow obs = new TerrestrialObservationRow();
                    obs.setStartPointName(this.startPointName);
                    obs.setEndPointName(this.endPointName);
                    obs.setInstrumentHeight(this.ih);
                    obs.setReflectorHeight(this.th);
                    obs.setValueApriori(dist2d);
                    obs.setDistanceApriori(dist2d);
                    this.horizontalDistances.add(obs);
                }
                if (dist3d != null) {
                    TerrestrialObservationRow obs = new TerrestrialObservationRow();
                    obs.setStartPointName(this.startPointName);
                    obs.setEndPointName(this.endPointName);
                    obs.setInstrumentHeight(this.ih);
                    obs.setReflectorHeight(this.th);
                    obs.setValueApriori(dist3d);
                    obs.setDistanceApriori(dist3d);
                    this.slopeDistances.add(obs);
                }
                if (zenith != null) {
                    TerrestrialObservationRow obs = new TerrestrialObservationRow();
                    obs.setStartPointName(this.startPointName);
                    obs.setEndPointName(this.endPointName);
                    obs.setInstrumentHeight(this.ih);
                    obs.setReflectorHeight(this.th);
                    obs.setValueApriori(zenith);
                    if (dist3d != null && dist3d > 0.0) {
                        obs.setDistanceApriori(dist3d);
                    }
                    this.zenithAngles.add(obs);
                }
            }
        }
        if (pointName != null && !pointName.isBlank()) {
            PointRow point;
            if (!this.reservedNames.contains(pointName) && !this.pointMap.containsKey(pointName)) {
                PointRow point2 = new PointRow();
                point2.setName(pointName);
                point2.setCode(pointCode);
                point2.setXApriori(x);
                point2.setYApriori(y);
                point2.setZApriori(z);
                if ((this.dim == DimensionType.SPATIAL || this.dim == DimensionType.PLAN_AND_HEIGHT) && x != null && y != null && z != null) {
                    this.pointMap.put(pointName, point2);
                    this.points3d.add(point2);
                } else if ((this.dim == DimensionType.PLAN || this.dim == DimensionType.PLAN_AND_HEIGHT) && x != null && y != null) {
                    this.pointMap.put(pointName, point2);
                    this.points2d.add(point2);
                } else if ((this.dim == DimensionType.HEIGHT || this.dim == DimensionType.PLAN_AND_HEIGHT) && z != null) {
                    this.pointMap.put(pointName, point2);
                    this.points1d.add(point2);
                }
            } else if (this.pointMap.containsKey(pointName) && this.hasZerosCoordinates(point = this.pointMap.get(pointName))) {
                if ((this.dim == DimensionType.SPATIAL || this.dim == DimensionType.PLAN_AND_HEIGHT) && x != null && y != null && z != null) {
                    point.setXApriori(x);
                    point.setYApriori(y);
                    point.setZApriori(z);
                } else if ((this.dim == DimensionType.PLAN || this.dim == DimensionType.PLAN_AND_HEIGHT) && x != null && y != null) {
                    point.setXApriori(x);
                    point.setYApriori(y);
                } else if ((this.dim == DimensionType.HEIGHT || this.dim == DimensionType.PLAN_AND_HEIGHT) && z != null) {
                    point.setZApriori(z);
                }
            }
        }
        this.isNewStation = false;
        this.isNewLevelingLine = false;
    }

    private boolean hasZerosCoordinates(PointRow point) {
        Double x = point.getXApriori();
        Double y = point.getYApriori();
        Double z = point.getZApriori();
        if (x != null && x != 0.0) {
            return false;
        }
        if (y != null && y != 0.0) {
            return false;
        }
        return z == null || z == 0.0;
    }

    private double convertToTrueValue(UnitType unit, int sign, String data) throws NumberFormatException {
        data = this.removeLeadingZeros(data);
        double value = 0.0;
        if (!data.isEmpty()) {
            value = Double.parseDouble(data);
        }
        switch (unit) {
            case METER: {
                value /= 1000.0;
                break;
            }
            case FEET: {
                value = value / 1000.0 * 0.3048;
                break;
            }
            case GRADIAN: {
                value = value / 100000.0 * 0.015707963267948967;
                break;
            }
            case DECIMAL_DEGREE: {
                value = value / 100000.0 * (Math.PI / 180);
                break;
            }
            case SEXAGESIMAL_DEGREE: {
                double dd = (int)value / 100000;
                double mm = (int)(value -= dd * 100000.0) / 1000;
                double ss = (value -= mm * 1000.0) / 10.0;
                value = (dd + mm / 60.0 + ss / 3600.0) * (Math.PI / 180);
                break;
            }
            case MIL: {
                value = value / 10000.0 * 9.817477042468104E-4;
                break;
            }
            case METER_10: {
                value /= 10000.0;
                break;
            }
            case FEET_10000: {
                value = value / 100000.0 * 0.3048;
                break;
            }
            case METER_100: {
                value /= 100000.0;
                break;
            }
        }
        return (double)sign * value;
    }

    private String removeLeadingZeros(String str) {
        return str.replaceAll("^0+", "");
    }

    private boolean isNumericValue(int key) {
        return !(key % 10 == 0 || key <= 19 || key >= 41 && key <= 49 || key >= 70 && key <= 79);
    }

    public static FileChooser.ExtensionFilter[] getExtensionFilters() {
        return new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18N.getInstance().getString("GSIFileReader.extension.gsi", "Geo Serial Interface (GSI)"), new String[]{"*.gsi", "*.GSI"}), new FileChooser.ExtensionFilter(I18N.getInstance().getString("FlatFileReader.extension", "All files"), new String[]{"*.*"})};
    }

    private void saveObservationGroups(boolean forceSaving) throws SQLException {
        if (!(this.dim != DimensionType.HEIGHT && this.dim != DimensionType.PLAN_AND_HEIGHT || this.leveling.isEmpty() || !forceSaving && !ImportOption.getInstance().isGroupSeparation(ObservationType.LEVELING))) {
            this.addLevelingData(this.levelingData);
            this.lastPointNameForeSightReading = null;
            this.levelingData = null;
            this.cnt = 0L;
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.LEVELING_LEAF, this.leveling);
        }
        if (this.dim != DimensionType.HEIGHT && !this.directions.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.DIRECTION))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.DIRECTION_LEAF, this.directions);
        }
        if (!(this.dim != DimensionType.PLAN && this.dim != DimensionType.PLAN_AND_HEIGHT || this.horizontalDistances.isEmpty() || !forceSaving && !ImportOption.getInstance().isGroupSeparation(ObservationType.HORIZONTAL_DISTANCE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.HORIZONTAL_DISTANCE_LEAF, this.horizontalDistances);
        }
        if (this.dim == DimensionType.SPATIAL && !this.slopeDistances.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.SLOPE_DISTANCE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.SLOPE_DISTANCE_LEAF, this.slopeDistances);
        }
        if (this.dim == DimensionType.SPATIAL && !this.zenithAngles.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.ZENITH_ANGLE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.ZENITH_ANGLE_LEAF, this.zenithAngles);
        }
    }

    private TreeItem<TreeItemValue> saveObservationGroup(TreeItemType itemType, List<TerrestrialObservationRow> observations) throws SQLException {
        TreeItem<TreeItemValue> treeItem = null;
        if (!observations.isEmpty()) {
            boolean isGroupWithEqualStation = ImportOption.getInstance().isGroupSeparation(TreeItemType.getObservationTypeByTreeItemType(itemType));
            String groupName = null;
            if (this.lastLevelingLineName != null && !this.lastLevelingLineName.isBlank()) {
                groupName = this.lastLevelingLineName;
            } else if (isGroupWithEqualStation && this.lastStartPointName != null) {
                groupName = this.lastStartPointName;
            }
            String itemName = this.createItemName(null, groupName != null ? " (" + groupName + ")" : null);
            treeItem = this.saveTerrestrialObservations(itemName, itemType, observations);
        }
        observations.clear();
        return treeItem;
    }

    private TreeItem<TreeItemValue> saveTerrestrialObservations(String itemName, TreeItemType treeItemType, List<TerrestrialObservationRow> observations) throws SQLException {
        if (observations == null || observations.isEmpty()) {
            return null;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(treeItemType);
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, -1, itemName, true, false);
        try {
            SQLManager.getInstance().saveGroup((ObservationTreeItemValue)newTreeItem.getValue());
        }
        catch (SQLException e) {
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            throw new SQLException(e);
        }
        try {
            int groupId = ((ObservationTreeItemValue)newTreeItem.getValue()).getGroupId();
            for (TerrestrialObservationRow row : observations) {
                row.setGroupId(groupId);
                SQLManager.getInstance().saveItem(row);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
        return newTreeItem;
    }

    private TreeItem<TreeItemValue> savePoints(String itemName, TreeItemType treeItemType, List<PointRow> points) throws SQLException {
        if (points == null || points.isEmpty()) {
            return null;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(treeItemType);
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, -1, itemName, true, false);
        try {
            SQLManager.getInstance().saveGroup((PointTreeItemValue)newTreeItem.getValue());
        }
        catch (SQLException e) {
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            throw new SQLException(e);
        }
        try {
            int groupId = ((PointTreeItemValue)newTreeItem.getValue()).getGroupId();
            for (PointRow row : points) {
                row.setGroupId(groupId);
                SQLManager.getInstance().saveItem(row);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
        return newTreeItem;
    }

    private void addLevelingData(LevelingData levelingData) {
        if (levelingData != null) {
            double dist2D = levelingData.getDistance();
            double deltaH = levelingData.getDeltaH();
            TerrestrialObservationRow obs = new TerrestrialObservationRow();
            obs.setStartPointName(levelingData.getStartPointName());
            obs.setEndPointName(levelingData.getEndPointName());
            obs.setInstrumentHeight(0.0);
            obs.setReflectorHeight(0.0);
            if (dist2D > 0.0) {
                obs.setDistanceApriori(dist2D);
            }
            obs.setValueApriori(deltaH);
            this.leveling.add(obs);
        }
    }

    private static String generatePointId(long cnt) {
        LocalDateTime localDateTime = LocalDateTime.now(ZoneId.of("UTC"));
        long doy = localDateTime.getDayOfYear();
        long musec = localDateTime.getNano() / 1000;
        long sec = localDateTime.getSecond();
        long min = localDateTime.getMinute();
        long hour = localDateTime.getHour();
        long musod = (hour * 3600L + min * 60L + sec) * 1000000L + musec;
        int salt = (int)Math.abs(Math.random() * 1000.0);
        return String.format(Locale.ENGLISH, "%c%04d%03d%011d%03d", Character.valueOf('W'), cnt, doy, musod, salt);
    }

    private static enum UnitType {
        NONE(-1),
        METER(0),
        FEET(1),
        GRADIAN(2),
        DECIMAL_DEGREE(3),
        SEXAGESIMAL_DEGREE(4),
        MIL(5),
        METER_10(6),
        FEET_10000(7),
        METER_100(8);

        private int id;

        private UnitType(int id) {
            this.id = id;
        }

        public static UnitType getEnumByValue(int value) {
            UnitType[] unitTypeArray = UnitType.values();
            int n = unitTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                UnitType element = unitTypeArray[n2];
                if (element.id == value) {
                    return element;
                }
                ++n2;
            }
            return NONE;
        }
    }
}

