/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.io.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.TreeItem;
import javafx.stage.FileChooser;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.io.reader.ImportOption;
import org.applied_geodesy.jag3d.ui.table.row.TerrestrialObservationRow;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.util.io.SourceFileReader;

public class GKAFileReader
extends SourceFileReader<TreeItem<TreeItemValue>> {
    private boolean isNewStation = false;
    private String startPointName = null;
    private String lastStartPointName = null;
    private double ih = 0.0;
    private Double edmRefractiveIndex = null;
    private Double edmCarrierWavelength = null;
    private TreeItem<TreeItemValue> lastTreeItem = null;
    private List<TerrestrialObservationRow> horizontalDistances = null;
    private List<TerrestrialObservationRow> directions = null;
    private List<TerrestrialObservationRow> slopeDistances = null;
    private List<TerrestrialObservationRow> zenithAngles = null;

    public GKAFileReader() {
        this.reset();
    }

    public GKAFileReader(File f) {
        this(f.toPath());
    }

    public GKAFileReader(String s) {
        this(new File(s));
    }

    public GKAFileReader(Path p) {
        super(p);
        this.reset();
    }

    @Override
    public void reset() {
        this.isNewStation = false;
        this.startPointName = null;
        this.lastStartPointName = null;
        this.ih = 0.0;
        if (this.horizontalDistances == null) {
            this.horizontalDistances = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.directions == null) {
            this.directions = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.slopeDistances == null) {
            this.slopeDistances = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.zenithAngles == null) {
            this.zenithAngles = new ArrayList<TerrestrialObservationRow>();
        }
        this.horizontalDistances.clear();
        this.directions.clear();
        this.slopeDistances.clear();
        this.zenithAngles.clear();
    }

    @Override
    public TreeItem<TreeItemValue> readAndImport() throws IOException, SQLException {
        this.lastTreeItem = null;
        this.reset();
        this.ignoreLinesWhichStartWith(";");
        super.read();
        this.saveObservationGroups(true);
        this.reset();
        return this.lastTreeItem;
    }

    @Override
    public void parse(String line) throws SQLException {
        String[] columns;
        if ((line = line.trim()).startsWith("#GNV11")) {
            this.isNewStation = false;
            this.startPointName = null;
            this.edmRefractiveIndex = null;
            this.edmCarrierWavelength = null;
            this.ih = 0.0;
        }
        if (!this.isNewStation && this.startPointName != null && !this.startPointName.isBlank()) {
            TerrestrialObservationRow obs2;
            columns = line.split(",");
            if (columns.length < 15) {
                return;
            }
            String endPointName = columns[1].trim();
            boolean isFaceII = columns[6].equalsIgnoreCase("2");
            double th = 0.0;
            try {
                th = Double.parseDouble(columns[9].trim());
            }
            catch (NumberFormatException e) {
                th = 0.0;
            }
            double prismConst = 0.0;
            double scale = 1.0;
            if (columns.length > 15) {
                try {
                    prismConst = Double.parseDouble(columns[15].trim());
                }
                catch (NumberFormatException e) {
                    prismConst = 0.0;
                }
            }
            if (columns.length > 27) {
                double pressure = 99.99;
                double temperature = 99.99;
                try {
                    pressure = Double.parseDouble(columns[25].trim());
                }
                catch (NumberFormatException e) {
                    pressure = 99.99;
                }
                try {
                    temperature = Double.parseDouble(columns[26].trim());
                }
                catch (NumberFormatException e) {
                    temperature = 99.99;
                }
                scale = this.getFirstVelocityCorrection(temperature, pressure);
                scale = scale > 0.0 ? scale : 1.0;
            }
            double distance = 0.0;
            double zenithAngle = 1.5707963267948966;
            try {
                obs2 = new TerrestrialObservationRow();
                obs2.setStartPointName(this.startPointName);
                obs2.setEndPointName(endPointName);
                obs2.setInstrumentHeight(this.ih);
                obs2.setReflectorHeight(th);
                distance = Double.parseDouble(columns[7].trim());
                if (distance > 0.0 && distance + prismConst > 0.0) {
                    distance = scale * distance + prismConst;
                    obs2.setValueApriori(distance);
                    obs2.setDistanceApriori(distance);
                    this.slopeDistances.add(obs2);
                }
            }
            catch (NumberFormatException obs2) {
                // empty catch block
            }
            try {
                th = Double.parseDouble(columns[14].trim());
            }
            catch (NumberFormatException e) {
                th = 0.0;
            }
            try {
                obs2 = new TerrestrialObservationRow();
                obs2.setStartPointName(this.startPointName);
                obs2.setEndPointName(endPointName);
                obs2.setInstrumentHeight(this.ih);
                obs2.setReflectorHeight(th);
                zenithAngle = Double.parseDouble(columns[12].trim()) * 0.015707963267948967;
                boolean bl = isFaceII = isFaceII || zenithAngle > Math.PI;
                if (isFaceII) {
                    zenithAngle = MathExtension.MOD(Math.PI * 2 - zenithAngle, Math.PI * 2);
                }
                obs2.setValueApriori(zenithAngle);
                if (distance > 0.0) {
                    obs2.setDistanceApriori(distance);
                }
                this.zenithAngles.add(obs2);
            }
            catch (NumberFormatException obs3) {
                // empty catch block
            }
            try {
                obs2 = new TerrestrialObservationRow();
                obs2.setStartPointName(this.startPointName);
                obs2.setEndPointName(endPointName);
                obs2.setInstrumentHeight(this.ih);
                obs2.setReflectorHeight(th);
                double direction = Double.parseDouble(columns[10].trim()) * 0.015707963267948967;
                if (isFaceII) {
                    direction = MathExtension.MOD(direction + Math.PI, Math.PI * 2);
                }
                obs2.setValueApriori(direction);
                if (distance > 0.0) {
                    obs2.setDistanceApriori(Math.abs(zenithAngle) > SQRT_EPS ? distance * Math.sin(zenithAngle) : distance * Math.sin(SQRT_EPS));
                }
                this.directions.add(obs2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.isNewStation) {
            columns = line.split(",");
            if (columns.length < 13) {
                return;
            }
            this.startPointName = columns[1].trim();
            if (this.lastStartPointName == null) {
                this.lastStartPointName = this.startPointName;
            }
            try {
                this.ih = Double.parseDouble(columns[5].trim());
            }
            catch (NumberFormatException e) {
                this.ih = 0.0;
            }
            try {
                this.edmRefractiveIndex = Double.parseDouble(columns[11].trim());
            }
            catch (NumberFormatException e) {
                this.edmRefractiveIndex = null;
            }
            try {
                this.edmCarrierWavelength = Double.parseDouble(columns[12].trim());
            }
            catch (NumberFormatException e) {
                this.edmCarrierWavelength = null;
            }
            this.isNewStation = false;
        }
        if (line.startsWith("#GNV11")) {
            this.saveObservationGroups(false);
            this.lastStartPointName = this.startPointName;
            this.isNewStation = true;
            this.startPointName = null;
            this.edmRefractiveIndex = null;
            this.edmCarrierWavelength = null;
            this.ih = 0.0;
        }
    }

    private void saveObservationGroups(boolean forceSaving) throws SQLException {
        if (!this.directions.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.DIRECTION))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.DIRECTION_LEAF, this.directions);
        }
        if (!this.horizontalDistances.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.HORIZONTAL_DISTANCE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.HORIZONTAL_DISTANCE_LEAF, this.horizontalDistances);
        }
        if (!this.slopeDistances.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.SLOPE_DISTANCE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.SLOPE_DISTANCE_LEAF, this.slopeDistances);
        }
        if (!this.zenithAngles.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.ZENITH_ANGLE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.ZENITH_ANGLE_LEAF, this.zenithAngles);
        }
    }

    private TreeItem<TreeItemValue> saveObservationGroup(TreeItemType itemType, List<TerrestrialObservationRow> observations) throws SQLException {
        TreeItem<TreeItemValue> treeItem = null;
        if (!observations.isEmpty()) {
            boolean isGroupWithEqualStation = ImportOption.getInstance().isGroupSeparation(TreeItemType.getObservationTypeByTreeItemType(itemType));
            String itemName = this.createItemName(null, isGroupWithEqualStation && this.lastStartPointName != null ? " (" + this.lastStartPointName + ")" : null);
            treeItem = this.saveTerrestrialObservations(itemName, itemType, observations);
        }
        observations.clear();
        return treeItem;
    }

    private TreeItem<TreeItemValue> saveTerrestrialObservations(String itemName, TreeItemType treeItemType, List<TerrestrialObservationRow> observations) throws SQLException {
        if (observations == null || observations.isEmpty()) {
            return null;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(treeItemType);
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, -1, itemName, true, false);
        try {
            SQLManager.getInstance().saveGroup((ObservationTreeItemValue)newTreeItem.getValue());
        }
        catch (SQLException e) {
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            throw new SQLException(e);
        }
        try {
            int groupId = ((ObservationTreeItemValue)newTreeItem.getValue()).getGroupId();
            for (TerrestrialObservationRow row : observations) {
                row.setGroupId(groupId);
                SQLManager.getInstance().saveItem(row);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
        return newTreeItem;
    }

    public static FileChooser.ExtensionFilter[] getExtensionFilters() {
        return new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18N.getInstance().getString("GKAFileReader.extension.gka", "GKA (Trimble)"), new String[]{"*.gka", "*.GKA"}), new FileChooser.ExtensionFilter(I18N.getInstance().getString("FlatFileReader.extension", "All files"), new String[]{"*.*"})};
    }

    private double getFirstVelocityCorrection(double temperature, double pressure) {
        if (this.edmCarrierWavelength == null || this.edmRefractiveIndex == null || pressure == 99.99 || temperature == 99.99) {
            return 1.0;
        }
        return 1.0 + (this.edmRefractiveIndex - this.edmCarrierWavelength * pressure / (temperature + 273.16)) * 1.0E-6;
    }
}

