/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.io.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.scene.control.TreeItem;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.io.reader.FlatFileReader;
import org.applied_geodesy.jag3d.ui.table.row.CongruenceAnalysisRow;
import org.applied_geodesy.jag3d.ui.tree.CongruenceAnalysisTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;

public class CongruenceAnalysisFlatFileReader
extends FlatFileReader<TreeItem<TreeItemValue>> {
    private Set<CongruenceAnalysisPointPair> reservedNamePairs = null;
    private final TreeItemType treeItemType;
    private List<CongruenceAnalysisRow> congruenceAnalysisPairs = null;

    public CongruenceAnalysisFlatFileReader(int dimension) {
        this.treeItemType = TreeItemType.getTreeItemTypeByCongruenceAnalysisDimension(dimension);
        if (this.treeItemType == null) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, dimension could not be transformed to tree item type. " + dimension);
        }
        this.reset();
    }

    public CongruenceAnalysisFlatFileReader(String fileName, int dimension) {
        this(new File(fileName).toPath(), dimension);
    }

    public CongruenceAnalysisFlatFileReader(File sf, int dimension) {
        this(sf.toPath(), dimension);
    }

    public CongruenceAnalysisFlatFileReader(Path path, int dimension) {
        super(path);
        this.treeItemType = TreeItemType.getTreeItemTypeByCongruenceAnalysisDimension(dimension);
        if (this.treeItemType == null) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, dimension could not be transformed to tree item type. " + dimension);
        }
        this.reset();
    }

    @Override
    public void reset() {
        if (this.congruenceAnalysisPairs == null) {
            this.congruenceAnalysisPairs = new ArrayList<CongruenceAnalysisRow>();
        }
        if (this.reservedNamePairs == null) {
            this.reservedNamePairs = new HashSet<CongruenceAnalysisPointPair>();
        }
        this.congruenceAnalysisPairs.clear();
        this.reservedNamePairs.clear();
    }

    @Override
    public TreeItem<TreeItemValue> readAndImport() throws IOException, SQLException {
        this.reset();
        this.ignoreLinesWhichStartWith("#");
        TreeItem<TreeItemValue> newTreeItem = null;
        super.read();
        if (!this.congruenceAnalysisPairs.isEmpty()) {
            String itemName = this.createItemName(null, null);
            TreeItemType parentType = TreeItemType.getDirectoryByLeafType(this.treeItemType);
            newTreeItem = UITreeBuilder.getInstance().addItem(parentType, -1, itemName, true, false);
            try {
                SQLManager.getInstance().saveGroup((CongruenceAnalysisTreeItemValue)newTreeItem.getValue());
            }
            catch (SQLException e) {
                UITreeBuilder.getInstance().removeItem(newTreeItem);
                e.printStackTrace();
                throw new SQLException(e);
            }
            try {
                int groupId = ((CongruenceAnalysisTreeItemValue)newTreeItem.getValue()).getGroupId();
                if (!this.congruenceAnalysisPairs.isEmpty()) {
                    for (CongruenceAnalysisRow row : this.congruenceAnalysisPairs) {
                        row.setGroupId(groupId);
                        SQLManager.getInstance().saveItem(row);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException(e);
            }
        }
        this.reset();
        return newTreeItem;
    }

    @Override
    public void parse(String line) {
        line = line.trim();
        CongruenceAnalysisRow congruenceAnalysisRow = null;
        try {
            congruenceAnalysisRow = CongruenceAnalysisRow.scan(line);
            if (congruenceAnalysisRow == null) {
                return;
            }
            String name1 = congruenceAnalysisRow.getNameInReferenceEpoch();
            String name2 = congruenceAnalysisRow.getNameInControlEpoch();
            if (name1 == null || name2 == null || name1.isBlank() || name2.isBlank() || name1.equals(name2)) {
                return;
            }
            CongruenceAnalysisPointPair pair = new CongruenceAnalysisPointPair(name1.trim(), name2.trim());
            if (!this.reservedNamePairs.contains(pair)) {
                this.congruenceAnalysisPairs.add(congruenceAnalysisRow);
                this.reservedNamePairs.add(pair);
            }
        }
        catch (Exception err) {
            return;
        }
    }

    private class CongruenceAnalysisPointPair {
        private final String name1;
        private final String name2;

        private CongruenceAnalysisPointPair(String name1, String name2) {
            this.name1 = name1;
            this.name2 = name2;
        }

        public int hashCode() {
            return this.name1.hashCode() + this.name2.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CongruenceAnalysisPointPair)) {
                return false;
            }
            CongruenceAnalysisPointPair other = (CongruenceAnalysisPointPair)obj;
            return this.name1.equals(other.name1) && this.name2.equals(other.name2) || this.name1.equals(other.name2) && this.name2.equals(other.name1);
        }
    }
}

