/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.io.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javafx.scene.control.TreeItem;
import org.applied_geodesy.adjustment.network.VerticalDeflectionType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.table.row.VerticalDeflectionRow;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.jag3d.ui.tree.VerticalDeflectionTreeItemValue;
import org.applied_geodesy.util.FormatterOptions;
import org.applied_geodesy.util.io.SourceFileReader;
import org.applied_geodesy.util.io.csv.CSVColumnType;
import org.applied_geodesy.util.io.csv.ColumnRange;

public class ColumnDefinedVerticalDeflectionFileReader
extends SourceFileReader<TreeItem<TreeItemValue>> {
    private final String tabulator;
    private final VerticalDeflectionType verticalDeflectionType;
    private Set<String> reservedNames = null;
    private TreeItemType treeItemType;
    private List<VerticalDeflectionRow> verticalDeflections = null;
    private FormatterOptions options = FormatterOptions.getInstance();
    private NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private int lastCharacterPosition = 0;
    private List<ColumnRange> columnRanges = new ArrayList<ColumnRange>(0);

    public ColumnDefinedVerticalDeflectionFileReader(VerticalDeflectionType verticalDeflectionType, String tabulator) {
        this.verticalDeflectionType = verticalDeflectionType;
        this.tabulator = tabulator;
        this.treeItemType = TreeItemType.getTreeItemTypeByVerticalDeflectionType(verticalDeflectionType);
        if (this.treeItemType == null) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, observation type could not be transformed to tree item type. " + String.valueOf((Object)verticalDeflectionType));
        }
        this.reset();
    }

    public ColumnDefinedVerticalDeflectionFileReader(String fileName, VerticalDeflectionType verticalDeflectionType, String tabulator) {
        this(new File(fileName).toPath(), verticalDeflectionType, tabulator);
    }

    public ColumnDefinedVerticalDeflectionFileReader(File sf, VerticalDeflectionType verticalDeflectionType, String tabulator) {
        this(sf.toPath(), verticalDeflectionType, tabulator);
    }

    public ColumnDefinedVerticalDeflectionFileReader(Path path, VerticalDeflectionType verticalDeflectionType, String tabulator) {
        super(path);
        this.verticalDeflectionType = verticalDeflectionType;
        this.tabulator = tabulator;
        this.treeItemType = TreeItemType.getTreeItemTypeByVerticalDeflectionType(verticalDeflectionType);
        if (this.treeItemType == null) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, observation type could not be transformed to tree item type. " + String.valueOf((Object)verticalDeflectionType));
        }
        this.reset();
    }

    public void setColumnRanges(List<ColumnRange> columnRanges) {
        this.columnRanges = columnRanges;
    }

    public void setFileLocale(Locale locale) {
        this.numberFormat = NumberFormat.getNumberInstance(locale);
    }

    @Override
    public void reset() {
        if (this.verticalDeflections == null) {
            this.verticalDeflections = new ArrayList<VerticalDeflectionRow>();
        }
        if (this.reservedNames == null) {
            this.reservedNames = new HashSet<String>();
        }
        this.verticalDeflections.clear();
        this.reservedNames.clear();
        this.lastCharacterPosition = 0;
    }

    @Override
    public TreeItem<TreeItemValue> readAndImport() throws IOException, SQLException {
        this.reset();
        this.ignoreLinesWhichStartWith("#");
        this.reservedNames = SQLManager.getInstance().getFullPointNameSet();
        TreeItem<TreeItemValue> newTreeItem = null;
        boolean hasXComponent = false;
        boolean hasYComponent = false;
        for (ColumnRange range : this.columnRanges) {
            this.lastCharacterPosition = Math.max(this.lastCharacterPosition, range.getColumnEnd() + 1);
            if (range.getType() == CSVColumnType.X) {
                hasXComponent = true;
                continue;
            }
            if (range.getType() != CSVColumnType.Y) continue;
            hasYComponent = true;
        }
        if (hasXComponent && hasYComponent) {
            super.read();
            if (!this.verticalDeflections.isEmpty()) {
                this.treeItemType = TreeItemType.getTreeItemTypeByVerticalDeflectionType(this.verticalDeflectionType);
                String itemName = this.createItemName(null, null);
                TreeItemType parentType = TreeItemType.getDirectoryByLeafType(this.treeItemType);
                newTreeItem = UITreeBuilder.getInstance().addItem(parentType, -1, itemName, true, false);
                try {
                    SQLManager.getInstance().saveGroup((VerticalDeflectionTreeItemValue)newTreeItem.getValue());
                }
                catch (SQLException e) {
                    UITreeBuilder.getInstance().removeItem(newTreeItem);
                    e.printStackTrace();
                    throw new SQLException(e);
                }
                try {
                    int groupId = ((VerticalDeflectionTreeItemValue)newTreeItem.getValue()).getGroupId();
                    for (VerticalDeflectionRow row : this.verticalDeflections) {
                        row.setGroupId(groupId);
                        SQLManager.getInstance().saveItem(row);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new SQLException(e);
                }
            }
        }
        this.reset();
        return newTreeItem;
    }

    @Override
    public void parse(String line) throws SQLException {
        line = String.format("%" + this.lastCharacterPosition + "s", line.replaceAll("\t", this.tabulator));
        VerticalDeflectionRow row = new VerticalDeflectionRow();
        block9: for (ColumnRange range : this.columnRanges) {
            try {
                CSVColumnType type = range.getType();
                int startPos = range.getColumnStart();
                int endPos = range.getColumnEnd() + 1;
                switch (type) {
                    case POINT_ID: {
                        String name = line.substring(startPos, endPos).trim();
                        if (name == null || name.isBlank()) continue block9;
                        row.setName(name);
                        break;
                    }
                    case X: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setXApriori(this.options.convertAngleToModel(value));
                        break;
                    }
                    case Y: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setYApriori(this.options.convertAngleToModel(value));
                        break;
                    }
                    case UNCERTAINTY_X: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setSigmaXapriori(this.options.convertAngleToModel(value));
                        break;
                    }
                    case UNCERTAINTY_Y: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setSigmaYapriori(this.options.convertAngleToModel(value));
                        break;
                    }
                    default: {
                        System.err.println(this.getClass().getSimpleName() + " Error, unsupported column type! " + String.valueOf((Object)type));
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (row.getName() != null && !row.getName().isBlank() && !this.reservedNames.contains(row.getName()) && row.getXApriori() != null && row.getYApriori() != null) {
            this.verticalDeflections.add(row);
            this.reservedNames.add(row.getName());
        }
    }
}

