/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.io.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javafx.scene.control.TreeItem;
import org.applied_geodesy.adjustment.network.PointType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.table.row.PointRow;
import org.applied_geodesy.jag3d.ui.tree.PointTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.util.FormatterOptions;
import org.applied_geodesy.util.io.SourceFileReader;
import org.applied_geodesy.util.io.csv.CSVColumnType;
import org.applied_geodesy.util.io.csv.ColumnRange;

public class ColumnDefinedPointFileReader
extends SourceFileReader<TreeItem<TreeItemValue>> {
    private final String tabulator;
    private final PointType pointType;
    private Set<String> reservedNames = null;
    private TreeItemType treeItemType;
    private List<PointRow> points = null;
    private FormatterOptions options = FormatterOptions.getInstance();
    private NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private int lastCharacterPosition = 0;
    private List<ColumnRange> columnRanges = new ArrayList<ColumnRange>(0);

    public ColumnDefinedPointFileReader(PointType pointType, String tabulator) {
        this.pointType = pointType;
        this.tabulator = tabulator;
        this.treeItemType = TreeItemType.getTreeItemTypeByPointType(pointType, 3);
        if (this.treeItemType == null) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, observation type could not be transformed to tree item type. " + String.valueOf((Object)pointType));
        }
        this.reset();
    }

    public ColumnDefinedPointFileReader(String fileName, PointType pointType, String tabulator) {
        this(new File(fileName).toPath(), pointType, tabulator);
    }

    public ColumnDefinedPointFileReader(File sf, PointType pointType, String tabulator) {
        this(sf.toPath(), pointType, tabulator);
    }

    public ColumnDefinedPointFileReader(Path path, PointType pointType, String tabulator) {
        super(path);
        this.pointType = pointType;
        this.tabulator = tabulator;
        this.treeItemType = TreeItemType.getTreeItemTypeByPointType(pointType, 3);
        if (this.treeItemType == null) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, observation type could not be transformed to tree item type. " + String.valueOf((Object)pointType));
        }
        this.reset();
    }

    public void setColumnRanges(List<ColumnRange> columnRanges) {
        this.columnRanges = columnRanges;
    }

    public void setFileLocale(Locale locale) {
        this.numberFormat = NumberFormat.getNumberInstance(locale);
    }

    @Override
    public void reset() {
        if (this.points == null) {
            this.points = new ArrayList<PointRow>();
        }
        if (this.reservedNames == null) {
            this.reservedNames = new HashSet<String>();
        }
        this.points.clear();
        this.reservedNames.clear();
        this.lastCharacterPosition = 0;
    }

    @Override
    public TreeItem<TreeItemValue> readAndImport() throws IOException, SQLException {
        this.reset();
        this.ignoreLinesWhichStartWith("#");
        this.reservedNames = SQLManager.getInstance().getFullPointNameSet();
        TreeItem<TreeItemValue> newTreeItem = null;
        boolean hasXComponent = false;
        boolean hasYComponent = false;
        boolean hasZComponent = false;
        for (ColumnRange range : this.columnRanges) {
            this.lastCharacterPosition = Math.max(this.lastCharacterPosition, range.getColumnEnd() + 1);
            if (range.getType() == CSVColumnType.X) {
                hasXComponent = true;
                continue;
            }
            if (range.getType() == CSVColumnType.Y) {
                hasYComponent = true;
                continue;
            }
            if (range.getType() != CSVColumnType.Z) continue;
            hasZComponent = true;
        }
        int dimension = -1;
        if (hasXComponent && hasYComponent && hasZComponent) {
            dimension = 3;
        } else if (hasXComponent && hasYComponent) {
            dimension = 2;
        } else if (hasZComponent) {
            dimension = 1;
        }
        if (dimension >= 1 && dimension <= 3) {
            super.read();
            if (!this.points.isEmpty()) {
                this.treeItemType = TreeItemType.getTreeItemTypeByPointType(this.pointType, dimension);
                String itemName = this.createItemName(null, null);
                TreeItemType parentType = TreeItemType.getDirectoryByLeafType(this.treeItemType);
                newTreeItem = UITreeBuilder.getInstance().addItem(parentType, -1, itemName, true, false);
                try {
                    SQLManager.getInstance().saveGroup((PointTreeItemValue)newTreeItem.getValue());
                }
                catch (SQLException e) {
                    UITreeBuilder.getInstance().removeItem(newTreeItem);
                    e.printStackTrace();
                    throw new SQLException(e);
                }
                try {
                    int groupId = ((PointTreeItemValue)newTreeItem.getValue()).getGroupId();
                    for (PointRow row : this.points) {
                        row.setGroupId(groupId);
                        SQLManager.getInstance().saveItem(row);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new SQLException(e);
                }
            }
        }
        this.reset();
        return newTreeItem;
    }

    @Override
    public void parse(String line) throws SQLException {
        line = String.format("%" + this.lastCharacterPosition + "s", line.replaceAll("\t", this.tabulator));
        PointRow row = new PointRow();
        block12: for (ColumnRange range : this.columnRanges) {
            try {
                CSVColumnType type = range.getType();
                int startPos = range.getColumnStart();
                int endPos = range.getColumnEnd() + 1;
                switch (type) {
                    case POINT_ID: {
                        String name = line.substring(startPos, endPos).trim();
                        if (name == null || name.isBlank()) continue block12;
                        row.setName(name);
                        break;
                    }
                    case POINT_CODE: {
                        row.setCode(line.substring(startPos, endPos).trim());
                        break;
                    }
                    case X: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setXApriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case Y: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setYApriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case Z: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setZApriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case UNCERTAINTY_X: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setSigmaXapriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case UNCERTAINTY_Y: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setSigmaYapriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case UNCERTAINTY_Z: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setSigmaZapriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    default: {
                        System.err.println(this.getClass().getSimpleName() + " Error, unsupported column type! " + String.valueOf((Object)type));
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (row.getName() != null && !row.getName().isBlank() && !this.reservedNames.contains(row.getName()) && (row.getZApriori() != null || row.getXApriori() != null && row.getYApriori() != null)) {
            this.points.add(row);
            this.reservedNames.add(row.getName());
        }
    }
}

