/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.io.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.scene.control.TreeItem;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.io.reader.ImportOption;
import org.applied_geodesy.jag3d.ui.table.row.GNSSObservationRow;
import org.applied_geodesy.jag3d.ui.table.row.ObservationRow;
import org.applied_geodesy.jag3d.ui.table.row.TerrestrialObservationRow;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.util.FormatterOptions;
import org.applied_geodesy.util.io.SourceFileReader;
import org.applied_geodesy.util.io.csv.CSVColumnType;
import org.applied_geodesy.util.io.csv.ColumnRange;

public class ColumnDefinedObservationFileReader
extends SourceFileReader<TreeItem<TreeItemValue>> {
    private final String tabulator;
    private final ObservationType observationType;
    private final TreeItemType treeItemType;
    private FormatterOptions options = FormatterOptions.getInstance();
    private NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private int lastCharacterPosition = 0;
    private List<ColumnRange> columnRanges = new ArrayList<ColumnRange>(0);
    private List<TerrestrialObservationRow> observations = null;
    private List<GNSSObservationRow> gnss = null;
    private boolean separateGroup = true;
    private boolean isGroupWithEqualStation = true;
    private String startPointName = null;

    public ColumnDefinedObservationFileReader(ObservationType observationType, String tabulator) {
        this.observationType = observationType;
        this.separateGroup = ImportOption.getInstance().isGroupSeparation(observationType);
        this.tabulator = tabulator;
        this.treeItemType = TreeItemType.getTreeItemTypeByObservationType(observationType);
        if (this.treeItemType == null) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, observation type could not be transformed to tree item type. " + String.valueOf((Object)observationType));
        }
        this.reset();
    }

    public ColumnDefinedObservationFileReader(String fileName, ObservationType observationType, String tabulator) {
        this(new File(fileName).toPath(), observationType, tabulator);
    }

    public ColumnDefinedObservationFileReader(File sf, ObservationType observationType, String tabulator) {
        this(sf.toPath(), observationType, tabulator);
    }

    public ColumnDefinedObservationFileReader(Path path, ObservationType observationType, String tabulator) {
        super(path);
        this.observationType = observationType;
        this.tabulator = tabulator;
        this.treeItemType = TreeItemType.getTreeItemTypeByObservationType(observationType);
        if (this.treeItemType == null) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, observation type could not be transformed to tree item type. " + String.valueOf((Object)observationType));
        }
        this.reset();
    }

    public void setColumnRanges(List<ColumnRange> columnRanges) {
        this.columnRanges = columnRanges;
    }

    public void setFileLocale(Locale locale) {
        this.numberFormat = NumberFormat.getNumberInstance(locale);
    }

    @Override
    public void reset() {
        if (this.observations == null) {
            this.observations = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.gnss == null) {
            this.gnss = new ArrayList<GNSSObservationRow>();
        }
        this.observations.clear();
        this.gnss.clear();
        this.isGroupWithEqualStation = true;
        this.startPointName = null;
        this.lastCharacterPosition = 0;
    }

    @Override
    public TreeItem<TreeItemValue> readAndImport() throws IOException, SQLException {
        this.reset();
        this.ignoreLinesWhichStartWith("#");
        for (ColumnRange range : this.columnRanges) {
            this.lastCharacterPosition = Math.max(this.lastCharacterPosition, range.getColumnEnd() + 1);
        }
        TreeItem<TreeItemValue> newTreeItem = null;
        super.read();
        if (!this.observations.isEmpty() || !this.gnss.isEmpty()) {
            if (!this.observations.isEmpty()) {
                newTreeItem = this.saveGroup(this.treeItemType, this.observations);
            } else if (!this.gnss.isEmpty()) {
                newTreeItem = this.saveGroup(this.treeItemType, this.gnss);
            }
        }
        this.reset();
        return newTreeItem;
    }

    private TreeItem<TreeItemValue> saveGroup(TreeItemType itemType, List<? extends ObservationRow> observations) throws SQLException {
        TreeItem<TreeItemValue> treeItem = null;
        if (!observations.isEmpty()) {
            String itemName = this.createItemName(null, this.isGroupWithEqualStation ? " (" + this.startPointName + ")" : null);
            treeItem = this.saveObservations(itemName, itemType);
        }
        observations.clear();
        this.startPointName = null;
        this.isGroupWithEqualStation = true;
        return treeItem;
    }

    private TreeItem<TreeItemValue> saveObservations(String itemName, TreeItemType treeItemType) throws SQLException {
        if ((this.observations == null || this.observations.isEmpty()) && (this.gnss == null || this.gnss.isEmpty())) {
            return null;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(treeItemType);
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, -1, itemName, true, false);
        try {
            SQLManager.getInstance().saveGroup((ObservationTreeItemValue)newTreeItem.getValue());
        }
        catch (SQLException e) {
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            throw new SQLException(e);
        }
        try {
            int groupId = ((ObservationTreeItemValue)newTreeItem.getValue()).getGroupId();
            if (!this.observations.isEmpty()) {
                for (TerrestrialObservationRow row : this.observations) {
                    row.setGroupId(groupId);
                    SQLManager.getInstance().saveItem(row);
                }
            } else if (!this.gnss.isEmpty()) {
                for (GNSSObservationRow row : this.gnss) {
                    row.setGroupId(groupId);
                    SQLManager.getInstance().saveItem(row);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
        return newTreeItem;
    }

    @Override
    public void parse(String line) throws SQLException {
        line = String.format("%" + this.lastCharacterPosition + "s", line.replaceAll("\t", this.tabulator));
        if (this.isGNSS()) {
            this.parseGNSSObservation(line);
        } else {
            this.parseTerrestrialObservation(line);
        }
    }

    private boolean isGNSS() {
        switch (this.observationType) {
            case GNSS1D: 
            case GNSS2D: 
            case GNSS3D: {
                return true;
            }
        }
        return false;
    }

    private void parseTerrestrialObservation(String line) {
        TerrestrialObservationRow row = new TerrestrialObservationRow();
        block17: for (ColumnRange range : this.columnRanges) {
            try {
                CSVColumnType type = range.getType();
                int startPos = range.getColumnStart();
                int endPos = range.getColumnEnd() + 1;
                block1 : switch (type) {
                    case STATION: {
                        String startPointName = line.substring(startPos, endPos).trim();
                        if (startPointName == null || startPointName.isBlank()) continue block17;
                        if (this.startPointName == null) {
                            this.startPointName = startPointName;
                        }
                        boolean bl = this.isGroupWithEqualStation = this.isGroupWithEqualStation && this.startPointName.equals(startPointName);
                        if (this.separateGroup && !this.startPointName.equals(startPointName)) {
                            this.isGroupWithEqualStation = true;
                            this.saveGroup(this.treeItemType, this.observations);
                            this.startPointName = startPointName;
                        }
                        row.setStartPointName(startPointName);
                        break;
                    }
                    case TARGET: {
                        String endPointName = line.substring(startPos, endPos).trim();
                        if (endPointName == null || endPointName.isBlank()) continue block17;
                        row.setEndPointName(endPointName);
                        break;
                    }
                    case INSTRUMENT_HEIGHT: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setInstrumentHeight(this.options.convertLengthToModel(value));
                        break;
                    }
                    case TARGET_HEIGHT: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setReflectorHeight(this.options.convertLengthToModel(value));
                        break;
                    }
                    case VALUE: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        switch (this.observationType) {
                            case DIRECTION: 
                            case ZENITH_ANGLE: {
                                row.setValueApriori(this.options.convertAngleToModel(value));
                                break block1;
                            }
                        }
                        row.setValueApriori(this.options.convertLengthToModel(value));
                        if (this.observationType != ObservationType.HORIZONTAL_DISTANCE && this.observationType != ObservationType.SLOPE_DISTANCE) continue block17;
                        row.setDistanceApriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case UNCERTAINTY: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        switch (this.observationType) {
                            case DIRECTION: 
                            case ZENITH_ANGLE: {
                                row.setSigmaApriori(this.options.convertAngleToModel(value));
                                break block1;
                            }
                        }
                        row.setSigmaApriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case DISTANCE_FOR_UNCERTAINTY: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setDistanceApriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    default: {
                        System.err.println(this.getClass().getSimpleName() + " Error, unsupported column type! " + String.valueOf((Object)type));
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (!(row.getStartPointName() == null || row.getEndPointName() == null || row.getValueApriori() == null || row.getStartPointName().isBlank() || row.getEndPointName().isBlank() || row.getStartPointName().equals(row.getEndPointName()))) {
            this.observations.add(row);
        }
    }

    private void parseGNSSObservation(String line) {
        GNSSObservationRow row = new GNSSObservationRow();
        block12: for (ColumnRange range : this.columnRanges) {
            try {
                CSVColumnType type = range.getType();
                int startPos = range.getColumnStart();
                int endPos = range.getColumnEnd() + 1;
                switch (type) {
                    case STATION: {
                        String startPointName = line.substring(startPos, endPos).trim();
                        if (startPointName == null || startPointName.isBlank()) continue block12;
                        if (this.startPointName == null) {
                            this.startPointName = startPointName;
                        }
                        boolean bl = this.isGroupWithEqualStation = this.isGroupWithEqualStation && this.startPointName.equals(startPointName);
                        if (this.separateGroup && !this.startPointName.equals(startPointName)) {
                            this.isGroupWithEqualStation = true;
                            this.saveGroup(this.treeItemType, this.observations);
                            this.startPointName = startPointName;
                        }
                        row.setStartPointName(startPointName);
                        break;
                    }
                    case TARGET: {
                        String endPointName = line.substring(startPos, endPos).trim();
                        if (endPointName == null || endPointName.isBlank()) continue block12;
                        row.setEndPointName(endPointName);
                        break;
                    }
                    case X: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setXApriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case Y: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setYApriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case Z: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setZApriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case UNCERTAINTY_X: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setSigmaXapriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case UNCERTAINTY_Y: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setSigmaYapriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    case UNCERTAINTY_Z: {
                        double value = this.numberFormat.parse(line.substring(startPos, endPos).trim()).doubleValue();
                        row.setSigmaZapriori(this.options.convertLengthToModel(value));
                        break;
                    }
                    default: {
                        System.err.println(this.getClass().getSimpleName() + " Error, unsupported column type! " + String.valueOf((Object)type));
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (row.getStartPointName() != null && row.getEndPointName() != null && !row.getStartPointName().isBlank() && !row.getEndPointName().isBlank() && !row.getStartPointName().equals(row.getEndPointName()) && (this.observationType == ObservationType.GNSS3D && row.getZApriori() != null && row.getXApriori() != null && row.getYApriori() != null || this.observationType == ObservationType.GNSS2D && row.getXApriori() != null && row.getYApriori() != null || this.observationType == ObservationType.GNSS1D && row.getZApriori() != null)) {
            this.gnss.add(row);
        }
    }
}

