/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.io.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.TreeItem;
import javafx.stage.FileChooser;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.io.reader.ImportOption;
import org.applied_geodesy.jag3d.ui.table.row.TerrestrialObservationRow;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.util.io.SourceFileReader;

public class BeoFileReader
extends SourceFileReader<TreeItem<TreeItemValue>> {
    private boolean isNewStation = false;
    private String startPointName = null;
    private String lastStartPointName = null;
    private double ih = 0.0;
    private TreeItem<TreeItemValue> lastTreeItem = null;
    private List<TerrestrialObservationRow> leveling = null;
    private List<TerrestrialObservationRow> horizontalDistances = null;
    private List<TerrestrialObservationRow> directions = null;
    private List<TerrestrialObservationRow> slopeDistances = null;
    private List<TerrestrialObservationRow> zenithAngles = null;

    public BeoFileReader() {
        this.reset();
    }

    public BeoFileReader(File f) {
        this(f.toPath());
    }

    public BeoFileReader(String s) {
        this(new File(s));
    }

    public BeoFileReader(Path p) {
        super(p);
        this.reset();
    }

    @Override
    public void reset() {
        this.isNewStation = false;
        this.startPointName = null;
        this.lastStartPointName = null;
        this.ih = 0.0;
        if (this.leveling == null) {
            this.leveling = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.horizontalDistances == null) {
            this.horizontalDistances = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.directions == null) {
            this.directions = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.slopeDistances == null) {
            this.slopeDistances = new ArrayList<TerrestrialObservationRow>();
        }
        if (this.zenithAngles == null) {
            this.zenithAngles = new ArrayList<TerrestrialObservationRow>();
        }
        this.leveling.clear();
        this.horizontalDistances.clear();
        this.directions.clear();
        this.slopeDistances.clear();
        this.zenithAngles.clear();
    }

    @Override
    public TreeItem<TreeItemValue> readAndImport() throws IOException, SQLException {
        this.lastTreeItem = null;
        this.reset();
        this.ignoreLinesWhichStartWith("#");
        super.read();
        this.saveObservationGroups(true);
        this.reset();
        return this.lastTreeItem;
    }

    @Override
    public void parse(String line) throws SQLException {
        if ((line = line.trim()).length() < 89) {
            return;
        }
        String key = line.substring(0, 3).trim();
        if (key.equalsIgnoreCase("10.")) {
            this.startPointName = line.substring(15, 28).trim();
            if (this.startPointName.isBlank()) {
                return;
            }
            this.isNewStation = this.startPointName != null;
            try {
                this.ih = Double.parseDouble(line.substring(79, line.length()).trim().replaceAll("\\s+.*", ""));
                this.ih = this.ih == -1000.0 ? 0.0 : this.ih;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this.startPointName != null && !this.startPointName.isBlank() && (key.equalsIgnoreCase("20.") || key.equalsIgnoreCase("21.") || key.equalsIgnoreCase("24.") || key.equalsIgnoreCase("31."))) {
            TerrestrialObservationRow obs3;
            if (this.isNewStation) {
                this.saveObservationGroups(false);
                this.lastStartPointName = null;
            }
            this.isNewStation = false;
            String endPointName = line.substring(15, 28).trim();
            if (endPointName.isBlank() || this.startPointName.equals(endPointName)) {
                return;
            }
            double th = 0.0;
            try {
                th = Double.parseDouble(line.substring(79, line.length()).trim().replaceAll("\\s+.*", ""));
                th = th == -1000.0 ? 0.0 : th;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.lastStartPointName == null) {
                this.lastStartPointName = this.startPointName;
            }
            boolean isFaceI = true;
            String value = line.substring(33, 49).trim();
            double distance = 0.0;
            if (!value.isBlank() && !value.startsWith("-1000.")) {
                try {
                    TerrestrialObservationRow obs2 = new TerrestrialObservationRow();
                    obs2.setStartPointName(this.startPointName);
                    obs2.setEndPointName(endPointName);
                    obs2.setInstrumentHeight(this.ih);
                    obs2.setReflectorHeight(th);
                    distance = Double.parseDouble(value);
                    if (distance > 0.0) {
                        obs2.setValueApriori(distance);
                        obs2.setDistanceApriori(distance);
                        this.slopeDistances.add(obs2);
                    }
                }
                catch (NumberFormatException obs2) {
                    // empty catch block
                }
            }
            value = line.substring(64, 79).trim();
            double zenith = 1.5707963267948966;
            if (!value.isBlank() && !value.startsWith("-1000.")) {
                try {
                    obs3 = new TerrestrialObservationRow();
                    obs3.setStartPointName(this.startPointName);
                    obs3.setEndPointName(endPointName);
                    obs3.setInstrumentHeight(this.ih);
                    obs3.setReflectorHeight(th);
                    zenith = Double.parseDouble(value) * 0.015707963267948967;
                    boolean bl = isFaceI = zenith <= Math.PI;
                    if (!isFaceI) {
                        zenith = MathExtension.MOD(Math.PI * 2 - zenith, Math.PI * 2);
                    }
                    obs3.setValueApriori(zenith);
                    if (distance > 0.0) {
                        obs3.setDistanceApriori(distance);
                    }
                    this.zenithAngles.add(obs3);
                }
                catch (NumberFormatException obs3) {
                    // empty catch block
                }
            }
            if (!(value = line.substring(49, 64).trim()).isBlank() && !value.startsWith("-1000.")) {
                try {
                    obs3 = new TerrestrialObservationRow();
                    obs3.setStartPointName(this.startPointName);
                    obs3.setEndPointName(endPointName);
                    obs3.setInstrumentHeight(this.ih);
                    obs3.setReflectorHeight(th);
                    double dir = Double.parseDouble(value) * 0.015707963267948967;
                    if (!isFaceI) {
                        dir = MathExtension.MOD(dir + Math.PI, Math.PI * 2);
                    }
                    obs3.setValueApriori(dir);
                    if (distance > 0.0) {
                        obs3.setDistanceApriori(Math.abs(zenith) > SQRT_EPS ? distance * Math.sin(zenith) : distance * Math.sin(SQRT_EPS));
                    }
                    this.directions.add(obs3);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (this.startPointName != null && !this.startPointName.isBlank() && key.equalsIgnoreCase("50.")) {
            TerrestrialObservationRow obs4;
            if (this.isNewStation) {
                this.saveObservationGroups(false);
                this.lastStartPointName = null;
            }
            this.isNewStation = false;
            String endPointName = line.substring(15, 28).trim();
            if (endPointName.isBlank()) {
                return;
            }
            double th = 0.0;
            try {
                th = Double.parseDouble(line.substring(79, line.length()).trim().replaceAll("\\s+.*", ""));
                th = th == -1000.0 ? 0.0 : th;
            }
            catch (NumberFormatException isFaceI) {
                // empty catch block
            }
            if (this.lastStartPointName == null) {
                this.lastStartPointName = this.startPointName;
            }
            double distance = 0.0;
            String value = line.substring(33, 49).trim();
            if (!value.isBlank() && !value.startsWith("-1000.")) {
                try {
                    obs4 = new TerrestrialObservationRow();
                    obs4.setStartPointName(this.startPointName);
                    obs4.setEndPointName(endPointName);
                    obs4.setInstrumentHeight(this.ih);
                    obs4.setReflectorHeight(th);
                    distance = Double.parseDouble(value);
                    if (distance > 0.0) {
                        obs4.setValueApriori(distance);
                        obs4.setDistanceApriori(distance);
                        this.horizontalDistances.add(obs4);
                    }
                }
                catch (NumberFormatException obs4) {
                    // empty catch block
                }
            }
            if (!(value = line.substring(49, 64).trim()).isBlank() && !value.startsWith("-1000.")) {
                try {
                    obs4 = new TerrestrialObservationRow();
                    obs4.setStartPointName(this.startPointName);
                    obs4.setEndPointName(endPointName);
                    obs4.setInstrumentHeight(this.ih);
                    obs4.setReflectorHeight(th);
                    double dir = Double.parseDouble(value) * 0.015707963267948967;
                    obs4.setValueApriori(dir);
                    if (distance > 0.0) {
                        obs4.setDistanceApriori(distance);
                    }
                    this.directions.add(obs4);
                }
                catch (NumberFormatException obs5) {
                    // empty catch block
                }
            }
            if (!(value = line.substring(64, 79).trim()).isBlank() && !value.startsWith("-1000.")) {
                try {
                    obs4 = new TerrestrialObservationRow();
                    obs4.setStartPointName(this.startPointName);
                    obs4.setEndPointName(endPointName);
                    obs4.setInstrumentHeight(this.ih);
                    obs4.setReflectorHeight(th);
                    double dh = Double.parseDouble(value);
                    obs4.setValueApriori(dh);
                    if (distance > 0.0) {
                        obs4.setDistanceApriori(distance);
                    }
                    this.leveling.add(obs4);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (this.startPointName != null && !this.startPointName.isBlank() && key.equalsIgnoreCase("70.")) {
            if (this.isNewStation) {
                this.saveObservationGroups(false);
                this.lastStartPointName = null;
            }
            this.isNewStation = false;
            String endPointName = line.substring(15, 28).trim();
            if (endPointName.isBlank()) {
                return;
            }
            double th = 0.0;
            try {
                th = Double.parseDouble(line.substring(79, line.length()).trim().replaceAll("\\s+.*", ""));
                th = th == -1000.0 ? 0.0 : th;
            }
            catch (NumberFormatException distance) {
                // empty catch block
            }
            String value = line.substring(64, 79).trim();
            if (!value.isBlank() && !value.startsWith("-1000.")) {
                try {
                    TerrestrialObservationRow obs = new TerrestrialObservationRow();
                    obs.setStartPointName(this.startPointName);
                    obs.setEndPointName(endPointName);
                    obs.setInstrumentHeight(this.ih);
                    obs.setReflectorHeight(th);
                    double dh = Double.parseDouble(value);
                    obs.setValueApriori(dh);
                    try {
                        obs.setDistanceApriori(Double.parseDouble(line.substring(33, 49).trim()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.leveling.add(obs);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void saveObservationGroups(boolean forceSaving) throws SQLException {
        if (!this.leveling.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.LEVELING))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.LEVELING_LEAF, this.leveling);
        }
        if (!this.directions.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.DIRECTION))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.DIRECTION_LEAF, this.directions);
        }
        if (!this.horizontalDistances.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.HORIZONTAL_DISTANCE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.HORIZONTAL_DISTANCE_LEAF, this.horizontalDistances);
        }
        if (!this.slopeDistances.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.SLOPE_DISTANCE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.SLOPE_DISTANCE_LEAF, this.slopeDistances);
        }
        if (!this.zenithAngles.isEmpty() && (forceSaving || ImportOption.getInstance().isGroupSeparation(ObservationType.ZENITH_ANGLE))) {
            this.lastTreeItem = this.saveObservationGroup(TreeItemType.ZENITH_ANGLE_LEAF, this.zenithAngles);
        }
    }

    private TreeItem<TreeItemValue> saveObservationGroup(TreeItemType itemType, List<TerrestrialObservationRow> observations) throws SQLException {
        TreeItem<TreeItemValue> treeItem = null;
        if (!observations.isEmpty()) {
            boolean isGroupWithEqualStation = ImportOption.getInstance().isGroupSeparation(TreeItemType.getObservationTypeByTreeItemType(itemType));
            String itemName = this.createItemName(null, isGroupWithEqualStation && this.lastStartPointName != null ? " (" + this.lastStartPointName + ")" : null);
            treeItem = this.saveTerrestrialObservations(itemName, itemType, observations);
        }
        observations.clear();
        return treeItem;
    }

    private TreeItem<TreeItemValue> saveTerrestrialObservations(String itemName, TreeItemType treeItemType, List<TerrestrialObservationRow> observations) throws SQLException {
        if (observations == null || observations.isEmpty()) {
            return null;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(treeItemType);
        TreeItem<TreeItemValue> newTreeItem = UITreeBuilder.getInstance().addItem(parentType, -1, itemName, true, false);
        try {
            SQLManager.getInstance().saveGroup((ObservationTreeItemValue)newTreeItem.getValue());
        }
        catch (SQLException e) {
            UITreeBuilder.getInstance().removeItem(newTreeItem);
            e.printStackTrace();
            throw new SQLException(e);
        }
        try {
            int groupId = ((ObservationTreeItemValue)newTreeItem.getValue()).getGroupId();
            for (TerrestrialObservationRow row : observations) {
                row.setGroupId(groupId);
                SQLManager.getInstance().saveItem(row);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
        return newTreeItem;
    }

    public static FileChooser.ExtensionFilter[] getExtensionFilters() {
        return new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18N.getInstance().getString("BeoFileReader.extension.beo", "Beo (Neptan)"), new String[]{"*.beo", "*.BEO"}), new FileChooser.ExtensionFilter(I18N.getInstance().getString("FlatFileReader.extension", "All files"), new String[]{"*.*"})};
    }
}

