/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.symbol;

import java.util.Map;
import java.util.Set;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.ObservationSymbolProperties;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.ArrowSymbolType;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.PointSymbolType;

public class SymbolBuilder {
    public static final double DEFAULT_SIZE = 12.0;

    public static void drawEllipse(GraphicsContext graphicsContext, PixelCoordinate coordinate, double majorAxis, double minorAxis, double angle) {
        double x0 = coordinate.getX() - majorAxis;
        double y0 = coordinate.getY() - minorAxis;
        graphicsContext.save();
        graphicsContext.transform(new Affine((Transform)new Rotate(angle * 57.29577951308232, coordinate.getX(), coordinate.getY())));
        graphicsContext.fillOval(x0, y0, 2.0 * majorAxis, 2.0 * minorAxis);
        graphicsContext.strokeOval(x0, y0, 2.0 * majorAxis, 2.0 * minorAxis);
        graphicsContext.restore();
    }

    public static void drawSymbol(GraphicsContext graphicsContext, PixelCoordinate coordinate, Map<ObservationSymbolProperties.ObservationType, ObservationSymbolProperties> symbolPropertiesMap, Set<ObservationSymbolProperties.ObservationType> observationTypes, double size) {
        int n = 0;
        for (ObservationSymbolProperties.ObservationType type : observationTypes) {
            if (!symbolPropertiesMap.get((Object)type).isVisible()) continue;
            ++n;
        }
        if (n > 0) {
            Paint currentPaint = graphicsContext.getStroke();
            double angle = 360.0 / (double)n;
            int cnt = 0;
            graphicsContext.setLineDashes(null);
            for (ObservationSymbolProperties.ObservationType type : observationTypes) {
                if (!symbolPropertiesMap.get((Object)type).isVisible()) continue;
                graphicsContext.setStroke((Paint)symbolPropertiesMap.get((Object)type).getColor());
                graphicsContext.setFill((Paint)symbolPropertiesMap.get((Object)type).getColor());
                graphicsContext.fillArc(coordinate.getX(), coordinate.getY(), size, size, (double)cnt * angle, angle, ArcType.ROUND);
                ++cnt;
            }
            graphicsContext.setStroke(currentPaint);
            graphicsContext.strokeOval(coordinate.getX(), coordinate.getY(), size, size);
        }
    }

    public static void drawSymbol(GraphicsContext graphicsContext, PixelCoordinate coordinate, ArrowSymbolType symbolType, double size, double angle) {
        switch (symbolType) {
            case STROKED_TETRAGON_ARROW: 
            case FILLED_TETRAGON_ARROW: {
                SymbolBuilder.drawTetragonArrow(graphicsContext, coordinate, size, angle, symbolType == ArrowSymbolType.STROKED_TETRAGON_ARROW);
                break;
            }
            case STROKED_ARROW: {
                SymbolBuilder.drawSimpleArrow(graphicsContext, coordinate, size, angle);
                break;
            }
            case STROKED_TRIANGLE_ARROW: 
            case FILLED_TRIANGLE_ARROW: {
                SymbolBuilder.drawTriangleArrow(graphicsContext, coordinate, size, angle, symbolType == ArrowSymbolType.STROKED_TRIANGLE_ARROW);
            }
        }
    }

    public static void drawSymbol(GraphicsContext graphicsContext, PixelCoordinate coordinate, PointSymbolType symbolType, double size) {
        switch (symbolType) {
            case STROKED_CIRCLE: 
            case FILLED_CIRCLE: {
                SymbolBuilder.drawCircle(graphicsContext, coordinate, size, symbolType == PointSymbolType.STROKED_CIRCLE);
                break;
            }
            case STROKED_SQUARE: 
            case FILLED_SQUARE: {
                SymbolBuilder.drawSquare(graphicsContext, coordinate, size, symbolType == PointSymbolType.STROKED_SQUARE);
                break;
            }
            case STROKED_UPRIGHT_TRIANGLE: 
            case FILLED_UPRIGHT_TRIANGLE: {
                SymbolBuilder.drawUprightTriangle(graphicsContext, coordinate, size, symbolType == PointSymbolType.STROKED_UPRIGHT_TRIANGLE);
                break;
            }
            case STROKED_DOWNRIGHT_TRIANGLE: 
            case FILLED_DOWNRIGHT_TRIANGLE: {
                SymbolBuilder.drawDownrightTriangle(graphicsContext, coordinate, size, symbolType == PointSymbolType.STROKED_DOWNRIGHT_TRIANGLE);
                break;
            }
            case STROKED_PENTAGON: 
            case FILLED_PENTAGON: {
                SymbolBuilder.drawNEdges(graphicsContext, coordinate, size, symbolType == PointSymbolType.STROKED_PENTAGON, 5);
                break;
            }
            case STROKED_HEXAGON: 
            case FILLED_HEXAGON: {
                SymbolBuilder.drawNEdges(graphicsContext, coordinate, size, symbolType == PointSymbolType.STROKED_HEXAGON, 6);
                break;
            }
            case STROKED_HEPTAGON: 
            case FILLED_HEPTAGON: {
                SymbolBuilder.drawNEdges(graphicsContext, coordinate, size, symbolType == PointSymbolType.STROKED_HEPTAGON, 7);
                break;
            }
            case STROKED_OCTAGON: 
            case FILLED_OCTAGON: {
                SymbolBuilder.drawNEdges(graphicsContext, coordinate, size, symbolType == PointSymbolType.STROKED_OCTAGON, 8);
                break;
            }
            case STROKED_STAR: 
            case FILLED_STAR: {
                SymbolBuilder.drawStar(graphicsContext, coordinate, size, symbolType == PointSymbolType.STROKED_STAR);
                break;
            }
            case STROKED_DIAMAND: 
            case FILLED_DIAMAND: {
                SymbolBuilder.drawDiamand(graphicsContext, coordinate, size, symbolType == PointSymbolType.STROKED_DIAMAND);
                break;
            }
            case X_CROSS: {
                SymbolBuilder.drawXCross(graphicsContext, coordinate, size);
                break;
            }
            case PLUS_CROSS: {
                SymbolBuilder.drawPlusCross(graphicsContext, coordinate, size);
                break;
            }
            case CROSSED_CIRCLE: {
                SymbolBuilder.drawCrossedCircle(graphicsContext, coordinate, size);
                break;
            }
            case CROSSED_SQUARE: {
                SymbolBuilder.drawCrossedSquare(graphicsContext, coordinate, size);
                break;
            }
            case DOT: {
                SymbolBuilder.drawCircle(graphicsContext, coordinate, 1.0, false);
            }
        }
        SymbolBuilder.drawCircle(graphicsContext, coordinate, 1.0, false);
    }

    private static void drawCircle(GraphicsContext gc, PixelCoordinate coordinate, double size, boolean stroke) {
        double x = coordinate.getX() - 0.5 * size;
        double y = coordinate.getY() - 0.5 * size;
        if (stroke) {
            gc.strokeOval(x, y, size, size);
        } else {
            gc.fillOval(x, y, size, size);
        }
    }

    private static void drawSquare(GraphicsContext gc, PixelCoordinate coordinate, double size, boolean stroke) {
        double x = coordinate.getX() - 0.5 * size;
        double y = coordinate.getY() - 0.5 * size;
        if (stroke) {
            gc.strokeRect(x, y, size, size);
        } else {
            gc.fillRect(x, y, size, size);
        }
    }

    private static void drawUprightTriangle(GraphicsContext gc, PixelCoordinate coordinate, double size, boolean stroke) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        double cos30 = Math.cos(Math.toRadians(30.0));
        double sin30 = Math.sin(Math.toRadians(30.0));
        double[] xi = new double[]{x, x + cos30 * 0.5 * size, x - cos30 * 0.5 * size};
        double[] yi = new double[]{y - 0.5 * size, y + sin30 * 0.5 * size, y + sin30 * 0.5 * size};
        if (stroke) {
            gc.strokePolygon(xi, yi, xi.length);
        } else {
            gc.fillPolygon(xi, yi, xi.length);
        }
    }

    private static void drawDownrightTriangle(GraphicsContext gc, PixelCoordinate coordinate, double size, boolean stroke) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        double cos30 = Math.cos(Math.toRadians(30.0));
        double sin30 = Math.sin(Math.toRadians(30.0));
        double[] xi = new double[]{x, x + cos30 * 0.5 * size, x - cos30 * 0.5 * size};
        double[] yi = new double[]{y + 0.5 * size, y - sin30 * 0.5 * size, y - sin30 * 0.5 * size};
        if (stroke) {
            gc.strokePolygon(xi, yi, xi.length);
        } else {
            gc.fillPolygon(xi, yi, xi.length);
        }
    }

    private static void drawDiamand(GraphicsContext gc, PixelCoordinate coordinate, double size, boolean stroke) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        double[] xi = new double[]{x, x + 0.5 * size, x, x - 0.5 * size};
        double[] yi = new double[]{y - 0.5 * size, y, y + 0.5 * size, y};
        if (stroke) {
            gc.strokePolygon(xi, yi, xi.length);
        } else {
            gc.fillPolygon(xi, yi, xi.length);
        }
    }

    private static void drawNEdges(GraphicsContext gc, PixelCoordinate coordinate, double size, boolean stroke, int n) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        double[] xi = new double[n];
        double[] yi = new double[n];
        double angle = Math.PI * 2 / (double)n;
        int i = 0;
        while (i < n) {
            xi[i] = x + 0.5 * size * Math.cos((double)i * angle);
            yi[i] = y + 0.5 * size * Math.sin((double)i * angle);
            ++i;
        }
        if (stroke) {
            gc.strokePolygon(xi, yi, n);
        } else {
            gc.fillPolygon(xi, yi, n);
        }
    }

    private static void drawStar(GraphicsContext gc, PixelCoordinate coordinate, double size, boolean stroke) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        int n = 5;
        double[] xi = new double[2 * n];
        double[] yi = new double[2 * n];
        double angle = Math.PI * 2 / (double)(2 * n);
        int i = 0;
        while (i < 2 * n) {
            double s = i % 2 == 0 ? 0.5 * size : 0.2 * size;
            xi[i] = x - s * Math.sin((double)i * angle);
            yi[i] = y - s * Math.cos((double)i * angle);
            ++i;
        }
        if (stroke) {
            gc.strokePolygon(xi, yi, 2 * n);
        } else {
            gc.fillPolygon(xi, yi, 2 * n);
        }
    }

    private static void drawCrossedCircle(GraphicsContext gc, PixelCoordinate coordinate, double size) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        gc.strokeLine(x - 0.5 / Math.sqrt(2.0) * size, y - 0.5 / Math.sqrt(2.0) * size, x + 0.5 / Math.sqrt(2.0) * size, y + 0.5 / Math.sqrt(2.0) * size);
        gc.strokeLine(x + 0.5 / Math.sqrt(2.0) * size, y - 0.5 / Math.sqrt(2.0) * size, x - 0.5 / Math.sqrt(2.0) * size, y + 0.5 / Math.sqrt(2.0) * size);
        SymbolBuilder.drawCircle(gc, coordinate, size, true);
    }

    private static void drawCrossedSquare(GraphicsContext gc, PixelCoordinate coordinate, double size) {
        SymbolBuilder.drawXCross(gc, coordinate, size);
        SymbolBuilder.drawSquare(gc, coordinate, size, true);
    }

    private static void drawXCross(GraphicsContext gc, PixelCoordinate coordinate, double size) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        gc.strokeLine(x - 0.5 * size, y - 0.5 * size, x + 0.5 * size, y + 0.5 * size);
        gc.strokeLine(x + 0.5 * size, y - 0.5 * size, x - 0.5 * size, y + 0.5 * size);
    }

    private static void drawPlusCross(GraphicsContext gc, PixelCoordinate coordinate, double size) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        gc.strokeLine(x, y - 0.5 * size, x, y + 0.5 * size);
        gc.strokeLine(x + 0.5 * size, y, x - 0.5 * size, y);
    }

    private static void drawTriangleArrow(GraphicsContext gc, PixelCoordinate coordinate, double size, double angle, boolean stroke) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        double[] xi = new double[]{x, x - size, x - size};
        double[] yi = new double[]{y, y + 0.375 * size, y - 0.375 * size};
        gc.save();
        gc.transform(new Affine((Transform)new Rotate(angle * 57.29577951308232, x, y)));
        if (stroke) {
            gc.strokePolygon(xi, yi, xi.length);
        } else {
            gc.fillPolygon(xi, yi, xi.length);
        }
        gc.restore();
    }

    private static void drawTetragonArrow(GraphicsContext gc, PixelCoordinate coordinate, double size, double angle, boolean stroke) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        double[] xi = new double[]{x, x - size, x - 0.75 * size, x - size};
        double[] yi = new double[]{y, y + 0.375 * size, y, y - 0.375 * size};
        gc.save();
        gc.transform(new Affine((Transform)new Rotate(angle * 57.29577951308232, x, y)));
        if (stroke) {
            gc.strokePolygon(xi, yi, xi.length);
        } else {
            gc.fillPolygon(xi, yi, xi.length);
        }
        gc.restore();
    }

    private static void drawSimpleArrow(GraphicsContext gc, PixelCoordinate coordinate, double size, double angle) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        gc.save();
        gc.transform(new Affine((Transform)new Rotate(angle * 57.29577951308232, x, y)));
        gc.strokeLine(x, y, x - size, y + 0.3 * size);
        gc.strokeLine(x, y, x - size, y - 0.3 * size);
        gc.restore();
    }
}

