/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import java.util.Arrays;
import java.util.LinkedHashSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerManager;
import org.applied_geodesy.jag3d.ui.graphic.layer.PointLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.PointSymbolTypeListCell;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.UILayerPropertyBuilder;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.PointSymbolType;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;

public class UIPointLayerPropertyBuilder
extends UILayerPropertyBuilder {
    private I18N i18n = I18N.getInstance();
    private static UIPointLayerPropertyBuilder pointLayerPropertyBuilder = new UIPointLayerPropertyBuilder();
    private ComboBox<PointSymbolType> symbolTypeComboBox;
    private ComboBox<Double> symbolSizeComboBox;
    private ComboBox<Double> lineWidthComboBox;
    private ColorPicker symbolColorPicker;
    private ComboBox<String> fontFamilyComboBox;
    private ComboBox<Double> fontSizeComboBox;
    private ColorPicker fontColorPicker;
    private ColorPicker fontBackgroundColorPicker;
    private Node highlightPane = null;
    private ComboBox<Double> highlightLineWidthComboBox;
    private ColorPicker highlightColorPicker;
    private ComboBox<TableRowHighlightType> highlightTypeComboBox;
    private CheckBox point1DVisibleCheckBox;
    private CheckBox point2DVisibleCheckBox;
    private CheckBox point3DVisibleCheckBox;
    private PointLayer currentLayer = null;
    private LayerManager layerManager = null;
    private VBox propertyPane = null;

    private UIPointLayerPropertyBuilder() {
    }

    private void init() {
        if (this.propertyPane != null) {
            return;
        }
        this.highlightPane = this.createHighlightPane();
        this.propertyPane = new VBox(20.0);
        this.propertyPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.propertyPane.setMinHeight(Double.NEGATIVE_INFINITY);
        this.propertyPane.getChildren().addAll((Object[])new Node[]{this.createSymbolPane(), this.createFontPane(), this.createPointDimensionVisibilityPane(), this.highlightPane});
    }

    public static Node getLayerPropertyPane(LayerManager layerManager, PointLayer layer) {
        UIPointLayerPropertyBuilder.pointLayerPropertyBuilder.layerManager = null;
        pointLayerPropertyBuilder.init();
        pointLayerPropertyBuilder.set(layer);
        UIPointLayerPropertyBuilder.pointLayerPropertyBuilder.layerManager = layerManager;
        return UIPointLayerPropertyBuilder.pointLayerPropertyBuilder.propertyPane;
    }

    private void set(PointLayer layer) {
        this.currentLayer = layer;
        this.symbolTypeComboBox.getSelectionModel().select((Object)this.currentLayer.getPointSymbolType());
        this.symbolSizeComboBox.getSelectionModel().select((Object)this.currentLayer.getSymbolSize());
        this.lineWidthComboBox.getSelectionModel().select((Object)this.currentLayer.getLineWidth());
        this.symbolColorPicker.setValue((Object)this.currentLayer.getColor());
        switch (this.currentLayer.getLayerType()) {
            case REFERENCE_POINT_APOSTERIORI: 
            case STOCHASTIC_POINT_APOSTERIORI: 
            case DATUM_POINT_APOSTERIORI: {
                this.prepareHighlightTypeComboBox(this.highlightTypeComboBox);
                this.highlightColorPicker.setValue((Object)this.currentLayer.getHighlightColor());
                this.highlightLineWidthComboBox.getSelectionModel().select((Object)this.currentLayer.getHighlightLineWidth());
                if (this.highlightTypeComboBox.getItems().contains((Object)this.currentLayer.getHighlightType())) {
                    this.highlightTypeComboBox.getSelectionModel().select((Object)this.currentLayer.getHighlightType());
                } else {
                    this.highlightTypeComboBox.getSelectionModel().select((Object)TableRowHighlightType.NONE);
                }
                this.highlightPane.setVisible(true);
                this.highlightPane.setManaged(true);
                break;
            }
            default: {
                this.highlightPane.setVisible(false);
                this.highlightPane.setManaged(false);
            }
        }
        this.fontFamilyComboBox.getSelectionModel().select((Object)this.currentLayer.getFontFamily());
        this.fontSizeComboBox.getSelectionModel().select((Object)this.currentLayer.getFontSize());
        this.fontColorPicker.setValue((Object)this.currentLayer.getFontColor());
        this.fontBackgroundColorPicker.setValue((Object)this.currentLayer.getFontBackgroundColor());
        this.point1DVisibleCheckBox.setSelected(this.currentLayer.isPoint1DVisible());
        this.point2DVisibleCheckBox.setSelected(this.currentLayer.isPoint2DVisible());
        this.point3DVisibleCheckBox.setSelected(this.currentLayer.isPoint3DVisible());
    }

    private Node createFontPane() {
        GridPane gridPane = this.createGridPane();
        Label fontFamilyLabel = new Label(this.i18n.getString("UIPointLayerPropertyBuilder.font.family.label", "Font family:"));
        fontFamilyLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Label fontSizeLabel = new Label(this.i18n.getString("UIPointLayerPropertyBuilder.font.size.label", "Font size:"));
        fontSizeLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Label fontColorLabel = new Label(this.i18n.getString("UIPointLayerPropertyBuilder.font.color.label", "Font color:"));
        fontColorLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Label fontBackgroundColorLabel = new Label(this.i18n.getString("UIPointLayerPropertyBuilder.font.background_color.label", "Background color:"));
        fontBackgroundColorLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Double[] fontSizes = new Double[10];
        int i = 0;
        while (i < fontSizes.length) {
            fontSizes[i] = 6.0 + (double)(2 * i);
            ++i;
        }
        this.fontFamilyComboBox = this.createFontFamliyComboBox(this.i18n.getString("UIPointLayerPropertyBuilder.font.family.tooltip", "Set font familiy"));
        this.fontSizeComboBox = this.createSizeComboBox(this.i18n.getString("UIPointLayerPropertyBuilder.font.size.tooltip", "Set font size"), fontSizes, 1);
        this.fontColorPicker = this.createColorPicker(Color.BLACK, this.i18n.getString("UIPointLayerPropertyBuilder.font.color.tooltip", "Set font color"));
        this.fontBackgroundColorPicker = this.createColorPicker(new Color(1.0, 1.0, 1.0, 0.25), this.i18n.getString("UIPointLayerPropertyBuilder.font.background_color.tooltip", "Set background color"));
        this.fontFamilyComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new FontFamilyChangeListener());
        this.fontSizeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new FontSizeChangeListener());
        this.fontColorPicker.valueProperty().addListener((ChangeListener)new FontColorChangeListener());
        this.fontBackgroundColorPicker.valueProperty().addListener((ChangeListener)new FontBackgroundColorChangeListener());
        fontFamilyLabel.setLabelFor(this.fontFamilyComboBox);
        fontSizeLabel.setLabelFor(this.fontSizeComboBox);
        fontColorLabel.setLabelFor((Node)this.fontColorPicker);
        fontBackgroundColorLabel.setLabelFor((Node)this.fontBackgroundColorPicker);
        GridPane.setHgrow((Node)fontFamilyLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)fontSizeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)fontColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)fontBackgroundColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow(this.fontFamilyComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.fontSizeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.fontColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.fontBackgroundColorPicker, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)fontFamilyLabel, 0, row);
        gridPane.add(this.fontFamilyComboBox, 1, row++);
        gridPane.add((Node)fontSizeLabel, 0, row);
        gridPane.add(this.fontSizeComboBox, 1, row++);
        gridPane.add((Node)fontColorLabel, 0, row);
        gridPane.add((Node)this.fontColorPicker, 1, row++);
        gridPane.add((Node)fontBackgroundColorLabel, 0, row);
        gridPane.add((Node)this.fontBackgroundColorPicker, 1, row++);
        return this.createTitledPane(this.i18n.getString("UIPointLayerPropertyBuilder.font.title", "Font properties"), (Node)gridPane);
    }

    private Node createSymbolPane() {
        GridPane gridPane = this.createGridPane();
        Label symbolTypeLabel = new Label(this.i18n.getString("UIPointLayerPropertyBuilder.symbol.type.label", "Symbol type:"));
        symbolTypeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label symbolSizeLabel = new Label(this.i18n.getString("UIPointLayerPropertyBuilder.symbol.size.label", "Symbol size:"));
        symbolSizeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label symbolColorLabel = new Label(this.i18n.getString("UIPointLayerPropertyBuilder.symbol.color.label", "Symbol color:"));
        symbolColorLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label symbolLineWidthLabel = new Label(this.i18n.getString("UIPointLayerPropertyBuilder.symbol.linewidth.label", "Line width:"));
        symbolLineWidthLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Double[] symbolSizes = new Double[21];
        int i = 0;
        while (i < symbolSizes.length) {
            symbolSizes[i] = 5.0 + 0.5 * (double)i;
            ++i;
        }
        this.symbolTypeComboBox = this.createSymbolComboBox(this.i18n.getString("UIPointLayerPropertyBuilder.symbol.type.tooltip", "Set point symbol type"));
        this.symbolSizeComboBox = this.createSizeComboBox(this.i18n.getString("UIPointLayerPropertyBuilder.symbol.size.tooltip", "Set point symbol size"), symbolSizes, 1);
        this.lineWidthComboBox = this.createLineWidthComboBox(this.i18n.getString("UIPointLayerPropertyBuilder.symbol.linewidth.tooltip", "Set line width"));
        this.symbolColorPicker = this.createColorPicker(Color.DARKBLUE, this.i18n.getString("UIPointLayerPropertyBuilder.symbol.color.tooltip", "Set symbol color"));
        this.symbolTypeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new SymbolTypeChangeListener());
        this.symbolSizeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new SymbolSizeChangeListener());
        this.lineWidthComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new LineWidthChangeListener());
        this.symbolColorPicker.valueProperty().addListener((ChangeListener)new ColorChangeListener());
        symbolTypeLabel.setLabelFor(this.symbolTypeComboBox);
        symbolSizeLabel.setLabelFor(this.symbolSizeComboBox);
        symbolColorLabel.setLabelFor((Node)this.symbolColorPicker);
        symbolLineWidthLabel.setLabelFor(this.lineWidthComboBox);
        GridPane.setHgrow((Node)symbolTypeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)symbolSizeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)symbolColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)symbolLineWidthLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow(this.symbolTypeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.symbolSizeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.symbolColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.lineWidthComboBox, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)symbolTypeLabel, 0, row);
        gridPane.add(this.symbolTypeComboBox, 1, row++);
        gridPane.add((Node)symbolSizeLabel, 0, row);
        gridPane.add(this.symbolSizeComboBox, 1, row++);
        gridPane.add((Node)symbolColorLabel, 0, row);
        gridPane.add((Node)this.symbolColorPicker, 1, row++);
        gridPane.add((Node)symbolLineWidthLabel, 0, row);
        gridPane.add(this.lineWidthComboBox, 1, row++);
        return this.createTitledPane(this.i18n.getString("UIPointLayerPropertyBuilder.symbol.title", "Symbol properties"), (Node)gridPane);
    }

    private Node createHighlightPane() {
        GridPane gridPane = this.createGridPane();
        Label highlightColorLabel = new Label(this.i18n.getString("UIPointLayerPropertyBuilder.highlight.color.label", "Highlight color:"));
        highlightColorLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label highlightTypeLabel = new Label(this.i18n.getString("UIPointLayerPropertyBuilder.highlight.type.label", "Highlight type:"));
        highlightTypeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label highlightLineWidthLabel = new Label(this.i18n.getString("UIPointLayerPropertyBuilder.highlight.linewidth.label", "Line width:"));
        highlightLineWidthLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.highlightTypeComboBox = this.createHighlightTypeComboBox(this.i18n.getString("UIPointLayerPropertyBuilder.highlight.type.tooltip", "Set type of highlighting"), this.getHighlightTypeStringConverter());
        this.highlightLineWidthComboBox = this.createLineWidthComboBox(this.i18n.getString("UIPointLayerPropertyBuilder.highlight.linewidth.tooltip", "Set line width for highlighting"));
        this.highlightColorPicker = this.createColorPicker(Color.DARKBLUE, this.i18n.getString("UIPointLayerPropertyBuilder.highlight.color.tooltip", "Set color of highlighting"));
        this.highlightColorPicker.valueProperty().addListener((ChangeListener)new HighlightColorChangeListener());
        this.highlightLineWidthComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new HighlightLineWidthChangeListener());
        this.highlightTypeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new HighlightTypeChangeListener());
        highlightColorLabel.setLabelFor((Node)this.highlightColorPicker);
        highlightTypeLabel.setLabelFor(this.highlightTypeComboBox);
        highlightLineWidthLabel.setLabelFor(this.highlightLineWidthComboBox);
        GridPane.setHgrow((Node)highlightColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)highlightTypeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)highlightLineWidthLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.highlightColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.highlightTypeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.highlightLineWidthComboBox, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)highlightTypeLabel, 0, row);
        gridPane.add(this.highlightTypeComboBox, 1, row++);
        gridPane.add((Node)highlightColorLabel, 0, row);
        gridPane.add((Node)this.highlightColorPicker, 1, row++);
        gridPane.add((Node)highlightLineWidthLabel, 0, row);
        gridPane.add(this.highlightLineWidthComboBox, 1, row++);
        return this.createTitledPane(this.i18n.getString("UIPointLayerPropertyBuilder.highlight.title", "Highlight properties"), (Node)gridPane);
    }

    private Node createPointDimensionVisibilityPane() {
        GridPane gridPane = this.createGridPane();
        this.point1DVisibleCheckBox = this.createCheckBox(this.i18n.getString("UIPointLayerPropertyBuilder.dimension.1d.label", "1D points"), this.i18n.getString("UIPointLayerPropertyBuilder.dimension.1d.tooltip", "If checked, 1D points will be drawn"));
        this.point2DVisibleCheckBox = this.createCheckBox(this.i18n.getString("UIPointLayerPropertyBuilder.dimension.2d.label", "2D points"), this.i18n.getString("UIPointLayerPropertyBuilder.dimension.2d.tooltip", "If checked, 2D points will be drawn"));
        this.point3DVisibleCheckBox = this.createCheckBox(this.i18n.getString("UIPointLayerPropertyBuilder.dimension.3d.label", "3D points"), this.i18n.getString("UIPointLayerPropertyBuilder.dimension.3d.tooltip", "If checked, 3D points will be drawn"));
        this.point1DVisibleCheckBox.selectedProperty().addListener((ChangeListener)new PointVisibleChangeListener(1));
        this.point2DVisibleCheckBox.selectedProperty().addListener((ChangeListener)new PointVisibleChangeListener(2));
        this.point3DVisibleCheckBox.selectedProperty().addListener((ChangeListener)new PointVisibleChangeListener(3));
        GridPane.setHgrow((Node)this.point1DVisibleCheckBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.point2DVisibleCheckBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.point3DVisibleCheckBox, (Priority)Priority.NEVER);
        int row = 0;
        gridPane.add((Node)this.point1DVisibleCheckBox, 0, row++);
        gridPane.add((Node)this.point2DVisibleCheckBox, 0, row++);
        gridPane.add((Node)this.point3DVisibleCheckBox, 0, row++);
        Region spacer = new Region();
        GridPane.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        gridPane.add((Node)spacer, 1, 0, 1, row);
        return this.createTitledPane(this.i18n.getString("UIPointLayerPropertyBuilder.dimension.title", "Visibility properties"), (Node)gridPane);
    }

    private ComboBox<PointSymbolType> createSymbolComboBox(String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])PointSymbolType.values());
        typeComboBox.getSelectionModel().select(0);
        typeComboBox.setCellFactory((Callback)new Callback<ListView<PointSymbolType>, ListCell<PointSymbolType>>(){

            public ListCell<PointSymbolType> call(ListView<PointSymbolType> param) {
                return new PointSymbolTypeListCell();
            }
        });
        typeComboBox.setButtonCell((ListCell)new PointSymbolTypeListCell());
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    private void prepareHighlightTypeComboBox(ComboBox<TableRowHighlightType> typeComboBox) {
        LinkedHashSet<TableRowHighlightType> supportedHiglightTypes = new LinkedHashSet<TableRowHighlightType>(Arrays.asList(TableRowHighlightType.values()));
        if (this.currentLayer != null) {
            switch (this.currentLayer.getLayerType()) {
                case REFERENCE_POINT_APOSTERIORI: 
                case DATUM_POINT_APOSTERIORI: {
                    supportedHiglightTypes.remove((Object)TableRowHighlightType.INFLUENCE_ON_POSITION);
                    supportedHiglightTypes.remove((Object)TableRowHighlightType.REDUNDANCY);
                    break;
                }
            }
        }
        typeComboBox.getSelectionModel().clearSelection();
        typeComboBox.getItems().setAll(supportedHiglightTypes);
        typeComboBox.getSelectionModel().select((Object)TableRowHighlightType.NONE);
    }

    private StringConverter<TableRowHighlightType> getHighlightTypeStringConverter() {
        return new StringConverter<TableRowHighlightType>(){

            public String toString(TableRowHighlightType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case NONE: {
                        return UIPointLayerPropertyBuilder.this.i18n.getString("UIPointLayerPropertyBuilder.highlight.type.none.label", "None");
                    }
                    case TEST_STATISTIC: {
                        return UIPointLayerPropertyBuilder.this.i18n.getString("UIPointLayerPropertyBuilder.highlight.type.test_statistic.label", "Test statistic");
                    }
                    case REDUNDANCY: {
                        return UIPointLayerPropertyBuilder.this.i18n.getString("UIPointLayerPropertyBuilder.highlight.type.redundancy.label", "Redundancy");
                    }
                    case INFLUENCE_ON_POSITION: {
                        return UIPointLayerPropertyBuilder.this.i18n.getString("UIPointLayerPropertyBuilder.highlight.type.influence_on_position.label", "Influence on position");
                    }
                    case P_PRIO_VALUE: {
                        return UIPointLayerPropertyBuilder.this.i18n.getString("UIPointLayerPropertyBuilder.highlight.type.p_prio.label", "p-Value (a-priori)");
                    }
                    case GROSS_ERROR: {
                        return UIPointLayerPropertyBuilder.this.i18n.getString("UIPointLayerPropertyBuilder.highlight.type.gross_error.label", "Gross error");
                    }
                }
                return null;
            }

            public TableRowHighlightType fromString(String string) {
                return TableRowHighlightType.valueOf(string);
            }
        };
    }

    private class ColorChangeListener
    implements ChangeListener<Color> {
        private ColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                UIPointLayerPropertyBuilder.this.currentLayer.setColor(newValue);
                UIPointLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class FontBackgroundColorChangeListener
    implements ChangeListener<Color> {
        private FontBackgroundColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                UIPointLayerPropertyBuilder.this.currentLayer.setFontBackgroundColor(newValue);
                UIPointLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class FontColorChangeListener
    implements ChangeListener<Color> {
        private FontColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                UIPointLayerPropertyBuilder.this.currentLayer.setFontColor(newValue);
                UIPointLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class FontFamilyChangeListener
    implements ChangeListener<String> {
        private FontFamilyChangeListener() {
        }

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                UIPointLayerPropertyBuilder.this.currentLayer.setFontFamily(newValue);
                UIPointLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class FontSizeChangeListener
    implements ChangeListener<Double> {
        private FontSizeChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                UIPointLayerPropertyBuilder.this.currentLayer.setFontSize(newValue);
                UIPointLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class HighlightColorChangeListener
    implements ChangeListener<Color> {
        private HighlightColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                UIPointLayerPropertyBuilder.this.currentLayer.setHighlightColor(newValue);
                UIPointLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class HighlightLineWidthChangeListener
    implements ChangeListener<Double> {
        private HighlightLineWidthChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                UIPointLayerPropertyBuilder.this.currentLayer.setHighlightLineWidth(newValue);
                UIPointLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class HighlightTypeChangeListener
    implements ChangeListener<TableRowHighlightType> {
        private HighlightTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends TableRowHighlightType> observable, TableRowHighlightType oldValue, TableRowHighlightType newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                UIPointLayerPropertyBuilder.this.currentLayer.setHighlightType(newValue);
                UIPointLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class LineWidthChangeListener
    implements ChangeListener<Double> {
        private LineWidthChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                UIPointLayerPropertyBuilder.this.currentLayer.setLineWidth(newValue);
                UIPointLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class PointVisibleChangeListener
    implements ChangeListener<Boolean> {
        private int dim;

        PointVisibleChangeListener(int dim) {
            this.dim = dim;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                switch (this.dim) {
                    case 1: {
                        UIPointLayerPropertyBuilder.this.currentLayer.setPoint1DVisible(newValue);
                        UIPointLayerPropertyBuilder.this.layerManager.draw();
                        break;
                    }
                    case 2: {
                        UIPointLayerPropertyBuilder.this.currentLayer.setPoint2DVisible(newValue);
                        UIPointLayerPropertyBuilder.this.layerManager.draw();
                        break;
                    }
                    case 3: {
                        UIPointLayerPropertyBuilder.this.currentLayer.setPoint3DVisible(newValue);
                        UIPointLayerPropertyBuilder.this.layerManager.draw();
                    }
                }
            }
        }
    }

    private class SymbolSizeChangeListener
    implements ChangeListener<Double> {
        private SymbolSizeChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                UIPointLayerPropertyBuilder.this.currentLayer.setSymbolSize(newValue);
                UIPointLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class SymbolTypeChangeListener
    implements ChangeListener<PointSymbolType> {
        private SymbolTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends PointSymbolType> observable, PointSymbolType oldValue, PointSymbolType newValue) {
            if (UIPointLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIPointLayerPropertyBuilder.this.layerManager != null) {
                UIPointLayerPropertyBuilder.this.currentLayer.setSymbolType(newValue);
                UIPointLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }
}

