/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerManager;
import org.applied_geodesy.jag3d.ui.graphic.layer.ObservationLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.ObservationSymbolProperties;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.UILayerPropertyBuilder;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;

public class UIObservationLayerPropertyBuilder
extends UILayerPropertyBuilder {
    private I18N i18n = I18N.getInstance();
    private static UIObservationLayerPropertyBuilder observationLayerPropertyBuilder = new UIObservationLayerPropertyBuilder();
    private ComboBox<Double> symbolSizeComboBox;
    private ComboBox<Double> lineWidthComboBox;
    private ColorPicker symbolColorPicker;
    private Node highlightPane = null;
    private ComboBox<Double> highlightLineWidthComboBox;
    private ComboBox<TableRowHighlightType> highlightTypeComboBox;
    private ColorPicker highlightColorPicker;
    private Map<ObservationSymbolProperties.ObservationType, ColorPicker> observationColorPickerMap = new HashMap<ObservationSymbolProperties.ObservationType, ColorPicker>();
    private Map<ObservationSymbolProperties.ObservationType, CheckBox> observationCheckBoxMap = new HashMap<ObservationSymbolProperties.ObservationType, CheckBox>();
    private ObservationLayer currentLayer = null;
    private LayerManager layerManager = null;
    private VBox propertyPane = null;

    private UIObservationLayerPropertyBuilder() {
    }

    private void init() {
        if (this.propertyPane != null) {
            return;
        }
        this.highlightPane = this.createHighlightPane();
        this.propertyPane = new VBox(20.0);
        this.propertyPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.propertyPane.setMinWidth(Double.NEGATIVE_INFINITY);
        this.propertyPane.getChildren().addAll((Object[])new Node[]{this.createSymbolPane(), this.createObservationPaintPane(), this.highlightPane});
    }

    public static Node getLayerPropertyPane(LayerManager layerManager, ObservationLayer layer) {
        UIObservationLayerPropertyBuilder.observationLayerPropertyBuilder.layerManager = null;
        observationLayerPropertyBuilder.init();
        observationLayerPropertyBuilder.set(layer);
        UIObservationLayerPropertyBuilder.observationLayerPropertyBuilder.layerManager = layerManager;
        return UIObservationLayerPropertyBuilder.observationLayerPropertyBuilder.propertyPane;
    }

    private void set(ObservationLayer layer) {
        ObservationSymbolProperties.ObservationType[] observationTypes;
        this.currentLayer = layer;
        this.symbolSizeComboBox.getSelectionModel().select((Object)this.currentLayer.getSymbolSize());
        this.lineWidthComboBox.getSelectionModel().select((Object)this.currentLayer.getLineWidth());
        this.symbolColorPicker.setValue((Object)this.currentLayer.getColor());
        switch (this.currentLayer.getLayerType()) {
            case OBSERVATION_APOSTERIORI: {
                this.highlightColorPicker.setValue((Object)this.currentLayer.getHighlightColor());
                this.highlightLineWidthComboBox.getSelectionModel().select((Object)this.currentLayer.getHighlightLineWidth());
                this.highlightTypeComboBox.getSelectionModel().select((Object)this.currentLayer.getHighlightType());
                this.highlightPane.setVisible(true);
                this.highlightPane.setManaged(true);
                break;
            }
            default: {
                this.highlightPane.setVisible(false);
                this.highlightPane.setManaged(false);
            }
        }
        ObservationSymbolProperties.ObservationType[] observationTypeArray = observationTypes = ObservationSymbolProperties.ObservationType.values();
        int n = observationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ObservationSymbolProperties.ObservationType observationType = observationTypeArray[n2];
            ObservationSymbolProperties properties = this.currentLayer.getObservationSymbolProperties(observationType);
            CheckBox checkBox = this.observationCheckBoxMap.get((Object)observationType);
            ColorPicker colorPicker = this.observationColorPickerMap.get((Object)observationType);
            checkBox.setSelected(properties.isVisible());
            colorPicker.setValue((Object)properties.getColor());
            ++n2;
        }
    }

    private Node createObservationPaintPane() {
        ObservationSymbolProperties.ObservationType[] observationTypes;
        GridPane gridPane = this.createGridPane();
        ObservationSymbolProperties.ObservationType[] observationTypeArray = observationTypes = ObservationSymbolProperties.ObservationType.values();
        int n = observationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ObservationSymbolProperties.ObservationType observationType = observationTypeArray[n2];
            switch (observationType) {
                case LEVELING: {
                    this.observationCheckBoxMap.put(observationType, this.createCheckBox(this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.leveling.enable.label", "Leveling:"), this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.leveling.enable.tooltip", "If checked, leveling will be drawn")));
                    this.observationColorPickerMap.put(observationType, this.createColorPicker(Color.DARKBLUE, this.i18n.getString("UIObservationLayerPropertyBuilder.color.leveling.tooltip", "Set color of leveling data")));
                    break;
                }
                case DIRECTION: {
                    this.observationCheckBoxMap.put(observationType, this.createCheckBox(this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.direction.enable.label", "Direction:"), this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.direction.enable.tooltip", "If checked, directions will be drawn")));
                    this.observationColorPickerMap.put(observationType, this.createColorPicker(Color.DARKBLUE, this.i18n.getString("UIObservationLayerPropertyBuilder.color.direction.tooltip", "Set color of direction measurements")));
                    break;
                }
                case DISTANCE: {
                    this.observationCheckBoxMap.put(observationType, this.createCheckBox(this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.distance.enable.label", "Distance:"), this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.distance.enable.tooltip", "If checked, distances will be drawn")));
                    this.observationColorPickerMap.put(observationType, this.createColorPicker(Color.DARKBLUE, this.i18n.getString("UIObservationLayerPropertyBuilder.color.distance.tooltip", "Set color of distance measurements")));
                    break;
                }
                case ZENITH_ANGLE: {
                    this.observationCheckBoxMap.put(observationType, this.createCheckBox(this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.zenith_angle.enable.label", "Zenith angle:"), this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.zenith_angle.enable.tooltip", "If checked, zenith angles will be drawn")));
                    this.observationColorPickerMap.put(observationType, this.createColorPicker(Color.DARKBLUE, this.i18n.getString("UIObservationLayerPropertyBuilder.color.zenith_angle.tooltip", "Set color of zenith angle measurements")));
                    break;
                }
                case GNSS: {
                    this.observationCheckBoxMap.put(observationType, this.createCheckBox(this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.gnss.enable.label", "GNSS Baseline:"), this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.gnss.enable.tooltip", "If checked, GNSS baselines will be drawn")));
                    this.observationColorPickerMap.put(observationType, this.createColorPicker(Color.DARKBLUE, this.i18n.getString("UIObservationLayerPropertyBuilder.color.gnss.tooltip", "Set color of GNSS measurements")));
                }
            }
            ++n2;
        }
        int row = 0;
        ObservationSymbolProperties.ObservationType[] observationTypeArray2 = observationTypes;
        int n3 = observationTypes.length;
        n = 0;
        while (n < n3) {
            ObservationSymbolProperties.ObservationType observationType = observationTypeArray2[n];
            CheckBox checkBox = this.observationCheckBoxMap.get((Object)observationType);
            ColorPicker colorPicker = this.observationColorPickerMap.get((Object)observationType);
            checkBox.selectedProperty().addListener((ChangeListener)new ObservationEnableChangeListener(observationType));
            colorPicker.valueProperty().addListener((ChangeListener)new ObservationColorChangeListener(observationType));
            GridPane.setHgrow((Node)checkBox, (Priority)Priority.NEVER);
            GridPane.setHgrow((Node)colorPicker, (Priority)Priority.ALWAYS);
            gridPane.add((Node)checkBox, 0, row);
            gridPane.add((Node)colorPicker, 1, row++);
            ++n;
        }
        return this.createTitledPane(this.i18n.getString("UIObservationLayerPropertyBuilder.observation.title", "Observation properties"), (Node)gridPane);
    }

    private Node createSymbolPane() {
        GridPane gridPane = this.createGridPane();
        Label symbolSizeLabel = new Label(this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.size.label", "Symbol size:"));
        symbolSizeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label symbolColorLabel = new Label(this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.color.label", "Symbol color:"));
        symbolColorLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label symbolLineWidthLabel = new Label(this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.linewidth.label", "Line width:"));
        symbolLineWidthLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Double[] symbolSizes = new Double[21];
        int i = 0;
        while (i < symbolSizes.length) {
            symbolSizes[i] = 5.0 + 0.5 * (double)i;
            ++i;
        }
        this.symbolSizeComboBox = this.createSizeComboBox(this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.size.tooltip", "Set symbol size"), symbolSizes, 1);
        this.lineWidthComboBox = this.createLineWidthComboBox(this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.linewidth.tooltip", "Set line width"));
        this.symbolColorPicker = this.createColorPicker(Color.DARKBLUE, this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.color.tooltip", "Set symbol color"));
        this.symbolSizeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new SymbolSizeChangeListener());
        this.lineWidthComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new LineWidthChangeListener());
        this.symbolColorPicker.valueProperty().addListener((ChangeListener)new ColorChangeListener());
        symbolSizeLabel.setLabelFor(this.symbolSizeComboBox);
        symbolColorLabel.setLabelFor((Node)this.symbolColorPicker);
        symbolLineWidthLabel.setLabelFor(this.lineWidthComboBox);
        GridPane.setHgrow((Node)symbolSizeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)symbolColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)symbolLineWidthLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow(this.symbolSizeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.symbolColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.lineWidthComboBox, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)symbolSizeLabel, 0, row);
        gridPane.add(this.symbolSizeComboBox, 1, row++);
        gridPane.add((Node)symbolColorLabel, 0, row);
        gridPane.add((Node)this.symbolColorPicker, 1, row++);
        gridPane.add((Node)symbolLineWidthLabel, 0, row);
        gridPane.add(this.lineWidthComboBox, 1, row++);
        return this.createTitledPane(this.i18n.getString("UIObservationLayerPropertyBuilder.symbol.title", "Symbol properties"), (Node)gridPane);
    }

    private Node createHighlightPane() {
        GridPane gridPane = this.createGridPane();
        Label highlightColorLabel = new Label(this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.color.label", "Highlight color:"));
        highlightColorLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label highlightTypeLabel = new Label(this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.type.label", "Highlight type:"));
        highlightTypeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label highlightLineWidthLabel = new Label(this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.linewidth.label", "Line width:"));
        highlightLineWidthLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.highlightTypeComboBox = this.createHighlightTypeComboBox(this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.type.tooltip", "Set type of highlighting"), this.getHighlightTypeStringConverter());
        this.highlightLineWidthComboBox = this.createLineWidthComboBox(this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.linewidth.tooltip", "Set line width for highlighting"));
        this.highlightColorPicker = this.createColorPicker(Color.DARKBLUE, this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.color.tooltip", "Set color of highlighting"));
        this.highlightColorPicker.valueProperty().addListener((ChangeListener)new HighlightColorChangeListener());
        this.highlightLineWidthComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new HighlightLineWidthChangeListener());
        this.highlightTypeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new HighlightTypeChangeListener());
        highlightColorLabel.setLabelFor((Node)this.highlightColorPicker);
        highlightTypeLabel.setLabelFor(this.highlightTypeComboBox);
        highlightLineWidthLabel.setLabelFor(this.highlightLineWidthComboBox);
        GridPane.setHgrow((Node)highlightColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)highlightTypeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)highlightLineWidthLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.highlightColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.highlightTypeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.highlightLineWidthComboBox, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)highlightTypeLabel, 0, row);
        gridPane.add(this.highlightTypeComboBox, 1, row++);
        gridPane.add((Node)highlightColorLabel, 0, row);
        gridPane.add((Node)this.highlightColorPicker, 1, row++);
        gridPane.add((Node)highlightLineWidthLabel, 0, row);
        gridPane.add(this.highlightLineWidthComboBox, 1, row++);
        return this.createTitledPane(this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.title", "Highlight properties"), (Node)gridPane);
    }

    private StringConverter<TableRowHighlightType> getHighlightTypeStringConverter() {
        return new StringConverter<TableRowHighlightType>(){

            public String toString(TableRowHighlightType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case NONE: {
                        return UIObservationLayerPropertyBuilder.this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.type.none.label", "None");
                    }
                    case TEST_STATISTIC: {
                        return UIObservationLayerPropertyBuilder.this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.type.test_statistic.label", "Test statistic");
                    }
                    case REDUNDANCY: {
                        return UIObservationLayerPropertyBuilder.this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.type.redundancy.label", "Redundancy");
                    }
                    case INFLUENCE_ON_POSITION: {
                        return UIObservationLayerPropertyBuilder.this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.type.influence_on_position.label", "Influence on position");
                    }
                    case P_PRIO_VALUE: {
                        return UIObservationLayerPropertyBuilder.this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.type.p_prio.label", "p-Value (a-priori)");
                    }
                    case GROSS_ERROR: {
                        return UIObservationLayerPropertyBuilder.this.i18n.getString("UIObservationLayerPropertyBuilder.highlight.type.gross_error.label", "Gross error");
                    }
                }
                return null;
            }

            public TableRowHighlightType fromString(String string) {
                return TableRowHighlightType.valueOf(string);
            }
        };
    }

    private class ColorChangeListener
    implements ChangeListener<Color> {
        private ColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UIObservationLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIObservationLayerPropertyBuilder.this.layerManager != null) {
                UIObservationLayerPropertyBuilder.this.currentLayer.setColor(newValue);
                UIObservationLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class HighlightColorChangeListener
    implements ChangeListener<Color> {
        private HighlightColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UIObservationLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIObservationLayerPropertyBuilder.this.layerManager != null) {
                UIObservationLayerPropertyBuilder.this.currentLayer.setHighlightColor(newValue);
                UIObservationLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class HighlightLineWidthChangeListener
    implements ChangeListener<Double> {
        private HighlightLineWidthChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UIObservationLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIObservationLayerPropertyBuilder.this.layerManager != null) {
                UIObservationLayerPropertyBuilder.this.currentLayer.setHighlightLineWidth(newValue);
                UIObservationLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class HighlightTypeChangeListener
    implements ChangeListener<TableRowHighlightType> {
        private HighlightTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends TableRowHighlightType> observable, TableRowHighlightType oldValue, TableRowHighlightType newValue) {
            if (UIObservationLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIObservationLayerPropertyBuilder.this.layerManager != null) {
                UIObservationLayerPropertyBuilder.this.currentLayer.setHighlightType(newValue);
                UIObservationLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class LineWidthChangeListener
    implements ChangeListener<Double> {
        private LineWidthChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UIObservationLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIObservationLayerPropertyBuilder.this.layerManager != null) {
                UIObservationLayerPropertyBuilder.this.currentLayer.setLineWidth(newValue);
                UIObservationLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class ObservationColorChangeListener
    implements ChangeListener<Color> {
        private ObservationSymbolProperties.ObservationType observationType;

        ObservationColorChangeListener(ObservationSymbolProperties.ObservationType observationType) {
            this.observationType = observationType;
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            ObservationSymbolProperties properties;
            if (UIObservationLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIObservationLayerPropertyBuilder.this.layerManager != null && (properties = UIObservationLayerPropertyBuilder.this.currentLayer.getObservationSymbolProperties(this.observationType)) != null) {
                properties.setColor(newValue);
                UIObservationLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class ObservationEnableChangeListener
    implements ChangeListener<Boolean> {
        private ObservationSymbolProperties.ObservationType observationType;

        ObservationEnableChangeListener(ObservationSymbolProperties.ObservationType observationType) {
            this.observationType = observationType;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            ObservationSymbolProperties properties;
            if (UIObservationLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIObservationLayerPropertyBuilder.this.layerManager != null && (properties = UIObservationLayerPropertyBuilder.this.currentLayer.getObservationSymbolProperties(this.observationType)) != null) {
                properties.setVisible(newValue);
                UIObservationLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class SymbolSizeChangeListener
    implements ChangeListener<Double> {
        private SymbolSizeChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UIObservationLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIObservationLayerPropertyBuilder.this.layerManager != null) {
                UIObservationLayerPropertyBuilder.this.currentLayer.setSymbolSize(newValue);
                UIObservationLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }
}

