/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerManager;
import org.applied_geodesy.jag3d.ui.graphic.layer.LegendLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LegendPositionType;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.UILayerPropertyBuilder;
import org.applied_geodesy.jag3d.ui.i18n.I18N;

public class UILegendLayerPropertyBuilder
extends UILayerPropertyBuilder {
    private I18N i18n = I18N.getInstance();
    private static UILegendLayerPropertyBuilder legendLayerPropertyBuilder = new UILegendLayerPropertyBuilder();
    private ColorPicker fontColorPicker;
    private ColorPicker fontBackgroundColorPicker;
    private ComboBox<String> fontFamilyComboBox;
    private ComboBox<Double> fontSizeComboBox;
    private ComboBox<Double> lineWidthComboBox;
    private ColorPicker borderColorPicker;
    private ComboBox<LegendPositionType> legendPositionTypeComboBox;
    private LegendLayer currentLayer = null;
    private LayerManager layerManager = null;
    private VBox propertyPane = null;

    private UILegendLayerPropertyBuilder() {
    }

    private void init() {
        if (this.propertyPane != null) {
            return;
        }
        this.propertyPane = new VBox(20.0);
        this.propertyPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.propertyPane.setMinHeight(Double.NEGATIVE_INFINITY);
        this.propertyPane.getChildren().addAll((Object[])new Node[]{this.createSymbolPane(), this.createFontPane()});
    }

    public static Node getLayerPropertyPane(LayerManager layerManager, LegendLayer layer) {
        UILegendLayerPropertyBuilder.legendLayerPropertyBuilder.layerManager = null;
        legendLayerPropertyBuilder.init();
        legendLayerPropertyBuilder.set(layer);
        UILegendLayerPropertyBuilder.legendLayerPropertyBuilder.layerManager = layerManager;
        return UILegendLayerPropertyBuilder.legendLayerPropertyBuilder.propertyPane;
    }

    private void set(LegendLayer layer) {
        this.currentLayer = layer;
        this.fontFamilyComboBox.getSelectionModel().select((Object)this.currentLayer.getFontFamily());
        this.fontSizeComboBox.getSelectionModel().select((Object)this.currentLayer.getFontSize());
        this.fontColorPicker.setValue((Object)this.currentLayer.getFontColor());
        this.fontBackgroundColorPicker.setValue((Object)this.currentLayer.getFontBackgroundColor());
        this.lineWidthComboBox.getSelectionModel().select((Object)this.currentLayer.getLineWidth());
        this.borderColorPicker.setValue((Object)this.currentLayer.getColor());
        this.legendPositionTypeComboBox.getSelectionModel().select((Object)this.currentLayer.getLegendPositionType());
    }

    private Node createSymbolPane() {
        GridPane gridPane = this.createGridPane();
        Label borderColorLabel = new Label(this.i18n.getString("UILegendLayerPropertyBuilder.border.color.label", "Border color:"));
        borderColorLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label borderLineWidthLabel = new Label(this.i18n.getString("UILegendLayerPropertyBuilder.border.linewidth.label", "Border width:"));
        borderLineWidthLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label legendPositionTypeLabel = new Label(this.i18n.getString("UILegendLayerPropertyBuilder.legendposition.label", "Position:"));
        legendPositionTypeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Double[] symbolSizes = new Double[21];
        int i = 0;
        while (i < symbolSizes.length) {
            symbolSizes[i] = 5.0 + 0.5 * (double)i;
            ++i;
        }
        this.lineWidthComboBox = this.createLineWidthComboBox(this.i18n.getString("UILegendLayerPropertyBuilder.border.linewidth.tooltip", "Set line width"));
        this.legendPositionTypeComboBox = this.createEstimationTypeComboBox(LegendPositionType.NORTH_EAST, this.i18n.getString("UILegendLayerPropertyBuilder.legendposition.tooltip", "Set legend position"));
        this.borderColorPicker = this.createColorPicker(Color.LIGHTSLATEGREY, this.i18n.getString("UILegendLayerPropertyBuilder.border.color.tooltip", "Set legend border color"));
        this.lineWidthComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new LineWidthChangeListener());
        this.legendPositionTypeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new LegendPositionTypeChangeListener());
        this.borderColorPicker.valueProperty().addListener((ChangeListener)new ColorChangeListener());
        borderColorLabel.setLabelFor((Node)this.borderColorPicker);
        borderLineWidthLabel.setLabelFor(this.lineWidthComboBox);
        legendPositionTypeLabel.setLabelFor(this.legendPositionTypeComboBox);
        GridPane.setHgrow((Node)borderColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)borderLineWidthLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)legendPositionTypeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.borderColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.lineWidthComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.legendPositionTypeComboBox, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)borderColorLabel, 0, row);
        gridPane.add((Node)this.borderColorPicker, 1, row++);
        gridPane.add((Node)borderLineWidthLabel, 0, row);
        gridPane.add(this.lineWidthComboBox, 1, row++);
        gridPane.add((Node)legendPositionTypeLabel, 0, row);
        gridPane.add(this.legendPositionTypeComboBox, 1, row++);
        return this.createTitledPane(this.i18n.getString("UILegendLayerPropertyBuilder.border.title", "Border properties"), (Node)gridPane);
    }

    private Node createFontPane() {
        GridPane gridPane = this.createGridPane();
        Label fontFamilyLabel = new Label(this.i18n.getString("UILegendLayerPropertyBuilder.font.family.label", "Font family:"));
        fontFamilyLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Label fontSizeLabel = new Label(this.i18n.getString("UILegendLayerPropertyBuilder.font.size.label", "Font size:"));
        fontSizeLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Label fontColorLabel = new Label(this.i18n.getString("UILegendLayerPropertyBuilder.font.color.label", "Font color:"));
        fontColorLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Label fontBackgroundColorLabel = new Label(this.i18n.getString("UILegendLayerPropertyBuilder.font.background_color.label", "Background color:"));
        fontBackgroundColorLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Double[] fontSizes = new Double[10];
        int i = 0;
        while (i < fontSizes.length) {
            fontSizes[i] = 6.0 + (double)(2 * i);
            ++i;
        }
        this.fontFamilyComboBox = this.createFontFamliyComboBox(this.i18n.getString("UILegendLayerPropertyBuilder.font.family.tooltip", "Set font family"));
        this.fontSizeComboBox = this.createSizeComboBox(this.i18n.getString("UILegendLayerPropertyBuilder.font.size.tooltip", "Set font size"), fontSizes, 1);
        this.fontColorPicker = this.createColorPicker(Color.SLATEGREY, this.i18n.getString("UILegendLayerPropertyBuilder.font.color.tooltip", "Set font color"));
        this.fontBackgroundColorPicker = this.createColorPicker(new Color(1.0, 1.0, 1.0, 0.9), this.i18n.getString("UILegendLayerPropertyBuilder.font.background_color.tooltip", "Set background color"));
        this.fontFamilyComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new FontFamilyChangeListener());
        this.fontSizeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new FontSizeChangeListener());
        this.fontColorPicker.valueProperty().addListener((ChangeListener)new FontColorChangeListener());
        this.fontBackgroundColorPicker.valueProperty().addListener((ChangeListener)new FontBackgroundColorChangeListener());
        fontFamilyLabel.setLabelFor(this.fontFamilyComboBox);
        fontSizeLabel.setLabelFor(this.fontSizeComboBox);
        fontColorLabel.setLabelFor((Node)this.fontColorPicker);
        fontBackgroundColorLabel.setLabelFor((Node)this.fontBackgroundColorPicker);
        GridPane.setHgrow((Node)fontFamilyLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)fontSizeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)fontColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)fontBackgroundColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow(this.fontFamilyComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.fontSizeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.fontColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.fontBackgroundColorPicker, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)fontFamilyLabel, 0, row);
        gridPane.add(this.fontFamilyComboBox, 1, row++);
        gridPane.add((Node)fontSizeLabel, 0, row);
        gridPane.add(this.fontSizeComboBox, 1, row++);
        gridPane.add((Node)fontColorLabel, 0, row);
        gridPane.add((Node)this.fontColorPicker, 1, row++);
        gridPane.add((Node)fontBackgroundColorLabel, 0, row);
        gridPane.add((Node)this.fontBackgroundColorPicker, 1, row++);
        return this.createTitledPane(this.i18n.getString("UILegendLayerPropertyBuilder.font.title", "Font properties"), (Node)gridPane);
    }

    private ComboBox<LegendPositionType> createEstimationTypeComboBox(LegendPositionType item, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])LegendPositionType.values());
        typeComboBox.getSelectionModel().select((Object)item);
        typeComboBox.setConverter((StringConverter)new StringConverter<LegendPositionType>(){

            public String toString(LegendPositionType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case NORTH: {
                        return UILegendLayerPropertyBuilder.this.i18n.getString("UILegendLayerPropertyBuilder.legendposition.north.label", "Noth");
                    }
                    case EAST: {
                        return UILegendLayerPropertyBuilder.this.i18n.getString("UILegendLayerPropertyBuilder.legendposition.east.label", "East");
                    }
                    case SOUTH: {
                        return UILegendLayerPropertyBuilder.this.i18n.getString("UILegendLayerPropertyBuilder.legendposition.south.label", "South");
                    }
                    case WEST: {
                        return UILegendLayerPropertyBuilder.this.i18n.getString("UILegendLayerPropertyBuilder.legendposition.west.label", "West");
                    }
                    case NORTH_EAST: {
                        return UILegendLayerPropertyBuilder.this.i18n.getString("UILegendLayerPropertyBuilder.legendposition.northeast.label", "Northeast");
                    }
                    case NORTH_WEST: {
                        return UILegendLayerPropertyBuilder.this.i18n.getString("UILegendLayerPropertyBuilder.legendposition.northwest.label", "Northwest");
                    }
                    case SOUTH_EAST: {
                        return UILegendLayerPropertyBuilder.this.i18n.getString("UILegendLayerPropertyBuilder.legendposition.southeast.label", "Southeast");
                    }
                    case SOUTH_WEST: {
                        return UILegendLayerPropertyBuilder.this.i18n.getString("UILegendLayerPropertyBuilder.legendposition.southwest.label", "Southwest");
                    }
                }
                return null;
            }

            public LegendPositionType fromString(String string) {
                return LegendPositionType.valueOf(string);
            }
        });
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    private class ColorChangeListener
    implements ChangeListener<Color> {
        private ColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UILegendLayerPropertyBuilder.this.currentLayer != null && newValue != null && UILegendLayerPropertyBuilder.this.layerManager != null) {
                UILegendLayerPropertyBuilder.this.currentLayer.setColor(newValue);
                UILegendLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class FontBackgroundColorChangeListener
    implements ChangeListener<Color> {
        private FontBackgroundColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UILegendLayerPropertyBuilder.this.currentLayer != null && newValue != null && UILegendLayerPropertyBuilder.this.layerManager != null) {
                UILegendLayerPropertyBuilder.this.currentLayer.setFontBackgroundColor(newValue);
                UILegendLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class FontColorChangeListener
    implements ChangeListener<Color> {
        private FontColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UILegendLayerPropertyBuilder.this.currentLayer != null && newValue != null && UILegendLayerPropertyBuilder.this.layerManager != null) {
                UILegendLayerPropertyBuilder.this.currentLayer.setFontColor(newValue);
                UILegendLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class FontFamilyChangeListener
    implements ChangeListener<String> {
        private FontFamilyChangeListener() {
        }

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            if (UILegendLayerPropertyBuilder.this.currentLayer != null && newValue != null && UILegendLayerPropertyBuilder.this.layerManager != null) {
                UILegendLayerPropertyBuilder.this.currentLayer.setFontFamily(newValue);
                UILegendLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class FontSizeChangeListener
    implements ChangeListener<Double> {
        private FontSizeChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UILegendLayerPropertyBuilder.this.currentLayer != null && newValue != null && UILegendLayerPropertyBuilder.this.layerManager != null) {
                UILegendLayerPropertyBuilder.this.currentLayer.setFontSize(newValue);
                UILegendLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class LegendPositionTypeChangeListener
    implements ChangeListener<LegendPositionType> {
        private LegendPositionTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends LegendPositionType> observable, LegendPositionType oldValue, LegendPositionType newValue) {
            if (UILegendLayerPropertyBuilder.this.currentLayer != null && newValue != null && UILegendLayerPropertyBuilder.this.layerManager != null) {
                UILegendLayerPropertyBuilder.this.currentLayer.setLegendPositionType(newValue);
                UILegendLayerPropertyBuilder.this.legendPositionTypeComboBox.setValue((Object)newValue);
                UILegendLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class LineWidthChangeListener
    implements ChangeListener<Double> {
        private LineWidthChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UILegendLayerPropertyBuilder.this.currentLayer != null && newValue != null && UILegendLayerPropertyBuilder.this.layerManager != null) {
                UILegendLayerPropertyBuilder.this.currentLayer.setLineWidth(newValue);
                UILegendLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }
}

