/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.LineWidthListCell;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;

public abstract class UILayerPropertyBuilder {
    ComboBox<Double> createLineWidthComboBox(String tooltip) {
        Object[] values = new Double[17];
        int i = 0;
        while (i < values.length) {
            values[i] = 0.25 + 0.25 * (double)i;
            ++i;
        }
        ComboBox lineWidthComboBox = new ComboBox();
        lineWidthComboBox.getItems().setAll(values);
        lineWidthComboBox.getSelectionModel().select(0);
        lineWidthComboBox.setCellFactory((Callback)new Callback<ListView<Double>, ListCell<Double>>(){

            public ListCell<Double> call(ListView<Double> param) {
                return new LineWidthListCell();
            }
        });
        lineWidthComboBox.setButtonCell((ListCell)new LineWidthListCell());
        lineWidthComboBox.setTooltip(new Tooltip(tooltip));
        lineWidthComboBox.setMaxWidth(Double.MAX_VALUE);
        return lineWidthComboBox;
    }

    ComboBox<Double> createSizeComboBox(String tooltip, Double[] values, int digits) {
        final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(digits);
        numberFormat.setMinimumFractionDigits(digits);
        numberFormat.setGroupingUsed(false);
        final ComboBox symbolSizeComboBox = new ComboBox();
        symbolSizeComboBox.getItems().setAll((Object[])values);
        symbolSizeComboBox.setEditable(true);
        symbolSizeComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<Double>(){

            public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
                if (newValue == null) {
                    symbolSizeComboBox.getSelectionModel().select((Object)oldValue);
                }
            }
        });
        symbolSizeComboBox.setConverter((StringConverter)new StringConverter<Double>(){

            public String toString(Double value) {
                return value == null ? null : numberFormat.format(value);
            }

            public Double fromString(String string) {
                if (string == null || string.isEmpty()) {
                    return null;
                }
                try {
                    return numberFormat.parse(string).doubleValue();
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        symbolSizeComboBox.getSelectionModel().select(0);
        symbolSizeComboBox.setTooltip(new Tooltip(tooltip));
        symbolSizeComboBox.setMaxWidth(Double.MAX_VALUE);
        symbolSizeComboBox.setMinWidth(65.0);
        symbolSizeComboBox.setPrefWidth(75.0);
        return symbolSizeComboBox;
    }

    GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(20.0);
        gridPane.setVgap(10.0);
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setPadding(new Insets(5.0, 15.0, 5.0, 15.0));
        return gridPane;
    }

    TitledPane createTitledPane(String title, Node content) {
        TitledPane titledPane = new TitledPane();
        titledPane.setCollapsible(false);
        titledPane.setAnimated(false);
        titledPane.setContent(content);
        titledPane.setPadding(new Insets(0.0, 10.0, 5.0, 10.0));
        titledPane.setText(title);
        return titledPane;
    }

    CheckBox createCheckBox(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        checkBox.setMaxWidth(Double.MAX_VALUE);
        return checkBox;
    }

    ComboBox<String> createFontFamliyComboBox(String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Collection)Font.getFamilies());
        typeComboBox.getSelectionModel().select((Object)Font.getDefault().getFamily());
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    ComboBox<TableRowHighlightType> createHighlightTypeComboBox(String tooltip, StringConverter<TableRowHighlightType> converter) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])TableRowHighlightType.values());
        typeComboBox.getSelectionModel().select((Object)TableRowHighlightType.NONE);
        typeComboBox.setConverter(converter);
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMinWidth(150.0);
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    ColorPicker createColorPicker(Color color, String tooltip) {
        ColorPicker colorPicker = new ColorPicker(color);
        colorPicker.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        colorPicker.setMaxWidth(Double.MAX_VALUE);
        colorPicker.getStyleClass().add((Object)"split-button");
        colorPicker.setTooltip(new Tooltip(tooltip));
        return colorPicker;
    }
}

