/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.applied_geodesy.jag3d.ui.graphic.layer.ConfidenceLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerManager;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.UILayerPropertyBuilder;
import org.applied_geodesy.jag3d.ui.i18n.I18N;

public class UIConfidenceLayerPropertyBuilder
extends UILayerPropertyBuilder {
    private I18N i18n = I18N.getInstance();
    private static UIConfidenceLayerPropertyBuilder confidenceLayerPropertyBuilder = new UIConfidenceLayerPropertyBuilder();
    private ComboBox<Double> lineWidthComboBox;
    private ColorPicker symbolStrokeColorPicker;
    private ColorPicker symbolFillColorPicker;
    private ConfidenceLayer<?> currentLayer = null;
    private VBox propertyPane = null;
    private LayerManager layerManager = null;

    private UIConfidenceLayerPropertyBuilder() {
    }

    private void init() {
        if (this.propertyPane != null) {
            return;
        }
        this.propertyPane = new VBox(20.0);
        this.propertyPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.propertyPane.setMinWidth(Double.NEGATIVE_INFINITY);
        this.propertyPane.getChildren().addAll((Object[])new Node[]{this.createSymbolPane()});
    }

    public static Node getLayerPropertyPane(LayerManager layerManager, ConfidenceLayer<?> layer) {
        UIConfidenceLayerPropertyBuilder.confidenceLayerPropertyBuilder.layerManager = null;
        confidenceLayerPropertyBuilder.init();
        confidenceLayerPropertyBuilder.set(layer);
        UIConfidenceLayerPropertyBuilder.confidenceLayerPropertyBuilder.layerManager = layerManager;
        return UIConfidenceLayerPropertyBuilder.confidenceLayerPropertyBuilder.propertyPane;
    }

    private void set(ConfidenceLayer<?> layer) {
        this.currentLayer = layer;
        this.lineWidthComboBox.getSelectionModel().select((Object)this.currentLayer.getLineWidth());
        this.symbolStrokeColorPicker.setValue((Object)this.currentLayer.getStrokeColor());
        this.symbolFillColorPicker.setValue((Object)this.currentLayer.getColor());
    }

    private Node createSymbolPane() {
        GridPane gridPane = this.createGridPane();
        Label symbolStrokeColorLabel = new Label(this.i18n.getString("UIConfidenceLayerPropertyBuilder.symbol.color.label", "Stroke color:"));
        symbolStrokeColorLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Label symbolFillColorLabel = new Label(this.i18n.getString("UIConfidenceLayerPropertyBuilder.symbol.fill_color.label", "Fill color:"));
        symbolFillColorLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Label symbolLineWidthLabel = new Label(this.i18n.getString("UIConfidenceLayerPropertyBuilder.symbol.linewidth.label", "Line width:"));
        symbolLineWidthLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        this.lineWidthComboBox = this.createLineWidthComboBox(this.i18n.getString("UIConfidenceLayerPropertyBuilder.symbol.linewidth.tooltip", "Set line width"));
        this.symbolStrokeColorPicker = this.createColorPicker(Color.BLACK, this.i18n.getString("UIConfidenceLayerPropertyBuilder.symbol.color.tooltip", "Set stroke color"));
        this.symbolFillColorPicker = this.createColorPicker(Color.LIGHTGREY, this.i18n.getString("UIConfidenceLayerPropertyBuilder.symbol.fill_color.tooltip", "Set fill color"));
        this.lineWidthComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new LineWidthChangeListener());
        this.symbolFillColorPicker.valueProperty().addListener((ChangeListener)new FillColorChangeListener());
        this.symbolStrokeColorPicker.valueProperty().addListener((ChangeListener)new StrokeColorChangeListener());
        symbolStrokeColorLabel.setLabelFor((Node)this.symbolStrokeColorPicker);
        symbolFillColorLabel.setLabelFor((Node)this.symbolFillColorPicker);
        symbolLineWidthLabel.setLabelFor(this.lineWidthComboBox);
        GridPane.setHgrow((Node)symbolStrokeColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)symbolFillColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)symbolLineWidthLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.symbolStrokeColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.symbolFillColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.lineWidthComboBox, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)symbolStrokeColorLabel, 0, row);
        gridPane.add((Node)this.symbolStrokeColorPicker, 1, row++);
        gridPane.add((Node)symbolFillColorLabel, 0, row);
        gridPane.add((Node)this.symbolFillColorPicker, 1, row++);
        gridPane.add((Node)symbolLineWidthLabel, 0, row);
        gridPane.add(this.lineWidthComboBox, 1, row++);
        return this.createTitledPane(this.i18n.getString("UIConfidenceLayerPropertyBuilder.symbol.title", "Symbol properties"), (Node)gridPane);
    }

    private class FillColorChangeListener
    implements ChangeListener<Color> {
        private FillColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UIConfidenceLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIConfidenceLayerPropertyBuilder.this.layerManager != null) {
                UIConfidenceLayerPropertyBuilder.this.currentLayer.setColor(newValue);
                UIConfidenceLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class LineWidthChangeListener
    implements ChangeListener<Double> {
        private LineWidthChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UIConfidenceLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIConfidenceLayerPropertyBuilder.this.layerManager != null) {
                UIConfidenceLayerPropertyBuilder.this.currentLayer.setLineWidth(newValue);
                UIConfidenceLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class StrokeColorChangeListener
    implements ChangeListener<Color> {
        private StrokeColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UIConfidenceLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIConfidenceLayerPropertyBuilder.this.layerManager != null) {
                UIConfidenceLayerPropertyBuilder.this.currentLayer.setStrokeColor(newValue);
                UIConfidenceLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }
}

