/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.applied_geodesy.jag3d.ui.graphic.layer.ArrowLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerManager;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.ArrowSymbolTypeListCell;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.UILayerPropertyBuilder;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.ArrowSymbolType;
import org.applied_geodesy.jag3d.ui.i18n.I18N;

public class UIArrowLayerPropertyBuilder
extends UILayerPropertyBuilder {
    private I18N i18n = I18N.getInstance();
    private static UIArrowLayerPropertyBuilder arrowLayerPropertyBuilder = new UIArrowLayerPropertyBuilder();
    private ComboBox<ArrowSymbolType> symbolTypeComboBox;
    private ComboBox<Double> symbolSizeComboBox;
    private ComboBox<Double> lineWidthComboBox;
    private ColorPicker symbolColorPicker;
    private ArrowLayer currentLayer = null;
    private LayerManager layerManager = null;
    private VBox propertyPane = null;

    private UIArrowLayerPropertyBuilder() {
    }

    private void init() {
        if (this.propertyPane != null) {
            return;
        }
        this.propertyPane = new VBox(20.0);
        this.propertyPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.propertyPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.propertyPane.getChildren().addAll((Object[])new Node[]{this.createSymbolPane()});
    }

    public static Node getLayerPropertyPane(LayerManager layerManager, ArrowLayer layer) {
        UIArrowLayerPropertyBuilder.arrowLayerPropertyBuilder.layerManager = null;
        arrowLayerPropertyBuilder.init();
        arrowLayerPropertyBuilder.set(layer);
        UIArrowLayerPropertyBuilder.arrowLayerPropertyBuilder.layerManager = layerManager;
        return UIArrowLayerPropertyBuilder.arrowLayerPropertyBuilder.propertyPane;
    }

    private void set(ArrowLayer layer) {
        this.currentLayer = layer;
        this.symbolSizeComboBox.getSelectionModel().select((Object)this.currentLayer.getSymbolSize());
        this.lineWidthComboBox.getSelectionModel().select((Object)this.currentLayer.getLineWidth());
        this.symbolColorPicker.setValue((Object)this.currentLayer.getColor());
        this.symbolTypeComboBox.setValue((Object)this.currentLayer.getSymbolType());
    }

    private Node createSymbolPane() {
        GridPane gridPane = this.createGridPane();
        Label symbolTypeLabel = new Label(this.i18n.getString("UIArrowLayerPropertyBuilder.symbol.type.label", "Symbol type:"));
        symbolTypeLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Label symbolSizeLabel = new Label(this.i18n.getString("UIArrowLayerPropertyBuilder.symbol.size.label", "Symbol size:"));
        symbolSizeLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Label symbolColorLabel = new Label(this.i18n.getString("UIArrowLayerPropertyBuilder.symbol.color.label", "Symbol color:"));
        symbolColorLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Label symbolLineWidthLabel = new Label(this.i18n.getString("UIArrowLayerPropertyBuilder.symbol.linewidth.label", "Line width:"));
        symbolLineWidthLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        Double[] symbolSizes = new Double[21];
        int i = 0;
        while (i < symbolSizes.length) {
            symbolSizes[i] = 5.0 + 0.5 * (double)i;
            ++i;
        }
        this.symbolTypeComboBox = this.createSymbolComboBox(this.i18n.getString("UIArrowLayerPropertyBuilder.symbol.type.tooltip", "Set arrow symbol type"));
        this.symbolSizeComboBox = this.createSizeComboBox(this.i18n.getString("UIArrowLayerPropertyBuilder.symbol.size.tooltip", "Set arrow symbol size"), symbolSizes, 1);
        this.lineWidthComboBox = this.createLineWidthComboBox(this.i18n.getString("UIArrowLayerPropertyBuilder.symbol.linewidth.tooltip", "Set line width"));
        this.symbolColorPicker = this.createColorPicker(Color.DARKBLUE, this.i18n.getString("UIArrowLayerPropertyBuilder.symbol.color.tooltip", "Set symbol color"));
        this.symbolTypeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new SymbolTypeChangeListener());
        this.symbolSizeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new SymbolSizeChangeListener());
        this.lineWidthComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new LineWidthChangeListener());
        this.symbolColorPicker.valueProperty().addListener((ChangeListener)new ColorChangeListener());
        symbolTypeLabel.setLabelFor(this.symbolTypeComboBox);
        symbolSizeLabel.setLabelFor(this.symbolSizeComboBox);
        symbolColorLabel.setLabelFor((Node)this.symbolColorPicker);
        symbolLineWidthLabel.setLabelFor(this.lineWidthComboBox);
        GridPane.setHgrow((Node)symbolTypeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)symbolSizeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)symbolColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)symbolLineWidthLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow(this.symbolTypeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.symbolSizeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.symbolColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.lineWidthComboBox, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)symbolTypeLabel, 0, row);
        gridPane.add(this.symbolTypeComboBox, 1, row++);
        gridPane.add((Node)symbolSizeLabel, 0, row);
        gridPane.add(this.symbolSizeComboBox, 1, row++);
        gridPane.add((Node)symbolColorLabel, 0, row);
        gridPane.add((Node)this.symbolColorPicker, 1, row++);
        gridPane.add((Node)symbolLineWidthLabel, 0, row);
        gridPane.add(this.lineWidthComboBox, 1, row++);
        return this.createTitledPane(this.i18n.getString("UIArrowLayerPropertyBuilder.symbol.title", "Symbol properties"), (Node)gridPane);
    }

    private ComboBox<ArrowSymbolType> createSymbolComboBox(String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])ArrowSymbolType.values());
        typeComboBox.getSelectionModel().select(0);
        typeComboBox.setCellFactory((Callback)new Callback<ListView<ArrowSymbolType>, ListCell<ArrowSymbolType>>(){

            public ListCell<ArrowSymbolType> call(ListView<ArrowSymbolType> param) {
                return new ArrowSymbolTypeListCell();
            }
        });
        typeComboBox.setButtonCell((ListCell)new ArrowSymbolTypeListCell());
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    private class ColorChangeListener
    implements ChangeListener<Color> {
        private ColorChangeListener() {
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (UIArrowLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIArrowLayerPropertyBuilder.this.layerManager != null) {
                UIArrowLayerPropertyBuilder.this.currentLayer.setColor(newValue);
                UIArrowLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class LineWidthChangeListener
    implements ChangeListener<Double> {
        private LineWidthChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UIArrowLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIArrowLayerPropertyBuilder.this.layerManager != null) {
                UIArrowLayerPropertyBuilder.this.currentLayer.setLineWidth(newValue);
                UIArrowLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class SymbolSizeChangeListener
    implements ChangeListener<Double> {
        private SymbolSizeChangeListener() {
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (UIArrowLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIArrowLayerPropertyBuilder.this.layerManager != null) {
                UIArrowLayerPropertyBuilder.this.currentLayer.setSymbolSize(newValue);
                UIArrowLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }

    private class SymbolTypeChangeListener
    implements ChangeListener<ArrowSymbolType> {
        private SymbolTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends ArrowSymbolType> observable, ArrowSymbolType oldValue, ArrowSymbolType newValue) {
            if (UIArrowLayerPropertyBuilder.this.currentLayer != null && newValue != null && UIArrowLayerPropertyBuilder.this.layerManager != null) {
                UIArrowLayerPropertyBuilder.this.currentLayer.setSymbolType(newValue);
                UIArrowLayerPropertyBuilder.this.layerManager.draw();
            }
        }
    }
}

