/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ListCell;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.PointSymbolType;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.SymbolBuilder;
import org.applied_geodesy.jag3d.ui.i18n.I18N;

public class PointSymbolTypeListCell
extends ListCell<PointSymbolType> {
    private I18N i18n = I18N.getInstance();

    protected void updateItem(PointSymbolType symbolType, boolean empty) {
        super.updateItem((Object)symbolType, empty);
        this.setGraphic(null);
        this.setText(null);
        if (symbolType != null) {
            this.setGraphic((Node)this.createSymbolImage(symbolType));
            this.setText(this.getText(symbolType));
        }
    }

    private Canvas createSymbolImage(PointSymbolType symbolType) {
        double width = 20.4;
        double height = 20.4;
        Canvas canvas = new Canvas(width, height);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.setStroke((Paint)Color.BLACK);
        graphicsContext.setFill((Paint)Color.BLACK);
        SymbolBuilder.drawSymbol(graphicsContext, new PixelCoordinate(0.5 * width, 0.5 * height), symbolType, 18.0);
        return canvas;
    }

    private String getText(PointSymbolType symbolType) {
        switch (symbolType) {
            case DOT: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.dot.label", "Dot");
            }
            case X_CROSS: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.x_cross.label", "Cross (x)");
            }
            case PLUS_CROSS: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.plus_cross.label", "Cross (+)");
            }
            case CROSSED_CIRCLE: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.crossed_circle.label", "Crossed circle");
            }
            case CROSSED_SQUARE: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.crossed_square.label", "Crossed square");
            }
            case FILLED_CIRCLE: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.filled_circle.label", "Filled circle");
            }
            case FILLED_DIAMAND: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.filled_diamand.label", "Filled diamand");
            }
            case FILLED_HEPTAGON: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.filled_heptagon.label", "Filled heptagon");
            }
            case FILLED_HEXAGON: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.filled_hexagon.label", "Filled hexagon");
            }
            case FILLED_OCTAGON: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.filled_octagon.label", "Filled octagon");
            }
            case FILLED_PENTAGON: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.filled_pentagon.label", "Filled pentagon");
            }
            case FILLED_SQUARE: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.filled_square.label", "Filled square");
            }
            case FILLED_STAR: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.filled_star.label", "Filled star");
            }
            case FILLED_UPRIGHT_TRIANGLE: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.filled_upright_triangle.label", "Filled upright triangle");
            }
            case FILLED_DOWNRIGHT_TRIANGLE: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.filled_downright_triangle.label", "Filled downright triangle");
            }
            case STROKED_CIRCLE: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.stroked_circle.label", "Stroked circle");
            }
            case STROKED_DIAMAND: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.stroked_diamand.label", "Stroked diamand");
            }
            case STROKED_HEPTAGON: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.stroked_heptagon.label", "Stroked heptagon");
            }
            case STROKED_HEXAGON: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.stroked_hexagon.label", "Stroked hexagon");
            }
            case STROKED_OCTAGON: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.stroked_octagon.label", "Stroked octagon");
            }
            case STROKED_PENTAGON: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.stroked_pentagon.label", "Stroked pentagon");
            }
            case STROKED_SQUARE: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.stroked_square.label", "Stroked square");
            }
            case STROKED_STAR: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.stroked_star.label", "Stroked star");
            }
            case STROKED_UPRIGHT_TRIANGLE: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.stroked_upright_triangle.label", "Stroked upright triangle");
            }
            case STROKED_DOWNRIGHT_TRIANGLE: {
                return this.i18n.getString("PointSymbolTypeListCell.symbol.stroked_downright_triangle.label", "Stroked downright triangle");
            }
        }
        return null;
    }
}

