/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import java.text.NumberFormat;
import java.util.Locale;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ListCell;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class LineWidthListCell
extends ListCell<Double> {
    private NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);

    LineWidthListCell() {
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setGroupingUsed(false);
    }

    protected void updateItem(Double lineWidth, boolean empty) {
        super.updateItem((Object)lineWidth, empty);
        this.setGraphic(null);
        this.setText(null);
        if (lineWidth != null) {
            this.setGraphic((Node)this.createSymbolImage(lineWidth));
            this.setText(this.numberFormat.format(lineWidth));
        }
    }

    private Canvas createSymbolImage(Double lineWidth) {
        double width = 75.0;
        double height = 20.4;
        Canvas canvas = new Canvas(width, height);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.setStroke((Paint)Color.BLACK);
        graphicsContext.setFill((Paint)Color.BLACK);
        graphicsContext.setLineWidth(lineWidth.doubleValue());
        graphicsContext.strokeLine(0.2 * width, 0.5 * height, 0.8 * width, 0.5 * height);
        return canvas;
    }
}

