/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.graphic.layer.ArrowLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.ConfidenceLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.Layer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerManager;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.graphic.layer.LegendLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.ObservationLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.PointLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.LayerListCell;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.UIArrowLayerPropertyBuilder;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.UIConfidenceLayerPropertyBuilder;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.UILegendLayerPropertyBuilder;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.UIObservationLayerPropertyBuilder;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.UIPointLayerPropertyBuilder;
import org.applied_geodesy.jag3d.ui.graphic.sql.SQLGraphicManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.ui.dialog.OptionDialog;

public class LayerManagerDialog {
    private I18N i18n = I18N.getInstance();
    private static LayerManagerDialog layerManagerDialog = new LayerManagerDialog();
    private Dialog<Void> dialog = null;
    private static Window window;
    private LayerManager layerManager;
    private BorderPane layerPropertyBorderPane = new BorderPane();
    private Button upButton;
    private Button downButton;
    private ListView<Layer> layerListView;
    private ObservableList<Layer> layers;
    private Set<Layer> aPrioriLayerSet = new HashSet<Layer>();
    private Set<Layer> aPosterioriLayerSet = new HashSet<Layer>();
    private CheckBox allAprioriLayersVisibleCheckBox;
    private CheckBox allAPosterioriLayersVisibleCheckBox;
    private boolean ignoreVisibleEvent = false;

    private LayerManagerDialog() {
    }

    public static void setOwner(Window owner) {
        window = owner;
    }

    public static Optional<Void> showAndWait(LayerManager layerManager, ObservableList<Layer> layers) {
        LayerManagerDialog.layerManagerDialog.layerManager = layerManager;
        LayerManagerDialog.layerManagerDialog.layers = layers;
        layerManagerDialog.init();
        layerManagerDialog.load();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    LayerManagerDialog.layerManagerDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)LayerManagerDialog.layerManagerDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return LayerManagerDialog.layerManagerDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("LayerManagerDialog.title", "Layer manager"));
        this.dialog.setHeaderText(this.i18n.getString("LayerManagerDialog.header", "Layer properties"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                LayerManagerDialog.this.save();
                LayerManagerDialog.this.layerListView.getSelectionModel().select(0);
            }
        });
    }

    private Node createPane() {
        this.layerPropertyBorderPane.setTop((Node)this.createLayerOrderToolBar());
        this.allAprioriLayersVisibleCheckBox = this.createCheckBox(this.i18n.getString("LayerManagerDialog.multiselection.apriori.label", "A-priori layers selection"), this.i18n.getString("LayerManagerDialog.multiselection.apriori.tooltip", "If checked, all a-priori layers are visible"));
        this.allAPosterioriLayersVisibleCheckBox = this.createCheckBox(this.i18n.getString("LayerManagerDialog.multiselection.aposteriori.label", "A-posteriori layers selection"), this.i18n.getString("LayerManagerDialog.multiselection.aposteriori.tooltip", "If checked, all a-posteriori layers are visible"));
        this.allAprioriLayersVisibleCheckBox.selectedProperty().addListener((ChangeListener)new LayersVisibleChangeListener(this.allAprioriLayersVisibleCheckBox, this.aPrioriLayerSet));
        this.allAPosterioriLayersVisibleCheckBox.selectedProperty().addListener((ChangeListener)new LayersVisibleChangeListener(this.allAPosterioriLayersVisibleCheckBox, this.aPosterioriLayerSet));
        this.layerListView = this.createLayerListPane();
        this.updateGlobalLayerVisibleState(LayerType.OBSERVATION_APRIORI);
        this.updateGlobalLayerVisibleState(LayerType.OBSERVATION_APOSTERIORI);
        VBox checkBoxGroup = new VBox(5.0);
        checkBoxGroup.getChildren().add((Object)this.allAprioriLayersVisibleCheckBox);
        checkBoxGroup.getChildren().add((Object)this.allAPosterioriLayersVisibleCheckBox);
        VBox layerBox = new VBox(10.0);
        layerBox.getChildren().add(this.layerListView);
        layerBox.getChildren().add((Object)checkBoxGroup);
        VBox.setVgrow(this.layerListView, (Priority)Priority.ALWAYS);
        BorderPane rootNode = new BorderPane();
        rootNode.setLeft((Node)layerBox);
        rootNode.setCenter((Node)this.layerPropertyBorderPane);
        return rootNode;
    }

    private ToolBar createLayerOrderToolBar() {
        UpDownEventHandler upDownEventHandler = new UpDownEventHandler();
        this.upButton = new Button(this.i18n.getString("LayerManagerDialog.up.label", "\u25b2"));
        this.upButton.setTooltip(new Tooltip(this.i18n.getString("LayerManagerDialog.up.tooltip", "Move selected layer up")));
        this.upButton.setOnAction((EventHandler)upDownEventHandler);
        this.downButton = new Button(this.i18n.getString("LayerManagerDialog.down.label", "\u25bc"));
        this.downButton.setTooltip(new Tooltip(this.i18n.getString("LayerManagerDialog.down.tooltip", "Move selected layer down")));
        this.downButton.setOnAction((EventHandler)upDownEventHandler);
        ToolBar toolBar = new ToolBar();
        HBox spacer = new HBox();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        toolBar.getItems().addAll((Object[])new Node[]{spacer, this.upButton, this.downButton});
        return toolBar;
    }

    private ListView<Layer> createLayerListPane() {
        ListView listView = new ListView();
        int length = this.layers.size();
        int i = length - 1;
        while (i >= 0) {
            Layer layer = (Layer)this.layers.get(i);
            listView.getItems().add((Object)layer);
            LayerType type = layer.getLayerType();
            switch (type) {
                case OBSERVATION_APRIORI: 
                case REFERENCE_POINT_APRIORI: 
                case STOCHASTIC_POINT_APRIORI: 
                case DATUM_POINT_APRIORI: 
                case NEW_POINT_APRIORI: {
                    this.aPrioriLayerSet.add(layer);
                    layer.visibleProperty().addListener((ChangeListener)new LayerVisibleStateChangeListener(layer));
                    break;
                }
                case OBSERVATION_APOSTERIORI: 
                case REFERENCE_POINT_APOSTERIORI: 
                case STOCHASTIC_POINT_APOSTERIORI: 
                case DATUM_POINT_APOSTERIORI: 
                case NEW_POINT_APOSTERIORI: {
                    this.aPosterioriLayerSet.add(layer);
                    layer.visibleProperty().addListener((ChangeListener)new LayerVisibleStateChangeListener(layer));
                    break;
                }
            }
            --i;
        }
        listView.setCellFactory((Callback)new Callback<ListView<Layer>, ListCell<Layer>>(){

            public ListCell<Layer> call(ListView<Layer> list) {
                return new LayerListCell();
            }
        });
        listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        listView.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new LayerIndexChangeListener((ListView<Layer>)listView));
        listView.getSelectionModel().select(0);
        return listView;
    }

    private void load() {
        SQLGraphicManager sqlGraphicManager = SQLManager.getInstance().getSQLGraphicManager();
        if (sqlGraphicManager == null) {
            return;
        }
        try {
            sqlGraphicManager.initLayer(this.layerManager);
            ListView listView = new ListView();
            int length = this.layers.size();
            Layer firstLayerNotLegend = null;
            int i = length - 1;
            while (i >= 0) {
                Layer layer = (Layer)this.layers.get(i);
                listView.getItems().add((Object)layer);
                if (firstLayerNotLegend == null && layer.getLayerType() != LayerType.LEGEND) {
                    firstLayerNotLegend = layer;
                }
                --i;
            }
            this.layerListView.getSelectionModel().clearSelection();
            this.layerListView.getItems().setAll((Collection)listView.getItems());
            if (firstLayerNotLegend != null) {
                this.layerListView.getSelectionModel().select(firstLayerNotLegend);
            } else {
                this.layerListView.getSelectionModel().select(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(LayerManagerDialog.this.i18n.getString("LayerManagerDialog.message.error.load.exception.title", "Unexpected SQL-Error"), LayerManagerDialog.this.i18n.getString("LayerManagerDialog.message.error.load.exception.header", "Error, could not load layer properties from database."), LayerManagerDialog.this.i18n.getString("LayerManagerDialog.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void save() {
        SQLGraphicManager sqlGraphicManager = SQLManager.getInstance().getSQLGraphicManager();
        if (sqlGraphicManager == null) {
            return;
        }
        try {
            int order = 0;
            for (Layer layer : this.layers) {
                LayerType layerType = layer.getLayerType();
                switch (layerType) {
                    case REFERENCE_POINT_APRIORI: 
                    case STOCHASTIC_POINT_APRIORI: 
                    case DATUM_POINT_APRIORI: 
                    case NEW_POINT_APRIORI: 
                    case REFERENCE_POINT_APOSTERIORI: 
                    case STOCHASTIC_POINT_APOSTERIORI: 
                    case DATUM_POINT_APOSTERIORI: 
                    case NEW_POINT_APOSTERIORI: {
                        sqlGraphicManager.save((PointLayer)layer, order);
                        break;
                    }
                    case OBSERVATION_APRIORI: 
                    case OBSERVATION_APOSTERIORI: {
                        sqlGraphicManager.save((ObservationLayer)layer, order);
                        break;
                    }
                    case ABSOLUTE_CONFIDENCE: 
                    case RELATIVE_CONFIDENCE: {
                        sqlGraphicManager.save((ConfidenceLayer)layer, order);
                        break;
                    }
                    case POINT_SHIFT_VERTICAL: 
                    case POINT_SHIFT_HORIZONTAL: 
                    case PRINCIPAL_COMPONENT_VERTICAL: 
                    case PRINCIPAL_COMPONENT_HORIZONTAL: 
                    case POINT_RESIDUAL_VERTICAL: 
                    case POINT_RESIDUAL_HORIZONTAL: {
                        sqlGraphicManager.save((ArrowLayer)layer, order);
                        break;
                    }
                    case LEGEND: {
                        sqlGraphicManager.save((LegendLayer)layer, order);
                    }
                }
                ++order;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(LayerManagerDialog.this.i18n.getString("LayerManagerDialog.message.error.save.exception.title", "Unexpected SQL-Error"), LayerManagerDialog.this.i18n.getString("LayerManagerDialog.message.error.save.exception.header", "Error, could not save layer properties to database."), LayerManagerDialog.this.i18n.getString("LayerManagerDialog.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void updateGlobalLayerVisibleState(LayerType type) {
        try {
            this.ignoreVisibleEvent = true;
            int numberOfVisibleLayers = 0;
            switch (type) {
                case OBSERVATION_APRIORI: 
                case REFERENCE_POINT_APRIORI: 
                case STOCHASTIC_POINT_APRIORI: 
                case DATUM_POINT_APRIORI: 
                case NEW_POINT_APRIORI: {
                    for (Layer layer : this.aPrioriLayerSet) {
                        if (!layer.isVisible()) continue;
                        ++numberOfVisibleLayers;
                    }
                    this.allAprioriLayersVisibleCheckBox.setSelected(this.aPrioriLayerSet.size() == numberOfVisibleLayers);
                    this.allAprioriLayersVisibleCheckBox.setIndeterminate(numberOfVisibleLayers > 0 && numberOfVisibleLayers < this.aPrioriLayerSet.size());
                    break;
                }
                case OBSERVATION_APOSTERIORI: 
                case REFERENCE_POINT_APOSTERIORI: 
                case STOCHASTIC_POINT_APOSTERIORI: 
                case DATUM_POINT_APOSTERIORI: 
                case NEW_POINT_APOSTERIORI: {
                    for (Layer layer : this.aPosterioriLayerSet) {
                        if (!layer.isVisible()) continue;
                        ++numberOfVisibleLayers;
                    }
                    this.allAPosterioriLayersVisibleCheckBox.setSelected(this.aPosterioriLayerSet.size() == numberOfVisibleLayers);
                    this.allAPosterioriLayersVisibleCheckBox.setIndeterminate(numberOfVisibleLayers > 0 && numberOfVisibleLayers < this.aPosterioriLayerSet.size());
                    break;
                }
            }
        }
        finally {
            this.ignoreVisibleEvent = false;
        }
    }

    private CheckBox createCheckBox(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinHeight(Double.NEGATIVE_INFINITY);
        checkBox.setMaxHeight(Double.MAX_VALUE);
        return checkBox;
    }

    private class LayerIndexChangeListener
    implements ChangeListener<Number> {
        private ListView<Layer> listView;

        private LayerIndexChangeListener(ListView<Layer> listView) {
            this.listView = listView;
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            if (newValue == null || newValue.intValue() < 0) {
                LayerManagerDialog.this.upButton.setDisable(true);
                LayerManagerDialog.this.downButton.setDisable(true);
            } else {
                LayerManagerDialog.this.upButton.setDisable(newValue.intValue() == 0);
                LayerManagerDialog.this.downButton.setDisable(newValue.intValue() == this.listView.getItems().size() - 1);
                Layer selectedLayer = (Layer)this.listView.getItems().get(newValue.intValue());
                if (selectedLayer != null && selectedLayer.getLayerType() != null && LayerManagerDialog.this.layerManager != null) {
                    LayerType type = selectedLayer.getLayerType();
                    Node propertiesNode = null;
                    switch (type) {
                        case REFERENCE_POINT_APRIORI: 
                        case STOCHASTIC_POINT_APRIORI: 
                        case DATUM_POINT_APRIORI: 
                        case NEW_POINT_APRIORI: 
                        case REFERENCE_POINT_APOSTERIORI: 
                        case STOCHASTIC_POINT_APOSTERIORI: 
                        case DATUM_POINT_APOSTERIORI: 
                        case NEW_POINT_APOSTERIORI: {
                            propertiesNode = UIPointLayerPropertyBuilder.getLayerPropertyPane(LayerManagerDialog.this.layerManager, (PointLayer)selectedLayer);
                            break;
                        }
                        case OBSERVATION_APRIORI: 
                        case OBSERVATION_APOSTERIORI: {
                            propertiesNode = UIObservationLayerPropertyBuilder.getLayerPropertyPane(LayerManagerDialog.this.layerManager, (ObservationLayer)selectedLayer);
                            break;
                        }
                        case ABSOLUTE_CONFIDENCE: 
                        case RELATIVE_CONFIDENCE: {
                            propertiesNode = UIConfidenceLayerPropertyBuilder.getLayerPropertyPane(LayerManagerDialog.this.layerManager, (ConfidenceLayer)selectedLayer);
                            break;
                        }
                        case POINT_SHIFT_VERTICAL: 
                        case POINT_SHIFT_HORIZONTAL: 
                        case PRINCIPAL_COMPONENT_VERTICAL: 
                        case PRINCIPAL_COMPONENT_HORIZONTAL: 
                        case POINT_RESIDUAL_VERTICAL: 
                        case POINT_RESIDUAL_HORIZONTAL: {
                            propertiesNode = UIArrowLayerPropertyBuilder.getLayerPropertyPane(LayerManagerDialog.this.layerManager, (ArrowLayer)selectedLayer);
                            break;
                        }
                        case LEGEND: {
                            propertiesNode = UILegendLayerPropertyBuilder.getLayerPropertyPane(LayerManagerDialog.this.layerManager, (LegendLayer)selectedLayer);
                        }
                    }
                    if (propertiesNode != null) {
                        ScrollPane scroller = new ScrollPane(propertiesNode);
                        scroller.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
                        scroller.setFitToHeight(true);
                        scroller.setFitToWidth(true);
                        LayerManagerDialog.this.layerPropertyBorderPane.setCenter((Node)scroller);
                    }
                }
            }
        }
    }

    private class LayerVisibleStateChangeListener
    implements ChangeListener<Boolean> {
        private final Layer layer;

        public LayerVisibleStateChangeListener(Layer layer) {
            this.layer = layer;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (!LayerManagerDialog.this.ignoreVisibleEvent) {
                LayerManagerDialog.this.updateGlobalLayerVisibleState(this.layer.getLayerType());
            }
        }
    }

    private class LayersVisibleChangeListener
    implements ChangeListener<Boolean> {
        private final Set<Layer> layerSet;
        private final CheckBox checkBox;

        public LayersVisibleChangeListener(CheckBox checkBox, Set<Layer> layerSet) {
            this.layerSet = layerSet;
            this.checkBox = checkBox;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (!LayerManagerDialog.this.ignoreVisibleEvent) {
                this.updateLayerVisibleState(newValue);
            }
        }

        private void updateLayerVisibleState(boolean select) {
            try {
                LayerManagerDialog.this.ignoreVisibleEvent = true;
                for (Layer layer : this.layerSet) {
                    layer.setVisible(select);
                }
                this.checkBox.setSelected(select);
            }
            finally {
                LayerManagerDialog.this.ignoreVisibleEvent = false;
            }
        }
    }

    private class UpDownEventHandler
    implements EventHandler<ActionEvent> {
        private UpDownEventHandler() {
        }

        public void handle(ActionEvent event) {
            Layer selectedLayer = (Layer)LayerManagerDialog.this.layerListView.getSelectionModel().getSelectedItem();
            boolean moveUp = event.getSource() == LayerManagerDialog.this.upButton;
            int selectedIndex = -1;
            if (selectedLayer != null && (selectedIndex = LayerManagerDialog.this.layerListView.getItems().indexOf((Object)selectedLayer)) >= 0) {
                Collections.swap(LayerManagerDialog.this.layerListView.getItems(), selectedIndex + (moveUp ? -1 : 1), selectedIndex);
                ArrayList<Layer> reorderedList = new ArrayList<Layer>((Collection<Layer>)LayerManagerDialog.this.layerListView.getItems());
                Collections.reverse(reorderedList);
                LayerManagerDialog.this.layerManager.reorderLayer(reorderedList);
                LayerManagerDialog.this.layerListView.getSelectionModel().select((Object)selectedLayer);
                LayerManagerDialog.this.layerManager.draw();
            }
        }
    }
}

