/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.applied_geodesy.jag3d.ui.graphic.layer.Layer;

public class LayerListCell
extends ListCell<Layer> {
    private CheckBox visibleCheckBox = new CheckBox();
    private Rectangle rect = new Rectangle(25.0, 15.0);

    public LayerListCell() {
        HBox box = new HBox(new Node[]{this.rect});
        box.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        this.rect.setStroke((Paint)Color.BLACK);
        this.visibleCheckBox.setText(null);
        this.visibleCheckBox.setGraphic((Node)box);
        this.itemProperty().addListener((ChangeListener)new ChangeListener<Layer>(){

            public void changed(ObservableValue<? extends Layer> observable, Layer oldValue, Layer newValue) {
                if (oldValue != null) {
                    LayerListCell.this.visibleCheckBox.selectedProperty().unbindBidirectional((Property)oldValue.visibleProperty());
                    LayerListCell.this.rect.fillProperty().unbind();
                }
                if (newValue != null) {
                    LayerListCell.this.visibleCheckBox.selectedProperty().bindBidirectional((Property)newValue.visibleProperty());
                    LayerListCell.this.rect.fillProperty().bind(newValue.colorProperty());
                }
            }
        });
    }

    public void updateItem(Layer layer, boolean empty) {
        super.updateItem((Object)layer, empty);
        if (!empty && layer != null) {
            this.setGraphic((Node)this.visibleCheckBox);
            this.setText(layer.toString());
        }
    }
}

