/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.jag3d.ui.graphic.layer.Layer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerManager;
import org.applied_geodesy.jag3d.ui.graphic.layer.PointLayer;
import org.applied_geodesy.jag3d.ui.graphic.sql.GraphicPoint;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.ui.table.NaturalOrderComparator;

public class FeatureZoomDialog {
    private I18N i18n = I18N.getInstance();
    private static FeatureZoomDialog featureZoomDialog = new FeatureZoomDialog();
    private Dialog<GraphicPoint> dialog = null;
    private static Window window;
    private LayerManager layerManager;
    private ObservableList<Layer> layers;
    private ComboBox<GraphicPoint> pointsComboBox;
    private Slider scaleSlider;

    private FeatureZoomDialog() {
    }

    public static void setOwner(Window owner) {
        window = owner;
    }

    public static Optional<GraphicPoint> showAndWait(LayerManager layerManager, ObservableList<Layer> layers) {
        FeatureZoomDialog.featureZoomDialog.layerManager = layerManager;
        FeatureZoomDialog.featureZoomDialog.layers = layers;
        featureZoomDialog.init();
        featureZoomDialog.load();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FeatureZoomDialog.featureZoomDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)FeatureZoomDialog.featureZoomDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return FeatureZoomDialog.featureZoomDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("FeatureZoomDialog.title", "Feature zoom"));
        this.dialog.setHeaderText(this.i18n.getString("FeatureZoomDialog.header", "Zoom and center to point"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, GraphicPoint>(){

            public GraphicPoint call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    GraphicPoint selectedPoint = (GraphicPoint)FeatureZoomDialog.this.pointsComboBox.getValue();
                    if (selectedPoint != null) {
                        FeatureZoomDialog.this.zoomToFeature(selectedPoint);
                    }
                    return selectedPoint;
                }
                return null;
            }
        });
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
    }

    private Node createPane() {
        Label pointsLabel = new Label(this.i18n.getString("FeatureZoomDialog.feature.points.label", "Adjusted points:"));
        Label scaleLabel = new Label(this.i18n.getString("FeatureZoomDialog.scale.label", "Scaling factor:"));
        this.pointsComboBox = this.createPointComboBox(this.i18n.getString("FeatureZoomDialog.feature.points.tooltip", "Select point to zoom"));
        this.scaleSlider = this.createScalingSlider(0.25, 1.75, 1.0, this.i18n.getString("FeatureZoomDialog.scale.tooltip", "Set scaling factor to zoom in or to zoom out"));
        pointsLabel.setLabelFor(this.pointsComboBox);
        scaleLabel.setLabelFor((Node)this.scaleSlider);
        GridPane.setHgrow((Node)pointsLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)scaleLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow(this.pointsComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.scaleSlider, (Priority)Priority.ALWAYS);
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setPadding(new Insets(5.0, 15.0, 5.0, 15.0));
        int row = 1;
        gridPane.add((Node)pointsLabel, 0, row);
        gridPane.add(this.pointsComboBox, 1, row++);
        gridPane.add((Node)scaleLabel, 0, row);
        gridPane.add((Node)this.scaleSlider, 1, row++);
        return gridPane;
    }

    private ComboBox<GraphicPoint> createPointComboBox(String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMinWidth(150.0);
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    private Slider createScalingSlider(double min, double max, double value, String tooltip) {
        Slider slider = new Slider(min, max, value);
        slider.setShowTickLabels(true);
        slider.setShowTickMarks(true);
        slider.setMajorTickUnit(0.5);
        slider.setMinorTickCount(1);
        slider.setBlockIncrement(0.25);
        slider.setMinWidth(150.0);
        slider.setMaxWidth(Double.MAX_VALUE);
        slider.setTooltip(new Tooltip(tooltip));
        return slider;
    }

    private void load() {
        ObservableList graphicPoints = FXCollections.observableArrayList();
        for (Layer layer : this.layers) {
            if (!layer.isVisible()) continue;
            switch (layer.getLayerType()) {
                case REFERENCE_POINT_APOSTERIORI: 
                case STOCHASTIC_POINT_APOSTERIORI: 
                case DATUM_POINT_APOSTERIORI: 
                case NEW_POINT_APOSTERIORI: {
                    PointLayer pointLayer = (PointLayer)layer;
                    graphicPoints.addAll(pointLayer.getPoints());
                    break;
                }
            }
        }
        if (!graphicPoints.isEmpty()) {
            Collections.sort(graphicPoints, new NaturalOrderComparator());
            FilteredList filteredPoints = new FilteredList(graphicPoints, (Predicate)new Predicate<GraphicPoint>(){

                @Override
                public boolean test(GraphicPoint point) {
                    return point.isVisible();
                }
            });
            int selectedIndex = this.pointsComboBox.getSelectionModel().getSelectedIndex();
            this.pointsComboBox.getItems().setAll((Collection)filteredPoints);
            if (filteredPoints.size() > selectedIndex && selectedIndex >= 0) {
                this.pointsComboBox.getSelectionModel().clearAndSelect(selectedIndex);
            } else if (!filteredPoints.isEmpty()) {
                this.pointsComboBox.getSelectionModel().clearAndSelect(0);
            }
        }
    }

    private void zoomToFeature(GraphicPoint selectedPoint) {
        GraphicExtent graphicExtent = this.layerManager.getCurrentGraphicExtent();
        double pointX = selectedPoint.getCoordinate().getX();
        double pointY = selectedPoint.getCoordinate().getY();
        double extentWidth = graphicExtent.getExtentWidth();
        double extentHeight = graphicExtent.getExtentHeight();
        double scale = graphicExtent.getScale();
        double newMinX = pointX - 0.5 * extentWidth;
        double newMaxX = pointX + 0.5 * extentWidth;
        double newMinY = pointY + 0.5 * extentHeight;
        double newMaxY = pointY - 0.5 * extentHeight;
        graphicExtent.set(newMinX, newMinY, newMaxX, newMaxY);
        graphicExtent.setScale(scale * this.scaleSlider.getValue());
        this.layerManager.draw();
    }
}

