/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer.dialog;

import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ListCell;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.ArrowSymbolType;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.SymbolBuilder;
import org.applied_geodesy.jag3d.ui.i18n.I18N;

public class ArrowSymbolTypeListCell
extends ListCell<ArrowSymbolType> {
    private I18N i18n = I18N.getInstance();

    protected void updateItem(ArrowSymbolType symbolType, boolean empty) {
        super.updateItem((Object)symbolType, empty);
        this.setGraphic(null);
        this.setText(null);
        if (symbolType != null) {
            this.setGraphic((Node)this.createSymbolImage(symbolType));
            this.setText(this.getText(symbolType));
        }
    }

    private Canvas createSymbolImage(ArrowSymbolType symbolType) {
        double width = 48.0;
        double height = 18.0;
        Canvas canvas = new Canvas(width, height);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.setStroke((Paint)Color.BLACK);
        graphicsContext.setFill((Paint)Color.BLACK);
        graphicsContext.strokeLine(0.05 * width, 0.5 * height, 0.75 * width, 0.5 * height);
        SymbolBuilder.drawSymbol(graphicsContext, new PixelCoordinate(0.05 * width, 0.5 * height), symbolType, 15.600000000000001, Math.PI);
        return canvas;
    }

    private String getText(ArrowSymbolType symbolType) {
        switch (symbolType) {
            case FILLED_TETRAGON_ARROW: {
                return this.i18n.getString("ArrowSymbolTypeListCell.symbol.filled_tetragon_arrow.label", "Filled tetragon arrow");
            }
            case FILLED_TRIANGLE_ARROW: {
                return this.i18n.getString("ArrowSymbolTypeListCell.symbol.filled_triangle_arrow.label", "Filled triangle arrow");
            }
            case STROKED_ARROW: {
                return this.i18n.getString("ArrowSymbolTypeListCell.symbol.stroked_arrow.label", "Stroked arrow");
            }
            case STROKED_TETRAGON_ARROW: {
                return this.i18n.getString("ArrowSymbolTypeListCell.symbol.stroked_tetragon_arrow.label", "Stroked tetragon arrow");
            }
            case STROKED_TRIANGLE_ARROW: {
                return this.i18n.getString("ArrowSymbolTypeListCell.symbol.stroked_triangle_arrow.label", "Stroked triangle arrow");
            }
        }
        return null;
    }
}

