/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.Layer;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;

class ResizableCanvas
extends Canvas {
    private final GraphicExtent currentGraphicExtent;
    private ObservableList<Layer> layers = FXCollections.observableArrayList();

    ResizableCanvas(GraphicExtent currentGraphicExtent) {
        this.currentGraphicExtent = currentGraphicExtent;
        this.widthProperty().bind((ObservableValue)this.currentGraphicExtent.drawingBoardWidthProperty());
        this.heightProperty().bind((ObservableValue)this.currentGraphicExtent.drawingBoardHeightProperty());
        this.widthProperty().addListener((ChangeListener)new ResizingListener(Orientation.HORIZONTAL));
        this.heightProperty().addListener((ChangeListener)new ResizingListener(Orientation.VERTICAL));
    }

    public ObservableList<Layer> getLayers() {
        return this.layers;
    }

    void draw() {
        this.clear();
        GraphicsContext graphicsContext = this.getGraphicsContext2D();
        for (Layer layer : this.layers) {
            if (!layer.isVisible()) continue;
            layer.draw(graphicsContext, this.getCurrentGraphicExtent());
        }
    }

    void clear() {
        double width = this.getWidth();
        double height = this.getHeight();
        GraphicsContext gc = this.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, width, height);
    }

    public GraphicExtent getCurrentGraphicExtent() {
        return this.currentGraphicExtent;
    }

    public boolean isResizable() {
        return true;
    }

    public double prefWidth(double height) {
        return this.getWidth();
    }

    public double prefHeight(double width) {
        return this.getHeight();
    }

    public boolean contains(PixelCoordinate pixelCoordinate) {
        return pixelCoordinate.getX() >= 0.0 && pixelCoordinate.getX() <= this.getWidth() && pixelCoordinate.getY() >= 0.0 && pixelCoordinate.getY() <= this.getHeight();
    }

    private class ResizingListener
    implements ChangeListener<Number> {
        private Orientation orientation;

        private ResizingListener(Orientation orientation) {
            this.orientation = orientation;
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            double extentWidth = ResizableCanvas.this.currentGraphicExtent.getExtentWidth();
            double extentHeight = ResizableCanvas.this.currentGraphicExtent.getExtentHeight();
            double drawingBoardHeight = ResizableCanvas.this.currentGraphicExtent.getDrawingBoardHeight();
            double drawingBoardWidth = ResizableCanvas.this.currentGraphicExtent.getDrawingBoardWidth();
            switch (this.orientation) {
                case HORIZONTAL: {
                    drawingBoardWidth = oldValue.doubleValue() > newValue.doubleValue() ? oldValue.doubleValue() : newValue.doubleValue();
                    break;
                }
                case VERTICAL: {
                    drawingBoardHeight = oldValue.doubleValue() > newValue.doubleValue() ? oldValue.doubleValue() : newValue.doubleValue();
                }
            }
            ResizableCanvas.this.currentGraphicExtent.setScale(GraphicExtent.getScale(drawingBoardHeight, drawingBoardWidth, extentHeight, extentWidth));
            ResizableCanvas.this.draw();
        }
    }
}

