/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import java.util.List;
import java.util.Locale;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.ConfidenceLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.graphic.layer.PointShiftArrowLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.SymbolBuilder;
import org.applied_geodesy.jag3d.ui.graphic.sql.GraphicPoint;
import org.applied_geodesy.jag3d.ui.graphic.sql.RelativeConfidence;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;
import org.applied_geodesy.util.FormatterOptions;

public class RelativeConfidenceLayer
extends ConfidenceLayer<PointShiftArrowLayer> {
    private FormatterOptions options = FormatterOptions.getInstance();

    RelativeConfidenceLayer(LayerType layerType) {
        super(layerType);
        Color strokeColor;
        Color fillColor;
        double lineWidth = -1.0;
        boolean visible = Boolean.TRUE;
        try {
            fillColor = Color.web((String)PROPERTIES.getProperty("RELATIVE_CONFIDENCE_FILL_COLOR", "#ffffe0"));
        }
        catch (Exception e) {
            fillColor = Color.web((String)"#ffffe0");
        }
        try {
            strokeColor = Color.web((String)PROPERTIES.getProperty("RELATIVE_CONFIDENCE_STROKE_COLOR", "#000000"));
        }
        catch (Exception e) {
            strokeColor = Color.web((String)"#000000");
        }
        try {
            visible = PROPERTIES.getProperty("RELATIVE_CONFIDENCE_VISIBLE").equalsIgnoreCase("TRUE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lineWidth = Double.parseDouble(PROPERTIES.getProperty("RELATIVE_CONFIDENCE_LINE_WIDTH"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        lineWidth = lineWidth >= 0.0 ? lineWidth : 0.5;
        this.setStrokeColor(strokeColor);
        this.setColor(fillColor);
        this.setLineWidth(lineWidth);
        this.setVisible(visible);
    }

    @Override
    public void draw(GraphicsContext graphicsContext, GraphicExtent graphicExtent) {
        if (!this.isVisible() || graphicExtent.getScale() <= 0.0) {
            return;
        }
        List referenceLayers = this.getReferenceLayers();
        double scale = graphicExtent.getScale();
        double lineWidth = this.getLineWidth();
        graphicsContext.setLineWidth(lineWidth);
        graphicsContext.setStroke((Paint)this.getStrokeColor());
        graphicsContext.setFill((Paint)this.getColor());
        graphicsContext.setLineDashes(null);
        for (PointShiftArrowLayer layer : referenceLayers) {
            if (!layer.isVisible()) continue;
            double ellipseScale = layer.getVectorScale() / scale;
            for (RelativeConfidence relativeConfidence : layer.getRelativeConfidences()) {
                double ye;
                double avgY;
                GraphicPoint startPoint = relativeConfidence.getStartPoint();
                GraphicPoint endPoint = relativeConfidence.getEndPoint();
                if (!startPoint.isVisible() || !endPoint.isVisible()) continue;
                PixelCoordinate pixelCoordinateStartPoint = GraphicExtent.toPixelCoordinate(startPoint.getCoordinate(), graphicExtent);
                PixelCoordinate pixelCoordinateEndPoint = GraphicExtent.toPixelCoordinate(endPoint.getCoordinate(), graphicExtent);
                if (!this.contains(graphicExtent, pixelCoordinateStartPoint) && !this.contains(graphicExtent, pixelCoordinateEndPoint)) continue;
                double xs = pixelCoordinateStartPoint.getX();
                double ys = pixelCoordinateStartPoint.getY();
                double xe = pixelCoordinateEndPoint.getX();
                double avgX = 0.5 * (xs + xe);
                PixelCoordinate vectorStartCoordinate = new PixelCoordinate(avgX, avgY = 0.5 * (ys + (ye = pixelCoordinateEndPoint.getY())));
                if (!this.contains(graphicExtent, vectorStartCoordinate) || !(relativeConfidence.getMajorAxis() > 0.0)) continue;
                double majorAxis = ellipseScale * relativeConfidence.getMajorAxis();
                double minorAxis = ellipseScale * relativeConfidence.getMinorAxis();
                double angle = relativeConfidence.getAngle();
                SymbolBuilder.drawEllipse(graphicsContext, vectorStartCoordinate, majorAxis, minorAxis, angle);
            }
        }
    }

    public String toString() {
        double confidenceLevel = this.getConfidenceLevel();
        String confidenceLevelLabel = confidenceLevel > 0.0 && confidenceLevel < 1.0 ? this.options.toPercentFormat(this.getConfidenceLevel(), true) : "";
        return String.format(Locale.ENGLISH, this.i18n.getString("RelativeConfidenceLayer.type", "Relative confidences"), confidenceLevelLabel);
    }

    @Override
    public boolean hasContent() {
        List referenceLayers = this.getReferenceLayers();
        for (PointShiftArrowLayer layer : referenceLayers) {
            if (!layer.isVisible() || !layer.hasContent()) continue;
            for (RelativeConfidence relativeConfidence : layer.getRelativeConfidences()) {
                GraphicPoint startPoint = relativeConfidence.getStartPoint();
                GraphicPoint endPoint = relativeConfidence.getEndPoint();
                if (!startPoint.isVisible() || !endPoint.isVisible()) continue;
                return true;
            }
        }
        return false;
    }
}

